=begin comment

Aspose.Diagram Cloud API Reference

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 3.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeDiagramCloud::StorageApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeDiagramCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeDiagramCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeDiagramCloud::ApiClient->new(@_);
    }

    my $access_token  =  $api_client->o_auth_post('grant_type' => "client_credentials", 'client_id' => $api_client->{config}->{app_sid}, 'client_secret' =>$api_client->{config}->{app_key})->access_token;
    $api_client->{config}->{access_token} = $access_token;
    my $base_url =  $api_client->{config}->{base_url};
    
    if( substr( $base_url,length($base_url)-1,1) eq '/'){
         $base_url =  $base_url . $api_client->{config}->{api_version};
    }else{
         $base_url =  $base_url . '/'.$api_client->{config}->{api_version};
    }
    
    $api_client->{config}->{base_url} =  $base_url;

    bless { api_client => $api_client }, $class;

}


#
# diagram_storage_disc_get
#
# Get disc usage
# 
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_disc_get' } = { 
    	summary => 'Get disc usage',
        params => $params,
        returns => 'DiscUsage',
        };
}
# @return DiscUsage
#
sub diagram_storage_disc_get {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/diagram/storage/disc';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DiscUsage', $response);
    return $_response_object;
}

#
# diagram_storage_exist_path_get
#
# Check if file or folder exists
# 
# @param string $path File or folder path e.g. &#39;/file.ext&#39; or &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File or folder path e.g. &#39;/file.ext&#39; or &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_exist_path_get' } = { 
    	summary => 'Check if file or folder exists',
        params => $params,
        returns => 'ObjectExist',
        };
}
# @return ObjectExist
#
sub diagram_storage_exist_path_get {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_exist_path_get");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/exist/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ObjectExist', $response);
    return $_response_object;
}

#
# diagram_storage_file_copy_src_path_put
#
# Copy file
# 
# @param string $src_path Source file path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $dest_path Destination file path (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
# @param string $version_id File version ID to copy (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source file path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination file path',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to copy',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_file_copy_src_path_put' } = { 
    	summary => 'Copy file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub diagram_storage_file_copy_src_path_put {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling diagram_storage_file_copy_src_path_put");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling diagram_storage_file_copy_src_path_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/file/copy/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if ( exists $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if ( exists $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# diagram_storage_file_move_src_path_put
#
# Move file
# 
# @param string $src_path Source file path e.g. &#39;/src.ext&#39; (required)
# @param string $dest_path Destination file path e.g. &#39;/dest.ext&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
# @param string $version_id File version ID to move (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source file path e.g. &#39;/src.ext&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination file path e.g. &#39;/dest.ext&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to move',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_file_move_src_path_put' } = { 
    	summary => 'Move file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub diagram_storage_file_move_src_path_put {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling diagram_storage_file_move_src_path_put");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling diagram_storage_file_move_src_path_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/file/move/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if ( exists $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if ( exists $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# diagram_storage_file_path_delete
#
# Delete file
# 
# @param string $path File path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID to delete (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to delete',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_file_path_delete' } = { 
    	summary => 'Delete file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub diagram_storage_file_path_delete {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_file_path_delete");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/file/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# diagram_storage_file_path_get
#
# Download file
# 
# @param string $path File path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID to download (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to download',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_file_path_get' } = { 
    	summary => 'Download file',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub diagram_storage_file_path_get {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_file_path_get");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/file/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# diagram_storage_file_path_put
#
# Upload file
# 
# @param string $path Path where to upload including filename and extension e.g. /file.ext or /Folder 1/file.ext             If the content is multipart and path does not contains the file name it tries to get them from filename parameter             from Content-Disposition header.              (required)
# @param string $file File to upload (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Path where to upload including filename and extension e.g. /file.ext or /Folder 1/file.ext             If the content is multipart and path does not contains the file name it tries to get them from filename parameter             from Content-Disposition header.             ',
        required => '1',
    },
    'file' => {
        data_type => 'string',
        description => 'File to upload',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_file_path_put' } = { 
    	summary => 'Upload file',
        params => $params,
        returns => 'FilesUploadResult',
        };
}
# @return FilesUploadResult
#
sub diagram_storage_file_path_put {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_file_path_put");
    }

    # verify the required parameter 'file' is set
    unless (exists $args{'file'}) {
      croak("Missing the required parameter 'file' when calling diagram_storage_file_path_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/file/{path}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'file'}) {
        $_body_data = $args{'file'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FilesUploadResult', $response);
    return $_response_object;
}

#
# diagram_storage_folder_copy_src_path_put
#
# Copy folder
# 
# @param string $src_path Source folder path e.g. &#39;/src&#39; (required)
# @param string $dest_path Destination folder path e.g. &#39;/dst&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source folder path e.g. &#39;/src&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination folder path e.g. &#39;/dst&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_folder_copy_src_path_put' } = { 
    	summary => 'Copy folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub diagram_storage_folder_copy_src_path_put {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling diagram_storage_folder_copy_src_path_put");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling diagram_storage_folder_copy_src_path_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/folder/copy/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if ( exists $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if ( exists $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# diagram_storage_folder_move_src_path_put
#
# Move folder
# 
# @param string $src_path Folder path to move e.g. &#39;/folder&#39; (required)
# @param string $dest_path Destination folder path to move to e.g &#39;/dst&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Folder path to move e.g. &#39;/folder&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination folder path to move to e.g &#39;/dst&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_folder_move_src_path_put' } = { 
    	summary => 'Move folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub diagram_storage_folder_move_src_path_put {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling diagram_storage_folder_move_src_path_put");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling diagram_storage_folder_move_src_path_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/folder/move/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if ( exists $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if ( exists $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# diagram_storage_folder_path_delete
#
# Delete folder
# 
# @param string $path Folder path e.g. &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
# @param boolean $recursive Enable to delete folders, subfolders and files (optional, default to false)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path e.g. &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'recursive' => {
        data_type => 'boolean',
        description => 'Enable to delete folders, subfolders and files',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_folder_path_delete' } = { 
    	summary => 'Delete folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub diagram_storage_folder_path_delete {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_folder_path_delete");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/folder/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if ( exists $args{'recursive'}) {
        $query_params->{'recursive'} = $self->{api_client}->to_query_value($args{'recursive'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# diagram_storage_folder_path_get
#
# Get all files and folders within a folder
# 
# @param string $path Folder path e.g. &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path e.g. &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_folder_path_get' } = { 
    	summary => 'Get all files and folders within a folder',
        params => $params,
        returns => 'FilesList',
        };
}
# @return FilesList
#
sub diagram_storage_folder_path_get {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_folder_path_get");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/folder/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FilesList', $response);
    return $_response_object;
}

#
# diagram_storage_folder_path_put
#
# Create the folder
# 
# @param string $path Folder path to create e.g. &#39;folder_1/folder_2/&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path to create e.g. &#39;folder_1/folder_2/&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_folder_path_put' } = { 
    	summary => 'Create the folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub diagram_storage_folder_path_put {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_folder_path_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/folder/{path}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# diagram_storage_storage_name_exist_get
#
# Check if storage exists
# 
# @param string $storage_name Storage name (required)
{
    my $params = {
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_storage_name_exist_get' } = { 
    	summary => 'Check if storage exists',
        params => $params,
        returns => 'StorageExist',
        };
}
# @return StorageExist
#
sub diagram_storage_storage_name_exist_get {
    my ($self, %args) = @_;

    # verify the required parameter 'storage_name' is set
    unless (exists $args{'storage_name'}) {
      croak("Missing the required parameter 'storage_name' when calling diagram_storage_storage_name_exist_get");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/{storageName}/exist';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'storage_name'}) {
        my $_base_variable = "{" . "storageName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'storage_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('StorageExist', $response);
    return $_response_object;
}

#
# diagram_storage_version_path_get
#
# Get file versions
# 
# @param string $path File path e.g. &#39;/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_version_path_get' } = { 
    	summary => 'Get file versions',
        params => $params,
        returns => 'FileVersions',
        };
}
# @return FileVersions
#
sub diagram_storage_version_path_get {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_version_path_get");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/version/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FileVersions', $response);
    return $_response_object;
}
#
# Upload file
#
# Upload file
# 
# @param string $path Path where to upload including filename and extension e.g. /file.ext or /Folder 1/file.ext             If the content is multipart and path does not contains the file name it tries to get them from filename parameter             from Content-Disposition header.              (required)
# @param File $file File to upload (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Path where to upload including filename and extension e.g. /file.ext or /Folder 1/file.ext             If the content is multipart and path does not contains the file name it tries to get them from filename parameter             from Content-Disposition header.             ',
        required => '1',
    },
    'localfileName' => {
        data_type => 'string',
        description => 'localfileName name.',
        required => '0',
    },
    'body' => {
        data_type => 'string',
        description => 'file.',
        required => '0',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'diagram_storage_file_path_put' } = { 
    	summary => 'Upload file',
        params => $params,
        returns => 'FilesUploadResult',
        };
}
# @return FilesUploadResult
#
sub upload_file {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling diagram_storage_file_path_put");
    }

    # parse inputs
    my $_resource_path = '/diagram/storage/file/{path}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    #####################################################
    my $filename=$args{'localfileName'};
    my $filedisposition='form-data; filename="'.$filename.'"';
    $header_params->{'Content-Disposition'} =$filedisposition;
    my $_body_data=$args{'body'};
    #printf $filedisposition;####################################

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FilesUploadResult', $response);
    return $_response_object;
}

1;
