=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsShapesApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_shapes_delete_worksheet_shape
#
# Delete a shape in worksheet
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param int $shapeindex shape index in worksheet shapes. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'shapeindex' => {
        data_type => 'int',
        description => 'shape index in worksheet shapes.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_delete_worksheet_shape' } = { 
    	summary => 'Delete a shape in worksheet',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_shapes_delete_worksheet_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_delete_worksheet_shape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_delete_worksheet_shape");
    }

    # verify the required parameter 'shapeindex' is set
    unless (exists $args{'shapeindex'}) {
      croak("Missing the required parameter 'shapeindex' when calling cells_shapes_delete_worksheet_shape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes/{shapeindex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shapeindex'}) {
        my $_base_variable = "{" . "shapeindex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shapeindex'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_shapes_delete_worksheet_shapes
#
# delete all shapes in worksheet
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_delete_worksheet_shapes' } = { 
    	summary => 'delete all shapes in worksheet',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_shapes_delete_worksheet_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_delete_worksheet_shapes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_delete_worksheet_shapes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_shapes_get_worksheet_shape
#
# Get worksheet shape
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param int $shapeindex shape index in worksheet shapes. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'shapeindex' => {
        data_type => 'int',
        description => 'shape index in worksheet shapes.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_get_worksheet_shape' } = { 
    	summary => 'Get worksheet shape',
        params => $params,
        returns => 'ShapeResponse',
        };
}
# @return ShapeResponse
#
sub cells_shapes_get_worksheet_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_get_worksheet_shape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_get_worksheet_shape");
    }

    # verify the required parameter 'shapeindex' is set
    unless (exists $args{'shapeindex'}) {
      croak("Missing the required parameter 'shapeindex' when calling cells_shapes_get_worksheet_shape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes/{shapeindex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shapeindex'}) {
        my $_base_variable = "{" . "shapeindex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shapeindex'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeResponse', $response);
    return $_response_object;
}

#
# cells_shapes_get_worksheet_shapes
#
# Get worksheet shapes 
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_get_worksheet_shapes' } = { 
    	summary => 'Get worksheet shapes ',
        params => $params,
        returns => 'ShapesResponse',
        };
}
# @return ShapesResponse
#
sub cells_shapes_get_worksheet_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_get_worksheet_shapes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_get_worksheet_shapes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapesResponse', $response);
    return $_response_object;
}

#
# cells_shapes_post_worksheet_shape
#
# Update a shape in worksheet
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param int $shapeindex shape index in worksheet shapes. (required)
# @param Shape $dto  (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'shapeindex' => {
        data_type => 'int',
        description => 'shape index in worksheet shapes.',
        required => '1',
    },
    'dto' => {
        data_type => 'Shape',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_post_worksheet_shape' } = { 
    	summary => 'Update a shape in worksheet',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_shapes_post_worksheet_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_post_worksheet_shape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_post_worksheet_shape");
    }

    # verify the required parameter 'shapeindex' is set
    unless (exists $args{'shapeindex'}) {
      croak("Missing the required parameter 'shapeindex' when calling cells_shapes_post_worksheet_shape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes/{shapeindex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shapeindex'}) {
        my $_base_variable = "{" . "shapeindex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shapeindex'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_shapes_put_worksheet_shape
#
# Add shape in worksheet
# 
# @param string $name document name. (required)
# @param string $sheet_name worksheet name. (required)
# @param string $drawing_type shape object type (required)
# @param int $upper_left_row Upper left row index. (required)
# @param int $upper_left_column Upper left column index. (required)
# @param int $top Represents the vertical offset of Spinner from its left row, in unit of pixel. (required)
# @param int $left Represents the horizontal offset of Spinner from its left column, in unit of pixel. (required)
# @param int $width Represents the height of Spinner, in unit of pixel. (required)
# @param int $height Represents the width of Spinner, in unit of pixel. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name.',
        required => '1',
    },
    'drawing_type' => {
        data_type => 'string',
        description => 'shape object type',
        required => '1',
    },
    'upper_left_row' => {
        data_type => 'int',
        description => 'Upper left row index.',
        required => '1',
    },
    'upper_left_column' => {
        data_type => 'int',
        description => 'Upper left column index.',
        required => '1',
    },
    'top' => {
        data_type => 'int',
        description => 'Represents the vertical offset of Spinner from its left row, in unit of pixel.',
        required => '1',
    },
    'left' => {
        data_type => 'int',
        description => 'Represents the horizontal offset of Spinner from its left column, in unit of pixel.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Represents the height of Spinner, in unit of pixel.',
        required => '1',
    },
    'height' => {
        data_type => 'int',
        description => 'Represents the width of Spinner, in unit of pixel.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_shapes_put_worksheet_shape' } = { 
    	summary => 'Add shape in worksheet',
        params => $params,
        returns => 'ShapeResponse',
        };
}
# @return ShapeResponse
#
sub cells_shapes_put_worksheet_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'drawing_type' is set
    unless (exists $args{'drawing_type'}) {
      croak("Missing the required parameter 'drawing_type' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'upper_left_row' is set
    unless (exists $args{'upper_left_row'}) {
      croak("Missing the required parameter 'upper_left_row' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'upper_left_column' is set
    unless (exists $args{'upper_left_column'}) {
      croak("Missing the required parameter 'upper_left_column' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'top' is set
    unless (exists $args{'top'}) {
      croak("Missing the required parameter 'top' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'left' is set
    unless (exists $args{'left'}) {
      croak("Missing the required parameter 'left' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'width' is set
    unless (exists $args{'width'}) {
      croak("Missing the required parameter 'width' when calling cells_shapes_put_worksheet_shape");
    }

    # verify the required parameter 'height' is set
    unless (exists $args{'height'}) {
      croak("Missing the required parameter 'height' when calling cells_shapes_put_worksheet_shape");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/shapes';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'drawing_type'}) {
        $query_params->{'DrawingType'} = $self->{api_client}->to_query_value($args{'drawing_type'});
    }

    # query params
    if ( exists $args{'upper_left_row'}) {
        $query_params->{'upperLeftRow'} = $self->{api_client}->to_query_value($args{'upper_left_row'});
    }

    # query params
    if ( exists $args{'upper_left_column'}) {
        $query_params->{'upperLeftColumn'} = $self->{api_client}->to_query_value($args{'upper_left_column'});
    }

    # query params
    if ( exists $args{'top'}) {
        $query_params->{'top'} = $self->{api_client}->to_query_value($args{'top'});
    }

    # query params
    if ( exists $args{'left'}) {
        $query_params->{'left'} = $self->{api_client}->to_query_value($args{'left'});
    }

    # query params
    if ( exists $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if ( exists $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeResponse', $response);
    return $_response_object;
}

1;
