/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TempBufferHolder;
import com.healthmarketscience.jackcess.impl.TempPageHolder;
import com.healthmarketscience.jackcess.impl.UsageMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LongValueColumnImpl
extends ColumnImpl {
    private static final byte LONG_VALUE_TYPE_THIS_PAGE = -128;
    private static final byte LONG_VALUE_TYPE_OTHER_PAGE = 64;
    private static final byte LONG_VALUE_TYPE_OTHER_PAGES = 0;
    private static final int LONG_VALUE_TYPE_MASK = -1073741824;
    private LongValueBufferHolder _lvalBufferH;

    LongValueColumnImpl(ColumnImpl.InitArgs args) throws IOException {
        super(args);
    }

    @Override
    public int getOwnedPageCount() {
        return this._lvalBufferH == null ? 0 : this._lvalBufferH.getOwnedPageCount();
    }

    @Override
    void setUsageMaps(UsageMap ownedPages, UsageMap freeSpacePages) {
        this._lvalBufferH = new UmapLongValueBufferHolder(ownedPages, freeSpacePages);
    }

    @Override
    void collectUsageMapPages(Collection<Integer> pages) {
        this._lvalBufferH.collectUsageMapPages(pages);
    }

    @Override
    void postTableLoadInit() throws IOException {
        if (this._lvalBufferH == null) {
            this._lvalBufferH = new LegacyLongValueBufferHolder();
        }
        super.postTableLoadInit();
    }

    protected int getMaxLengthInUnits() {
        return this.getType().toUnitSize(this.getType().getMaxSize());
    }

    @Override
    public Object read(byte[] data, ByteOrder order) throws IOException {
        switch (this.getType()) {
            case OLE: {
                if (data.length > 0) {
                    return this.readLongValue(data);
                }
                return null;
            }
            case MEMO: {
                if (data.length > 0) {
                    return this.readLongStringValue(data);
                }
                return null;
            }
        }
        throw new RuntimeException(this.withErrorContext("unexpected var length, long value type: " + (Object)((Object)this.getType())));
    }

    @Override
    protected ByteBuffer writeRealData(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
        switch (this.getType()) {
            case OLE: {
                break;
            }
            case MEMO: {
                obj = this.encodeTextValue(obj, 0, this.getMaxLengthInUnits(), false).array();
                break;
            }
            default: {
                throw new RuntimeException(this.withErrorContext("unexpected var length, long value type: " + (Object)((Object)this.getType())));
            }
        }
        return this.writeLongValue(LongValueColumnImpl.toByteArray(obj), remainingRowLength);
    }

    protected byte[] readLongValue(byte[] lvalDefinition) throws IOException {
        ByteBuffer def = PageChannel.wrap(lvalDefinition);
        int lengthWithFlags = def.getInt();
        int length = lengthWithFlags & 0x3FFFFFFF;
        byte[] rtn = new byte[length];
        byte type = (byte)((lengthWithFlags & 0xC0000000) >>> 24);
        if (type == -128) {
            def.getInt();
            def.getInt();
            int rowLen = def.remaining();
            if (rowLen < length) {
                LOG.warn(this.withErrorContext("Value may be truncated: expected length " + length + " found " + rowLen));
                rtn = new byte[rowLen];
            }
            def.get(rtn);
        } else {
            if (lvalDefinition.length != this.getFormat().SIZE_LONG_VALUE_DEF) {
                throw new IOException(this.withErrorContext("Expected " + this.getFormat().SIZE_LONG_VALUE_DEF + " bytes in long value definition, but found " + lvalDefinition.length));
            }
            int rowNum = ByteUtil.getUnsignedByte(def);
            int pageNum = ByteUtil.get3ByteInt(def, def.position());
            ByteBuffer lvalPage = this.getPageChannel().createPageBuffer();
            switch (type) {
                case 64: {
                    this.getPageChannel().readPage(lvalPage, pageNum);
                    short rowStart = TableImpl.findRowStart(lvalPage, rowNum, this.getFormat());
                    short rowEnd = TableImpl.findRowEnd(lvalPage, rowNum, this.getFormat());
                    int rowLen = rowEnd - rowStart;
                    if (rowLen < length) {
                        LOG.warn(this.withErrorContext("Value may be truncated: expected length " + length + " found " + rowLen));
                        rtn = new byte[rowLen];
                    }
                    lvalPage.position(rowStart);
                    lvalPage.get(rtn);
                    break;
                }
                case 0: {
                    int chunkLength;
                    ByteBuffer rtnBuf = ByteBuffer.wrap(rtn);
                    for (int remainingLen = length; remainingLen > 0; remainingLen -= chunkLength) {
                        lvalPage.clear();
                        this.getPageChannel().readPage(lvalPage, pageNum);
                        short rowStart = TableImpl.findRowStart(lvalPage, rowNum, this.getFormat());
                        short rowEnd = TableImpl.findRowEnd(lvalPage, rowNum, this.getFormat());
                        lvalPage.position(rowStart);
                        rowNum = ByteUtil.getUnsignedByte(lvalPage);
                        pageNum = ByteUtil.get3ByteInt(lvalPage);
                        chunkLength = rowEnd - rowStart - 4;
                        if (chunkLength > remainingLen) {
                            rowEnd = (short)(rowEnd - (chunkLength - remainingLen));
                            chunkLength = remainingLen;
                        }
                        lvalPage.limit(rowEnd);
                        rtnBuf.put(lvalPage);
                    }
                    break;
                }
                default: {
                    throw new IOException(this.withErrorContext("Unrecognized long value type: " + type));
                }
            }
        }
        return rtn;
    }

    private String readLongStringValue(byte[] lvalDefinition) throws IOException {
        byte[] binData = this.readLongValue(lvalDefinition);
        if (binData == null) {
            return null;
        }
        if (binData.length == 0) {
            return "";
        }
        return this.decodeTextValue(binData);
    }

    protected ByteBuffer writeLongValue(byte[] value, int remainingRowLength) throws IOException {
        if (value.length > this.getType().getMaxSize()) {
            throw new IOException(this.withErrorContext("value too big for column, max " + this.getType().getMaxSize() + ", got " + value.length));
        }
        int type = 0;
        int lvalDefLen = this.getFormat().SIZE_LONG_VALUE_DEF;
        if (this.getFormat().SIZE_LONG_VALUE_DEF + value.length <= remainingRowLength && value.length <= this.getFormat().MAX_INLINE_LONG_VALUE_SIZE) {
            type = -128;
            lvalDefLen += value.length;
        } else {
            type = value.length <= this.getFormat().MAX_LONG_VALUE_ROW_SIZE ? 64 : 0;
        }
        ByteBuffer def = PageChannel.createBuffer(lvalDefLen);
        int lengthWithFlags = value.length | type << 24;
        def.putInt(lengthWithFlags);
        if (type == -128) {
            def.putInt(0);
            def.putInt(0);
            def.put(value);
        } else {
            ByteBuffer lvalPage = null;
            int firstLvalPageNum = -1;
            byte firstLvalRow = 0;
            switch (type) {
                case 64: {
                    lvalPage = this._lvalBufferH.getLongValuePage(value.length);
                    firstLvalPageNum = this._lvalBufferH.getPageNumber();
                    firstLvalRow = (byte)TableImpl.addDataPageRow(lvalPage, value.length, this.getFormat(), 0);
                    lvalPage.put(value);
                    this.getPageChannel().writePage(lvalPage, firstLvalPageNum);
                    break;
                }
                case 0: {
                    int chunkLength;
                    int remainingLen;
                    ByteBuffer buffer = ByteBuffer.wrap(value);
                    buffer.limit(0);
                    lvalPage = this._lvalBufferH.getLongValuePage(remainingLen);
                    firstLvalPageNum = this._lvalBufferH.getPageNumber();
                    firstLvalRow = (byte)TableImpl.getRowsOnDataPage(lvalPage, this.getFormat());
                    int lvalPageNum = firstLvalPageNum;
                    ByteBuffer nextLvalPage = null;
                    int nextLvalPageNum = 0;
                    int nextLvalRowNum = 0;
                    for (remainingLen = buffer.remaining(); remainingLen > 0; remainingLen -= chunkLength) {
                        lvalPage.clear();
                        chunkLength = Math.min(this.getFormat().MAX_LONG_VALUE_ROW_SIZE - 4, remainingLen);
                        if (chunkLength < remainingLen) {
                            this._lvalBufferH.clear();
                            nextLvalPage = this._lvalBufferH.getLongValuePage(remainingLen - chunkLength + 4);
                            nextLvalPageNum = this._lvalBufferH.getPageNumber();
                            nextLvalRowNum = TableImpl.getRowsOnDataPage(nextLvalPage, this.getFormat());
                        } else {
                            nextLvalPage = null;
                            nextLvalPageNum = 0;
                            nextLvalRowNum = 0;
                        }
                        TableImpl.addDataPageRow(lvalPage, chunkLength + 4, this.getFormat(), 0);
                        lvalPage.put((byte)nextLvalRowNum);
                        ByteUtil.put3ByteInt(lvalPage, nextLvalPageNum);
                        buffer.limit(buffer.limit() + chunkLength);
                        lvalPage.put(buffer);
                        this.getPageChannel().writePage(lvalPage, lvalPageNum);
                        lvalPage = nextLvalPage;
                        lvalPageNum = nextLvalPageNum;
                    }
                    break;
                }
                default: {
                    throw new IOException(this.withErrorContext("Unrecognized long value type: " + type));
                }
            }
            def.put(firstLvalRow);
            ByteUtil.put3ByteInt(def, firstLvalPageNum);
            def.putInt(0);
        }
        def.flip();
        return def;
    }

    private void writeLongValueHeader(ByteBuffer lvalPage) {
        lvalPage.put((byte)1);
        lvalPage.put((byte)1);
        lvalPage.putShort((short)this.getFormat().DATA_PAGE_INITIAL_FREE_SPACE);
        lvalPage.put((byte)76);
        lvalPage.put((byte)86);
        lvalPage.put((byte)65);
        lvalPage.put((byte)76);
        lvalPage.putInt(0);
        lvalPage.putShort((short)0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UmapLongValueBufferHolder
    extends LongValueBufferHolder {
        private final UsageMap _ownedPages;
        private final UsageMap _freeSpacePages;
        private final TempPageHolder _longValueBufferH;

        private UmapLongValueBufferHolder(UsageMap ownedPages, UsageMap freeSpacePages) {
            this._longValueBufferH = TempPageHolder.newHolder(TempBufferHolder.Type.SOFT);
            this._ownedPages = ownedPages;
            this._freeSpacePages = freeSpacePages;
        }

        @Override
        protected TempPageHolder getBufferHolder() {
            return this._longValueBufferH;
        }

        @Override
        public int getOwnedPageCount() {
            return this._ownedPages.getPageCount();
        }

        @Override
        protected ByteBuffer findNewPage(int dataLength) throws IOException {
            ByteBuffer newPage = TableImpl.findFreeRowSpace(this._ownedPages, this._freeSpacePages, this._longValueBufferH);
            if (newPage != null) {
                if (TableImpl.rowFitsOnDataPage(dataLength, newPage, LongValueColumnImpl.this.getFormat())) {
                    return newPage;
                }
                this.clear();
            }
            newPage = super.findNewPage(dataLength);
            int pageNumber = this.getPageNumber();
            this._ownedPages.addPageNumber(pageNumber);
            this._freeSpacePages.addPageNumber(pageNumber);
            return newPage;
        }

        @Override
        public void clear() throws IOException {
            int pageNumber = this.getPageNumber();
            if (pageNumber != -1) {
                this._freeSpacePages.removePageNumber(pageNumber);
            }
            super.clear();
        }

        @Override
        public void collectUsageMapPages(Collection<Integer> pages) {
            pages.add(this._ownedPages.getTablePageNumber());
            pages.add(this._freeSpacePages.getTablePageNumber());
        }
    }

    private final class LegacyLongValueBufferHolder
    extends LongValueBufferHolder {
        private LegacyLongValueBufferHolder() {
        }

        protected TempPageHolder getBufferHolder() {
            return LongValueColumnImpl.this.getTable().getLongValueBuffer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LongValueBufferHolder {
        private LongValueBufferHolder() {
        }

        public ByteBuffer getLongValuePage(int dataLength) throws IOException {
            TempPageHolder lvalBufferH = this.getBufferHolder();
            dataLength = Math.min(dataLength, LongValueColumnImpl.this.getFormat().MAX_LONG_VALUE_ROW_SIZE);
            ByteBuffer lvalPage = null;
            if (lvalBufferH.getPageNumber() != -1 && TableImpl.rowFitsOnDataPage(dataLength, lvalPage = lvalBufferH.getPage(LongValueColumnImpl.this.getPageChannel()), LongValueColumnImpl.this.getFormat())) {
                return lvalPage;
            }
            return this.findNewPage(dataLength);
        }

        protected ByteBuffer findNewPage(int dataLength) throws IOException {
            ByteBuffer lvalPage = this.getBufferHolder().setNewPage(LongValueColumnImpl.this.getPageChannel());
            LongValueColumnImpl.this.writeLongValueHeader(lvalPage);
            return lvalPage;
        }

        public int getOwnedPageCount() {
            return 0;
        }

        public int getPageNumber() {
            return this.getBufferHolder().getPageNumber();
        }

        public void clear() throws IOException {
            this.getBufferHolder().clear();
        }

        public void collectUsageMapPages(Collection<Integer> pages) {
        }

        protected abstract TempPageHolder getBufferHolder();
    }
}

