#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Audio::Signal::Tone::Exp;

  use Moose;
  
  extends 'Audio::Signal::Tone';

  has 'rise' => (
    is => 'rw',
    isa => 'Num',
    trigger => sub {
      my ($self,$val,$old) = @_;
      if($val < 0 || $val > 8092) {
        warn "Regrettably, sustain parameter for pluck synth ${$self->position} is out of generous range.";
      }
    },
  );

  has 'fall' => (
    is => 'rw',
    isa => 'Num',
    trigger => sub {
      my ($self,$val,$old) = @_;
      if($val < 0 || $val > 8092) {
        warn "Regrettably, sustain parameter for pluck synth ${$self->position} is out of generous range.";
      }
    },
  );

  sub gencmd {
    my $self = shift;
    my $ret = sprintf("%s %s %s %s",$self->fm,$self->note,$self->rise,$self->fall);
    return($ret);
  }
}

1;
