use CamelPub::Commands;
use CamelPub::ActivityPub;

module CamelPubTool {
  module Grammar {
    our grammar Cli {
      rule TOP { <command> <params> }
      token command { \w+ }
      token params { .* }
    }
  }

  our sub dispatch(ActivityPub::Document $profile, Grammar::Cli $ast) {
    given $ast{'command'} {
      when "follow" { Commands::follow($profile, $ast{'params'}) }
      when "listen" { Commands::listen($profile, $ast{'params'}) }
      default { say "{$_} not understood"; help() }
    }
  }

  our sub help {
    say "\$ camelpub <command>";
    say "follow <url>";
    say "listen";
  }
}
