package Google::Ads::AdWords::v201109::ServicedAccountGraph;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201109' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %accounts_of :ATTR(:get<accounts>);
my %links_of :ATTR(:get<links>);

__PACKAGE__->_factory(
    [ qw(        accounts
        links

    ) ],
    {
        'accounts' => \%accounts_of,
        'links' => \%links_of,
    },
    {
        'accounts' => 'Google::Ads::AdWords::v201109::Account',
        'links' => 'Google::Ads::AdWords::v201109::Link',
    },
    {

        'accounts' => 'accounts',
        'links' => 'links',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109::ServicedAccountGraph

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ServicedAccountGraph from the namespace https://adwords.google.com/api/adwords/mcm/v201109.

Represents a list of the requested managers and clients, and the relationships between them. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * accounts


=item * links




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109::ServicedAccountGraph
   accounts =>  $a_reference_to, # see Google::Ads::AdWords::v201109::Account
   links =>  $a_reference_to, # see Google::Ads::AdWords::v201109::Link
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

