use lib 'inc';

require Module::Build;

my %module_build_args = (
    module_name => 'App::ClusterSSH',
  'build_requires' => {
    'Module::Build' => '0.28'
  },
  'configure_requires' => {
    'Module::Build' => '0.28'
  },
  'recommends' => {
    'Sort::Naturally' => '1.03'
  },
  'requires' => {
    'Carp' => '0',
    'English' => '0',
    'Exception::Class' => '1.31',
    'Fcntl' => '0',
    'File::Basename' => '0',
    'File::Copy' => '0',
    'File::Glob' => '0',
    'File::Path' => '0',
    'File::Temp' => '0',
    'FindBin' => '0',
    'Getopt::Long' => '2.48',
    'Locale::Maketext' => '1.01',
    'Module::Load' => '0',
    'Net::hostent' => '0',
    'POSIX' => '0',
    'Pod::Usage' => '0',
    'Socket' => '0',
    'Sys::Hostname' => '0',
    'Tk' => '800.022',
    'Tk::Dialog' => '0',
    'Tk::LabEntry' => '0',
    'Tk::ROText' => '0',
    'Tk::Xlib' => '0',
    'Try::Tiny' => '0.28',
    'X11::Keysyms' => '0',
    'X11::Protocol' => '0.56',
    'X11::Protocol::Constants' => '0',
    'X11::Protocol::WM' => '29',
    'XML::Simple' => '0',
    'base' => '0',
    'overload' => '0',
    'strict' => '0',
    'vars' => '0',
    'version' => '0',
    'warnings' => '0'
  },
  'test_requires' => {
    'Data::Dump' => '0',
    'File::Which' => '0',
    'Getopt::Std' => '0',
    'Readonly' => '0',
    'Test::Differences' => '0',
    'Test::More' => '0',
    'Test::Trap' => '0',
    'lib' => '0'
  },

    script_files => [
        'bin/cssh', 'bin/csftp',
        'bin/ccon', 'bin/crsh',
        'bin/ctel', 'bin/clusterssh_bash_completion.dist'
    ],
    PL_files    => {
        'bin_PL/_build_docs' => [
            'bin/cssh', 'bin/csftp',
            'bin/ccon', 'bin/crsh',
            'bin/ctel', 'bin/clusterssh_bash_completion.dist'
        ],
    },
);

unless ( eval { Module::Build->VERSION(0.4004) } ) {
    my $tr = delete $module_build_args{test_requires};
    my $br = $module_build_args{build_requires};
    for my $mod ( keys %$tr ) {
        if ( exists $br->{$mod} ) {
            $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
        }
        else {
            $br->{$mod} = $tr->{$mod};
        }
    }
}    # end unless Module::Build is 0.4004 or newer

my $builder = Module::Build->new(%module_build_args);
$builder->create_build_script;
