package App::Manoc::DB::ResultSet;
#ABSTRACT: base class for Manoc dbic resultset classes

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'DBIx::Class::ResultSet';

# do not load ingnorewantarray helper since it breaks
# HTML::FormHandler
#
# also avoid Helper::ResultSet::AutoRemoveColumns
__PACKAGE__->load_components(
    qw{
        Helper::ResultSet::CorrelateRelationship
        Helper::ResultSet::Me
        Helper::ResultSet::NoColumns
        Helper::ResultSet::RemoveColumns
        Helper::ResultSet::ResultClassDWIM
        Helper::ResultSet::SearchOr
        Helper::ResultSet::SetOperations
        Helper::ResultSet::Shortcut
        }
);

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet - base class for Manoc dbic resultset classes

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
