/**
 * File with actions of the blast page
 * 
 * @author Wendel Hime Lino Castro
 */

$("#back").hide();

$("#SEQFILE").on("change", function() {
	startRead("SEQFILE");
});

/**
 * Button back on click
 */
$("#back").click(function() {
	$("#formBlast").show();
	$("#SEQFILE").val("");
	$("#back").hide();
	$(".response").remove();
	$(".errors").remove();
});

/**
 * Add function to submit form
 */
$(function() {
	$("#formBlast").submit(function() {
		if ($("#SEQUENCE").val() == "") {
			$("#SEQUENCE").val(fileContent);
			$("#FILESEQ").val("");
		}
		if ($("#SEQUENCE").val() != "") {
			// var sourceObject = JSON.parse(JSON.stringify($("#formBlast")
			// .serializeArray().reduce(function(a, x) {
			// a[x.name] = x.value;
			// return a;
			// }, {})));
			$("#SEQUENCE").val($("#SEQUENCE").val().replace(/[#%&{}\\<*?\/$!'":;@]/g, ""));
            $("#SEQUENCE").val($("#SEQUENCE").val().replace(/ /g, "_"));
            $("#SEQUENCE").val($("#SEQUENCE").val().replace(/_*\([\w\.\)]*\)/g, ""));
            if(!($("#gapCosts").prop('disabled'))) {
                var gapValues = $("#gapCosts").val().split(" ");
                $("#COST_OPEN_GAP").val(gapValues[0]);
                $("#COST_EXTEND_GAP").val(gapValues[1]);
            }
			var form = document.getElementById("formBlast");
			var formData = new FormData(form);
			var baseResponse = postBlast(formData).done(function(baseResponse) {
				baseResponse = JSON.parse(baseResponse);
				var response = baseResponse.response;
				if(!response.html) {
					$("#formBlast").append("<div class='row'><div class='col-md-12'><div class='alert alert-danger errors'> Oops, there is something wrong with the query, please check fields and try again </div></div></div>");
				}
				var srcToChange = response.html.match(/<img src="([\.\w\s]*)"/gm);
				response.html = response.html.replace(srcToChange, "<img src='data:image/png;base64,"+response.image+"' ");
				$("#back").show();
				$("#formBlast").hide();
				var html = "<div class='row response'><div class='col-md-12'>" + response.html + "</div></div>";
				$("#containerBlast").append(html);
			}).fail(function() {
				$("#formBlast").append("<div class='row'><div class='col-md-12'><div class='alert alert-danger errors'> Oops, there is something wrong with the query, please check fields and try again </div></div></div>");
			});
		}
		return false;
	});
});

$('#program').on('change', function() {
    $("#gapCosts option").remove();
    $("#wordSize option").remove(); 
    if(this.value == "blastn") {
        $("#gapCosts").prop("disabled", false);
        $("#matrix").val("BLOSUM62");
        $("#matrix").prop("disabled", true);
        $("#gapCosts").append($('<option>', {
            value: '0 0',
            text: 'Linear'
        }), $('<option>', {
            value: '5 2',
            text: 'Existence: 5 Extension: 2'
        }), $('<option>', {
            value: '2 2',
            text: 'Existence: 2 Extension: 2'
        }), $('<option>', {
            value: '1 2',
            text: 'Existence: 1 Extension: 2'
        }), $('<option>', {
            value: '0 2',
            text: 'Existence: 0 Extension: 2'
        }), $('<option>', {
            value: '3 1',
            text: 'Existence: 3 Extension: 1'
        }), $('<option>', {
            value: '2 1',
            text: 'Existence: 2 Extension: 1'
        }), $('<option>', {
            value: '1 1',
            text: 'Existence: 1 Extension: 1'
        })); 
        $("#wordSize").append($('<option>', {
            value: '16',
            text: '16'
        }), $('<option>', {
            value: '20',
            text: '20'
        }), $('<option>', {
            value: '24',
            text: '24'
        }), $('<option>', {
            value: '28',
            text: '28',
            selected: 'selected'
        }), $('<option>', {
            value: '32',
            text: '32'
        }), $('<option>', {
            value: '48',
            text: '48'
        }), $('<option>', {
            value: '64',
            text: '64'
        }), $('<option>', {
            value: '128',
            text: '128'
        }), $('<option>', {
            value: '256',
            text: '256'
        }));
    } else if(this.value == "blastx" || this.value == "tblastn" || this.value == "blastp" ) {
        $("#gapCosts").prop("disabled", false); 
        $("#matrix").val("BLOSUM62");
        $("#matrix").prop("disabled", false); 
        $("#gapCosts").append($('<option>', {
            value: '11 2',
            text: 'Existence: 11 Extension: 2'
        }), $('<option>', {
            value: '10 2',
            text: 'Existence: 10 Extension: 2'
        }), $('<option>', {
            value: '9 2',
            text: 'Existence: 9 Extension: 2'
        }), $('<option>', {
            value: '8 2',
            text: 'Existence: 8 Extension: 2'
        }), $('<option>', {
            value: '7 2',
            text: 'Existence: 7 Extension: 2'
        }), $('<option>', {
            value: '6 2',
            text: 'Existence: 6 Extension: 2'
        }), $('<option>', {
            value: '13 1',
            text: 'Existence: 13 Extension: 1'
        }), $('<option>', {
            value: '12 1',
            text: 'Existence: 12 Extension: 1'
        }), $('<option>', {
            value: '11 1',
            text: 'Existence: 11 Extension: 1',
            selected: 'selected'
        }), $('<option>', {
            value: '10 1',
            text: 'Existence: 10 Extension: 1'
        }), $('<option>', {
            value: '9 1',
            text: 'Existence: 9 Extension: 1'
        }));
        $("#wordSize").append($('<option>', {
            value: '2',
            text: '2'
        }), $('<option>', {
            value: '3',
            text: '3'
        }), $('<option>', {
            value: '6',
            text: '6',
            selected: 'selected'
        }));
    } else if(this.value == "tblastx") {
        $("#matrix").val("BLOSUM62");
        $("#matrix").prop("disabled", false);  
        $("#wordSize").append($('<option>', {
            value: '2',
            text: '2'
        }), $('<option>', {
            value: '3',
            text: '3',
            selected: 'selected'
        }));
        $("#gapCosts").prop("disabled", true);
    }
});

$("#matrix").on("change", function() {
    if($("#program").val() != "blastn") { 
        if(this.value == "PAM30") {
            $("#gapCosts option").remove();
            $("#gapCosts").append("<option value='7 2'>Existence: 7 Extension: 2</option><option value='6 2'>Existence: 6 Extension: 2</option><option value='5 2'>Existence: 5 Extension: 2</option><option value='10 1'>Existence: 10 Extension: 1</option><option value='9 1' selected='selected'>Existence: 9 Extension: 1</option><option value='8 1'>Existence: 8 Extension: 1</option><option value='13 3'>Existence: 13 Extension: 3</option><option value='15 3'>Existence: 15 Extension: 3</option><option value='14 1'>Existence: 14 Extension: 1</option><option value='14 2'>Existence: 14 Extension: 2</option> ");
        } else if(this.value == "PAM70") {
            $("#gapCosts option").remove();
            $("#gapCosts").append("<option value='8 2'>Existence: 8 Extension: 2</option><option value='7 2'>Existence: 7 Extension: 2</option><option value='6 2'>Existence: 6 Extension: 2</option><option value='11 1'>Existence: 11 Extension: 1</option><option value='10 1' selected='selected'>Existence: 10 Extension: 1</option><option value='9 1'>Existence: 9 Extension: 1</option><option value='12 3'>Existence:12 Extension: 3</option><option value='11 2'>Existence: 11 Extension: 2</option>");
        } else if(this.value == "PAM250") {
            $("#gapCosts option").remove();
            $("#gapCosts").append("<option value='15 3'>Existence: 15 Extension: 3</option><option value='14 3'>Existence: 14 Extension: 3</option><option value='13 3'>Existence: 13 Extension: 3</option><option value='12 3'>Existence: 12 Extension: 3</option><option value='11 3'>Existence: 11 Extension: 3</option><option value='17 2'>Existence: 17 Extension: 2</option><option value='16 2'>Existence: 16 Extension: 2</option><option value='15 2'>Existence: 15 Extension: 2</option><option value='14 2'>Existence: 14 Extension: 2</option><option value='13 2'>Existence: 13 Extension: 2</option><option value='21 1'>Existence: 21 Extension: 1</option><option value='20 1'>Existence: 20 Extension: 1</option><option value='19 1'>Existence: 19 Extension: 1</option><option value='18 1'>Existence: 18 Extension: 1</option><option value='17 1'>Existence: 17 Extension: 1</option>");
        } else if(this.value == "BLOSUM80") {
            $("#gapCosts option").remove();
            $("#gapCosts").append("<option value='8 2'>Existence: 8 Extension: 2</option><option value='7 2'>Existence: 7 Extension: 2</option><option value='6 2'>Existence: 6 Extension: 2</option><option value='11 1'>Existence: 11 Extension: 1</option><option value='10 1' selected='selected'>Existence: 10 Extension: 1</option><option value='9 1'>Existence: 9 Extension: 1</option>");
        } else if(this.value == "BLOSUM62") {
            $("#gapCosts option").remove();
            $("#gapCosts").append("<option value='11 2'>Existence: 11 Extension: 2</option><option value='10 2'>Existence: 10 Extension: 2</option><option value='9 2'>Existence: 9 Extension: 2</option><option value='8 2'>Existence: 8 Extension: 2</option><option value='7 2'>Existence: 7 Extension: 2</option><option value='6 2'>Existence: 6 Extension: 2</option><option value='13 1'>Existence: 13 Extension: 1</option><option value='12 1'>Existence: 12 Extension: 1</option><option value='11 1' selected='selected'>Existence: 11 Extension: 1</option><option value='10 1'>Existence: 10 Extension: 1</option><option value='9 1'>Existence: 9 Extension: 1</option>");
        } else if(this.value == "BLOSUM45") {
            $("#gapCosts option").remove();
            $("#gapCosts").append("<option value='13 3'>Existence: 13 Extension: 3</option><option value='12 3'>Existence: 12 Extension: 3</option><option value='11 3'>Existence: 11 Extension: 3</option><option value='10 3'>Existence: 10 Extension: 3</option><option value='15 2' selected='selected'>Existence: 15 Extension: 2</option><option value='14 2'>Existence: 14 Extension: 2</option><option value='13 2'>Existence: 13 Extension: 2</option><option value='12 2'>Existence: 12 Extension: 2</option><option value='19 1'>Existence: 19 Extension: 1</option><option value='18 1'>Existence: 18 Extension: 1</option><option value='17 1'>Existence: 17 Extension: 1</option><option value='16 1'>Existence: 16 Extension: 1</option>");
        } else if(this.value == "BLOSUM50") {
            $("#gapCosts option").remove();
            $("#gapCosts").append("<option value='13 3'>Existence: 13 Extension: 3</option><option value='12 3'>Existence: 12 Extension: 3</option><option value='11 3'>Existence: 11 Extension: 3</option><option value='10 3'>Existence: 10 Extension: 3</option><option value='9 3'>Existence: 9 Extension: 3</option><option value='16 2'>Existence: 16 Extension: 2</option><option value='15 2'>Existence: 15 Extension: 2</option><option value='14 2'>Existence: 14 Extension: 2</option><option value='13 2' selected='selected'>Existence: 13 Extension: 2</option><option value='12 2'>Existence: 12 Extension: 2</option><option value='19 1'>Existence: 19 Extension: 1</option><option value='18 1'>Existence: 18 Extension: 1</option><option value='17 1'>Existence: 17 Extension: 1</option><option value='16 1'>Existence: 16 Extension: 1</option><option value='15 1'>Existence: 15 Extension: 1</option>");
        } else if(this.value == "BLOSUM90") {
            $("#gapCosts option").remove();
            $("#gapCosts").append("<option value='9 2'>Existence: 9 Extension: 2</option><option value='8 2'>Existence: 8 Extension: 2</option><option value='7 2'>Existence: 7 Extension: 2</option><option value='6 2'>Existence: 6 Extension: 2</option><option value='11 1'>Existence: 11 Extension: 1</option><option value='10 1' selected='selected'>Existence: 10 Extension: 1</option><option value='9 1'>Existence: 9 Extension: 1</option>");
        }
    }
});
$("#matrix").prop("disabled", true); 
