use strict;
use warnings;
package Alien::PortMidi;

# ABSTRACT: Install the Mixxx fork of PortMidi

our $VERSION = '0.03';

use parent qw/ Alien::Base /;

BEGIN {
    # On *nix we can set RPATH to $ORIGIN so portmidi can find porttime
    # in the same dir. Windows DLL search path does not offer similar.
    # Explicitly loading porttime before portmidi obviates the need to
    # worry about the Windows search path.
    if ( $^O eq 'MSWin32' ) {
        require DynaLoader;
        DynaLoader::dl_load_file($_)
          for grep { /porttime/ } __PACKAGE__->dynamic_libs;
    }
}








1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Alien::PortMidi - Install the Mixxx fork of PortMidi

=head1 VERSION

version 0.03

=head1 SYNOPSIS

In your Makefile.PL:

 use ExtUtils::MakeMaker;
 use Alien::Base::Wrapper ();

 WriteMakefile(
   Alien::Base::Wrapper->new('Alien::PortMidi')->mm_args2(
     # MakeMaker args
     NAME => 'My::XS',
     ...
   ),
 );

In your Build.PL:

 use Module::Build;
 use Alien::Base::Wrapper qw( Alien::PortMidi !export );

 my $builder = Module::Build->new(
   ...
   configure_requires => {
     'Alien::PortMidi' => '0',
     ...
   },
   Alien::Base::Wrapper->mb_args,
   ...
 );

 $build->create_build_script;

In your L<FFI::Platypus> script or module:

 use FFI::Platypus;
 use Alien::PortMidi;

 my $ffi = FFI::Platypus->new(
   lib => [ Alien::PortMidi->dynamic_libs ],
 );

=head1 DESCRIPTION

This distribution provides PortMidi so that it can be used by other
Perl distributions that are on CPAN.  It does this by first trying to
detect an existing install of PortMidi on your system.  If found it
will use that.  If it cannot be found, the source code will be downloaded
from the internet and it will be installed in a private share location
for the use of other modules.

=head1 SEE ALSO

L<Alien>, L<Alien::Base>, L<Alien::Build::Manual::AlienUser>

=head1 AUTHOR

John Barrett <john@jbrt.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by John Barrett.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
