package Class::Stack;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::Array );
    our $VERSION = 'v0.1.0';
};

1;

__END__

=encoding utf8

=head1 NAME

Class::Stack - An Array Object Class

=head1 SYNOPSIS

    use Class::Stack;
    my $a = Class::Stack->new;

=head1 VERSION

    v0.1.0

=head1 DESCRIPTION

This package provides a versatile array class object for the manipulation and chaining of arrays.

See L<Module::Generic::Array> for more information.

=head1 SEE ALSO

L<Class::Stack>, L<Class::String>, L<Class::Number>, L<Class::Boolean>, L<Class::Assoc>, L<Class::File>, L<Class::DateTime>, L<Class::Exception>, L<Class::Finfo>, L<Class::NullChain>

=head1 AUTHOR

Jacques Deguest E<lt>F<jack@deguest.jp>E<gt>

=head1 COPYRIGHT & LICENSE

Copyright (c) 2021 DEGUEST Pte. Ltd.

You can use, copy, modify and redistribute this package and associated
files under the same terms as Perl itself.

=cut

