// __AUTOGENERATED__ for __NAME__
const path = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');

const isDev = process.env.NODE_ENV !== 'production';
const sourceMap = process.env.WEBPACK_SOURCE_MAPS ? true : isDev ? true : false;

const config = {
  mode: isDev ? 'development' : 'production',
  module: {rules: []},
  optimization: {minimizer: []},
  output: {
    filename: isDev ? '[name].development.js' : '[name].[chunkhash].js',
    path: process.env.WEBPACK_OUT_DIR || path.resolve(__dirname, './public/asset'),
    publicPath: '',
  },
  plugins: [
    new HtmlWebpackPlugin({
      cache: true,
      filename: './webpack.' + (process.env.WEBPACK_CUSTOM_NAME ? process.env.WEBPACK_CUSTOM_NAME : isDev ? 'development' : 'production') + '.html',
      hash: false,
      inject: 'head',
      minify: false,
      showErrors: true,
      template: (process.env.WEBPACK_SHARE_DIR || './assets') + '/webpack.html',
      xhtml: false,
    }),
  ]
};

if (process.env.WEBPACK_RULE_FOR_JS) {
  const TerserPlugin = require('terser-webpack-plugin');
  config.optimization.minimizer.push(new TerserPlugin({parallel: true}));
  config.module.rules.push({
    test: /\.js$/,
    exclude: /node_modules/,
    use: {loader: 'babel-loader'},
  });
}

if (process.env.WEBPACK_RULE_FOR_CSS || process.env.WEBPACK_RULE_FOR_SASS) {
  var MiniCssExtractPlugin = require('mini-css-extract-plugin');
  config.plugins.push(new MiniCssExtractPlugin({filename: isDev ? '[name].development.css' : '[name].[contenthash].css'}));

  const OptimizeCSSAssetsPlugin = require('css-minimizer-webpack-plugin');
  config.optimization.minimizer.push(new OptimizeCSSAssetsPlugin({}));
}

if (process.env.WEBPACK_RULE_FOR_CSS) {
  config.module.rules.push({
    test: /\.css$/,
    use: [MiniCssExtractPlugin.loader, {loader: 'css-loader', options: {sourceMap}}],
  });
}

if (process.env.WEBPACK_RULE_FOR_SASS) {
  const sassIncludePaths = (process.env.SASS_INCLUDE_PATHS || '').split(':');
  config.module.rules.push({
    test: /\.s(a|c)ss$/,
    use: [
      MiniCssExtractPlugin.loader,
      {loader: 'css-loader', options: {sourceMap}},
      {loader: 'sass-loader', options: {sassOptions: {includePaths: sassIncludePaths}, sourceMap}}
    ],
  });
}

if (process.env.WEBPACK_RULE_FOR_VUE) {
  const { VueLoaderPlugin } = require('vue-loader')
  config.plugins.push(new VueLoaderPlugin());
  config.module.rules.push({test: /\.vue$/, use: 'vue-loader'});
}

require('./assets/webpack.' + (process.env.WEBPACK_CUSTOM_NAME || 'custom') + '.js')(config);

module.exports = config;
