# Generated by default/object.tt
package Paws::GameLift::GameServerGroupAutoScalingPolicy;
  use Moose;
  has EstimatedInstanceWarmup => (is => 'ro', isa => 'Int');
  has TargetTrackingConfiguration => (is => 'ro', isa => 'Paws::GameLift::TargetTrackingConfiguration', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::GameServerGroupAutoScalingPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::GameServerGroupAutoScalingPolicy object:

  $service_obj->Method(Att1 => { EstimatedInstanceWarmup => $value, ..., TargetTrackingConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::GameServerGroupAutoScalingPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->EstimatedInstanceWarmup

=head1 DESCRIPTION

B<This data type is used with the GameLift FleetIQ and game server
groups.>

Configuration settings for intelligent automatic scaling that uses
target tracking. These settings are used to add an Auto Scaling policy
when creating the corresponding Auto Scaling group with
CreateGameServerGroup. After the Auto Scaling group is created, all
updates to Auto Scaling policies, including changing this policy and
adding or removing other policies, is done directly on the Auto Scaling
group.

=head1 ATTRIBUTES


=head2 EstimatedInstanceWarmup => Int

Length of time, in seconds, it takes for a new instance to start new
game server processes and register with GameLift FleetIQ. Specifying a
warm-up time can be useful, particularly with game servers that take a
long time to start up, because it avoids prematurely starting new
instances.


=head2 B<REQUIRED> TargetTrackingConfiguration => L<Paws::GameLift::TargetTrackingConfiguration>

Settings for a target-based scaling policy applied to Auto Scaling
group. These settings are used to create a target-based policy that
tracks the GameLift FleetIQ metric C<"PercentUtilizedGameServers"> and
specifies a target value for the metric. As player usage changes, the
policy triggers to adjust the game server group capacity so that the
metric returns to the target value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

