# Generated by default/object.tt
package Paws::Appflow::RedshiftConnectorProfileProperties;
  use Moose;
  has BucketName => (is => 'ro', isa => 'Str', request_name => 'bucketName', traits => ['NameInRequest'], required => 1);
  has BucketPrefix => (is => 'ro', isa => 'Str', request_name => 'bucketPrefix', traits => ['NameInRequest']);
  has DatabaseUrl => (is => 'ro', isa => 'Str', request_name => 'databaseUrl', traits => ['NameInRequest'], required => 1);
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::RedshiftConnectorProfileProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::RedshiftConnectorProfileProperties object:

  $service_obj->Method(Att1 => { BucketName => $value, ..., RoleArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::RedshiftConnectorProfileProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->BucketName

=head1 DESCRIPTION

The connector-specific profile properties when using Amazon Redshift.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BucketName => Str

A name for the associated Amazon S3 bucket.


=head2 BucketPrefix => Str

The object key for the destination bucket in which Amazon AppFlow
places the files.


=head2 B<REQUIRED> DatabaseUrl => Str

The JDBC URL of the Amazon Redshift cluster.


=head2 B<REQUIRED> RoleArn => Str

The Amazon Resource Name (ARN) of the IAM role.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

