/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LatticeEdge
implements Serializable {
    public final String word;
    public String label = null;
    public double weight;
    public final int start;
    public final int end;
    public final Map<String, String> attrs;
    private static final long serialVersionUID = 4416189959485854286L;

    public LatticeEdge(String word, double weight2, int start, int end) {
        this.word = word;
        this.weight = weight2;
        this.start = start;
        this.end = end;
        this.attrs = new HashMap<String, String>();
    }

    public void setAttr(String key, String value) {
        this.attrs.put(key, value);
    }

    public String getAttr(String key) {
        return this.attrs.get(key);
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public void setWeight(double w) {
        this.weight = w;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ " + this.word);
        sb.append(String.format(" start(%d) end(%d) wt(%f) ]", this.start, this.end, this.weight));
        if (this.label != null) {
            sb.append(" / " + this.label);
        }
        return sb.toString();
    }
}

