#===============================================================================
#         FILE:  TackedPackage.pm
#  DESCRIPTION:  Object Generated by a UPS Tracking Request Object
#       AUTHOR:  Kyle Brandt (mn), kyle@kbrandt.com , http://www.kbrandt.com
#===============================================================================

package WebService::UPS::TrackedPackage;
use Data::Dumper;
use Mouse;
use WebService::UPS::Address;
use WebService::UPS::Activity;
has '_returned_xml' => ( is => 'rw' );
has 'debug' => ( is => 'rw' );

sub isError {
	my $self = shift;
	if (defined($self->_returned_xml()->{Response}{Error})) {
		return 1;
	} else {
		return 0;
	}
	if ($self->debug()) {
		print $self->_returned_xml()->{Response}{Error};
	}
}

sub getError {
	my $self = shift;
	return $self->_returned_xml()->{Response}{Error} // '';
}
	
sub getShipperAddress {
	my $self = shift;
	my $addressObject = WebService::UPS::Address->new( _address_hash => $self->_returned_xml()->{Shipment}{Shipper}{Address}) // '';
	return $addressObject;
}
	
sub getDestinationAddress {
	my $self = shift;
	my $addressObject = WebService::UPS::Address->new( _address_hash => $self->_returned_xml()->{Shipment}{ShipTo}{Address}) // '';
	return $addressObject;
}

sub getActivityCount {
	my $self = shift;
	my $activityArray = $self->_returned_xml()->{Shipment}{Package}{Activity} // [];
	my $activityArrayCount = @{$activityArray};
	return $activityArrayCount;
}

sub getActivity {
	my $self = shift;
	my $index = shift;
	unless (defined($index)) {
		$index = 0;
	}
	my $activityHash = $self->_returned_xml()->{Shipment}{Package}{Activity}[$index] // [];
	return WebService::UPS::Activity->new( _activity_hash => $activityHash);
}

sub getCurrentStatus {
	my $self = shift;
	my $currentStatus =  $self->_returned_xml()->{Shipment}{CurrentStatus}{Description} // '';
	return  $currentStatus;
}

sub getScheduledDeliveryDate {
	my $self = shift;
	my $ddate = $self->_returned_xml()->{Shipment}{ScheduledDeliveryDate} // '';
	return $ddate;

}

sub getActivityList {
	my $self = shift;
	my $delim = "\t";
	print "Date\tLocation\tStatus\n";
	my $actString;
	foreach my $index ( 0 .. ($self->getActivityCount() - 1) ) {
		my $activityObject = $self->getActivity($index);
		my $actAddress = $activityObject->getAddress();
		my $actDesc    = $activityObject->getDescription();
		$actString .= $activityObject->getDate() || 'NA';
		$actString .= $delim;
		$actString .= $actAddress->getCity() || 'NA';
		$actString .= ',';
		$actString .= $actAddress->getState() || 'NA';
		$actString .= $delim;
		$actString .= $actDesc || 'NA';
		$actString .= "\n";
	}
	return $actString;
}

sub getWeight {
	my $self = shift;
	my $weight = $self->_returned_xml()->{Shipment}{ShipmentWeight}{Weight} // '';
	my $unit = $self->_returned_xml()->{Shipment}{ShipmentWeight}{UnitOfMeasurement}{Code} // '';
	my $weightString = $weight . ' ' . $unit;
	return $weightString;
}

sub getDescription {
	my $self = shift;
	my $desc =  $self->_returned_xml()->{Response}{TransactionReference}{CustomerContext} // '';
	return $desc;
}
	
1;

=head1 NAME

WebService::UPS::TrackedPackage - Generated from the WebService::UPS::TrackRequest Object, Use this object to get tracking infomation

=head1 SYNOPSIS

    my $Package = WebService::UPS::TrackRequest->new;
    $Package->Username('kbrandt');
    $Package->Password('topsecrent');
    $Package->License('8C3D7EE8FZZZZZ4');
    $Package->TrackingNumber('1ZA45Y5111111111');
    print $Package->Username();
    my $trackedpackage = $Package->requestTrack();
    $trackedpackage->isError()

=head1 Methods

=head2 new()

    $trackedpackage = WebService::UPS::TrackRequest->new( _returned_xml => $object->requestTrack());

The constructor method that creates a new Request Object.  You probably should not be calling this directly as above, rather it should returned from the WebService::UPS::TrackRequest Object

=over 1

=item _returned_xml 
    
This is populated by the WebService::UPS::TrackRequest Object, you shouldn't be messing with it in general.  But if you dump it with dumper, and you are clever, you might be able to access things that my module doesn't have getters for.

=item debug
    
Set this to something to make a lot of stuff appear

=back

=head2 isError()

	$trackedpackage->isError()

Returns 1 if the UPS response says there was an error with your TrackRequest, if no error, returns 0.

=head2 isError()

	$trackedpackage->getError()

Returns the UPS response Error if your trackrequest was invalid

=head2 getShipperAddress()

	my $addressObject = $trackedpackage->getShipperAddress()

Returns a WebService::UPS::Address object with the shipper's address information.

=head2 getDestinationAddress()

See getShipperAddress, but for where the package is going.

=head2 getActivityCount;

	$trackedpackage->getActivityCount()

Returns how many 'Activity Entries' there are. This is useful if you want to iterate over the activity and return a bunch of WebService::UPS::Activity Objects. To itterate with it, make sure you use (- 1).

=head2 getActivity()

	$trackedpackage->getActivity(1)

Returns a WebService::UPS::Activity object at the index specified (1 in the above example).  If no argument is provided, the method will assume 0, which seems to be the most recent entry.  Use getActivityCount to find out how many activity Entries there are.

=head2 getCurrentStatus()

	$trackedpackage->getCurrentStatus()

Returns a string with UPS's summary of the shipment's current Status

=head2 getScheduledDeliveryDate()
	
	$trackedpackage->getScheduledDeliveryDate()

Returns when UPS thinks your package will be delivered might be returned, but be careful!!, this will still be there if the delivery date has been rescheduled.

=head2 getActivityList

	$trackedpackage->getActivityList()

A convenience method that uses other methods. This displays a tab delimited list with the Date, Location, and Description of all activity for the package (Also, a header). You might want to look at this as an example of how to use this module. 

=head2 getWeight()

	$trackedpackage->getWeight()

Returns a string "Weight Unit", for example "18.00 LBS"

=head2 getDescription()
	
	$trackedpackage->getDescription()
	
Returns a string which should be whatever you specified as the description attribute in your TrackRequest Object. However, it is fetched from the UPS response, hence 'should'.

=head1 AUTHOR

Kyle Brandt, kyle@kbrandt.com 
http://www.kbrandt.com

=cut
