use Test::More tests => 67;

require_ok('SSN::Validate');

my $ssn = new SSN::Validate;

my %ssns = (
    '444l63749'   => [ 0, 'OK' ],
    '000-56-3749' => [ 0, '' ],
    '444-00-3749' => [ 0, 'OK' ],
    '748010000'   => [ 0, '' ],
    '764-40-3145' => [ 0, '??' ],
    '710-22-7722' => [ 0, 'RB' ],
    '900-44-1234' => [ 0, '??' ], # Tax range
    '550-19-1234' => [ 0, 'CA' ], # Bad Combo
    '042-10-3580' => [ 0, 'CT' ],
    '062-36-0749' => [ 0, NY ],
    '078-05-1120' => [ 0, NY ],
    '095-07-3645' => [ 0, NY ],
    '128-03-6045' => [ 0, NY ],
    '135-01-6629' => [ 0, NJ ],
    '141-18-6941' => [ 0, NJ ],
    '165-16-7999' => [ 0, 'PA' ],
    '165-18-7999' => [ 0, 'PA' ],
    '165-20-7999' => [ 0, 'PA' ],
    '165-22-7999' => [ 0, 'PA' ],
    '165-24-7999' => [ 0, 'PA' ],
    '189-09-2294' => [ 0, 'PA' ],
    '212-09-7694' => [ 0, 'MD' ],
    '212-09-9999' => [ 0, 'MD' ],
    '306-30-2348' => [ 0, 'IN' ],
    '308-12-5070' => [ 0, 'IN' ],
    '468-28-8779' => [ 0, 'MN' ],
    '549-24-1889' => [ 0, 'CA' ],
    '660991234'   => [ 0, ''], # Unassigned
    '699451234'   => [ 0, ''], # Unassigned
    '666451234'   => [ 0, ''], # EVIL!!
    '000-00-0000'   => [ 0, ''], 
    '044-00-3456'   => [ 0, 'CT'],
    '044-11-0000'   => [ 0, 'CT'],
);

for my $num ( sort { $a cmp $b } keys %ssns ) {
    ok( $ssn->valid_ssn($num) == $ssns{$num}->[0], "valid_ssn($num)" );
    ok( $ssn->get_state($num) eq $ssns{$num}->[1], "get_state($num)" );
}
