#
# This configuration file controls
# data conversion from PML to SQL/dumps
# and loading of the data to the SQL database
#
# You will need to configure at least the following
# parameters:
#
#  pmltq_dir
#  treebank_id
#  title
#  infoURL
#  abstract
#  syntax 
#  sys_password
#  password (Oracle)
#  layers

# and review the following
#
#   db
#   db_host
#   db_port
#   sys_user
#   sys_db
#   sys_password
#   user
#   passsword
#   resource_dir

########################################################
# PLEASE REVIEW THE FLLOWING SETTINGS
########################################################

pmltq_dir="$HOME/pmltq"   # where to find PML-TQ installation
treebank_id="sample"      # name for the treebank database

title=""    # Long name of the treebank, e.g. "Prague Dependency Treebank 2.0"
infoURL=""  # URL where the user may obtain more information about the treebank
abstract="" # Long description of the treebank (a paragraph of text)

syntax=postgres           # options: postgres, oracle

# Rootnames of layers of your treebank, lower layers first!
# e.g. layers=(valency_lexicon adata tdata)
layers=() 

if [ $syntax = postgres ]; then

  # Configuration for PostgreSQL (if used)

  db="$treebank_id"       # name of the database used for the treebank
                          # (will be created automatically)

  db_host=localhost       # database server
  db_port=5432            # database port
  sys_user="$USER"        # database user that can create a new database
  sys_password=""         # database password for $sys_user

  # Review only:
  sys_db="$sys_user"      # initial database used only to connect to
			  # the server and create a new database,
			  # usually same as $sys_user
  user="$sys_user"        # if you change this, you'll have to grant the user permissions 
                          # to the $db database first
  password="$sys_password"  # leave as $sys_password if $user = $sys_user

  psql_command=psql

elif [ $syntax = oracle ]; then

  # Configuration for Oracle (if used)

  user="$treebank_id"     # db user that will own the treebank tables
                          # (will be created automatically; note that
                          # in Oracle, user represents a database schema)
  password=""             # db password for $user (use different password than $sys_password!)

  db="$ORACLE_SID"        # oracle database (SID) to use
  db_host=localhost       # database server hostname
  db_port=1521            # port of the oracle network listener
  sys_user="SYSTEM"       # db user that can create a new database
  sys_password=""         # db password of $sys_user (see below)

fi

resource_dir=""           # if needed, add special schema file locations

########################################################
# NO NEED TO MAKE CHANGES BELOW THIS LINE
########################################################

script_dir="$(dirname $BASH_SOURCE)"
script_dir=$(readlink -f "$script_dir")
base_dir=$(readlink -f "$script_dir/..")
dump_dir="${base_dir}/sql_dump.$treebase_id.$syntax"
data_dir="$base_dir/data"
sql_shell="${script_dir}/sql_shell.sh"
pml2base_btred="$pmltq_dir/contrib/pml2base.btred"
[ -n $resource_dir ] && resource_dir="$resource_dir:"
resource_dir="$base_dir/resources:$pmltq_dir/contrib/resources/pdt2base:$pmltq_dir/resources:"
config_cleanup=''

if [ ! -d "$data_dir" ]; then 
  echo "ERROR: Data dir not found: $data_dir";
  echo "Please configure 'data_dir' variable in $BASH_SOURCE"
  exit 1;
fi

if [ ! -f $pmltq_dir/libs/pmltq/PML2BASE.pm ]; then
  echo "ERROR: Didn't find PML-TQ installation in $pmltq_dir"
  echo "Please configure 'pmltq_dir' variable in $BASH_SOURCE"
  exit 2;
fi

if [ -z "$password" ]; then 
  echo "ERROR: Database password not configured!";
  echo "Please configure 'password' and 'sys_password' variable in $BASH_SOURCE"
  exit 1;
fi
if [ -z "$sys_password" ]; then 
  echo "ERROR: Database sys_password not configured!";
  echo "Please configure 'password' and 'sys_password' variable in $BASH_SOURCE"
  exit 1;
fi

if [[ $treebank_id != [A-Za-z_]*  || $treebank_id = *[^A-Za-z0-9_]* ]]; then
  echo "ERROR: Please choose treebank_id that matches [A-Z_][A-Z0-9_]!";
  exit 1;
fi

if [ $syntax = postgres ]; then

  # Setup for PostgreSQL (edit as needed)
  [ -z "$TMPDIR" ] && TMPDIR=/tmp
  PGPASSFILE="${TMPDIR}/pgpass.$USER.$$.conf"
  [ -f "$PGPASSFILE" ] && rm "$PGPASSFILE"
  touch "$PGPASSFILE"; chmod 600 "$PGPASSFILE"
  cat <<EOF >> $PGPASSFILE
$db_host:$db_port:$db:$user:$password
$db_host:$db_port:$sys_db:$sys_user:$sys_password
EOF
  export PGPASSFILE

  config_cleanup="rm -f $PASSFILE"

elif [ $syntax = oracle ]; then

  # Setup for Oracle (edit as needed)
  [ -n $db_host ] && db_opts="$db_host"
  [ -n $db_port ] && db_opts="$opts:$db_port"
  [ -n $db_opts ] && db_opts="$opts/"

  db="$opts$db"
  sys_db="$db as SYSDBA" # append role

fi

run_sql() {
    if [ "$syntax" = "postgres" ]; then
	opts=''
	[ -n $db_host ] && opts="-h '$db_host'"
	[ -n $db_port ] && opts="$opts -p '$db_port'"
	eval $psql_command -d "$db" -U "$user" $opts "$@"
    elif [ "$syntax" = "oracle" ]; then
	sqlplus "$user/$password@$db" "$@"
    fi
}
run_sys_sql() {
    user=$sys_user password=$sys_password db=$sys_db run_sql "$@"
}

start='env PML_COMPILE=2'

pml_to_db() {
  if [ x$pml_to_db_configure_only = x1 ]; then
      return 0;
  fi
  layer=$1; shift
  if [ -z "${!layer}" ]; then
      echo "You must define '$layer=( ...parameters... )' before calling pml_to_db $layer"
      return 1;
  fi
  eval 'args=("${'$layer'[@]}")'
  (
      echo "Converting data for layer $layer"
      ([ -d "$dump_dir" ] || mkdir "$dump_dir") && cd "$dump_dir"
      [ $? = 0 ] || exit 1

      $start btred -QI "$pml2base_btred" \
         --no-secondary-files \
         --resource-dir "$resource_dir": \
         -o \
          --syntax "$syntax" \
         "${args[@]}" \
         -- "$@"

      )
}

config_loaded=1
