package Mock::Data::SubWrapper;
use strict;
use warnings;
require Scalar::Util;
require Mock::Data::Generator;
our @ISA= ( 'Mock::Data::Generator' );

# ABSTRACT: Wrap a coderef to become a blessed Generator object
our $VERSION = '0.00_001'; # TRIAL VERSION


sub _new {
	my ($pkg, $sub)= @_;
	bless $sub, $pkg;
}

sub compile {
	return $_[0];
}

sub generate {
	my $self= shift;
	$self->(@_);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Mock::Data::SubWrapper - Wrap a coderef to become a blessed Generator object

=head1 DESCRIPTION

This is an implementation detail of L<Mock::Data::Generator>.  It wraps coderefs to be
generators without bothering to allocate a new object for them.

=head1 METHODS

=head2 compile

Returns C<$self>.  (because it's already a coderef)

=head2 generate

Calls C<$self>.

=head1 AUTHOR

Michael Conrad <mike@nrdvana.net>

=head1 VERSION

version 0.00_001

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by Michael Conrad.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
