package Catmandu::Fix::downcase;

use Catmandu::Sane;

our $VERSION = '1.2008';

use Moo;
use Catmandu::Util::Path qw(as_path);
use Catmandu::Util qw(as_utf8);
use namespace::clean;
use Catmandu::Fix::Has;

with 'Catmandu::Fix::Builder';

has path => (fix_arg => 1);

sub _build_fixer {
    my ($self) = @_;
    as_path($self->path)->updater(if_string => sub {lc as_utf8 $_[0]});
}

1;

__END__

=pod

=head1 NAME

Catmandu::Fix::downcase - lowercase the value of a field

=head1 SYNOPSIS

   # Lowercase 'foo'. E.g. foo => 'BAR'
   downcase(foo) # foo => 'bar'

=head1 SEE ALSO

L<Catmandu::Fix>

=cut
