#!/usr/bin/perl

use strict;
use warnings;

use Test::Builder::Tester;
use Test::More;

use Test::Future::IO;

my $test_fio = Test::Future::IO->controller;

# pass
{
   test_out q[ok 1 - Future::IO->sleep is done];
   test_out q[ok 2 - ->sleep('0.5')];

   $test_fio->expect_sleep( 0.5 )
      ->returns;
   ok( Future::IO->sleep( 0.5 )->is_done, 'Future::IO->sleep is done' );
   $test_fio->check_and_clear( '->sleep' );

   test_test 'sleep OK';
}

# fail not called
{
   test_out q[not ok 1 - ->sleep('0.5')];
   test_fail( +4 );

   $test_fio->expect_sleep( 0.5 )
      ->returns;
   $test_fio->check_and_clear( '->sleep' );

   test_test 'sleep fail not called';
}

# fail wrong args
{
   test_out q[ok 1 - ->sleep with wrong args dies];
   test_out q[not ok 2 - ->sleep('0.5')];
   test_fail( +5 );

   $test_fio->expect_sleep( 0.5 )
      ->returns;
   ok( !defined eval { Future::IO->sleep( 1.0 ) }, '->sleep with wrong args dies' );
   $test_fio->check_and_clear( '->sleep fails' );

   test_test 'sleep fail wrong args';
}

# fail unexpected
{
   test_out q[ok 1 - unexpected ->sleep dies];
   test_out q[ok 2 - No calls made];

   ok( !defined eval { Future::IO->sleep( 2.0 ) }, 'unexpected ->sleep dies' );
   $test_fio->check_and_clear( '->sleep fails' );

   test_test 'sleep fail unexpected';
}

done_testing;
