/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import java.io.File;

public class TestFileSystem {
    static long touch = 0L;
    static boolean readLast = false;

    int readDir(File f) {
        File[] subs = f.listFiles();
        if (subs == null) {
            return 0;
        }
        int count = subs.length;
        for (File sub : subs) {
            if (sub.isDirectory()) {
                count += this.readDir(sub);
            }
            if (readLast) {
                touch += sub.lastModified();
            }
            touch += (long)sub.getPath().hashCode();
        }
        return count;
    }

    int timeDir(File f) {
        File[] subs;
        int total = 0;
        System.out.printf("file                     count  msecs%n", new Object[0]);
        for (File sub : subs = f.listFiles()) {
            if (!sub.isDirectory()) continue;
            long start = System.nanoTime();
            int count = this.readDir(sub);
            long end = System.nanoTime();
            System.out.printf("%-20s, %8d, %f%n", sub.getPath(), count, (double)((end - start) / 1000L) / 1000.0);
            total += count;
        }
        return total;
    }

    public static void main(String[] args) {
        String root = "C:/";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("root")) {
                int pos = args[i].indexOf(61);
                if (pos > 0) {
                    root = args[i].substring(pos + 1);
                    System.out.printf("root=%s ", root);
                }
                if (args[i].equals("usage")) {
                    System.out.printf("java -classpath {jar} ucar.nc2.util.cache.TestFileSystem root={rootDir} [readLastModified] -%n", new Object[0]);
                    System.exit(0);
                }
            }
            if (!args[i].equals("readLastModified")) continue;
            readLast = true;
            System.out.printf(" readLastModified ", new Object[0]);
        }
        System.out.printf(" %n%n", new Object[0]);
        TestFileSystem test = new TestFileSystem();
        long start = System.nanoTime();
        int total = test.timeDir(new File(root));
        long end = System.nanoTime();
        System.out.printf("%n%-20s, %8d, %f usecs%n", root, total, (double)((end - start) / 1000L) / 1000.0);
        System.out.printf("%n %d %n", touch);
    }
}

