/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
 *    2007 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by opcode.pl from its data.  Any changes made here
 *  will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_LOGASSIGN_ASSIGN = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_MAGICSV	 = 10,
	OP_PUSHRE	 = 11,
	OP_RV2GV	 = 12,
	OP_RV2SV	 = 13,
	OP_RV2CV	 = 14,
	OP_ANONCODE	 = 15,
	OP_PROTOTYPE	 = 16,
	OP_SREFGEN	 = 17,
	OP_REF		 = 18,
	OP_BLESS	 = 19,
	OP_ANONSCALAR	 = 20,
	OP_BACKTICK	 = 21,
	OP_GLOB		 = 22,
	OP_READLINE	 = 23,
	OP_RCATLINE	 = 24,
	OP_REGCMAYBE	 = 25,
	OP_REGCRESET	 = 26,
	OP_REGCOMP	 = 27,
	OP_MATCH	 = 28,
	OP_QR		 = 29,
	OP_SUBST	 = 30,
	OP_SUBSTCONT	 = 31,
	OP_SASSIGN	 = 32,
	OP_DOTDOTDOT	 = 33,
	OP_PLACEHOLDER	 = 34,
	OP_CHOP		 = 35,
	OP_CHOMP	 = 36,
	OP_DEFINED	 = 37,
	OP_UNDEF	 = 38,
	OP_STUDY	 = 39,
	OP_POS		 = 40,
	OP_PREINC	 = 41,
	OP_I_PREINC	 = 42,
	OP_PREDEC	 = 43,
	OP_I_PREDEC	 = 44,
	OP_POSTINC	 = 45,
	OP_I_POSTINC	 = 46,
	OP_POSTDEC	 = 47,
	OP_I_POSTDEC	 = 48,
	OP_POW		 = 49,
	OP_MULTIPLY	 = 50,
	OP_I_MULTIPLY	 = 51,
	OP_DIVIDE	 = 52,
	OP_I_DIVIDE	 = 53,
	OP_MODULO	 = 54,
	OP_I_MODULO	 = 55,
	OP_REPEAT	 = 56,
	OP_ADD		 = 57,
	OP_I_ADD	 = 58,
	OP_SUBTRACT	 = 59,
	OP_I_SUBTRACT	 = 60,
	OP_CONCAT	 = 61,
	OP_STRINGIFY	 = 62,
	OP_LEFT_SHIFT	 = 63,
	OP_RIGHT_SHIFT	 = 64,
	OP_LT		 = 65,
	OP_I_LT		 = 66,
	OP_GT		 = 67,
	OP_I_GT		 = 68,
	OP_LE		 = 69,
	OP_I_LE		 = 70,
	OP_GE		 = 71,
	OP_I_GE		 = 72,
	OP_EQ		 = 73,
	OP_I_EQ		 = 74,
	OP_NE		 = 75,
	OP_I_NE		 = 76,
	OP_NCMP		 = 77,
	OP_I_NCMP	 = 78,
	OP_REF_EQ	 = 79,
	OP_REF_NE	 = 80,
	OP_SEQ		 = 81,
	OP_SNE		 = 82,
	OP_SCMP		 = 83,
	OP_BIT_AND	 = 84,
	OP_BIT_XOR	 = 85,
	OP_BIT_OR	 = 86,
	OP_NEGATE	 = 87,
	OP_I_NEGATE	 = 88,
	OP_NOT		 = 89,
	OP_COMPLEMENT	 = 90,
	OP_ATAN2	 = 91,
	OP_SIN		 = 92,
	OP_COS		 = 93,
	OP_RAND		 = 94,
	OP_SRAND	 = 95,
	OP_EXP		 = 96,
	OP_LOG		 = 97,
	OP_SQRT		 = 98,
	OP_INT		 = 99,
	OP_HEX		 = 100,
	OP_OCT		 = 101,
	OP_ABS		 = 102,
	OP_LENGTH	 = 103,
	OP_SUBSTR	 = 104,
	OP_VEC		 = 105,
	OP_INDEX	 = 106,
	OP_RINDEX	 = 107,
	OP_SPRINTF	 = 108,
	OP_ORD		 = 109,
	OP_CHR		 = 110,
	OP_CRYPT	 = 111,
	OP_UCFIRST	 = 112,
	OP_LCFIRST	 = 113,
	OP_UC		 = 114,
	OP_LC		 = 115,
	OP_QUOTEMETA	 = 116,
	OP_RV2AV	 = 117,
	OP_AELEMFAST	 = 118,
	OP_AELEM	 = 119,
	OP_ASLICE	 = 120,
	OP_EACH		 = 121,
	OP_VALUES	 = 122,
	OP_KEYS		 = 123,
	OP_NKEYS	 = 124,
	OP_DELETE	 = 125,
	OP_EXISTS	 = 126,
	OP_RV2HV	 = 127,
	OP_HELEM	 = 128,
	OP_HSLICE	 = 129,
	OP_UNPACK	 = 130,
	OP_PACK		 = 131,
	OP_SPLIT	 = 132,
	OP_JOIN		 = 133,
	OP_LIST		 = 134,
	OP_LSLICE	 = 135,
	OP_ENTER_ANONARRAY_ASSIGN = 136,
	OP_ENTER_ANONHASH_ASSIGN = 137,
	OP_ANONARRAY	 = 138,
	OP_ANONHASH	 = 139,
	OP_LISTLAST	 = 140,
	OP_LISTFIRST	 = 141,
	OP_EXPAND	 = 142,
	OP_ARRAYEXPAND	 = 143,
	OP_ENTER_ARRAYEXPAND_ASSIGN = 144,
	OP_HASHEXPAND	 = 145,
	OP_ENTER_HASHEXPAND_ASSIGN = 146,
	OP_NELEMS	 = 147,
	OP_SPLICE	 = 148,
	OP_PUSH		 = 149,
	OP_POP		 = 150,
	OP_SHIFT	 = 151,
	OP_UNSHIFT	 = 152,
	OP_SORT		 = 153,
	OP_REVERSE	 = 154,
	OP_ARRAYJOIN	 = 155,
	OP_HASHJOIN	 = 156,
	OP_ARRAYCONCAT	 = 157,
	OP_HASHCONCAT	 = 158,
	OP_GREPSTART	 = 159,
	OP_GREPWHILE	 = 160,
	OP_MAPSTART	 = 161,
	OP_MAPWHILE	 = 162,
	OP_RANGE	 = 163,
	OP_AND		 = 164,
	OP_OR		 = 165,
	OP_XOR		 = 166,
	OP_DOR		 = 167,
	OP_COND_EXPR	 = 168,
	OP_ANDASSIGN	 = 169,
	OP_ORASSIGN	 = 170,
	OP_DORASSIGN	 = 171,
	OP_METHOD	 = 172,
	OP_ENTERSUB	 = 173,
	OP_ENTERSUB_TARGARGS = 174,
	OP_ENTERSUB_SAVE = 175,
	OP_LEAVESUB	 = 176,
	OP_CALLER	 = 177,
	OP_WARN		 = 178,
	OP_DIE		 = 179,
	OP_DYNASCOPE	 = 180,
	OP_LINESEQ	 = 181,
	OP_NEXTSTATE	 = 182,
	OP_DBSTATE	 = 183,
	OP_UNSTACK	 = 184,
	OP_ENTER	 = 185,
	OP_LEAVE	 = 186,
	OP_SCOPE	 = 187,
	OP_ENTERITER	 = 188,
	OP_ITER		 = 189,
	OP_ENTERLOOP	 = 190,
	OP_LEAVELOOP	 = 191,
	OP_RETURN	 = 192,
	OP_LAST		 = 193,
	OP_NEXT		 = 194,
	OP_REDO		 = 195,
	OP_EXIT		 = 196,
	OP_METHOD_NAMED	 = 197,
	OP_OPEN		 = 198,
	OP_CLOSE	 = 199,
	OP_PIPE_OP	 = 200,
	OP_FILENO	 = 201,
	OP_UMASK	 = 202,
	OP_BINMODE	 = 203,
	OP_SELECT	 = 204,
	OP_GETC		 = 205,
	OP_READ		 = 206,
	OP_PRTF		 = 207,
	OP_PRINT	 = 208,
	OP_SYSOPEN	 = 209,
	OP_SYSSEEK	 = 210,
	OP_SYSREAD	 = 211,
	OP_SYSWRITE	 = 212,
	OP_EOF		 = 213,
	OP_TELL		 = 214,
	OP_SEEK		 = 215,
	OP_TRUNCATE	 = 216,
	OP_FCNTL	 = 217,
	OP_IOCTL	 = 218,
	OP_FLOCK	 = 219,
	OP_SEND		 = 220,
	OP_RECV		 = 221,
	OP_SOCKET	 = 222,
	OP_SOCKPAIR	 = 223,
	OP_BIND		 = 224,
	OP_CONNECT	 = 225,
	OP_LISTEN	 = 226,
	OP_ACCEPT	 = 227,
	OP_SHUTDOWN	 = 228,
	OP_GSOCKOPT	 = 229,
	OP_SSOCKOPT	 = 230,
	OP_GETSOCKNAME	 = 231,
	OP_GETPEERNAME	 = 232,
	OP_LSTAT	 = 233,
	OP_STAT		 = 234,
	OP_FTRREAD	 = 235,
	OP_FTRWRITE	 = 236,
	OP_FTREXEC	 = 237,
	OP_FTEREAD	 = 238,
	OP_FTEWRITE	 = 239,
	OP_FTEEXEC	 = 240,
	OP_FTIS		 = 241,
	OP_FTSIZE	 = 242,
	OP_FTMTIME	 = 243,
	OP_FTATIME	 = 244,
	OP_FTCTIME	 = 245,
	OP_FTROWNED	 = 246,
	OP_FTEOWNED	 = 247,
	OP_FTZERO	 = 248,
	OP_FTSOCK	 = 249,
	OP_FTCHR	 = 250,
	OP_FTBLK	 = 251,
	OP_FTFILE	 = 252,
	OP_FTDIR	 = 253,
	OP_FTPIPE	 = 254,
	OP_FTSUID	 = 255,
	OP_FTSGID	 = 256,
	OP_FTSVTX	 = 257,
	OP_FTLINK	 = 258,
	OP_FTTTY	 = 259,
	OP_FTTEXT	 = 260,
	OP_FTBINARY	 = 261,
	OP_CHDIR	 = 262,
	OP_CHOWN	 = 263,
	OP_CHROOT	 = 264,
	OP_UNLINK	 = 265,
	OP_CHMOD	 = 266,
	OP_UTIME	 = 267,
	OP_RENAME	 = 268,
	OP_LINK		 = 269,
	OP_SYMLINK	 = 270,
	OP_READLINK	 = 271,
	OP_MKDIR	 = 272,
	OP_RMDIR	 = 273,
	OP_OPEN_DIR	 = 274,
	OP_READDIR	 = 275,
	OP_TELLDIR	 = 276,
	OP_SEEKDIR	 = 277,
	OP_REWINDDIR	 = 278,
	OP_CLOSEDIR	 = 279,
	OP_FORK		 = 280,
	OP_WAIT		 = 281,
	OP_WAITPID	 = 282,
	OP_SYSTEM	 = 283,
	OP_EXEC		 = 284,
	OP_KILL		 = 285,
	OP_GETPPID	 = 286,
	OP_GETPGRP	 = 287,
	OP_SETPGRP	 = 288,
	OP_GETPRIORITY	 = 289,
	OP_SETPRIORITY	 = 290,
	OP_TIME		 = 291,
	OP_TMS		 = 292,
	OP_LOCALTIME	 = 293,
	OP_GMTIME	 = 294,
	OP_ALARM	 = 295,
	OP_SLEEP	 = 296,
	OP_SHMGET	 = 297,
	OP_SHMCTL	 = 298,
	OP_SHMREAD	 = 299,
	OP_SHMWRITE	 = 300,
	OP_MSGGET	 = 301,
	OP_MSGCTL	 = 302,
	OP_MSGSND	 = 303,
	OP_MSGRCV	 = 304,
	OP_SEMOP	 = 305,
	OP_SEMGET	 = 306,
	OP_SEMCTL	 = 307,
	OP_REQUIRE	 = 308,
	OP_DOFILE	 = 309,
	OP_HINTSEVAL	 = 310,
	OP_ENTEREVAL	 = 311,
	OP_LEAVEEVAL	 = 312,
	OP_ENTERTRY	 = 313,
	OP_LEAVETRY	 = 314,
	OP_GHBYNAME	 = 315,
	OP_GHBYADDR	 = 316,
	OP_GHOSTENT	 = 317,
	OP_GNBYNAME	 = 318,
	OP_GNBYADDR	 = 319,
	OP_GNETENT	 = 320,
	OP_GPBYNAME	 = 321,
	OP_GPBYNUMBER	 = 322,
	OP_GPROTOENT	 = 323,
	OP_GSBYNAME	 = 324,
	OP_GSBYPORT	 = 325,
	OP_GSERVENT	 = 326,
	OP_SHOSTENT	 = 327,
	OP_SNETENT	 = 328,
	OP_SPROTOENT	 = 329,
	OP_SSERVENT	 = 330,
	OP_EHOSTENT	 = 331,
	OP_ENETENT	 = 332,
	OP_EPROTOENT	 = 333,
	OP_ESERVENT	 = 334,
	OP_GPWNAM	 = 335,
	OP_GPWUID	 = 336,
	OP_GPWENT	 = 337,
	OP_SPWENT	 = 338,
	OP_EPWENT	 = 339,
	OP_GGRNAM	 = 340,
	OP_GGRGID	 = 341,
	OP_GGRENT	 = 342,
	OP_SGRENT	 = 343,
	OP_EGRENT	 = 344,
	OP_GETLOGIN	 = 345,
	OP_SYSCALL	 = 346,
	OP_LOCK		 = 347,
	OP_COMPSUB	 = 348,
	OP_CUSTOM	 = 349,
	OP_ROOT		 = 350,
	OP_max		
} opcode;

#define MAXO 351
#define OP_phoney_INPUT_ONLY -1
#define OP_phoney_OUTPUT_ONLY -2


/* the OP_IS_(SOCKET|FILETEST) macros are optimized to a simple range
    check because all the member OPs are contiguous in opcode.pl
    <DATA> table.  opcode.pl verifies the range contiguity.  */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

/* ex: set ro: */
