package Microsoft::AdCenter::V6::ReportingService::SegmentationReportColumn;
# Copyright (C) 2011 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V6::ReportingService::SegmentationReportColumn - Represents "SegmentationReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountId
    AccountName
    AccountNumber
    AdGroupId
    AdGroupName
    AgeGroup
    Assists
    CampaignId
    CampaignName
    Conversions
    Country
    FunnelConversionRate
    Gender
    Goal
    Keyword
    KeywordId
    MetroArea
    ReturnOnAdSpend
    Revenue
    Spend
    State
    Step1Count
    Step2Count
    Step3Count
    Step4Count
    Step5Count
    TimePeriod

=cut

sub AccountId {
    return 'AccountId';
}

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdGroupId {
    return 'AdGroupId';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub AgeGroup {
    return 'AgeGroup';
}

sub Assists {
    return 'Assists';
}

sub CampaignId {
    return 'CampaignId';
}

sub CampaignName {
    return 'CampaignName';
}

sub Conversions {
    return 'Conversions';
}

sub Country {
    return 'Country';
}

sub FunnelConversionRate {
    return 'FunnelConversionRate';
}

sub Gender {
    return 'Gender';
}

sub Goal {
    return 'Goal';
}

sub Keyword {
    return 'Keyword';
}

sub KeywordId {
    return 'KeywordId';
}

sub MetroArea {
    return 'MetroArea';
}

sub ReturnOnAdSpend {
    return 'ReturnOnAdSpend';
}

sub Revenue {
    return 'Revenue';
}

sub Spend {
    return 'Spend';
}

sub State {
    return 'State';
}

sub Step1Count {
    return 'Step1Count';
}

sub Step2Count {
    return 'Step2Count';
}

sub Step3Count {
    return 'Step3Count';
}

sub Step4Count {
    return 'Step4Count';
}

sub Step5Count {
    return 'Step5Count';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
