/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class Sum
extends Aggregate {
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType base = Atomizer.getAtomizedItemType(this.argument[0], false, th);
        if (base.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            base = BuiltInAtomicType.DOUBLE;
        }
        if (Cardinality.allowsZero(this.argument[0].getCardinality())) {
            if (this.argument.length == 1) {
                return Type.getCommonSuperType(base, BuiltInAtomicType.INTEGER, th);
            }
            return Type.getCommonSuperType(base, this.argument[1].getItemType(th), th);
        }
        return base;
    }

    public int computeCardinality() {
        if (this.argument.length == 1 || this.argument[1].getCardinality() == 1) {
            return 16384;
        }
        return super.computeCardinality();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue sum = Sum.total(this.argument[0].iterate(context), context, this);
        if (sum != null) {
            return sum;
        }
        if (this.argument.length == 2) {
            return this.argument[1].evaluateItem(context);
        }
        return Int64Value.ZERO;
    }

    public static AtomicValue total(SequenceIterator iter, XPathContext context, SourceLocator location) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        StringConverter toDouble = StringConverter.getStringConverter(BuiltInAtomicType.DOUBLE, rules);
        AtomicValue sum = (AtomicValue)iter.next();
        if (sum == null) {
            return null;
        }
        if (sum instanceof UntypedAtomicValue) {
            try {
                sum = toDouble.convert(sum).asAtomic();
            }
            catch (XPathException e) {
                e.maybeSetLocation(location);
                throw e;
            }
        }
        if (sum instanceof NumericValue) {
            AtomicValue next;
            do {
                if ((next = (AtomicValue)iter.next()) == null) {
                    return sum;
                }
                if (next instanceof UntypedAtomicValue) {
                    next = toDouble.convert(next).asAtomic();
                    continue;
                }
                if (next instanceof NumericValue) continue;
                XPathException err = new XPathException("Input to sum() contains a mix of numeric and non-numeric values");
                err.setXPathContext(context);
                err.setErrorCode("FORG0006");
                err.setLocator(location);
                throw err;
            } while (!(sum = ArithmeticExpression.compute(sum, 0, next, context)).isNaN() || !(sum instanceof DoubleValue));
            return sum;
        }
        if (sum instanceof DurationValue) {
            if (!(sum instanceof DayTimeDurationValue) && !(sum instanceof YearMonthDurationValue)) {
                XPathException err = new XPathException("Input to sum() contains a duration that is neither a dayTimeDuration nor a yearMonthDuration");
                err.setXPathContext(context);
                err.setErrorCode("FORG0006");
                err.setLocator(location);
                throw err;
            }
            while (true) {
                AtomicValue next;
                if ((next = (AtomicValue)iter.next()) == null) {
                    return sum;
                }
                if (!(next instanceof DurationValue)) {
                    XPathException err = new XPathException("Input to sum() contains a mix of duration and non-duration values");
                    err.setXPathContext(context);
                    err.setErrorCode("FORG0006");
                    err.setLocator(location);
                    throw err;
                }
                sum = ((DurationValue)sum).add((DurationValue)next);
            }
        }
        XPathException err = new XPathException("Input to sum() contains a value of type " + sum.getPrimitiveType().getDisplayName() + " which is neither numeric, nor a duration");
        err.setXPathContext(context);
        err.setErrorCode("FORG0006");
        err.setLocator(location);
        throw err;
    }
}

