package X11::XRandR;

# ABSTRACT: An interface to the X11 XRandR extension

use strict;
use warnings;

our $VERSION = '0.01';

1;

#
# This file is part of X11-XRandR
#
# This software is Copyright (c) 2018 by Diab Jerius.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

=pod

=head1 NAME

X11::XRandR - An interface to the X11 XRandR extension

=head1 VERSION

version 0.01

=head1 DESCRIPTION

The L<X11::XRandR> Module and others in this distribution are
dedicated to interfacing with the X11 XRandR extension.

This distribution is currently in great flux.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://rt.cpan.org/Public/Dist/Display.html?Name=X11-XRandR> or by email
to L<bug-X11-XRandR@rt.cpan.org|mailto:bug-X11-XRandR@rt.cpan.org>.

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SOURCE

The development version is on github at L<https://github.com/djerius/x11-xrandr>
and may be cloned from L<git://github.com/djerius/x11-xrandr.git>

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<X11::XCB>

=back

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Diab Jerius.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut

__END__


#pod =head1 DESCRIPTION
#pod
#pod The L<X11::XRandR> Module and others in this distribution are
#pod dedicated to interfacing with the X11 XRandR extension.
#pod
#pod This distribution is currently in great flux.
#pod
#pod =head1 SEE ALSO
#pod
#pod L<X11::XCB>
