use strict;
use warnings;
use inc::Module::Install;
use Module::Install::XSUtil 0.41;
use Module::Install::AuthorTests;
use Module::Install::Repository;

all_from 'lib/Hash/FieldHash.pm';

use_xshelper;
cc_warnings;

requires 'parent' => 0.221;
requires 'MRO::Compat' => 0.10 if $] < 5.010;

test_requires 'Test::More'      => 0.62;
test_requires 'Test::LeakTrace' => 0.07;

tests 't/*.t t/*/*.t';
author_tests 'xt';

if(author_context){
	cc_define '-DFIELDHASH_DEBUG';
}

makemaker_args depend => { '$(C_FILES)' => 'compat58.xsi' },

auto_set_repository() if -d '.git';

clean_files q(
	Hash-FieldHash-* *.stackdump
	*.gcda *.gcno *.gcov
	nytprof *.out
	cover_db
);

WriteAll check_nmake => 0;
