/*
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Some functions in this file use the VSOP87 solution by
 *  Messrs. Bretagnon and Francou.
 * 
 *  Copyright (C) 2000 - 2005 Liam Girdwood  
 */

#include <math.h>
#include <libnova/saturn.h>
#include <libnova/vsop87.h>
#include <libnova/solar.h>
#include <libnova/earth.h>
#include <libnova/transform.h>
#include <libnova/rise_set.h>
#include <libnova/utility.h>

#define LONG_L0 1437
#define LONG_L1 817
#define LONG_L2 438
#define LONG_L3 192
#define LONG_L4 85
#define LONG_L5 30
#define LAT_B0 500
#define LAT_B1 247
#define LAT_B2 111
#define LAT_B3 54
#define LAT_B4 24
#define LAT_B5 11
#define RADIUS_R0 1208
#define RADIUS_R1 627
#define RADIUS_R2 338
#define RADIUS_R3 154
#define RADIUS_R4 65
#define RADIUS_R5 27

/* cache variables */
static double cJD = 0, cL = 0, cB = 0, cR = 0;

static const struct ln_vsop saturn_longitude_l0[LONG_L0] = {
    {     0.87401354025,  0.00000000000,        0.00000000000}, 
    {     0.11107659762,  3.96205090159,      213.29909543800}, 
    {     0.01414150957,  4.58581516874,        7.11354700080}, 
    {     0.00398379389,  0.52112032699,      206.18554843720}, 
    {     0.00350769243,  3.30329907896,      426.59819087600}, 
    {     0.00206816305,  0.24658372002,      103.09277421860}, 
    {     0.00079271300,  3.84007056878,      220.41264243880}, 
    {     0.00023990355,  4.66976924553,      110.20632121940}, 
    {     0.00016573588,  0.43719228296,      419.48464387520}, 
    {     0.00014906995,  5.76903183869,      316.39186965660}, 
    {     0.00015820290,  0.93809155235,      632.78373931320}, 
    {     0.00014609559,  1.56518472000,        3.93215326310}, 
    {     0.00013160301,  4.44891291899,       14.22709400160}, 
    {     0.00015053543,  2.71669915667,      639.89728631400}, 
    {     0.00013005299,  5.98119023644,       11.04570026390}, 
    {     0.00010725067,  3.12939523827,      202.25339517410}, 
    {     0.00005863206,  0.23656938524,      529.69096509460}, 
    {     0.00005227757,  4.20783365759,        3.18139373770}, 
    {     0.00006126317,  1.76328667907,      277.03499374140}, 
    {     0.00005019687,  3.17787728405,      433.71173787680}, 
    {     0.00004592550,  0.61977744975,      199.07200143640}, 
    {     0.00004005867,  2.24479718502,       63.73589830340}, 
    {     0.00002953796,  0.98280366998,       95.97922721780}, 
    {     0.00003873670,  3.22283226966,      138.51749687070}, 
    {     0.00002461186,  2.03163875071,      735.87651353180}, 
    {     0.00003269484,  0.77492638211,      949.17560896980}, 
    {     0.00001758145,  3.26580109940,      522.57741809380}, 
    {     0.00001640172,  5.50504453050,      846.08283475120}, 
    {     0.00001391327,  4.02333150505,      323.50541665740}, 
    {     0.00001580648,  4.37265307169,      309.27832265580}, 
    {     0.00001123498,  2.83726798446,      415.55249061210}, 
    {     0.00001017275,  3.71700135395,      227.52618943960}, 
    {     0.00000848642,  3.19150170830,      209.36694217490}, 
    {     0.00001087229,  4.18343257560,        2.44768055480}, 
    {     0.00000956757,  0.50744342622,     1265.56747862640}, 
    {     0.00000789205,  5.00745127508,        0.96320784650}, 
    {     0.00000686999,  1.74714152638,     1052.26838318840}, 
    {     0.00000654484,  1.59889329033,        0.04818410980}, 
    {     0.00000748819,  2.14396789786,      853.19638175200}, 
    {     0.00000633982,  2.29887419204,      412.37109687440}, 
    {     0.00000743599,  5.25277685028,      224.34479570190}, 
    {     0.00000852677,  3.42141279787,      175.16605980020}, 
    {     0.00000579844,  3.09254750266,       74.78159856730}, 
    {     0.00000624883,  0.97048087510,      210.11770170030}, 
    {     0.00000529874,  4.44938991187,      117.31986822020}, 
    {     0.00000542648,  1.51824981131,        9.56122755560}, 
    {     0.00000474277,  5.47526482059,      742.99006053260}, 
    {     0.00000448547,  1.28991363969,      127.47179660680}, 
    {     0.00000546365,  2.12677911914,      350.33211960040}, 
    {     0.00000478044,  2.96486700885,      137.03302416240}, 
    {     0.00000354988,  3.01280169452,      838.96928775040}, 
    {     0.00000451857,  1.04437293342,      490.33408917940}, 
    {     0.00000347422,  1.53923267387,      340.77089204480}, 
    {     0.00000343481,  0.24603836481,        0.52126486180}, 
    {     0.00000309029,  3.49491017725,      216.48048917570}, 
    {     0.00000322189,  0.96136528867,      203.73786788240}, 
    {     0.00000372318,  2.27822895353,      217.23124870110}, 
    {     0.00000321562,  2.57185176731,      647.01083331480}, 
    {     0.00000330197,  0.24721738903,     1581.95934828300}, 
    {     0.00000249142,  1.47004230445,     1368.66025284500}, 
    {     0.00000286703,  2.37046001635,      351.81659230870}, 
    {     0.00000220225,  4.20421716654,      200.76892246580}, 
    {     0.00000277774,  0.40024010033,      211.81462272970}, 
    {     0.00000204520,  6.01073368945,      265.98929347750}, 
    {     0.00000207645,  0.48344140678,     1162.47470440780}, 
    {     0.00000208650,  1.34533476508,      625.67019231240}, 
    {     0.00000182459,  5.49122412646,        2.92076130680}, 
    {     0.00000226601,  4.90997278296,       12.53017297220}, 
    {     0.00000207666,  1.28298038875,       39.35687591520}, 
    {     0.00000173914,  1.86305647242,        0.75075952540}, 
    {     0.00000184698,  3.50349102817,      149.56319713460}, 
    {     0.00000183509,  0.97260974474,        4.19278569400}, 
    {     0.00000146074,  6.23107926975,      195.13984817330}, 
    {     0.00000164541,  0.44004693949,        5.41662597140}, 
    {     0.00000147544,  1.53530368067,        5.62907429250}, 
    {     0.00000139690,  4.29463428594,       21.34064100240}, 
    {     0.00000131292,  4.06829024226,       10.29494073850}, 
    {     0.00000117326,  2.67913173095,     1155.36115740700}, 
    {     0.00000149302,  5.73592320434,       52.69019803950}, 
    {     0.00000122371,  1.97585460706,        4.66586644600}, 
    {     0.00000113737,  5.59421876022,     1059.38193018920}, 
    {     0.00000102689,  1.19754453191,     1685.05212250160}, 
    {     0.00000118169,  5.34072820318,      554.06998748280}, 
    {     0.00000109287,  3.43808188855,      536.80451209540}, 
    {     0.00000110400,  0.16605133194,        1.48447270830}, 
    {     0.00000124980,  6.27738701225,     1898.35121793960}, 
    {     0.00000089916,  5.80394843417,      114.13847448250}, 
    {     0.00000103968,  2.19185625957,       88.86568021700}, 
    {     0.00000112430,  1.10510750315,      191.20769491020}, 
    {     0.00000106578,  4.01153470635,      956.28915597060}, 
    {     0.00000091425,  1.87523841598,       38.13303563780}, 
    {     0.00000083763,  5.48810655641,        0.11187458460}, 
    {     0.00000083489,  2.28927138986,      628.85158605010}, 
    {     0.00000096973,  4.53662541679,      302.16477565500}, 
    {     0.00000100634,  4.96513420321,      269.92144674060}, 
    {     0.00000075496,  2.18005762811,      728.76296653100}, 
    {     0.00000096330,  2.83319249226,      275.55052103310}, 
    {     0.00000082386,  3.05482650543,      440.82528487760}, 
    {     0.00000073896,  5.08917637074,     1375.77379984580}, 
    {     0.00000071625,  5.10946423579,       65.22037101170}, 
    {     0.00000070386,  4.86846451411,        0.21244832110}, 
    {     0.00000069760,  3.71027033119,       14.97785352700}, 
    {     0.00000088771,  3.86334160349,      278.51946644970}, 
    {     0.00000068092,  0.73430499450,     1478.86657406440}, 
    {     0.00000066481,  0.02658132849,       70.84944530420}, 
    {     0.00000065694,  2.02147100289,      142.44965013380}, 
    {     0.00000075752,  1.61413426010,      284.14854074220}, 
    {     0.00000063138,  3.49495099319,      479.28838891550}, 
    {     0.00000062557,  2.58733971413,      422.66603761290}, 
    {     0.00000069300,  3.44002100885,      515.46387109300}, 
    {     0.00000079010,  4.45159676932,       35.42472265210}, 
    {     0.00000063664,  3.31747980190,       62.25142559510}, 
    {     0.00000052994,  5.51392725227,        0.26063243090}, 
    {     0.00000053017,  3.18475265559,        8.07675484730}, 
    {     0.00000054492,  2.45664158976,       22.09140052780}, 
    {     0.00000050507,  4.26791628421,       99.16062095550}, 
    {     0.00000055159,  0.96792241728,      942.06206196900}, 
    {     0.00000049320,  2.38666475800,     1471.75302706360}, 
    {     0.00000047203,  2.02525393154,      312.19908396260}, 
    {     0.00000061090,  1.50302054623,      210.85141488320}, 
    {     0.00000060676,  2.68689407241,      388.46515523820}, 
    {     0.00000045138,  0.93106348303,     2001.44399215820}, 
    {     0.00000043450,  2.52603236088,      288.08069400530}, 
    {     0.00000042562,  3.81786681717,      330.61896365820}, 
    {     0.00000039933,  5.71382574413,      408.43894361130}, 
    {     0.00000050125,  6.03152570850,     2214.74308759620}, 
    {     0.00000046031,  0.54227917765,      212.33588759150}, 
    {     0.00000054160,  0.78128719345,      191.95845443560}, 
    {     0.00000047042,  4.59902370789,      437.64389113990}, 
    {     0.00000042367,  1.90069581380,      430.53034413910}, 
    {     0.00000039759,  1.63243208156,     1066.49547719000}, 
    {     0.00000036469,  0.84688120284,      213.34727954780}, 
    {     0.00000035468,  4.18601929802,      215.74677599280}, 
    {     0.00000036469,  3.93224996469,      213.25091132820}, 
    {     0.00000038003,  0.31314052371,      423.41679713830}, 
    {     0.00000044824,  1.12406079738,        6.15033915430}, 
    {     0.00000037902,  1.19795851065,        2.70831298570}, 
    {     0.00000043405,  1.37360455570,      563.63121503840}, 
    {     0.00000043913,  3.93075296633,      525.49817940060}, 
    {     0.00000034837,  1.01543342379,      203.00415469950}, 
    {     0.00000031755,  1.69273634405,        0.16005869440}, 
    {     0.00000030892,  6.13529793424,      417.03696332040}, 
    {     0.00000036407,  6.00604303567,       18.15924726470}, 
    {     0.00000029157,  1.19375828579,      404.50679034820}, 
    {     0.00000032811,  0.53654765923,      107.02492748170}, 
    {     0.00000030461,  0.72314414241,      222.86032299360}, 
    {     0.00000032668,  0.81193242653,     1795.25844372100}, 
    {     0.00000037741,  3.69667138462,     1272.68102562720}, 
    {     0.00000027679,  1.45663968120,        7.16173111060}, 
    {     0.00000027165,  1.89600219634,     1045.15483618760}, 
    {     0.00000037836,  4.51945172068,       24.37902238820}, 
    {     0.00000035003,  4.46092370686,      214.26230328450}, 
    {     0.00000032661,  0.66347743190,      692.58748435350}, 
    {     0.00000030436,  5.30241022019,       33.94024994380}, 
    {     0.00000027579,  6.22702209204,        1.27202438720}, 
    {     0.00000026658,  4.56713174166,        7.06536289100}, 
    {     0.00000031745,  5.49844823318,       56.62235130260}, 
    {     0.00000028153,  5.64388600762,      128.95626931510}, 
    {     0.00000024275,  3.93953220869,      414.06801790380}, 
    {     0.00000032024,  5.22237631301,       92.04707395470}, 
    {     0.00000023059,  3.66034194445,      207.67002114550}, 
    {     0.00000026975,  0.06644184255,      205.22234059070}, 
    {     0.00000031825,  5.59208218558,     6069.77675455340}, 
    {     0.00000023153,  2.10053945000,     1788.14489672020}, 
    {     0.00000031040,  0.37144696566,      703.63318461740}, 
    {     0.00000029384,  0.14749408878,      131.40394986990}, 
    {     0.00000022551,  5.23994780210,      212.77783057620}, 
    {     0.00000026183,  5.41312719168,      140.00196957900}, 
    {     0.00000025779,  4.36084632109,       32.24332891440}, 
    {     0.00000020659,  0.67095777002,     2317.83586181480}, 
    {     0.00000020362,  2.82404200673,      429.77958461370}, 
    {     0.00000024404,  3.08826377429,      145.63104387150}, 
    {     0.00000023748,  2.54374565817,       76.26607127560}, 
    {     0.00000020112,  5.05984887501,      617.80588578620}, 
    {     0.00000023302,  3.97332549746,      483.22054217860}, 
    {     0.00000022878,  6.10447953656,      177.87437278590}, 
    {     0.00000022984,  3.20182261633,      208.63322899200}, 
    {     0.00000020638,  5.22127912054,        6.59228213900}, 
    {     0.00000021419,  0.71923264007,     1258.45393162560}, 
    {     0.00000018151,  6.11584874018,      210.37833413120}, 
    {     0.00000022385,  5.92318160986,      173.94221952280}, 
    {     0.00000019120,  5.77736469009,      213.82036029980}, 
    {     0.00000020870,  5.79129638608,     2531.13495725280}, 
    {     0.00000016904,  3.27550525617,       98.89998852460}, 
    {     0.00000019330,  1.64166493503,      565.11568774670}, 
    {     0.00000020839,  2.01683749266,      860.30992875280}, 
    {     0.00000015638,  3.10062358099,      106.27416795630}, 
    {     0.00000017802,  3.14497635160,      831.85574074960}, 
    {     0.00000018235,  5.22594210687,       73.29712585900}, 
    {     0.00000019304,  5.93982202636,      425.11371816770}, 
    {     0.00000014514,  2.75049388379,        1.22384027740}, 
    {     0.00000014577,  5.18679424151,      305.34616939270}, 
    {     0.00000014254,  3.88076623214,       54.17467074780}, 
    {     0.00000014586,  3.24988127841,       78.71375183040}, 
    {     0.00000013670,  2.55602680997,      405.25754987360}, 
    {     0.00000013912,  1.72287975369,       69.15252427480}, 
    {     0.00000013689,  2.37432937754,      125.98732389850}, 
    {     0.00000013434,  0.83488320765,       99.91138048090}, 
    {     0.00000013835,  6.18875441195,      245.54242435240}, 
    {     0.00000018486,  0.73172908046,     9999.98645077300}, 
    {     0.00000013544,  3.58586392379,      234.63973644040}, 
    {     0.00000017441,  0.23802704474,      134.58534360760}, 
    {     0.00000016882,  0.72758125023,     2111.65031337760}, 
    {     0.00000014180,  4.51956561605,       59.80374504030}, 
    {     0.00000013598,  2.53775710444,        1.69692102940}, 
    {     0.00000012237,  2.11959388836,       28.31117565130}, 
    {     0.00000011990,  1.62127312922,     1361.54670584420}, 
    {     0.00000011982,  4.07445076924,      280.96714700450}, 
    {     0.00000012757,  5.31153889246,      344.70304530790}, 
    {     0.00000016075,  3.97061471646,      355.74874557180}, 
    {     0.00000011427,  5.51112367921,      192.69216761850}, 
    {     0.00000013107,  4.69154717483,      767.36908292080}, 
    {     0.00000014712,  3.29079681274,     1589.07289528380}, 
    {     0.00000011417,  1.81615806473,     2104.53676637680}, 
    {     0.00000011631,  2.79398246172,      362.86229257260}, 
    {     0.00000013238,  4.16610173164,      225.82926841020}, 
    {     0.00000010596,  5.50455161216,      199.28444975750}, 
    {     0.00000010558,  3.57501718639,        1.43628859850}, 
    {     0.00000010487,  2.84545452542,       85.82729883120}, 
    {     0.00000010296,  0.22213213548,      198.32124191100}, 
    {     0.00000010552,  0.18714408691,      217.49188113200}, 
    {     0.00000011853,  0.11583647552,        7.63481186260}, 
    {     0.00000010248,  0.21860767654,      144.14657116320}, 
    {     0.00000010388,  1.68706377306,       31.01948863700}, 
    {     0.00000010298,  4.72105283737,      216.21985674480}, 
    {     0.00000010718,  2.60866218060,      339.28641933650}, 
    {     0.00000009680,  3.66617781358,      212.54833591260}, 
    {     0.00000009686,  0.41563892555,     2634.22773147140}, 
    {     0.00000009606,  3.34180429839,      223.59403617650}, 
    {     0.00000009880,  4.01876851049,      207.14875628370}, 
    {     0.00000013227,  6.00697508523,      214.78356814630}, 
    {     0.00000011346,  2.61894580651,        7.86430652620}, 
    {     0.00000009158,  5.39847150076,      342.25536475310}, 
    {     0.00000011882,  4.00177866802,      267.47376618580}, 
    {     0.00000012076,  3.59957096236,      124.43341522100}, 
    {     0.00000008905,  4.22810786842,        6.36278747540}, 
    {     0.00000010136,  3.60824178626,       14.01464568050}, 
    {     0.00000009194,  0.71906399877,      347.88443904560}, 
    {     0.00000010529,  2.36775276401,      831.10498122420}, 
    {     0.00000008574,  4.48725894302,     1692.16566950240}, 
    {     0.00000010251,  3.93334219207,      207.88246946660}, 
    {     0.00000009179,  4.28183918668,      312.45971639350}, 
    {     0.00000008088,  0.81220128390,      264.50482076920}, 
    {     0.00000009228,  4.26415997810,       20.60692781950}, 
    {     0.00000009607,  0.64286774221,      218.92816973050}, 
    {     0.00000008675,  0.48616033737,     1574.84580128220}, 
    {     0.00000007927,  4.71998972854,      333.65734504400}, 
    {     0.00000008927,  0.90701584499,      497.44763618020}, 
    {     0.00000007934,  2.73280543540,        4.14460158420}, 
    {     0.00000009133,  5.08251865324,      241.61027108930}, 
    {     0.00000008885,  5.55498151216,     2847.52682690940}, 
    {     0.00000009639,  1.60623316904,        0.89377187730}, 
    {     0.00000008926,  5.80855143690,      329.72519178090}, 
    {     0.00000007233,  0.60129637991,      206.23373254700}, 
    {     0.00000007655,  5.53681474398,      116.42609634290}, 
    {     0.00000007537,  5.43686778771,      621.73803904930}, 
    {     0.00000007118,  0.18742612368,      209.10630974400}, 
    {     0.00000008834,  5.36090734150,      343.21857259960}, 
    {     0.00000007056,  0.41899430952,      756.32338265690}, 
    {     0.00000008128,  4.05572601077,      237.67811782620}, 
    {     0.00000008949,  1.65024350785,      210.33015002140}, 
    {     0.00000006962,  3.17856271724,      543.02428721890}, 
    {     0.00000008917,  0.56506143275,     2428.04218303420}, 
    {     0.00000006918,  3.66850644263,      247.23934538180}, 
    {     0.00000008989,  4.25044698859,       46.47042291600}, 
    {     0.00000007094,  5.14244381046,      231.45834270270}, 
    {     0.00000007372,  1.25037224558,      217.96496188400}, 
    {     0.00000006355,  0.82409971051,       31.49256938900}, 
    {     0.00000007562,  5.62661243268,      518.64526483070}, 
    {     0.00000006911,  3.70119674288,      206.13736432740}, 
    {     0.00000007015,  2.84101112991,     1148.24761040620}, 
    {     0.00000006748,  4.56542342874,      120.35824960600}, 
    {     0.00000006281,  5.79091493667,      179.35884549420}, 
    {     0.00000006275,  3.53628080965,      244.31858407500}, 
    {     0.00000005815,  1.40677827798,      214.04985496340}, 
    {     0.00000005870,  4.86690383052,      320.32402291970}, 
    {     0.00000006217,  1.07999162981,      251.43213107580}, 
    {     0.00000007735,  3.82203922745,      380.12776796000}, 
    {     0.00000005718,  1.34924759084,     1677.93857550080}, 
    {     0.00000006455,  1.34715012955,      188.92007304980}, 
    {     0.00000006105,  3.62445388144,     1169.58825140860}, 
    {     0.00000005646,  2.28659477016,       20.44686912510}, 
    {     0.00000005804,  1.54857952361,     2420.92863603340}, 
    {     0.00000005940,  1.65973782972,      842.15068148810}, 
    {     0.00000005593,  0.50496981495,      148.07872442630}, 
    {     0.00000005703,  5.05997067230,        2.96894541660}, 
    {     0.00000006496,  1.93848779933,      357.44566660120}, 
    {     0.00000006369,  2.44534144405,      654.12438031560}, 
    {     0.00000007440,  1.35926163985,      166.82867252200}, 
    {     0.00000006407,  0.40682441040,      168.05251279940}, 
    {     0.00000005568,  2.69532203990,      750.10360753340}, 
    {     0.00000007145,  2.23105866128,      488.84961647110}, 
    {     0.00000006711,  6.03818797147,      160.60889739850}, 
    {     0.00000006939,  5.78359794712,      700.66423920080}, 
    {     0.00000005675,  2.59531513404,        1.64453140270}, 
    {     0.00000006615,  3.14048409935,      491.81856188770}, 
    {     0.00000004903,  2.03902856851,        0.80314915210}, 
    {     0.00000005163,  4.10008637563,      196.62432088160}, 
    {     0.00000006445,  5.49855871291,      206.70681329900}, 
    {     0.00000004984,  2.96757082827,      258.87574647670}, 
    {     0.00000005935,  1.81402138235,      252.65597135320}, 
    {     0.00000006195,  5.01900946561,      273.10284047830}, 
    {     0.00000005957,  3.32859235467,      182.27960680100}, 
    {     0.00000004784,  2.24574932417,      635.96513305090}, 
    {     0.00000005502,  3.31422964456,     1905.46476494040}, 
    {     0.00000005102,  3.98187445707,      254.94359321360}, 
    {     0.00000005213,  0.53623981887,      135.54855145410}, 
    {     0.00000004624,  0.04437884888,      213.18722085340}, 
    {     0.00000005950,  0.54568184723,       51.20572533120}, 
    {     0.00000004546,  0.14439151027,     2950.61960112800}, 
    {     0.00000004775,  3.16022842156,       28.57180808220}, 
    {     0.00000004624,  4.73740665452,      213.41097002260}, 
    {     0.00000004755,  1.12135253955,        6.21977512350}, 
    {     0.00000005730,  0.04398674476,      348.84764689210}, 
    {     0.00000004334,  2.67820804456,       81.75213321620}, 
    {     0.00000004538,  3.83676862123,      487.36514376280}, 
    {     0.00000005589,  3.63336808808,      248.72381809010}, 
    {     0.00000004100,  3.39344356340,       50.40257617910}, 
    {     0.00000005656,  3.59967152437,      282.45161971280}, 
    {     0.00000005145,  1.33338899757,      173.68158709190}, 
    {     0.00000003886,  4.11776461222,      213.51154375910}, 
    {     0.00000003886,  0.66402089118,      213.08664711690}, 
    {     0.00000004462,  0.08626824180,      905.88657979150}, 
    {     0.00000004935,  2.19065724639,      189.72322220190}, 
    {     0.00000003960,  1.60336432627,      218.71572140940}, 
    {     0.00000003739,  3.30739598474,      274.06604832480}, 
    {     0.00000003807,  0.26514954931,      636.71589257630}, 
    {     0.00000005254,  3.75977292946,     3127.31333126180}, 
    {     0.00000004658,  0.37534234779,     2744.43405269080}, 
    {     0.00000003684,  5.11566742961,      458.84151979040}, 
    {     0.00000003737,  2.56821327326,      546.95644048200}, 
    {     0.00000004217,  5.18269682223,       27.08733537390}, 
    {     0.00000003875,  2.21675780973,      358.93013930950}, 
    {     0.00000004786,  4.60614024001,       72.07328558160}, 
    {     0.00000003550,  3.22934089351,      543.91805909620}, 
    {     0.00000003490,  3.68860413802,       41.64449777560}, 
    {     0.00000004794,  4.73551181492,      240.38643081190}, 
    {     0.00000003735,  3.86571768678,     2008.55753915900}, 
    {     0.00000003680,  5.36657261110,       10.03430830760}, 
    {     0.00000004306,  3.15625769753,      738.79727483860}, 
    {     0.00000003380,  0.73199430789,       11.30633269480}, 
    {     0.00000003497,  2.62462312872,       13.33332212430}, 
    {     0.00000003552,  0.28968750645,     1891.23767093880}, 
    {     0.00000003605,  4.69815639671,      295.05122865420}, 
    {     0.00000003610,  6.25354930659,      129.91947716160}, 
    {     0.00000003333,  5.04215642358,      153.49535039770}, 
    {     0.00000003837,  5.31755531541,     3163.91869656600}, 
    {     0.00000003263,  5.59031570352,        2.00573757010}, 
    {     0.00000004021,  2.37124549902,      176.65053250850}, 
    {     0.00000004120,  5.46956536520,        6.90109867970}, 
    {     0.00000003247,  1.70523763310,      235.39049596580}, 
    {     0.00000003696,  4.07571730975,      969.62247809490}, 
    {     0.00000003939,  4.26938238363,      181.80652604900}, 
    {     0.00000003425,  2.54883422278,     1464.63948006280}, 
    {     0.00000003850,  5.48772352401,       37.87240320690}, 
    {     0.00000003321,  6.05373085646,        9.40116886120}, 
    {     0.00000003040,  2.38594161141,      221.37585028530}, 
    {     0.00000003462,  5.81114445373,       13.49338081870}, 
    {     0.00000002979,  4.14161019024,       66.70484372000}, 
    {     0.00000004112,  2.01009585863,      601.76425067620}, 
    {     0.00000003202,  4.26949637598,      593.42686339800}, 
    {     0.00000002921,  4.76322755866,      213.55972786890}, 
    {     0.00000002934,  1.83716438778,      501.37978944330}, 
    {     0.00000003602,  0.14095035212,      552.58551477450}, 
    {     0.00000003258,  4.44716335489,       60.76695288680}, 
    {     0.00000003747,  5.26128919780,      561.18353448360}, 
    {     0.00000002921,  0.01855836131,      213.03846300710}, 
    {     0.00000002981,  5.12623240503,      205.66428357540}, 
    {     0.00000002969,  0.77373880440,       17.52610781830}, 
    {     0.00000003987,  0.76730729086,      424.15051032120}, 
    {     0.00000002804,  1.07514216418,     1994.33044515740}, 
    {     0.00000002905,  1.27184850848,     2737.32050569000}, 
    {     0.00000003642,  0.23263431318,      121.25202148330}, 
    {     0.00000003155,  2.74978627621,      494.26624244250}, 
    {     0.00000003576,  4.49821243480,      167.08930495290}, 
    {     0.00000002735,  0.66893355408,        7.00167241620}, 
    {     0.00000002782,  2.09895935688,      894.84087952760}, 
    {     0.00000003004,  0.25953785005,       40.84134862350}, 
    {     0.00000002737,  5.33066704009,      327.43756992050}, 
    {     0.00000002726,  3.75149783110,      429.04587143080}, 
    {     0.00000002784,  4.17562629670,      292.01284726840}, 
    {     0.00000002744,  2.41346599990,      151.04766984290}, 
    {     0.00000002575,  1.26282074105,      193.65537546500}, 
    {     0.00000002616,  4.81916423909,      681.54178408960}, 
    {     0.00000002538,  3.78251096387,     1485.98012106520}, 
    {     0.00000002926,  0.62372026398,      643.82943957710}, 
    {     0.00000003466,  5.76060994071,      141.22580985640}, 
    {     0.00000003253,  0.75622630094,      555.55446019110}, 
    {     0.00000002885,  6.15831808835,      425.63498302950}, 
    {     0.00000003386,  2.48152283756,       43.28902917830}, 
    {     0.00000002436,  4.57894879527,      477.80391620720}, 
    {     0.00000003190,  0.66177706026,      776.93031047640}, 
    {     0.00000002576,  1.41578305216,      100.64509366380}, 
    {     0.00000002443,  1.04510089705,     1279.79457262800}, 
    {     0.00000002598,  3.73058695150,       17.40848773930}, 
    {     0.00000002559,  5.35988524657,        7.22542158540}, 
    {     0.00000002846,  1.52684623695,       17.26547538740}, 
    {     0.00000002830,  2.47231866942,      280.00393915800}, 
    {     0.00000002455,  2.74279373432,      172.24529849340}, 
    {     0.00000003203,  4.10000274579,      618.55664531160}, 
    {     0.00000002960,  3.96746610269,      650.94298657790}, 
    {     0.00000002286,  0.18374210727,      426.64637498580}, 
    {     0.00000002719,  2.76563681910,       45.57665103870}, 
    {     0.00000002653,  0.14212412417,      162.89651925890}, 
    {     0.00000003118,  2.80942514258,     2221.85663459700}, 
    {     0.00000002288,  3.26959753229,      426.55000676620}, 
    {     0.00000002349,  4.24056039902,      113.38771495710}, 
    {     0.00000002540,  5.57935398465,      381.35160823740}, 
    {     0.00000002770,  4.36266517918,      130.44074202340}, 
    {     0.00000002164,  5.43669210151,      630.33605875840}, 
    {     0.00000003003,  3.71917411581,      228.27694896500}, 
    {     0.00000002368,  4.49216312171,       25.12978191360}, 
    {     0.00000002479,  1.71731092969,      313.68355667090}, 
    {     0.00000002791,  0.40226730686,        8.59801970910}, 
    {     0.00000002777,  0.06507506560,     5856.47765911540}, 
    {     0.00000002071,  2.40453395841,       16.46232623530}, 
    {     0.00000002051,  6.19717541981,     3267.01147078460}, 
    {     0.00000002755,  0.40055260057,      219.44943459230}, 
    {     0.00000002306,  2.61456314387,       26.82670294300}, 
    {     0.00000001974,  2.16033790290,      746.92221379570}, 
    {     0.00000002056,  0.71975258021,      472.17484191470}, 
    {     0.00000001949,  3.13157993219,      226.63241756230}, 
    {     0.00000002373,  3.44821539437,      241.87090352020}, 
    {     0.00000002172,  1.41663830575,       23.57587323610}, 
    {     0.00000002314,  2.92801925795,      170.76082578510}, 
    {     0.00000002408,  1.55295728708,      112.65400177420}, 
    {     0.00000002239,  4.31274272536,      556.51766803760}, 
    {     0.00000002082,  4.33452809464,      210.59078245230}, 
    {     0.00000001879,  2.14326068371,      135.33610313300}, 
    {     0.00000001873,  4.75518673767,      115.62294719080}, 
    {     0.00000002309,  0.11732366204,     3060.82592234740}, 
    {     0.00000001938,  5.63821612530,      454.90936652730}, 
    {     0.00000001832,  0.64631637571,      181.05576652360}, 
    {     0.00000001868,  5.70976107774,       19.12245511120}, 
    {     0.00000002117,  0.44726902093,      216.00740842370}, 
    {     0.00000001807,  6.15427316170,        5.84152261360}, 
    {     0.00000002249,  3.36716140568,      696.51963761660}, 
    {     0.00000002212,  3.42279313426,      533.62311835770}, 
    {     0.00000002419,  3.29356384047,      569.04784100980}, 
    {     0.00000001870,  0.06477042691,      436.15941843160}, 
    {     0.00000001853,  3.90470835472,      220.36445832900}, 
    {     0.00000001759,  0.94203956471,      213.45915413240}, 
    {     0.00000001910,  3.72525967039,      104.05598206510}, 
    {     0.00000001759,  3.83975218378,      213.13903674360}, 
    {     0.00000001743,  2.21262997019,      416.30325013750}, 
    {     0.00000001873,  1.42763846972,       16.67477455640}, 
    {     0.00000002146,  4.41413968676,      184.09414790940}, 
    {     0.00000001737,  0.82318971745,      220.46082654860}, 
    {     0.00000001715,  0.26599994417,      103.14095832840}, 
    {     0.00000002079,  3.85808396012,      672.14061522840}, 
    {     0.00000001863,  4.68604777727,      286.59622129700}, 
    {     0.00000001904,  5.30834458331,      405.99126305650}, 
    {     0.00000002240,  3.02208358469,      105.54045477340}, 
    {     0.00000001861,  2.26358723734,     1781.03134971940}, 
    {     0.00000001633,  0.16030477876,       18.91000679010}, 
    {     0.00000002116,  2.90219103589,      486.40193591630}, 
    {     0.00000001789,  5.08244147798,      731.94436026870}, 
    {     0.00000002198,  3.88171991657,      427.56139872250}, 
    {     0.00000001630,  5.33964027212,      418.52143602870}, 
    {     0.00000001706,  3.35212116331,      103.04459010880}, 
    {     0.00000001604,  2.48961496337,       55.65914345610}, 
    {     0.00000001574,  6.10208401892,      106.01353552540}, 
    {     0.00000001744,  1.83781933542,     1044.40407666220}, 
    {     0.00000002078,  6.03488501179,      916.93228005540}, 
    {     0.00000001697,  3.52606534347,      627.36711334180}, 
    {     0.00000001998,  4.65407827221,      353.30106501700}, 
    {     0.00000001725,  1.49594317534,       25.86349509650}, 
    {     0.00000001765,  5.14792752968,      107.28555991260}, 
    {     0.00000001554,  1.11927446344,      230.82520325630}, 
    {     0.00000001654,  6.01871001230,       77.96299230500}, 
    {     0.00000001486,  0.80594519287,     2310.72231481400}, 
    {     0.00000001846,  0.02334047107,      102.12956637210}, 
    {     0.00000001528,  1.00286132704,     3053.71237534660}, 
    {     0.00000001477,  4.25171290737,      194.17664032680}, 
    {     0.00000001529,  5.58893570501,      212.02707105080}, 
    {     0.00000001686,  5.08403152624,     3480.31056622260}, 
    {     0.00000001884,  3.62471460828,      204.70107572890}, 
    {     0.00000001885,  3.29608219905,     2324.94940881560}, 
    {     0.00000001529,  5.47660937647,      214.57111982520}, 
    {     0.00000001392,  2.27890229097,      403.02231763990}, 
    {     0.00000001541,  2.06818136546,       36.64856292950}, 
    {     0.00000001446,  6.04094616943,      165.60483224460}, 
    {     0.00000001924,  1.37067955741,      468.24268865160}, 
    {     0.00000001427,  0.13207926609,     2207.62954059540}, 
    {     0.00000001371,  3.34466996039,       93.53154666300}, 
    {     0.00000001368,  1.63092978466,      629.60234557550}, 
    {     0.00000001376,  5.36960481264,      180.16199464630}, 
    {     0.00000001376,  2.32437962529,      721.64941953020}, 
    {     0.00000001574,  0.85824745087,      271.40591944890}, 
    {     0.00000001652,  5.34399182698,      835.03713448730}, 
    {     0.00000001395,  5.68950292442,       25.27279426550}, 
    {     0.00000001539,  5.48277268478,      391.17346822390}, 
    {     0.00000001356,  2.22997055118,      643.07868005170}, 
    {     0.00000001761,  3.58954066417,      508.35032409220}, 
    {     0.00000001597,  3.04206255741,       42.53826965290}, 
    {     0.00000001390,  4.55010436102,      426.07692601420}, 
    {     0.00000001369,  2.91645695847,      447.93883187840}, 
    {     0.00000001303,  1.82744175272,     1382.88734684660}, 
    {     0.00000001282,  4.26450378358,      123.53964334370}, 
    {     0.00000001258,  3.01135384620,      409.92341631960}, 
    {     0.00000001466,  1.84480396294,      289.56516671360}, 
    {     0.00000001718,  5.69747594400,       22.89454967990}, 
    {     0.00000001272,  4.39843475366,      558.00214074590}, 
    {     0.00000001348,  3.87460263816,     1802.37199072180}, 
    {     0.00000001321,  0.07205905057,      411.62033734900}, 
    {     0.00000001223,  4.07454753623,       28.45418800320}, 
    {     0.00000001565,  2.32965370903,       41.05379694460}, 
    {     0.00000001648,  6.06315403714,      268.43697403230}, 
    {     0.00000001367,  5.83045867550,     1108.13997496560}, 
    {     0.00000001202,  3.07875838575,      420.96911658350}, 
    {     0.00000001238,  5.25936845912,      412.58354519550}, 
    {     0.00000001220,  3.92987038126,        2.66012887590}, 
    {     0.00000001552,  1.48184058623,     9786.68735533500}, 
    {     0.00000001288,  5.09334449950,      427.11945573780}, 
    {     0.00000001131,  5.39248376531,      423.67742956920}, 
    {     0.00000001210,  1.45847814907,      291.26208774300}, 
    {     0.00000001121,  3.86569300942,     1033.35837639830}, 
    {     0.00000001314,  1.47623638670,     1073.60902419080}, 
    {     0.00000001165,  4.09976571840,      685.47393735270}, 
    {     0.00000001340,  2.51007561607,      421.93232443000}, 
    {     0.00000001307,  0.11221972956,       71.81265315070}, 
    {     0.00000001265,  0.90565355476,      778.41478318470}, 
    {     0.00000001438,  2.57735033390,      100.38446123290}, 
    {     0.00000001190,  5.63379509659,        5.10780943070}, 
    {     0.00000001099,  0.15185327787,      820.05928096030}, 
    {     0.00000001289,  5.20598956623,      278.25883401880}, 
    {     0.00000001081,  5.18890270804,      313.21047591890}, 
    {     0.00000001233,  2.70202819383,      282.66406803390}, 
    {     0.00000001205,  4.01989274918,      980.66817835880}, 
    {     0.00000001153,  5.01183625908,      230.56457082540}, 
    {     0.00000001400,  2.58587010058,     2538.24850425360}, 
    {     0.00000001022,  1.11289664927,       69.36497259590}, 
    {     0.00000001255,  2.46286000363,      457.61767951300}, 
    {     0.00000001076,  2.39117465097,       48.75804477640}, 
    {     0.00000001190,  6.18490188091,     3377.21779200400}, 
    {     0.00000001204,  4.09186978258,      525.75881183150}, 
    {     0.00000000990,  5.94952240765,     3583.40334044120}, 
    {     0.00000001005,  5.21278239561,      319.31263096340}, 
    {     0.00000000971,  4.25395254634,      397.39324334740}, 
    {     0.00000000991,  0.03591482796,      140.96517742550}, 
    {     0.00000000968,  5.67985317617,      422.40540518200}, 
    {     0.00000001300,  1.34580694314,      875.83029900100}, 
    {     0.00000001190,  0.67902660568,      699.70103135430}, 
    {     0.00000000966,  1.77267401630,       67.66805156650}, 
    {     0.00000000950,  2.66974427113,       92.30770638560}, 
    {     0.00000000933,  0.62979417948,      406.95447090300}, 
    {     0.00000001027,  1.95953557809,     2097.42321937600}, 
    {     0.00000001184,  3.70094967310,      285.63301345050}, 
    {     0.00000000948,  0.92585793863,      143.93412284210}, 
    {     0.00000001048,  3.69648624644,      117.91056905120}, 
    {     0.00000001201,  4.22453841439,      219.89137757700}, 
    {     0.00000001150,  2.53520366594,      104.57724692690}, 
    {     0.00000001258,  2.51634186900,      694.07195706180}, 
    {     0.00000000940,  3.94701776697,       35.21227433100}, 
    {     0.00000001181,  5.26563174373,      638.41281360570}, 
    {     0.00000001047,  6.12360979462,      238.90195810360}, 
    {     0.00000000959,  5.19545703649,      240.12579838100}, 
    {     0.00000000888,  2.16687798409,      739.80866679490}, 
    {     0.00000000910,  6.12673330424,      616.32141307790}, 
    {     0.00000001179,  1.71786905567,      691.10301164520}, 
    {     0.00000000893,  0.95364488395,       14.81779483260}, 
    {     0.00000000944,  3.47615309940,      443.86366626340}, 
    {     0.00000000875,  0.58638080067,        2.28762186040}, 
    {     0.00000000992,  3.17301353403,      337.73251065900}, 
    {     0.00000000842,  3.90433125703,      331.20966448920}, 
    {     0.00000001055,  3.94158533336,      945.24345570670}, 
    {     0.00000000848,  3.18251107437,      196.03362005060}, 
    {     0.00000001043,  3.87748523839,      532.61172640140}, 
    {     0.00000001021,  2.93082353478,      184.98791978670}, 
    {     0.00000000820,  1.01398728276,      480.77286162380}, 
    {     0.00000001076,  3.28234305253,        5.67725840230}, 
    {     0.00000000965,  2.88516068358,      211.60217440860}, 
    {     0.00000000840,  5.37879523628,       97.67614824720}, 
    {     0.00000000808,  2.78227865695,      212.07525516060}, 
    {     0.00000000803,  0.77782236251,      724.83081326790}, 
    {     0.00000000839,  3.54633464957,      421.18156490460}, 
    {     0.00000000806,  0.91687463872,      108.72184851110}, 
    {     0.00000000808,  2.21175862312,      610.69233878540}, 
    {     0.00000000808,  2.00008111736,      214.52293571540}, 
    {     0.00000000797,  2.64685759248,      436.89313161450}, 
    {     0.00000000791,  2.35474255596,        1.37259812370}, 
    {     0.00000001001,  2.34471240227,       16.04163511000}, 
    {     0.00000000993,  0.63704559422,       84.93352695390}, 
    {     0.00000000818,  5.65861039653,      662.53120356300}, 
    {     0.00000000980,  2.62928231216,      395.57870223900}, 
    {     0.00000001022,  2.72113505557,      268.95823889410}, 
    {     0.00000000867,  1.60229563173,       19.64371997300}, 
    {     0.00000000768,  5.25077200882,      305.08553696180}, 
    {     0.00000000894,  1.48955357147,      760.25553592000}, 
    {     0.00000000890,  0.12712803242,      238.42887735160}, 
    {     0.00000000906,  3.36915692315,      526.50957135690}, 
    {     0.00000000932,  2.83616864072,     2641.34127847220}, 
    {     0.00000000808,  5.23759255093,      216.26804085460}, 
    {     0.00000000733,  0.56621977741,     2627.11418447060}, 
    {     0.00000000798,  3.72376709468,      124.50285119020}, 
    {     0.00000000847,  2.03085858041,      511.53171782990}, 
    {     0.00000000908,  0.27377388936,      710.74673161820}, 
    {     0.00000000753,  0.72727486508,     3370.10424500320}, 
    {     0.00000000795,  0.27912881638,      101.86893394120}, 
    {     0.00000000785,  1.63053749655,      465.95506679120}, 
    {     0.00000000752,  4.77248612283,      102.57150935680}, 
    {     0.00000000718,  1.61123765583,      159.12442469020}, 
    {     0.00000000804,  2.07376802341,      114.39910691340}, 
    {     0.00000000790,  4.48898079269,      444.75743814070}, 
    {     0.00000000806,  1.20040327670,      570.74476203920}, 
    {     0.00000000834,  4.30066746390,      453.42489381900}, 
    {     0.00000000911,  5.04625406846,      913.96333463880}, 
    {     0.00000000860,  2.78958557006,      495.75071515080}, 
    {     0.00000000688,  1.10207467005,        1.53686233500}, 
    {     0.00000000744,  3.54097534054,     1182.92157353290}, 
    {     0.00000000817,  3.77746249152,     2118.76386037840}, 
    {     0.00000000763,  2.56122272197,      418.00017116690}, 
    {     0.00000000858,  3.50137925405,      439.12836384820}, 
    {     0.00000000697,  1.84993135386,       72.33391801250}, 
    {     0.00000000684,  3.93924645159,      337.80194662820}, 
    {     0.00000000716,  6.18909857064,      310.71461125430}, 
    {     0.00000000922,  1.70582310864,      125.18417474640}, 
    {     0.00000000881,  1.69931467623,     6283.07584999140}, 
    {     0.00000000658,  0.03671701039,     2524.02141025200}, 
    {     0.00000000742,  1.91529584654,      214.99601646740}, 
    {     0.00000000656,  1.28143991756,      432.01481684740}, 
    {     0.00000000847,  4.57879676752,      624.91943278700}, 
    {     0.00000000853,  3.03999967701,      298.23262239190}, 
    {     0.00000000733,  5.86794900190,      938.12990870590}, 
    {     0.00000000667,  2.19812773242,      576.16138801060}, 
    {     0.00000000809,  1.62224980069,      299.12639426920}, 
    {     0.00000000665,  1.63005583526,      221.16340196420}, 
    {     0.00000000631,  2.01204905117,       58.10682401090}, 
    {     0.00000000804,  5.94281804567,       26.02355379090}, 
    {     0.00000000679,  2.11784460945,      256.42806592190}, 
    {     0.00000000731,  1.95762888351,       19.01058052660}, 
    {     0.00000000786,  0.91251218885,      518.38463239980}, 
    {     0.00000000683,  4.89269007977,     3796.70243587920}, 
    {     0.00000000718,  4.15300342275,      909.81873305460}, 
    {     0.00000000611,  2.08393662004,     1038.04128918680}, 
    {     0.00000000625,  4.05845324358,      429.51895218280}, 
    {     0.00000000692,  4.71966732510,     1048.33622992530}, 
    {     0.00000000828,  0.31672617003,       25.60286266560}, 
    {     0.00000000588,  1.95775535435,      211.86280683950}, 
    {     0.00000000816,  4.10459434690,      141.48644228730}, 
    {     0.00000000588,  2.82460441996,      214.73538403650}, 
    {     0.00000000661,  5.28288481360,      103.61403908040}, 
    {     0.00000000768,  5.28051245446,      428.08266358430}, 
    {     0.00000000657,  2.58191098926,      526.98265210890}, 
    {     0.00000000649,  5.56200025375,      393.46109008430}, 
    {     0.00000000629,  5.97635563917,      188.02630117250}, 
    {     0.00000000753,  1.90904368126,    25874.60404613620}, 
    {     0.00000000748,  5.44697890119,      220.93390730060}, 
    {     0.00000000733,  2.95763022430,      606.76018552230}, 
    {     0.00000000744,  1.07486030610,      239.16259053450}, 
    {     0.00000000591,  2.37128962566,      205.43478891180}, 
    {     0.00000000611,  2.87854337819,      460.53844081980}, 
    {     0.00000000535,  5.80500022712,      100.17201291180}, 
    {     0.00000000553,  5.75044544607,      430.79097657000}, 
    {     0.00000000543,  3.42480625305,      597.35901666110}, 
    {     0.00000000686,  0.66246572964,      953.10776223290}, 
    {     0.00000000680,  6.15131458182,      432.22726516850}, 
    {     0.00000000550,  2.22246008421,       92.79783348010}, 
    {     0.00000000648,  2.33387623043,       30.75885620610}, 
    {     0.00000000618,  4.10680331300,      505.31194270640}, 
    {     0.00000000520,  2.67035391622,      262.05714021440}, 
    {     0.00000000513,  3.04159909875,      425.84743135060}, 
    {     0.00000000564,  1.70404561569,     2413.81508903260}, 
    {     0.00000000531,  2.17713708436,      263.02034806090}, 
    {     0.00000000578,  3.31462999801,       33.72780162270}, 
    {     0.00000000502,  4.46951168080,      343.73983746140}, 
    {     0.00000000502,  2.10975368391,      319.57326339430}, 
    {     0.00000000516,  1.42008175574,     1246.65747183630}, 
    {     0.00000000524,  5.78873025919,      366.79444583570}, 
    {     0.00000000551,  5.70618089893,     1119.18567522950}, 
    {     0.00000000497,  3.85720033517,      850.01498801430}, 
    {     0.00000000511,  1.98874585808,      958.57677783100}, 
    {     0.00000000619,  2.38199178019,     2854.64037391020}, 
    {     0.00000000552,  3.64343336935,      256.58812461630}, 
    {     0.00000000622,  1.86517305535,      524.01370669230}, 
    {     0.00000000531,  2.81862554182,      227.31374111850}, 
    {     0.00000000493,  4.63380945820,      384.05992122310}, 
    {     0.00000000480,  5.33682425120,       29.20494752860}, 
    {     0.00000000578,  5.89620504304,     3693.60966166060}, 
    {     0.00000000592,  3.23373539743,      824.74219374880}, 
    {     0.00000000526,  4.17768461979,      136.06981631590}, 
    {     0.00000000514,  2.31169637126,     2957.73314812880}, 
    {     0.00000000611,  4.56245943434,      774.48262992160}, 
    {     0.00000000482,  2.02179864928,     1063.31408345230}, 
    {     0.00000000471,  5.57017731512,     1171.87587326900}, 
    {     0.00000000527,  4.00342741707,     2435.15573003500}, 
    {     0.00000000643,  3.24713673017,       67.88049988760}, 
    {     0.00000000524,  4.72613379833,      336.83873878170}, 
    {     0.00000000467,  3.48891086991,      219.66188291340}, 
    {     0.00000000470,  1.49296381710,      849.26422848890}, 
    {     0.00000000495,  5.95822960452,      765.88461021250}, 
    {     0.00000000463,  6.09780322600,       54.33472944220}, 
    {     0.00000000514,  5.00485530287,      273.85360000370}, 
    {     0.00000000457,  5.55952771886,     3899.79521009780}, 
    {     0.00000000447,  1.87280713595,       62.03897727400}, 
    {     0.00000000470,  2.97782717732,      306.83064210100}, 
    {     0.00000000552,  0.65842795395,      315.16802937920}, 
    {     0.00000000499,  1.92816937061,      217.44369702220}, 
    {     0.00000000518,  1.75253765929,      867.42347575360}, 
    {     0.00000000517,  3.53711999444,      233.90602325750}, 
    {     0.00000000554,  1.28959719818,      133.10087089930}, 
    {     0.00000000562,  3.72609171835,      934.94851496820}, 
    {     0.00000000563,  2.99951491306,      170.01006625970}, 
    {     0.00000000447,  6.04404377845,      141.69889060840}, 
    {     0.00000000447,  5.83596703375,      823.99143422340}, 
    {     0.00000000468,  3.87435857327,      320.58465535060}, 
    {     0.00000000537,  0.85582040261,      214.19286731530}, 
    {     0.00000000442,  2.80002649672,      209.15449385380}, 
    {     0.00000000556,  2.28527743564,      810.65811209910}, 
    {     0.00000000443,  4.31061989755,     9992.87290377220}, 
    {     0.00000000573,  5.47590213541,      376.19561469690}, 
    {     0.00000000488,  0.35817136383,       36.90919536040}, 
    {     0.00000000498,  0.19856617778,      450.97721326420}, 
    {     0.00000000457,  0.44937757211,      431.26405732200}, 
    {     0.00000000483,  3.92979214854,       39.61750834610}, 
    {     0.00000000467,  1.89153069484,       30.05628079050}, 
    {     0.00000000428,  5.78549789490,      491.55792945680}, 
    {     0.00000000410,  4.94157240067,      306.09692891810}, 
    {     0.00000000410,  5.52148731043,      118.07062774560}, 
    {     0.00000000431,  4.30068740031,       88.11492069160}, 
    {     0.00000000486,  1.24507986579,      107.75864066460}, 
    {     0.00000000468,  3.66040999717,      988.53248488500}, 
    {     0.00000000418,  1.40296106325,      313.94418910180}, 
    {     0.00000000483,  4.50050476783,       46.20979048510}, 
    {     0.00000000437,  0.86746182155,      170.97327410620}, 
    {     0.00000000481,  1.80728434905,       43.12897048390}, 
    {     0.00000000398,  2.91337006854,      131.54696222180}, 
    {     0.00000000529,  3.74604329884,      699.17976649250}, 
    {     0.00000000545,  2.97416609047,      305.60680182360}, 
    {     0.00000000537,  2.53257235538,      952.09637027660}, 
    {     0.00000000412,  3.81964618636,       84.34282612290}, 
    {     0.00000000391,  2.42357051081,      295.19424100610}, 
    {     0.00000000492,  0.69476260355,      328.24071907260}, 
    {     0.00000000390,  1.37349719402,      945.99421523210}, 
    {     0.00000000443,  1.09570138382,      963.40270297140}, 
    {     0.00000000472,  2.41331813400,      838.21852822500}, 
    {     0.00000000519,  3.12248135009,    10213.28554621100}, 
    {     0.00000000494,  4.63690152976,      301.41401612960}, 
    {     0.00000000537,  3.92653937170,      212.40532356070}, 
    {     0.00000000414,  2.59696973215,      121.84272231430}, 
    {     0.00000000379,  4.88521294200,      775.23338944700}, 
    {     0.00000000477,  1.66086029667,      175.42669223110}, 
    {     0.00000000458,  5.15052595883,      960.22130923370}, 
    {     0.00000000461,  3.55548515746,       71.60020482960}, 
    {     0.00000000372,  0.33222550941,     2943.50605412720}, 
    {     0.00000000457,  4.45882272299,       33.13710079170}, 
    {     0.00000000476,  3.63257697985,       20.49505323490}, 
    {     0.00000000398,  4.38336031417,      739.05790726950}, 
    {     0.00000000366,  1.53633889734,      369.08206769610}, 
    {     0.00000000381,  0.82643132982,      229.97386999440}, 
    {     0.00000000376,  2.94742828993,     6062.66320755260}, 
    {     0.00000000383,  1.84135490966,      346.39996633730}, 
    {     0.00000000366,  4.24140062871,      541.53981451060}, 
    {     0.00000000366,  2.04993663405,       87.31177153950}, 
    {     0.00000000367,  1.55348491072,      754.83890994860}, 
    {     0.00000000440,  6.27186292780,      378.90392768260}, 
    {     0.00000000407,  2.54835966340,      732.69511979410}, 
    {     0.00000000497,  5.69945820916,      562.14674233010}, 
    {     0.00000000367,  5.72103354739,       96.87299909510}, 
    {     0.00000000370,  5.65930804475,       89.75945209430}, 
    {     0.00000000451,  3.05732548022,      898.77303279070}, 
    {     0.00000000418,  2.03137205914,      146.59425171800}, 
    {     0.00000000367,  5.87612343294,      561.93429400900}, 
    {     0.00000000408,  5.59691221721,       58.31927233200}, 
    {     0.00000000382,  3.87558216751,      519.39602435610}, 
    {     0.00000000458,  3.41993870613,      829.62050851590}, 
    {     0.00000000433,  3.40938468811,       32.45577723550}, 
    {     0.00000000342,  3.61061377024,      449.23210812500}, 
    {     0.00000000351,  0.42169595316,     3686.49611465980}, 
    {     0.00000000383,  1.45427056096,     2730.20695868920}, 
    {     0.00000000389,  2.73429108352,       36.17548217750}, 
    {     0.00000000434,  0.33633221675,       55.13787859430}, 
    {     0.00000000347,  5.08987125237,      392.65794093220}, 
    {     0.00000000336,  1.56848818314,      233.74596456310}, 
    {     0.00000000468,  4.21059909473,      832.58945393250}, 
    {     0.00000000400,  1.32437246111,      551.10104206620}, 
    {     0.00000000408,  0.29350145668,       90.56260124640}, 
    {     0.00000000331,  3.31396426529,      952.35700270750}, 
    {     0.00000000433,  3.06705605051,      885.43971066640}, 
    {     0.00000000363,  5.21662491556,     1321.43907040360}, 
    {     0.00000000350,  0.27061951411,      386.98068252990}, 
    {     0.00000000377,  4.02407408251,      195.89060769870}, 
    {     0.00000000439,  0.20614895280,      768.85355562910}, 
    {     0.00000000343,  2.18929174651,       80.19822453870}, 
    {     0.00000000371,  4.82569230753,      103.35340664950}, 
    {     0.00000000316,  3.77933506984,      749.20983565610}, 
    {     0.00000000313,  0.33412233010,      354.99798604640}, 
    {     0.00000000345,  0.65964675903,      303.86169668440}, 
    {     0.00000000318,  6.18967282289,      540.73666535850}, 
    {     0.00000000394,  0.49801994278,      248.46318565920}, 
    {     0.00000000321,  1.38233217556,      572.22923474750}, 
    {     0.00000000409,  4.50419980169,     2914.01423582380}, 
    {     0.00000000304,  0.55980988137,      200.55647414470}, 
    {     0.00000000425,  5.38041771827,      387.24131496080}, 
    {     0.00000000307,  5.62169035036,      426.48631629140}, 
    {     0.00000000303,  1.77577015570,     1354.43315884340}, 
    {     0.00000000326,  0.55650991969,      857.12853501510}, 
    {     0.00000000320,  0.76110062758,      402.21916848780}, 
    {     0.00000000306,  5.43075844483,     1151.42900414390}, 
    {     0.00000000296,  3.15801280056,      192.85222631290}, 
    {     0.00000000373,  3.70882376658,      420.44785172170}, 
    {     0.00000000381,  1.98600461815,      109.94568878850}, 
    {     0.00000000313,  1.98847351323,     3274.12501778540}, 
    {     0.00000000316,  4.68238982521,     4113.09430553580}, 
    {     0.00000000296,  4.45699206346,      668.20846196530}, 
    {     0.00000000307,  4.03153284883,      426.71006546060}, 
    {     0.00000000386,  3.23974290135,      745.91082183940}, 
    {     0.00000000392,  0.14336691305,      206.39799675830}, 
    {     0.00000000317,  1.84490263716,      214.94362684070}, 
    {     0.00000000286,  1.04058058980,      315.64111013120}, 
    {     0.00000000286,  2.10284268664,      335.14181775230}, 
    {     0.00000000289,  4.70265740009,       29.74746424980}, 
    {     0.00000000284,  4.67220236113,      281.17959532560}, 
    {     0.00000000283,  5.25961089189,      414.81877742920}, 
    {     0.00000000280,  0.45877292284,       38.60611638980}, 
    {     0.00000000377,  0.85962141856,      423.62924545940}, 
    {     0.00000000283,  1.20963336142,     1699.27921650320}, 
    {     0.00000000302,  1.14801271444,     1257.70317210020}, 
    {     0.00000000289,  0.39419904139,      114.94162363460}, 
    {     0.00000000310,  4.11324737724,      769.81676347560}, 
    {     0.00000000282,  2.75269537491,      551.03160609700}, 
    {     0.00000000336,  6.23083557086,      731.68372783780}, 
    {     0.00000000279,  0.26388092959,      464.73122651380}, 
    {     0.00000000368,  1.33340900488,     1055.44977692610}, 
    {     0.00000000269,  0.19102111090,      172.45774681450}, 
    {     0.00000000361,  2.44015253985,      705.11765732570}, 
    {     0.00000000275,  4.28054408975,      380.38840039090}, 
    {     0.00000000377,  4.70934833857,      745.27768239300}, 
    {     0.00000000307,  1.98521490131,      495.96316347190}, 
    {     0.00000000337,  3.68858519623,      259.76951835400}, 
    {     0.00000000339,  3.08818903316,    10220.39909321180}, 
    {     0.00000000296,  2.00421481341,      589.49471013490}, 
    {     0.00000000317,  1.58244658244,      707.56533788050}, 
    {     0.00000000296,  5.75916833234,     4010.00153131720}, 
    {     0.00000000272,  5.06188002128,      604.47256366190}, 
    {     0.00000000309,  5.08967978904,      481.73606947030}, 
    {     0.00000000268,  4.17204337052,       90.82323367730}, 
    {     0.00000000279,  2.57997066424,     1166.40685767090}, 
    {     0.00000000263,  5.83143850743,      236.19364511790}, 
    {     0.00000000262,  4.82319865484,      254.14044406150}, 
    {     0.00000000330,  5.28727805343,      373.90799283650}, 
    {     0.00000000272,  5.86503850236,      332.17287233570}, 
    {     0.00000000270,  2.05575029737,     1056.20053645150}, 
    {     0.00000000325,  5.61078155189,       95.22846769240}, 
    {     0.00000000329,  3.65551552377,     1261.63532536330}, 
    {     0.00000000262,  5.26283687262,      190.40454575810}, 
    {     0.00000000266,  3.28625963812,      560.71045373160}, 
    {     0.00000000273,  6.14693613085,       57.51612317990}, 
    {     0.00000000281,  5.14426219194,      253.45912050530}, 
    {     0.00000000258,  3.41189080652,      426.81063919710}, 
    {     0.00000000258,  6.24133239267,      426.38574255490}, 
    {     0.00000000279,  4.41281278656,      385.54439393140}, 
    {     0.00000000256,  3.16610713985,      102.34201469320}, 
    {     0.00000000257,  0.70050938269,      103.84353374400}, 
    {     0.00000000254,  5.72706255967,      680.05731138130}, 
    {     0.00000000261,  2.03152918911,      782.34693644780}, 
    {     0.00000000266,  2.54277079029,      132.88842257820}, 
    {     0.00000000254,  3.62032079258,      419.43645976540}, 
    {     0.00000000316,  2.93504590700,      357.23321828010}, 
    {     0.00000000267,  5.54665314271,      628.59095361920}, 
    {     0.00000000325,  6.25534454270,      763.43692965770}, 
    {     0.00000000278,  3.34275955950,     1193.96727379680}, 
    {     0.00000000249,  3.99548655043,      441.57604440300}, 
    {     0.00000000246,  4.81514754590,     1534.73816584160}, 
    {     0.00000000272,  2.48071385760,      550.13783421970}, 
    {     0.00000000246,  5.71006975326,      476.31944349890}, 
    {     0.00000000294,  1.22963935768,      249.94765836750}, 
    {     0.00000000259,  3.88202030192,      639.37602145220}, 
    {     0.00000000244,  5.10422417434,      310.97524368520}, 
    {     0.00000000311,  3.52049740257,     2751.54759969160}, 
    {     0.00000000243,  6.28195773692,     2840.41327990860}, 
    {     0.00000000313,  3.42509462426,      598.84348936940}, 
    {     0.00000000239,  0.56411438013,     1041.22268292450}, 
    {     0.00000000314,  2.09014741078,     2700.71514038580}, 
    {     0.00000000252,  3.18783181098,      433.66355376700}, 
    {     0.00000000269,  0.46123281645,      419.53282798500}, 
    {     0.00000000287,  3.94676800561,      187.43560034150}, 
    {     0.00000000239,  4.33768387204,      418.96337901340}, 
    {     0.00000000277,  3.33020754198,      545.47196777370}, 
    {     0.00000000235,  1.40745218631,      325.95309721220}, 
    {     0.00000000303,  3.77099446355,      285.37238101960}, 
    {     0.00000000246,  0.91025855538,      427.34895040140}, 
    {     0.00000000304,  3.15302544595,      409.18970313670}, 
    {     0.00000000260,  3.22650696823,     1251.34038462480}, 
    {     0.00000000270,  0.26009457956,     1175.80802653210}, 
    {     0.00000000286,  4.70301654462,     5429.87946823940}, 
    {     0.00000000302,  3.15201610429,      915.23535902600}, 
    {     0.00000000264,  0.46129841785,      720.89866000480}, 
    {     0.00000000284,  5.20343995757,      395.10562148700}, 
    {     0.00000000300,  3.02573280616,      498.93210888850}, 
    {     0.00000000237,  4.86867505639,     1181.43710082460}, 
    {     0.00000000231,  0.11031027115,      433.75992198660}, 
    {     0.00000000261,  3.79185925936,      658.05653357870}, 
    {     0.00000000258,  0.22294298357,      535.91074021810}, 
    {     0.00000000268,  4.16390951489,      348.63519857100}, 
    {     0.00000000294,  1.09586943179,      544.50875992720}, 
    {     0.00000000319,  0.20364888646,      201.51968199120}, 
    {     0.00000000320,  0.21731757970,    25448.00585526019}, 
    {     0.00000000235,  2.91419127683,     3553.91152213780}, 
    {     0.00000000228,  3.13658374798,      806.72595883600}, 
    {     0.00000000280,  1.89219912250,      608.87779767700}, 
    {     0.00000000304,  1.81517981104,       49.72125262290}, 
    {     0.00000000241,  4.41107497608,       97.46369992610}, 
    {     0.00000000280,  1.91710870481,      619.29035849450}, 
    {     0.00000000268,  5.54944666204,    12352.85260454480}, 
    {     0.00000000300,  0.82078435036,      260.36021918500}, 
    {     0.00000000241,  2.73275886611,     2254.09996351140}, 
    {     0.00000000248,  2.51130290270,      203.26478713040}, 
    {     0.00000000270,  2.71882107339,      455.16999895820}, 
    {     0.00000000317,  4.74822142018,      420.00590873700}, 
    {     0.00000000238,  4.57200367401,      347.41135829360}, 
    {     0.00000000312,  2.00917921228,     3171.03224356680}, 
    {     0.00000000282,  4.29159133350,     1127.26243007680}, 
    {     0.00000000285,  6.25041522099,      913.00012679230}, 
    {     0.00000000290,  3.93862532064,      566.60016045500}, 
    {     0.00000000243,  4.43884635841,      611.44309831080}, 
    {     0.00000000227,  4.22136692370,      821.70381236300}, 
    {     0.00000000273,  1.92151965288,      418.73388434980}, 
    {     0.00000000236,  4.10002766188,     6467.92575796160}, 
    {     0.00000000222,  3.40994011933,      520.12973753900}, 
    {     0.00000000223,  2.86569801117,      359.68089883490}, 
    {     0.00000000226,  1.60308230653,      316.27999507200}, 
    {     0.00000000286,  6.10546385630,      484.70501488690}, 
    {     0.00000000224,  5.42477390085,      870.46185713940}, 
    {     0.00000000269,  2.80616329306,      693.55069220000}, 
    {     0.00000000295,  3.16789723206,     1050.99635880120}, 
    {     0.00000000225,  2.15616043634,      670.91677495100}, 
    {     0.00000000218,  5.03896380986,      771.30123618390}, 
    {     0.00000000229,  1.16019729708,      531.97858695500}, 
    {     0.00000000270,  6.11597757902,     9360.08916445900}, 
    {     0.00000000220,  0.94624118346,      316.50374424120}, 
    {     0.00000000223,  4.56047229133,     4429.48617519240}, 
    {     0.00000000217,  0.06814070717,     3259.89792378380}, 
    {     0.00000000291,  3.12121440958,       47.69426319340}, 
    {     0.00000000231,  0.26541832793,      394.35486196160}, 
    {     0.00000000215,  6.17765322528,      108.50940019000}, 
    {     0.00000000236,  4.43402005260,      640.41855117580}, 
    {     0.00000000279,  2.65446123759,      134.11226285560}, 
    {     0.00000000216,  0.22963287739,     5753.38488489680}, 
    {     0.00000000247,  4.17284923639,      950.13881681630}, 
    {     0.00000000287,  3.36813375814,      666.72398925700}, 
    {     0.00000000212,  6.07108339832,     1725.94586075180}, 
    {     0.00000000212,  2.45582771491,     1164.76232626820}, 
    {     0.00000000266,  2.30030836660,      314.90739694830}, 
    {     0.00000000279,  2.87114139089,      322.61164478010}, 
    {     0.00000000228,  2.30491692416,      614.62449204850}, 
    {     0.00000000224,  3.01352239231,     1937.70809385480}, 
    {     0.00000000284,  0.34813114540,     1269.49963188950}, 
    {     0.00000000210,  2.36229213543,      439.93151300030}, 
    {     0.00000000286,  4.17396480661,     1364.72809958190}, 
    {     0.00000000222,  4.51639912202,      304.12232911530}, 
    {     0.00000000215,  0.74685271202,     1008.97935401010}, 
    {     0.00000000246,  1.05357358595,      657.16276170140}, 
    {     0.00000000272,  0.63607231806,      679.25416222920}, 
    {     0.00000000220,  2.78497656776,      840.66620877980}, 
    {     0.00000000271,  3.98523199705,      453.68552624990}, 
    {     0.00000000264,  2.58516335032,     2527.20280398970}, 
    {     0.00000000206,  5.74019252688,      232.20910222810}, 
    {     0.00000000203,  1.50483331540,      962.50893109410}, 
    {     0.00000000258,  1.50724315598,     1759.83372106890}, 
    {     0.00000000212,  0.21249623632,     1170.39140056070}, 
    {     0.00000000242,  5.51076641081,     1254.52177836250}, 
    {     0.00000000202,  2.80107182616,      255.83736509090}, 
    {     0.00000000201,  1.11940822442,       97.41551581630}, 
    {     0.00000000234,  3.44765874117,     1190.03512053370}, 
    {     0.00000000201,  5.42082689064,      194.38908864790}, 
    {     0.00000000209,  0.33775403299,       81.89514556810}, 
    {     0.00000000201,  2.67485193508,     1546.53462563090}, 
    {     0.00000000236,  2.80474989355,      462.02291352810}, 
    {     0.00000000230,  4.73688121440,      401.32539661050}, 
    {     0.00000000216,  5.55255486747,      334.55111692130}, 
    {     0.00000000208,  0.74090848873,      517.16079212240}, 
    {     0.00000000268,  2.54915323674,      795.68025857210}, 
    {     0.00000000203,  5.48549678977,      557.03893289940}, 
    {     0.00000000195,  0.30930524284,     1673.25566271230}, 
    {     0.00000000239,  3.98478822895,      661.09491496450}, 
    {     0.00000000194,  3.15655633545,      532.87235883230}, 
    {     0.00000000202,  3.72909313764,     2225.78878786010}, 
    {     0.00000000198,  4.62958669511,     6076.89030155420}, 
    {     0.00000000194,  4.05734751710,      426.85882330690}, 
    {     0.00000000245,  3.77879563722,      499.89531673500}, 
    {     0.00000000197,  2.59372890647,      639.84910220420}, 
    {     0.00000000194,  0.96685944577,     1310.39337013970}, 
    {     0.00000000239,  4.63640373069,      868.71675200020}, 
    {     0.00000000262,  2.16648038763,     9573.38825989700}, 
    {     0.00000000193,  6.12031277542,      620.25356634100}, 
    {     0.00000000197,  0.56732371899,      156.67674413540}, 
    {     0.00000000247,  2.91348766240,      689.61853893690}, 
    {     0.00000000194,  5.59586362692,      426.33755844510}, 
    {     0.00000000232,  1.76649868274,      354.26427286350}, 
    {     0.00000000237,  1.24961133027,      882.94384600180}, 
    {     0.00000000242,  6.18368970388,      559.69906177530}, 
    {     0.00000000202,  4.49789034288,     1239.54392483550}, 
    {     0.00000000193,  0.87361458277,       47.06112374700}, 
    {     0.00000000259,  4.16391413557,      934.19775544280}, 
    {     0.00000000243,  2.86100782215,       64.95973858080}, 
    {     0.00000000264,  5.77011941310,    25654.19140369739}, 
    {     0.00000000204,  2.99939346928,     1385.17496870700}, 
    {     0.00000000187,  4.79452148614,      843.63515419640}, 
    {     0.00000000192,  4.99048344211,      636.97652500720}, 
    {     0.00000000191,  5.40552794600,     1489.91227432830}, 
    {     0.00000000187,  4.02967932517,     6114.53829769400}, 
    {     0.00000000184,  1.13531068665,     1262.38608488870}, 
    {     0.00000000184,  3.84493991801,      318.67949151700}, 
    {     0.00000000244,  0.76614174177,     5643.17856367740}, 
    {     0.00000000195,  1.79897803267,      485.88067105450}, 
    {     0.00000000199,  2.25323627854,       66.18357885820}, 
    {     0.00000000215,  0.53010966790,      784.04385747720}, 
    {     0.00000000184,  5.29993031141,      451.72797278960}, 
    {     0.00000000222,  3.92654047757,     1226.21060271120}, 
    {     0.00000000201,  4.70550758042,     1276.61317889030}, 
    {     0.00000000248,  3.47834021364,     1045.88854937050}, 
    {     0.00000000189,  1.84142475095,      434.67494572330}, 
    {     0.00000000193,  4.63015663692,      625.88264063350}, 
    {     0.00000000210,  5.12097279511,     3494.53766022420}, 
    {     0.00000000225,  3.47799120533,      728.01220700560}, 
    {     0.00000000180,  1.67083010191,      244.79166482700}, 
    {     0.00000000185,  1.26599682245,      837.69726336320}, 
    {     0.00000000199,  1.34931214692,     1012.91150727320}, 
    {     0.00000000206,  4.20379638812,      548.44091319030}, 
    {     0.00000000185,  3.63189231877,     1097.09427470170}, 
    {     0.00000000200,  2.80981188653,      757.21715453420}, 
    {     0.00000000180,  5.69338271322,     4216.18707975440}, 
    {     0.00000000210,  4.55350094602,      608.40471692500}, 
    {     0.00000000178,  4.72379761838,      317.14262918200}, 
    {     0.00000000183,  1.59341380048,      469.88722005430}, 
    {     0.00000000201,  0.50219680740,       36.38793049860}, 
    {     0.00000000211,  2.58933275158,       89.00869256890}, 
    {     0.00000000179,  1.30120995289,     3906.90875709860}, 
    {     0.00000000177,  2.25151102161,       35.16409022120}, 
    {     0.00000000246,  5.20794390821,      272.58157561650}, 
    {     0.00000000176,  2.39195564251,   103925.01437542078}, 
    {     0.00000000226,  2.06446075323,      631.29926660490}, 
    {     0.00000000174,  5.69939637397,      469.72716135990}, 
    {     0.00000000174,  5.04863411343,     1523.69246557770}, 
    {     0.00000000232,  5.19350798290,      594.65070367540}, 
    {     0.00000000192,  5.50039064912,      707.77778620160}, 
    {     0.00000000177,  5.82784918044,      413.85556958270}, 
    {     0.00000000173,  1.58292103982,     1379.70595310890}, 
    {     0.00000000172,  5.94041958594,      984.60033162190}, 
    {     0.00000000172,  4.68707195529,       40.16002506730}, 
    {     0.00000000189,  4.84284140555,      568.29708148440}, 
    {     0.00000000175,  4.83511975400,     1194.71803332220}, 
    {     0.00000000241,  0.67201443623,     1089.12939443900}, 
    {     0.00000000213,  6.08435697556,      271.61836777000}, 
    {     0.00000000177,  1.64110733509,     3590.51688744200}, 
    {     0.00000000224,  0.38976137724,      991.71387862270}, 
    {     0.00000000216,  2.99208871258,     1141.13406340540}, 
    {     0.00000000191,  0.70123392369,     2015.67108615980}, 
    {     0.00000000174,  3.63541680305,      605.27571281400}, 
    {     0.00000000177,  1.45237852614,      904.40210708320}, 
    {     0.00000000178,  0.35454887224,      444.12429869430}, 
    {     0.00000000183,  1.13762118246,      258.54567807660}, 
    {     0.00000000183,  3.04829576614,    25668.41849769900}, 
    {     0.00000000182,  0.75986655407,      504.56118318100}, 
    {     0.00000000199,  3.47101766075,      842.90144101350}, 
    {     0.00000000187,  4.12687876136,     9985.75935677140}, 
    {     0.00000000166,  6.00733259649,     3576.28979344040}, 
    {     0.00000000187,  0.80594740329,      226.04171673130}, 
    {     0.00000000191,  1.79131964388,      702.14871190910}, 
    {     0.00000000232,  3.68163889937,     1123.11782849260}, 
    {     0.00000000172,  5.41410693088,     2306.79016155090}, 
    {     0.00000000186,  0.86352341507,      973.55463135800}, 
    {     0.00000000173,  1.54028223744,      827.92358748650}, 
    {     0.00000000193,  1.24804468649,      109.24311337290}, 
    {     0.00000000184,  4.60992527921,      223.33340374560}, 
    {     0.00000000165,  1.51886495431,     1670.82502850000}, 
    {     0.00000000162,  2.30291581618,      874.39401040250}, 
    {     0.00000000206,  1.66459080869,     6290.18939699220}, 
    {     0.00000000177,  4.36776214702,      328.92204262880}, 
    {     0.00000000197,  1.43444932583,      347.36317418380}, 
    {     0.00000000203,  5.71459758755,      664.27630870220}, 
    {     0.00000000196,  4.72078032034,      104.78969524800}, 
    {     0.00000000182,  1.78459753906,     1245.17299912800}, 
    {     0.00000000184,  0.48156047778,      948.21240112330}, 
    {     0.00000000177,  3.47933371966,     1304.92435454160}, 
    {     0.00000000162,  3.87494735228,      949.12742486000}, 
    {     0.00000000168,  5.94654405439,      883.79517926370}, 
    {     0.00000000188,  4.04198730930,      688.65533109040}, 
    {     0.00000000200,  5.54644649494,      308.31511480930}, 
    {     0.00000000195,  0.29491330050,     1144.31545714310}, 
    {     0.00000000212,  5.98509016682,      432.74853003030}, 
    {     0.00000000211,  1.36833704118,      815.06334611420}, 
    {     0.00000000179,  5.49884895380,     9566.27471289620}, 
    {     0.00000000158,  5.97577354437,      224.60542813280}, 
    {     0.00000000166,  0.96670231118,      632.03297978780}, 
    {     0.00000000181,  2.40654138031,      812.14258480740}, 
    {     0.00000000162,  4.04123271503,      632.73555520340}, 
    {     0.00000000185,  3.01715709315,       55.87159177720}, 
    {     0.00000000154,  4.23895313385,      227.47800532980}, 
    {     0.00000000165,  4.27833421336,      633.74694715970}, 
    {     0.00000000155,  3.77147874591,      407.47573576480}, 
    {     0.00000000195,  2.06339645296,     1127.04998175570}, 
    {     0.00000000171,  3.79380560971,      433.19047301500}, 
    {     0.00000000203,  0.18481949826,     1596.18644228460}, 
    {     0.00000000152,  0.87668770181,      632.83192342300}, 
    {     0.00000000205,  1.62784908817,      389.94962794650}, 
    {     0.00000000156,  2.47045974513,      634.26821202150}, 
    {     0.00000000165,  3.05465194470,      893.35640681930}, 
    {     0.00000000160,  1.59024173023,      774.00954916960}, 
    {     0.00000000153,  0.67184956696,     1026.24482939750}, 
    {     0.00000000157,  5.37707567291,      262.80789973980}, 
    {     0.00000000164,  5.93798546311,      199.80571461930}, 
    {     0.00000000152,  0.62990682378,      949.22379307960}, 
    {     0.00000000184,  2.81115706121,      913.75088631770}, 
    {     0.00000000174,  3.92776720931,      313.47110834980}, 
    {     0.00000000157,  5.67235483479,    77837.11123384659}, 
    {     0.00000000178,  0.28722296370,      637.44960575920}, 
    {     0.00000000150,  3.40116011178,      401.53784493160}, 
    {     0.00000000150,  2.55468547332,      623.22251175760}, 
    {     0.00000000149,  2.64528846124,     1567.73225428140}, 
    {     0.00000000177,  4.68158494106,     2921.12778282460}, 
    {     0.00000000200,  4.59746011930,      851.71190904370}, 
    {     0.00000000147,  4.28619772534,     1160.83017300510}, 
    {     0.00000000147,  5.22553334565,      219.14061805160}, 
    {     0.00000000180,  4.39237324654,      110.15813710960}, 
    {     0.00000000150,  0.38685537182,      346.18751801620}, 
    {     0.00000000151,  1.58821996099,      110.25450532920}, 
    {     0.00000000170,  2.06997658106,      907.37105249980}, 
    {     0.00000000170,  1.70870898705,      493.30303459600}, 
    {     0.00000000147,  5.66193217302,      866.52970387630}, 
    {     0.00000000156,  0.37713977057,      285.11174858870}, 
    {     0.00000000148,  2.14966333692,     1053.75285589670}, 
    {     0.00000000145,  2.97578064766,      318.83955021140}, 
    {     0.00000000150,  2.02972985856,     1049.08698945070}, 
    {     0.00000000155,  5.40486194982,      941.31130244360}, 
    {     0.00000000157,  2.34913118792,     5959.57043333400}, 
    {     0.00000000176,  0.72569662289,      562.66800719190}, 
    {     0.00000000174,  2.74727949944,      652.42745928620}, 
    {     0.00000000144,  0.07286394798,     1357.61455258110}, 
    {     0.00000000157,  5.60572015205,       83.37961827640}, 
    {     0.00000000192,  1.32296078608,     2906.90068882300}, 
    {     0.00000000145,  2.89440864386,      757.80785536520}, 
    {     0.00000000163,  2.96579171875,      398.14400287280}, 
    {     0.00000000143,  5.77044222961,      638.93407846750}, 
    {     0.00000000153,  4.30822632490,     1688.23351623930}, 
    {     0.00000000162,  2.92059412639,      640.86049416050}, 
    {     0.00000000148,  2.22132937111,      366.04368631030}, 
    {     0.00000000139,  1.57016688059,      508.49333644410}, 
    {     0.00000000137,  1.28925665930,      214.10224459010}, 
    {     0.00000000137,  4.69338435212,     1091.62525910360}, 
    {     0.00000000137,  3.49438482945,      212.49594628590}, 
    {     0.00000000161,  2.79324425926,     1884.12412393800}, 
    {     0.00000000141,  6.11606010109,      689.40609061580}, 
    {     0.00000000158,  2.93809799437,      211.65456403530}, 
    {     0.00000000133,  1.07901356698,      714.67888488130}, 
    {     0.00000000132,  3.41532758407,      241.75328344120}, 
    {     0.00000000140,  0.35543703784,      219.51887056150}, 
    {     0.00000000132,  1.60294025637,     1372.59240610810}, 
    {     0.00000000138,  4.87283429639,      635.70450062000}, 
    {     0.00000000174,  3.20392947742,     3067.93946934820}, 
    {     0.00000000131,  2.72435966674,      398.28701522470}, 
    {     0.00000000142,  2.33733560884,      424.90126984660}, 
    {     0.00000000145,  2.46754245743,      740.06929922580}, 
    {     0.00000000130,  6.04357829917,      361.37781986430}, 
    {     0.00000000136,  4.16548251681,     1016.84366053630}, 
    {     0.00000000129,  1.72249381106,     9683.59458111640}, 
    {     0.00000000166,  0.13141571702,      990.22940591440}, 
    {     0.00000000176,  1.05208913969,     2520.08925698890}, 
    {     0.00000000166,  0.94384437158,      476.10699517780}, 
    {     0.00000000140,  3.62845418039,      423.88987789030}, 
    {     0.00000000146,  4.06866189224,     5636.06501667660}, 
    {     0.00000000138,  3.29913390228,       98.42690777260}, 
    {     0.00000000144,  0.52149675978,     1459.95656727430}, 
    {     0.00000000171,  2.81138753424,      184.72728735580}, 
    {     0.00000000158,  1.60504572001,     3487.42411322340}, 
    {     0.00000000124,  2.85700280720,      635.23141986800}, 
    {     0.00000000159,  1.00544429672,      514.71311156760}, 
    {     0.00000000162,  5.11097835962,      354.52490529440}, 
    {     0.00000000140,  4.36785639431,      207.07932031450}, 
    {     0.00000000123,  2.38472091094,      254.35289238260}, 
    {     0.00000000131,  4.00719555038,     1736.99156101570}, 
    {     0.00000000127,  2.14761211605,     1443.44185141230}, 
    {     0.00000000128,  2.83776405449,      152.74459087230}, 
    {     0.00000000145,  5.85135135519,      221.89711514710}, 
    {     0.00000000165,  4.63544466195,     9793.80090233580}, 
    {     0.00000000138,  3.13686094637,     3384.33133900480}, 
    {     0.00000000161,  5.37196690469,      373.01422095920}, 
    {     0.00000000122,  1.92670167775,      466.75821594330}, 
    {     0.00000000153,  2.81114887778,     1201.83158032300}, 
    {     0.00000000139,  3.58663958553,      864.24208201590}, 
    {     0.00000000121,  1.00723355716,     1578.77795454530}, 
    {     0.00000000141,  0.53873068197,     5650.29211067820}, 
    {     0.00000000139,  6.02467596636,      429.30650386170}, 
    {     0.00000000118,  0.06202877387,     4002.88798431640}, 
    {     0.00000000117,  0.23611720848,      426.75824957040}, 
    {     0.00000000121,  5.61834288138,      683.18631549230}, 
    {     0.00000000131,  0.19099049100,     1034.84284910660}, 
    {     0.00000000145,  2.01100408928,     9580.50180689780}, 
    {     0.00000000148,  0.86320227639,      802.79380557290}, 
    {     0.00000000120,  5.84000868066,      639.94547042380}, 
    {     0.00000000117,  3.13382982755,      426.43813218160}, 
    {     0.00000000148,  1.37965451617,      737.31280213030}, 
    {     0.00000000125,  1.29791571244,     1314.32552340280}, 
    {     0.00000000120,  4.18622956101,     1827.50177263540}, 
    {     0.00000000120,  1.11355985676,     2303.60876781320}, 
    {     0.00000000151,  5.23544423687,     3178.14579056760}, 
    {     0.00000000113,  5.49041486750,      887.72733252680}, 
    {     0.00000000120,  0.32334283674,      629.86297800640}, 
    {     0.00000000126,  2.25106706266,      653.23060843830}, 
    {     0.00000000126,  0.97215166444,      311.72600321060}, 
    {     0.00000000135,  1.85375623937,      733.42883297700}, 
    {     0.00000000118,  3.16360333291,      642.34496686880}, 
    {     0.00000000138,  1.39135824716,     1120.14888307600}, 
    {     0.00000000112,  0.42841632061,      475.35623565240}, 
    {     0.00000000134,  6.26324135064,      384.27236954420}, 
    {     0.00000000133,  1.19341413256,      502.86426215160}, 
    {     0.00000000110,  6.20238397088,      220.30076785420}, 
    {     0.00000000113,  4.51098937409,     1511.10990297880}, 
    {     0.00000000134,  4.06540685737,      976.73602509570}, 
    {     0.00000000117,  4.21929280836,      927.83496796740}, 
    {     0.00000000111,  1.19685071887,     6393.28217121080}, 
    {     0.00000000109,  4.44503867691,     1299.34766987580}, 
    {     0.00000000109,  5.14421802968,     6179.98307577280}, 
    {     0.00000000116,  2.91900716047,      528.20649238630}, 
    {     0.00000000107,  5.19867681343,      754.03576079650}, 
    {     0.00000000113,  0.70071879215,      494.47869076360}, 
    {     0.00000000124,  5.77019376453,      488.63716815000}, 
    {     0.00000000114,  0.06007563513,      631.82053146670}, 
    {     0.00000000107,  2.73081851971,      628.11787286720}, 
    {     0.00000000146,  1.07964353369,      206.29742302180}, 
    {     0.00000000124,  1.16920221082,      188.16931352440}, 
    {     0.00000000117,  3.62421096533,     2175.38621168100}, 
    {     0.00000000112,  5.17086478948,     1799.19059698410}, 
    {     0.00000000110,  4.44922411890,      786.27908971090}, 
    {     0.00000000148,  5.97825717990,     2946.68744786490}, 
    {     0.00000000137,  1.43623456292,      225.07850888480}, 
    {     0.00000000116,  5.52594794167,      632.26247445140}, 
    {     0.00000000108,  3.38785406479,      642.81804762080}, 
    {     0.00000000108,  4.43079377264,     1158.54255114470}, 
    {     0.00000000117,  4.26185039858,      484.91746320800}, 
    {     0.00000000136,  1.97060630403,      206.93630796260}, 
    {     0.00000000105,  2.43791237776,     1159.29331067010}, 
    {     0.00000000141,  3.48766318510,     1578.02719501990}, 
    {     0.00000000108,  4.73450004538,      220.52451702340}, 
    {     0.00000000103,  3.84307420095,      848.53051530600}, 
    {     0.00000000105,  5.15580410406,     1748.78802080500}, 
    {     0.00000000129,  1.12557930490,    26080.78959457339}, 
    {     0.00000000110,  5.43388877128,      128.36556848410}, 
    {     0.00000000135,  6.14947956124,     3340.61242669980}, 
    {     0.00000000106,  1.43304093123,      646.11706143750}, 
    {     0.00000000101,  3.80702867071,      461.12914165080}, 
    {     0.00000000115,  3.45101596098,     5863.59120611620}, 
    {     0.00000000103,  0.94773770700,     1106.65550225730}, 
    {     0.00000000109,  1.02847174985,     1062.56332392690}, 
    {     0.00000000105,  1.37783338573,     1987.21689815660}, 
    {     0.00000000110,  2.98897645954,     1042.91960395390}, 
    {     0.00000000099,  2.05195836305,     1034.10913592370}, 
    {     0.00000000104,  3.40324525347,      812.94573395950}, 
    {     0.00000000116,  2.49303741513,     2200.51599359460}, 
    {     0.00000000111,  5.01164686630,      220.20019411770}, 
    {     0.00000000099,  5.80548808441,       42.32582133180}, 
    {     0.00000000139,  5.01901587647,      968.13800538660}, 
    {     0.00000000126,  2.60609533649,      661.23792731640}, 
    {     0.00000000129,  1.74723365040,      263.70167161710}, 
    {     0.00000000109,  5.93625989258,      525.02509864860}, 
    {     0.00000000098,  5.80682614639,      764.40013750420}, 
    {     0.00000000134,  3.20331090065,      521.61421024730}, 
    {     0.00000000118,  1.30968907750,     1222.27844944810}, 
    {     0.00000000106,  3.86968434473,     4105.98075853500}, 
    {     0.00000000111,  5.14023256336,      226.79247625670}, 
    {     0.00000000113,  0.50893852381,      184.84490743480}, 
    {     0.00000000124,  2.63716767830,     1264.29545423920}, 
    {     0.00000000101,  4.88259461441,      425.32616648880}, 
    {     0.00000000114,  1.01995685373,     1340.34907719370}, 
    {     0.00000000127,  4.89025569067,      162.09337010680}, 
    {     0.00000000116,  5.20717925949,      845.33207522580}, 
    {     0.00000000096,  4.61869048279,      316.60431797770}, 
    {     0.00000000096,  1.11796162186,      316.17942133550}, 
    {     0.00000000096,  5.84959086837,      845.56156988940}, 
    {     0.00000000096,  4.59376884505,     6386.16862421000}, 
    {     0.00000000103,  5.68113298509,     1130.23137549340}, 
    {     0.00000000101,  3.86045823511,      198.10879358990}, 
    {     0.00000000101,  3.27916836807,      896.48541093030}, 
    {     0.00000000095,  1.49267497700,      674.42823708880}, 
    {     0.00000000102,  4.03806928315,      665.02706822760}, 
    {     0.00000000111,  4.66594406212,      700.45179087970}, 
    {     0.00000000120,  4.40929322898,      695.55642977010}, 
    {     0.00000000109,  2.68886916566,     1518.22344997960}, 
    {     0.00000000127,  1.35796937995,     1493.09366806600}, 
    {     0.00000000102,  1.49520081692,      327.69820235140}, 
    {     0.00000000132,  5.87656214175,      971.10695080320}, 
    {     0.00000000124,  4.37096631322,     1134.37597707760}, 
    {     0.00000000094,  3.78070391483,      326.68681039510}, 
    {     0.00000000100,  5.11374589444,      644.09007200800}, 
    {     0.00000000094,  4.12103973042,   104351.61256629678}, 
    {     0.00000000119,  2.44464219276,     1773.91780271860}, 
    {     0.00000000120,  5.51190663062,      322.02094394910}, 
    {     0.00000000104,  0.94072801823,       45.24658263860}, 
    {     0.00000000110,  5.83597099432,      633.30500417500}, 
    {     0.00000000092,  3.17165005690,      507.59956456680}, 
    {     0.00000000101,  4.77041953206,      427.87021526320}, 
    {     0.00000000098,  4.20048929060,    78263.70942472259}, 
    {     0.00000000098,  2.90784721259,      199.96577331370}, 
    {     0.00000000119,  2.04004116097,     1154.61039788160}, 
    {     0.00000000091,  1.30724317620,     1286.90811962880}, 
    {     0.00000000104,  1.18434321311,      448.68959140380}, 
    {     0.00000000091,  2.03003386313,      650.19222705250}, 
    {     0.00000000117,  2.22762346918,      740.28174754690}, 
    {     0.00000000097,  0.59571650703,      317.87634236490}, 
    {     0.00000000093,  5.03178505524,      847.04604259770}, 
    {     0.00000000095,  0.56124912733,      236.87496867410}, 
    {     0.00000000091,  5.22516620379,     1031.87390369000}, 
    {     0.00000000099,  1.50209451695,      743.79320968470}, 
    {     0.00000000115,  5.88226858490,      924.04582705620}, 
    {     0.00000000091,  6.22628300162,      211.29335786790}, 
    {     0.00000000112,  0.60952277376,      498.19839570560}, 
    {     0.00000000090,  0.20903253046,     1390.00089384740}, 
    {     0.00000000124,  0.14544703761,     2332.06295581640}, 
    {     0.00000000093,  5.53494077769,     5687.94010681800}, 
    {     0.00000000094,  5.34823546532,     1235.61177157240}, 
    {     0.00000000105,  2.75074759436,     1152.17976366930}, 
    {     0.00000000097,  3.87780918853,     2733.38835242690}, 
    {     0.00000000092,  3.33658628877,      518.90589726160}, 
    {     0.00000000090,  3.20306478995,     1164.92238496260}, 
    {     0.00000000091,  4.84054379431,      215.30483300810}, 
    {     0.00000000091,  1.52963589526,      789.46048344860}, 
    {     0.00000000109,  2.69742747002,     1457.52593306200}, 
    {     0.00000000088,  2.39325619929,      639.14652678860}, 
    {     0.00000000104,  2.55393911799,      799.61241183520}, 
    {     0.00000000087,  0.03653347258,     1389.10712197010}, 
    {     0.00000000093,  0.72961701339,      608.24465823060}, 
    {     0.00000000093,  5.30395179663,      222.70026429920}, 
    {     0.00000000087,  1.64989693105,      338.48327018440}, 
    {     0.00000000097,  4.65063535253,     1784.21274345710}, 
    {     0.00000000089,  4.65304680818,     4326.39340097380}, 
    {     0.00000000086,  2.32612831847,     1176.70179840940}, 
    {     0.00000000095,  0.84654513116,      785.52833018550}, 
    {     0.00000000094,  2.02588413534,      512.42548970720}, 
    {     0.00000000098,  4.72121429417,      232.42155054920}, 
    {     0.00000000085,  5.89926368802,     3156.80514956520}, 
    {     0.00000000090,  0.49974649623,       77.75054398390}, 
    {     0.00000000085,  2.91624163677,      746.76215510130}, 
    {     0.00000000088,  0.46680815352,     1912.57831194120}, 
    {     0.00000000084,  4.29098368309,      896.32535223590}, 
    {     0.00000000084,  3.26093035827,     1101.02642796480}, 
    {     0.00000000097,  5.87961038568,     2648.45482547300}, 
    {     0.00000000112,  1.42592292237,     3046.59882834580}, 
    {     0.00000000095,  5.07265268907,     1887.30551767570}, 
    {     0.00000000096,  1.73235805032,     3803.81598288000}, 
    {     0.00000000095,  5.49343620014,      452.20105354160}, 
    {     0.00000000084,  6.00447997565,     4333.50694797460}, 
    {     0.00000000092,  1.30019476195,    25241.82030682300}, 
    {     0.00000000091,  0.34482517770,      912.47886193050}, 
    {     0.00000000089,  5.25882296348,      528.46712481720}, 
    {     0.00000000087,  2.55502392314,    10323.49186743040}, 
    {     0.00000000092,  5.75692439129,      113.12708252620}, 
    {     0.00000000083,  1.67229948282,      229.76142167330}, 
    {     0.00000000110,  1.58491727058,     1023.95720753710}, 
    {     0.00000000084,  2.57764287124,     1448.91086701040}, 
    {     0.00000000084,  1.61297525962,     1173.36034597730}, 
    {     0.00000000090,  0.42687791140,      473.65931462300}, 
    {     0.00000000100,  4.61116427326,      582.38116313410}, 
    {     0.00000000093,  5.76287499930,      203.89792657680}, 
    {     0.00000000102,  0.71631463560,    26301.20223701220}, 
    {     0.00000000086,  4.04071522456,     3789.58888887840}, 
    {     0.00000000108,  1.27513065507,      946.72792841500}, 
    {     0.00000000085,  3.37712901665,     1621.31622419820}, 
    {     0.00000000099,  1.96529929552,     1452.84302027350}, 
    {     0.00000000088,  5.20958727187,     9470.29548567840}, 
    {     0.00000000085,  0.31181175336,      627.15466502070}, 
    {     0.00000000081,  3.03622757274,      196.83676920270}, 
    {     0.00000000083,  2.42949595819,      818.57480825200}, 
    {     0.00000000081,  1.89609165087,      364.34676528090}, 
    {     0.00000000087,  5.45538307617,     1147.49685088080}, 
    {     0.00000000080,  5.25329934448,     4532.57894941100}, 
    {     0.00000000082,  0.02899852098,     4856.08436606840}, 
    {     0.00000000083,  3.14142784311,      157.63995198190}, 
    {     0.00000000097,  1.23841230494,       95.01601937130}, 
    {     0.00000000100,  5.24393975284,      817.77165909990}, 
    {     0.00000000084,  0.31157071716,     1599.95853685330}, 
    {     0.00000000088,  4.27265950076,     1681.11996923850}, 
    {     0.00000000080,  2.85939270432,     1268.74887236410}, 
    {     0.00000000086,  0.97630886006,      200.03520928290}, 
    {     0.00000000083,  2.28713281517,       12.74262129330}, 
    {     0.00000000097,  0.91815961642,     1030.92774218600}, 
    {     0.00000000079,  3.07698098095,      206.07367385260}, 
    {     0.00000000091,  5.75729901464,      807.94979911340}, 
    {     0.00000000087,  0.42720761608,    10007.09999777380}, 
    {     0.00000000078,  3.71839527643,      146.38180339690}, 
    {     0.00000000108,  5.20280565998,     1184.40604624120}, 
    {     0.00000000092,  2.60904862533,      154.01661525950}, 
    {     0.00000000084,  0.32694738907,     1173.52040467170}, 
    {     0.00000000081,  3.57713443867,      205.97310011610}, 
    {     0.00000000085,  0.00036736404,      443.27296543240}, 
    {     0.00000000089,  3.50851506346,      835.78789401270}, 
    {     0.00000000087,  0.76899512620,      201.99276274320}, 
    {     0.00000000082,  3.64624188259,      718.61103814440}, 
    {     0.00000000100,  5.66342418624,     1115.25352196640}, 
    {     0.00000000080,  2.72322567646,      458.09076026500}, 
    {     0.00000000078,  2.92017576269,      634.48066034260}, 
    {     0.00000000094,  5.87172951757,     2545.36205125440}, 
    {     0.00000000082,  5.30395730854,      111.16952906590}, 
    {     0.00000000076,  5.95235039360,      649.45851386960}, 
    {     0.00000000092,  4.67308746790,      596.60825713570}, 
    {     0.00000000076,  5.61246309601,      595.71448525840}, 
    {     0.00000000088,  1.35973650628,     4223.30062675520}, 
    {     0.00000000089,  0.18598030370,     1482.04796780210}, 
    {     0.00000000077,  0.65783702665,      567.82400073240}, 
    {     0.00000000074,  3.13429668952,      529.16970023280}, 
    {     0.00000000077,  1.78883058145,      171.65459766240}, 
    {     0.00000000101,  2.01741399535,      943.75898299840}, 
    {     0.00000000081,  3.18217237590,      534.35683154060}, 
    {     0.00000000077,  5.55978103968,      878.32616366560}, 
    {     0.00000000088,  4.96030794134,     5966.68398033480}, 
    {     0.00000000093,  5.49611976914,      645.52636060650}, 
    {     0.00000000074,  5.82012747215,      316.44005376640}, 
    {     0.00000000086,  5.10320208624,      734.23198212910}, 
    {     0.00000000085,  4.02471557641,      987.78172535960}, 
    {     0.00000000074,  1.59328832031,      846.13101886100}, 
    {     0.00000000077,  5.04672541583,      238.57188970350}, 
    {     0.00000000095,  4.71721046069,     1037.29052966140}, 
    {     0.00000000082,  2.67123570357,     1877.01057693720}, 
    {     0.00000000088,  3.44796546980,     1587.42836388110}, 
    {     0.00000000086,  1.12360345918,      845.11962690470}, 
    {     0.00000000073,  0.30784168957,      109.99387289830}, 
    {     0.00000000092,  3.20015163409,      324.98988936570}, 
    {     0.00000000078,  4.90441489556,      828.13603580760}, 
    {     0.00000000088,  4.85305395851,      251.17149864490}, 
    {     0.00000000095,  4.06828252459,      738.32419408660}, 
    {     0.00000000074,  2.08215303049,      416.56388256840}, 
    {     0.00000000073,  3.80312093402,      110.41876954050}, 
    {     0.00000000086,  4.26211128325,      809.01358069640}, 
    {     0.00000000094,  4.99996575655,      378.64329525170}, 
    {     0.00000000095,  2.96497733290,      844.59836204290}, 
    {     0.00000000100,  0.15146872601,      186.21176006410}, 
    {     0.00000000088,  4.16731870359,      232.94281541100}, 
    {     0.00000000072,  2.01506338325,       94.42531854030}, 
    {     0.00000000076,  4.72470357864,      195.77298761970}, 
    {     0.00000000072,  0.63509909932,      645.31391228540}, 
    {     0.00000000085,  3.70783979194,     1057.89745748090}, 
    {     0.00000000073,  5.83760271337,     1560.61870728060}, 
    {     0.00000000072,  0.86081417266,     3892.68166309700}, 
    {     0.00000000072,  0.99750824683,      280.21638747910}, 
    {     0.00000000077,  1.14405747955,      227.57437354940}, 
    {     0.00000000071,  0.96814412427,      544.66881862160}, 
    {     0.00000000088,  1.03829142709,      266.95250132400}, 
};


static const struct ln_vsop saturn_longitude_l1[LONG_L1] = {
    {   213.29909521690,  0.00000000000,        0.00000000000}, 
    {     0.01297370862,  1.82834923978,      213.29909543800}, 
    {     0.00564345393,  2.88499717272,        7.11354700080}, 
    {     0.00093734369,  1.06311793502,      426.59819087600}, 
    {     0.00107674962,  2.27769131009,      206.18554843720}, 
    {     0.00040244455,  2.04108104671,      220.41264243880}, 
    {     0.00019941774,  1.27954390470,      103.09277421860}, 
    {     0.00010511678,  2.74880342130,       14.22709400160}, 
    {     0.00006416106,  0.38238295041,      639.89728631400}, 
    {     0.00004848994,  2.43037610229,      419.48464387520}, 
    {     0.00004056892,  2.92133209468,      110.20632121940}, 
    {     0.00003768635,  3.64965330780,        3.93215326310}, 
    {     0.00003384691,  2.41694503459,        3.18139373770}, 
    {     0.00003231693,  1.26149969158,      433.71173787680}, 
    {     0.00003071405,  2.32739504783,      199.07200143640}, 
    {     0.00001953179,  3.56378136497,       11.04570026390}, 
    {     0.00001249468,  2.62810757084,       95.97922721780}, 
    {     0.00000921350,  1.96069472334,      227.52618943960}, 
    {     0.00000701524,  4.43097553887,      529.69096509460}, 
    {     0.00000649591,  6.17410622073,      202.25339517410}, 
    {     0.00000627498,  6.11109816220,      309.27832265580}, 
    {     0.00000468362,  4.61704486774,       63.73589830340}, 
    {     0.00000440442,  6.01861163350,      853.19638175200}, 
    {     0.00000478347,  4.98809792152,      522.57741809380}, 
    {     0.00000408800,  2.10122200324,      323.50541665740}, 
    {     0.00000407654,  1.29967965754,      209.36694217490}, 
    {     0.00000343720,  3.95819456535,      412.37109687440}, 
    {     0.00000338569,  3.63538109408,      316.39186965660}, 
    {     0.00000336129,  3.77170200605,      735.87651353180}, 
    {     0.00000331895,  2.86077271205,      210.11770170030}, 
    {     0.00000346963,  2.24152661493,      632.78373931320}, 
    {     0.00000289484,  2.73211009526,      117.31986822020}, 
    {     0.00000254100,  0.54280472223,      647.01083331480}, 
    {     0.00000230497,  1.64428691304,      216.48048917570}, 
    {     0.00000280910,  5.74399466555,        2.44768055480}, 
    {     0.00000192275,  2.96534476762,      224.34479570190}, 
    {     0.00000171342,  4.09606536666,      846.08283475120}, 
    {     0.00000167110,  2.59746814308,       21.34064100240}, 
    {     0.00000136321,  2.28588945465,       10.29494073850}, 
    {     0.00000129468,  3.44863729720,      742.99006053260}, 
    {     0.00000127864,  4.09556557491,      217.23124870110}, 
    {     0.00000109809,  6.16222822735,      415.55249061210}, 
    {     0.00000093929,  3.48395603528,     1052.26838318840}, 
    {     0.00000092500,  3.94738565799,       88.86568021700}, 
    {     0.00000097503,  4.72798517062,      838.96928775040}, 
    {     0.00000085414,  1.21992749767,      440.82528487760}, 
    {     0.00000083544,  3.11243528672,      625.67019231240}, 
    {     0.00000077552,  6.24420223771,      302.16477565500}, 
    {     0.00000061557,  1.82806831206,      195.13984817330}, 
    {     0.00000061894,  4.29399030957,      127.47179660680}, 
    {     0.00000067100,  0.28960408801,        4.66586644600}, 
    {     0.00000056935,  5.01850216663,      137.03302416240}, 
    {     0.00000054018,  5.12526846805,      490.33408917940}, 
    {     0.00000054588,  0.28394184881,       74.78159856730}, 
    {     0.00000065843,  5.64781011841,        9.56122755560}, 
    {     0.00000049360,  1.44414937308,      536.80451209540}, 
    {     0.00000057790,  2.47591802875,      191.95845443560}, 
    {     0.00000044445,  2.70867717923,        5.41662597140}, 
    {     0.00000046462,  1.17725360336,      149.56319713460}, 
    {     0.00000040352,  3.88835739308,      728.76296653100}, 
    {     0.00000037766,  2.53385959344,       12.53017297220}, 
    {     0.00000046627,  5.14898441386,      515.46387109300}, 
    {     0.00000045601,  2.22651202659,      956.28915597060}, 
    {     0.00000040425,  0.41248570335,      269.92144674060}, 
    {     0.00000037318,  3.78007466606,        2.92076130680}, 
    {     0.00000033848,  3.21091304755,     1368.66025284500}, 
    {     0.00000037468,  0.63301847328,      422.66603761290}, 
    {     0.00000033013,  0.30379634705,      351.81659230870}, 
    {     0.00000030286,  2.84006878726,      203.00415469950}, 
    {     0.00000035096,  6.08465483298,        5.62907429250}, 
    {     0.00000033273,  4.64025207300,      277.03499374140}, 
    {     0.00000031908,  4.38588051077,     1155.36115740700}, 
    {     0.00000029011,  3.38845528142,     1059.38193018920}, 
    {     0.00000028659,  2.02118990830,      330.61896365820}, 
    {     0.00000029347,  5.41549054397,     1066.49547719000}, 
    {     0.00000028266,  2.74211823281,      265.98929347750}, 
    {     0.00000030064,  6.18691482959,      284.14854074220}, 
    {     0.00000031444,  2.43486054228,       52.69019803950}, 
    {     0.00000026507,  4.51149190693,      340.77089204480}, 
    {     0.00000022023,  5.14128268104,        4.19278569400}, 
    {     0.00000022201,  1.96451679625,      203.73786788240}, 
    {     0.00000021711,  2.67663515039,      942.06206196900}, 
    {     0.00000022573,  5.88439455151,      210.85141488320}, 
    {     0.00000019449,  4.76522617576,       70.84944530420}, 
    {     0.00000019260,  2.30000060917,      437.64389113990}, 
    {     0.00000019467,  6.16358069850,      860.30992875280}, 
    {     0.00000019308,  4.10055638793,       18.15924726470}, 
    {     0.00000022756,  4.13890496693,      191.20769491020}, 
    {     0.00000017772,  2.43993724475,      423.41679713830}, 
    {     0.00000017625,  1.84879760332,      234.63973644040}, 
    {     0.00000017917,  0.90281001853,      429.77958461370}, 
    {     0.00000015390,  4.23435556180,     1162.47470440780}, 
    {     0.00000014518,  3.60447992897,     1045.15483618760}, 
    {     0.00000014098,  2.94108637859,     1685.05212250160}, 
    {     0.00000016365,  4.04772986282,      949.17560896980}, 
    {     0.00000013351,  6.24525394105,       38.13303563780}, 
    {     0.00000015958,  1.06504854837,       56.62235130260}, 
    {     0.00000014066,  1.43547760486,      408.43894361130}, 
    {     0.00000015765,  5.59418374906,        6.15033915430}, 
    {     0.00000013047,  5.75713536656,      138.51749687070}, 
    {     0.00000014963,  5.77194144042,       22.09140052780}, 
    {     0.00000015910,  1.93236196007,     1272.68102562720}, 
    {     0.00000012859,  4.24850891703,      405.25754987360}, 
    {     0.00000013585,  4.09378444821,     1471.75302706360}, 
    {     0.00000015186,  0.74349230082,      200.76892246580}, 
    {     0.00000016343,  5.95883716209,      628.85158605010}, 
    {     0.00000010876,  1.54843099228,      223.59403617650}, 
    {     0.00000012178,  1.86122230918,      131.40394986990}, 
    {     0.00000011698,  1.80956732786,      124.43341522100}, 
    {     0.00000010205,  3.46772102734,     1375.77379984580}, 
    {     0.00000010113,  2.38081573177,      107.02492748170}, 
    {     0.00000009801,  2.55376042251,       99.91138048090}, 
    {     0.00000010569,  5.35748271313,      215.74677599280}, 
    {     0.00000012078,  4.84566679178,      831.85574074960}, 
    {     0.00000009282,  3.90397999336,      430.53034413910}, 
    {     0.00000010209,  6.07702154705,       32.24332891440}, 
    {     0.00000009247,  3.65397916243,      142.44965013380}, 
    {     0.00000009333,  5.81168126660,        7.16173111060}, 
    {     0.00000008973,  1.23896814586,      106.27416795630}, 
    {     0.00000009584,  1.38807709012,      145.63104387150}, 
    {     0.00000008092,  4.41109592718,      703.63318461740}, 
    {     0.00000008370,  5.64021200149,       62.25142559510}, 
    {     0.00000008365,  2.42756208502,     1258.45393162560}, 
    {     0.00000007625,  3.75230513033,      312.19908396260}, 
    {     0.00000007507,  0.52825397746,      654.12438031560}, 
    {     0.00000007222,  0.28432332038,        0.75075952540}, 
    {     0.00000008219,  6.22089296322,       14.97785352700}, 
    {     0.00000007047,  0.53162328102,      388.46515523820}, 
    {     0.00000006575,  3.48594056852,       35.42472265210}, 
    {     0.00000009019,  4.94930308863,      208.63322899200}, 
    {     0.00000006422,  3.32913886531,     1361.54670584420}, 
    {     0.00000008828,  0.08576921133,      288.08069400530}, 
    {     0.00000006468,  2.89346190385,      114.13847448250}, 
    {     0.00000006244,  0.54959845938,       65.22037101170}, 
    {     0.00000006147,  2.67701859857,     2001.44399215820}, 
    {     0.00000006729,  0.23473166872,        8.07675484730}, 
    {     0.00000007330,  4.85397668762,      222.86032299360}, 
    {     0.00000006306,  3.80609816761,     1788.14489672020}, 
    {     0.00000005794,  4.39110470067,       81.75213321620}, 
    {     0.00000006114,  0.88426580807,       92.04707395470}, 
    {     0.00000006916,  2.04730284282,       99.16062095550}, 
    {     0.00000005224,  5.49152647879,      563.63121503840}, 
    {     0.00000006227,  1.60545827612,     1589.07289528380}, 
    {     0.00000005156,  2.11913652877,      214.26230328450}, 
    {     0.00000006641,  5.82592142759,      483.22054217860}, 
    {     0.00000004960,  5.75655227165,      565.11568774670}, 
    {     0.00000004949,  0.41506756602,       76.26607127560}, 
    {     0.00000005284,  4.58064490860,      134.58534360760}, 
    {     0.00000004983,  4.20110843598,      404.50679034820}, 
    {     0.00000005143,  4.67534992519,      212.33588759150}, 
    {     0.00000004733,  4.59040852304,      554.06998748280}, 
    {     0.00000004551,  3.24564999051,      231.45834270270}, 
    {     0.00000005149,  3.33574378590,        1.48447270830}, 
    {     0.00000004646,  5.79841221351,      217.96496188400}, 
    {     0.00000004468,  0.12007438852,      295.05122865420}, 
    {     0.00000004609,  0.45274542243,      362.86229257260}, 
    {     0.00000004476,  5.37754871729,      497.44763618020}, 
    {     0.00000004962,  3.77054763448,     1265.56747862640}, 
    {     0.00000004209,  4.88259084305,       98.89998852460}, 
    {     0.00000004240,  5.00130451925,      213.34727954780}, 
    {     0.00000004739,  4.53295409208,     1148.24761040620}, 
    {     0.00000005056,  2.20279742533,      207.88246946660}, 
    {     0.00000003647,  0.55692708637,      750.10360753340}, 
    {     0.00000003590,  1.83316476388,      225.82926841020}, 
    {     0.00000003553,  0.35405996436,      333.65734504400}, 
    {     0.00000003771,  0.98541172336,       24.37902238820}, 
    {     0.00000003643,  1.61349634910,      245.54242435240}, 
    {     0.00000003416,  2.19565598832,     1574.84580128220}, 
    {     0.00000003326,  5.32536836657,      347.88443904560}, 
    {     0.00000003648,  0.80545608428,      343.21857259960}, 
    {     0.00000003230,  0.21797740452,      635.96513305090}, 
    {     0.00000004252,  1.80251333130,      213.25091132820}, 
    {     0.00000003110,  3.03951432197,     1677.93857550080}, 
    {     0.00000003692,  0.81899526461,      344.70304530790}, 
    {     0.00000003007,  3.35935547424,        7.86430652620}, 
    {     0.00000002905,  1.33932275244,      543.91805909620}, 
    {     0.00000002952,  4.87373800642,      144.14657116320}, 
    {     0.00000002765,  2.42541766183,     2317.83586181480}, 
    {     0.00000003051,  4.30989927790,     6062.66320755260}, 
    {     0.00000003636,  5.12822987131,      218.92816973050}, 
    {     0.00000002960,  3.53539509519,     2104.53676637680}, 
    {     0.00000003220,  2.88065191084,      216.21985674480}, 
    {     0.00000002890,  5.73415956875,     9992.87290377220}, 
    {     0.00000002581,  3.79872579706,       17.26547538740}, 
    {     0.00000003497,  5.29659047575,      350.33211960040}, 
    {     0.00000002852,  3.72852216251,     6076.89030155420}, 
    {     0.00000002825,  2.54354879030,     1692.16566950240}, 
    {     0.00000002775,  0.23409308831,      357.44566660120}, 
    {     0.00000002964,  2.48786690434,       46.47042291600}, 
    {     0.00000002494,  4.37756234530,      217.49188113200}, 
    {     0.00000002434,  0.74936808231,      414.06801790380}, 
    {     0.00000002711,  5.15376962514,    10007.09999777380}, 
    {     0.00000003124,  1.92045529107,       17.40848773930}, 
    {     0.00000003110,  1.71435795236,     1169.58825140860}, 
    {     0.00000002683,  3.44460235259,       31.01948863700}, 
    {     0.00000003070,  0.27064671367,      120.35824960600}, 
    {     0.00000002498,  0.89152242639,      479.28838891550}, 
    {     0.00000002239,  3.76466001926,      425.11371816770}, 
    {     0.00000002492,  2.10872471949,      168.05251279940}, 
    {     0.00000002554,  1.63237286968,      182.27960680100}, 
    {     0.00000002212,  3.15570115956,      212.77783057620}, 
    {     0.00000002345,  2.33187767722,      218.71572140940}, 
    {     0.00000002512,  4.52214797332,      198.32124191100}, 
    {     0.00000002058,  5.32848893146,      125.98732389850}, 
    {     0.00000002670,  5.76962486601,      618.55664531160}, 
    {     0.00000002501,  1.36963027063,     1905.46476494040}, 
    {     0.00000002258,  3.21639296814,      273.10284047830}, 
    {     0.00000002143,  4.82825483897,     1279.79457262800}, 
    {     0.00000002052,  1.27587061572,       14.01464568050}, 
    {     0.00000002615,  0.71070461113,       85.82729883120}, 
    {     0.00000002093,  3.39000145617,      160.60889739850}, 
    {     0.00000001983,  0.39573727330,      358.93013930950}, 
    {     0.00000002197,  5.93385162544,       13.33332212430}, 
    {     0.00000001947,  1.11697571149,      447.93883187840}, 
    {     0.00000001963,  2.32757954485,       28.45418800320}, 
    {     0.00000002225,  3.64731297942,      213.82036029980}, 
    {     0.00000001993,  1.35754866700,       20.60692781950}, 
    {     0.00000001908,  1.85043929897,        1.27202438720}, 
    {     0.00000001912,  3.44056631214,       69.15252427480}, 
    {     0.00000001924,  3.75344898408,       28.31117565130}, 
    {     0.00000002107,  2.25960904718,      116.42609634290}, 
    {     0.00000001990,  5.04917972011,      424.15051032120}, 
    {     0.00000002242,  4.24915057068,     1464.63948006280}, 
    {     0.00000001837,  5.40613525191,       31.49256938900}, 
    {     0.00000001884,  6.27237464104,       25.12978191360}, 
    {     0.00000001964,  4.88959404434,      275.55052103310}, 
    {     0.00000001761,  1.55538934409,      650.94298657790}, 
    {     0.00000002289,  4.95949808683,      258.87574647670}, 
    {     0.00000001715,  3.99957963119,      416.30325013750}, 
    {     0.00000002176,  0.00746756006,        0.89377187730}, 
    {     0.00000001909,  2.59860489663,      329.72519178090}, 
    {     0.00000001677,  0.41818851015,       54.17467074780}, 
    {     0.00000002113,  2.56576165077,       59.80374504030}, 
    {     0.00000001910,  2.42712655158,      113.38771495710}, 
    {     0.00000001599,  5.29789805696,      251.43213107580}, 
    {     0.00000001827,  5.46952748031,      842.15068148810}, 
    {     0.00000001650,  1.82771651512,      128.95626931510}, 
    {     0.00000001878,  3.51442725486,     1581.95934828300}, 
    {     0.00000001598,  1.71834334467,      129.91947716160}, 
    {     0.00000001533,  2.76924053810,     1994.33044515740}, 
    {     0.00000001688,  1.91034000476,      278.51946644970}, 
    {     0.00000001990,  5.28713202313,      508.35032409220}, 
    {     0.00000001961,  1.22898590055,      621.73803904930}, 
    {     0.00000001507,  0.54655212147,      320.32402291970}, 
    {     0.00000001683,  2.63417306973,      767.36908292080}, 
    {     0.00000001459,  2.01614186149,     1891.23767093880}, 
    {     0.00000001532,  3.27409841371,     2420.92863603340}, 
    {     0.00000001431,  0.21259204805,      643.07868005170}, 
    {     0.00000001443,  5.51283885539,     1073.60902419080}, 
    {     0.00000001331,  4.20981834774,      546.95644048200}, 
    {     0.00000001364,  4.00794878746,      721.64941953020}, 
    {     0.00000001370,  0.00435400783,     1795.25844372100}, 
    {     0.00000001548,  6.10125434827,      280.96714700450}, 
    {     0.00000001368,  2.06272463663,      192.69216761850}, 
    {     0.00000001296,  4.84837761166,       45.57665103870}, 
    {     0.00000001267,  5.28133965845,      173.94221952280}, 
    {     0.00000001401,  6.13410133967,       39.35687591520}, 
    {     0.00000001252,  2.19203979277,     2634.22773147140}, 
    {     0.00000001466,  4.16355235441,       26.82670294300}, 
    {     0.00000001285,  3.76170874847,        2.28762186040}, 
    {     0.00000001263,  3.65141438062,      264.50482076920}, 
    {     0.00000001489,  5.41027945158,      214.04985496340}, 
    {     0.00000001429,  0.71807502378,      254.94359321360}, 
    {     0.00000001181,  0.42661254361,       41.64449777560}, 
    {     0.00000001391,  2.15567541516,     2008.55753915900}, 
    {     0.00000001161,  5.23598298659,      181.05576652360}, 
    {     0.00000001538,  3.62924135993,      561.18353448360}, 
    {     0.00000001121,  1.08299011495,        6.59228213900}, 
    {     0.00000001218,  1.40812599648,      209.10630974400}, 
    {     0.00000001083,  0.27140934643,      184.09414790940}, 
    {     0.00000001345,  6.11690814301,      207.67002114550}, 
    {     0.00000001090,  4.74012700942,       78.71375183040}, 
    {     0.00000001113,  0.96578641864,      305.34616939270}, 
    {     0.00000001189,  4.76346210827,      219.44943459230}, 
    {     0.00000001202,  3.47297831356,       51.20572533120}, 
    {     0.00000001094,  1.86667293176,     1485.98012106520}, 
    {     0.00000001172,  4.19848597258,      417.03696332040}, 
    {     0.00000001067,  3.41866093436,      629.60234557550}, 
    {     0.00000001286,  2.34110191143,      210.37833413120}, 
    {     0.00000001405,  2.38547495352,      636.71589257630}, 
    {     0.00000001226,  3.94550906032,     1781.03134971940}, 
    {     0.00000001109,  4.88830425812,     1478.86657406440}, 
    {     0.00000001084,  3.68973847177,      274.06604832480}, 
    {     0.00000000991,  6.18957362221,     2111.65031337760}, 
    {     0.00000000987,  2.19659363820,      617.80588578620}, 
    {     0.00000001051,  1.05437128119,      237.67811782620}, 
    {     0.00000000988,  6.04638824298,      291.26208774300}, 
    {     0.00000001204,  1.15120847561,     2221.85663459700}, 
    {     0.00000001095,  0.87682075285,      313.21047591890}, 
    {     0.00000000932,  6.06709440285,      601.76425067620}, 
    {     0.00000001127,  5.94936507654,      196.62432088160}, 
    {     0.00000000920,  3.87350396084,      135.33610313300}, 
    {     0.00000001111,  5.24820138356,      189.72322220190}, 
    {     0.00000000980,  0.80994813332,      436.89313161450}, 
    {     0.00000000903,  2.30830859720,      312.45971639350}, 
    {     0.00000000877,  0.11036923562,      267.47376618580}, 
    {     0.00000000881,  3.67094694490,       25.27279426550}, 
    {     0.00000000903,  3.52927348588,      643.82943957710}, 
    {     0.00000000870,  2.91480922799,      211.81462272970}, 
    {     0.00000001090,  0.40467871703,      692.58748435350}, 
    {     0.00000001076,  0.14126679823,      175.16605980020}, 
    {     0.00000000933,  3.24021183740,      214.78356814630}, 
    {     0.00000000931,  4.46792395595,       77.96299230500}, 
    {     0.00000000893,  4.70654310595,      148.07872442630}, 
    {     0.00000000887,  3.36333952309,      166.82867252200}, 
    {     0.00000000855,  5.52989068704,      205.22234059070}, 
    {     0.00000000853,  1.02568311507,      491.81856188770}, 
    {     0.00000000816,  4.75099680144,      776.93031047640}, 
    {     0.00000000812,  6.11564621357,      488.84961647110}, 
    {     0.00000001128,  1.36995647618,      337.73251065900}, 
    {     0.00000000815,  6.27092737025,     1382.88734684660}, 
    {     0.00000000790,  0.89169444614,      342.25536475310}, 
    {     0.00000001076,  5.31614813327,      235.39049596580}, 
    {     0.00000000761,  2.48192692858,     2310.72231481400}, 
    {     0.00000000789,  0.05788153963,      543.02428721890}, 
    {     0.00000000752,  3.76519728356,      916.93228005540}, 
    {     0.00000000754,  5.18365928022,      244.31858407500}, 
    {     0.00000000939,  5.77229186804,      501.37978944330}, 
    {     0.00000000967,  1.31738834270,      486.40193591630}, 
    {     0.00000000790,  2.98595083986,     2737.32050569000}, 
    {     0.00000000774,  6.26950492111,      151.04766984290}, 
    {     0.00000000939,  5.48036983143,      339.28641933650}, 
    {     0.00000000710,  2.41625453577,      247.23934538180}, 
    {     0.00000000794,  2.59522645936,        1.64453140270}, 
    {     0.00000000723,  4.56009184704,      121.25202148330}, 
    {     0.00000000857,  1.99272123647,      248.72381809010}, 
    {     0.00000000683,  5.50977618441,      487.36514376280}, 
    {     0.00000000678,  6.10807510472,      867.42347575360}, 
    {     0.00000000690,  3.76660351032,     1038.04128918680}, 
    {     0.00000000761,  4.61027550357,       23.57587323610}, 
    {     0.00000000673,  5.68235998909,      319.57326339430}, 
    {     0.00000000808,  3.21312273480,     1898.35121793960}, 
    {     0.00000000715,  5.00023555936,      220.46082654860}, 
    {     0.00000000639,  5.92948462252,     2428.04218303420}, 
    {     0.00000000637,  1.86001190818,     2207.62954059540}, 
    {     0.00000000615,  2.49867623797,      444.75743814070}, 
    {     0.00000000764,  1.81804298404,     2324.94940881560}, 
    {     0.00000000672,  2.54160500837,      271.40591944890}, 
    {     0.00000000737,  1.50543762956,      268.43697403230}, 
    {     0.00000000836,  1.26618033038,      212.54833591260}, 
    {     0.00000000637,  2.20572760431,     1802.37199072180}, 
    {     0.00000000671,  4.00880206711,      425.63498302950}, 
    {     0.00000000603,  0.64742621983,      207.14875628370}, 
    {     0.00000000598,  1.51837804657,      427.56139872250}, 
    {     0.00000000596,  1.92568455140,     2950.61960112800}, 
    {     0.00000000601,  6.22126671427,      228.27694896500}, 
    {     0.00000000737,  5.27939281526,      204.70107572890}, 
    {     0.00000000720,  2.58510714719,      472.17484191470}, 
    {     0.00000000595,  4.72112782623,      380.12776796000}, 
    {     0.00000000683,  3.83223866420,       43.28902917830}, 
    {     0.00000000684,  3.66033684379,     2097.42321937600}, 
    {     0.00000000677,  4.53513985772,     5863.59120611620}, 
    {     0.00000000570,  1.18346560079,      131.54696222180}, 
    {     0.00000000731,  2.69927545658,       16.67477455640}, 
    {     0.00000000563,  6.07653636333,      241.61027108930}, 
    {     0.00000000564,  5.70013327331,      696.51963761660}, 
    {     0.00000000665,  5.96873852837,     9793.80090233580}, 
    {     0.00000000549,  4.92449367054,      188.92007304980}, 
    {     0.00000000556,  5.75593773439,      533.62311835770}, 
    {     0.00000000550,  5.49717741465,      206.23373254700}, 
    {     0.00000000556,  4.59787882758,      411.62033734900}, 
    {     0.00000000572,  5.79171128918,      195.89060769870}, 
    {     0.00000000690,  1.01867006902,      381.35160823740}, 
    {     0.00000000650,  6.28308874623,      556.51766803760}, 
    {     0.00000000584,  5.43287379445,      526.50957135690}, 
    {     0.00000000520,  2.19322568805,      180.16199464630}, 
    {     0.00000000673,  4.45121662104,      105.54045477340}, 
    {     0.00000000543,  4.19353137744,      213.18722085340}, 
    {     0.00000000592,  4.28259073720,      905.88657979150}, 
    {     0.00000000575,  3.98595915950,      140.00196957900}, 
    {     0.00000000549,  3.29327549224,      193.65537546500}, 
    {     0.00000000586,  3.03561621613,     6275.96230299060}, 
    {     0.00000000539,  0.80688137797,      458.84151979040}, 
    {     0.00000000566,  4.23028541931,      426.64637498580}, 
    {     0.00000000510,  1.10982373938,      738.79727483860}, 
    {     0.00000000590,  4.09764962186,      436.15941843160}, 
    {     0.00000000578,  5.76630812428,      963.40270297140}, 
    {     0.00000000505,  2.95732719798,      135.54855145410}, 
    {     0.00000000492,  2.71568281674,       84.93352695390}, 
    {     0.00000000474,  5.99252453125,      289.56516671360}, 
    {     0.00000000486,  5.24155754727,     5849.36411211460}, 
    {     0.00000000644,  4.91580087837,      824.74219374880}, 
    {     0.00000000567,  4.53417326513,    10206.17199921020}, 
    {     0.00000000475,  6.19959930188,      397.39324334740}, 
    {     0.00000000552,  1.46641944663,       42.53826965290}, 
    {     0.00000000447,  2.59259132013,        7.22542158540}, 
    {     0.00000000545,  0.04176014331,      221.37585028530}, 
    {     0.00000000449,  0.47070133410,      306.09692891810}, 
    {     0.00000000449,  5.79259534172,      685.47393735270}, 
    {     0.00000000497,  1.91225950427,      831.10498122420}, 
    {     0.00000000472,  5.76556319499,      570.74476203920}, 
    {     0.00000000543,  2.60337387591,      213.41097002260}, 
    {     0.00000000476,  1.86523349842,      980.66817835880}, 
    {     0.00000000525,  5.41470067852,      699.70103135430}, 
    {     0.00000000568,  0.92576336154,     2538.24850425360}, 
    {     0.00000000485,  0.61141693408,       41.05379694460}, 
    {     0.00000000434,  5.97213044475,      576.16138801060}, 
    {     0.00000000422,  4.60394612547,      710.74673161820}, 
    {     0.00000000411,  1.34966980065,       27.08733537390}, 
    {     0.00000000413,  4.83700122362,      429.04587143080}, 
    {     0.00000000408,  1.57481461411,      241.75328344120}, 
    {     0.00000000505,  2.85524554478,      327.43756992050}, 
    {     0.00000000434,  2.72438932125,     3053.71237534660}, 
    {     0.00000000424,  4.03073158555,      739.80866679490}, 
    {     0.00000000400,  5.00202145163,      431.26405732200}, 
    {     0.00000000394,  1.80181930923,      184.98791978670}, 
    {     0.00000000431,  2.02055510167,      525.75881183150}, 
    {     0.00000000456,  1.98373183360,      213.51154375910}, 
    {     0.00000000385,  5.66636299791,      519.39602435610}, 
    {     0.00000000415,  4.41614347545,      179.35884549420}, 
    {     0.00000000375,  4.64683561376,      409.92341631960}, 
    {     0.00000000389,  5.74762722112,      849.26422848890}, 
    {     0.00000000375,  5.86666869275,       19.64371997300}, 
    {     0.00000000390,  2.10901103499,      731.94436026870}, 
    {     0.00000000439,  3.38020838546,     2413.81508903260}, 
    {     0.00000000380,  2.33004090915,     2627.11418447060}, 
    {     0.00000000405,  3.15000005309,     2214.74308759620}, 
    {     0.00000000374,  0.41322198420,     9779.57380833420}, 
    {     0.00000000379,  4.79045619616,      421.93232443000}, 
    {     0.00000000381,  3.49547033281,     1354.43315884340}, 
    {     0.00000000375,  1.15376522878,      569.04784100980}, 
    {     0.00000000366,  1.36950986067,      835.03713448730}, 
    {     0.00000000456,  4.81317341975,      213.08664711690}, 
    {     0.00000000391,  0.63869657954,      206.13736432740}, 
    {     0.00000000377,  5.03922180095,      298.23262239190}, 
    {     0.00000000389,  3.23546953234,      760.25553592000}, 
    {     0.00000000361,  3.97052467541,       92.79783348010}, 
    {     0.00000000384,  0.99158031411,      282.66406803390}, 
    {     0.00000000472,  1.54703074354,      421.18156490460}, 
    {     0.00000000351,  0.67273886199,      305.08553696180}, 
    {     0.00000000386,  4.64254644028,      170.76082578510}, 
    {     0.00000000365,  6.20540615033,      181.80652604900}, 
    {     0.00000000393,  2.12942707805,      532.61172640140}, 
    {     0.00000000383,  0.05185541996,      252.65597135320}, 
    {     0.00000000467,  2.26337241837,      518.64526483070}, 
    {     0.00000000406,  2.18134488483,     2118.76386037840}, 
    {     0.00000000356,  3.19586885413,      945.99421523210}, 
    {     0.00000000361,  0.50233063987,       50.40257617910}, 
    {     0.00000000334,  5.63337650974,     2744.43405269080}, 
    {     0.00000000459,  5.37964866365,      934.94851496820}, 
    {     0.00000000378,  3.56033503151,     1119.18567522950}, 
    {     0.00000000344,  3.96892381773,      610.69233878540}, 
    {     0.00000000385,  0.47930663456,      263.70167161710}, 
    {     0.00000000324,  3.68349538825,       72.07328558160}, 
    {     0.00000000426,  3.89784222224,      525.49817940060}, 
    {     0.00000000358,  4.11241839677,       37.87240320690}, 
    {     0.00000000378,  2.02895767226,      285.63301345050}, 
    {     0.00000000319,  0.23235332054,      705.11765732570}, 
    {     0.00000000337,  4.89868242091,      898.77303279070}, 
    {     0.00000000310,  2.86499460237,      913.96333463880}, 
    {     0.00000000316,  5.77993661207,       69.36497259590}, 
    {     0.00000000357,  4.08921720644,      511.53171782990}, 
    {     0.00000000304,  4.17744815606,       73.29712585900}, 
    {     0.00000000337,  3.31563536598,      391.17346822390}, 
    {     0.00000000383,  1.51729490652,     2641.34127847220}, 
    {     0.00000000297,  5.50908719718,      702.14871190910}, 
    {     0.00000000343,  2.62919531951,      213.55972786890}, 
    {     0.00000000339,  2.60492937184,      518.38463239980}, 
    {     0.00000000291,  4.98832153464,      778.41478318470}, 
    {     0.00000000310,  1.57685156193,      259.76951835400}, 
    {     0.00000000327,  2.86020999144,      724.83081326790}, 
    {     0.00000000293,  5.71827875268,       60.76695288680}, 
    {     0.00000000323,  4.94511156125,      409.18970313670}, 
    {     0.00000000326,  1.93871115533,      480.77286162380}, 
    {     0.00000000288,  0.87763268205,      887.72733252680}, 
    {     0.00000000301,  4.30795192233,      206.70681329900}, 
    {     0.00000000380,  2.84673036576,      774.48262992160}, 
    {     0.00000000280,  1.66491233830,      405.99126305650}, 
    {     0.00000000281,  0.91462178099,      273.85360000370}, 
    {     0.00000000279,  1.76942204576,      945.24345570670}, 
    {     0.00000000331,  2.74250642576,       22.89454967990}, 
    {     0.00000000281,  5.28412046410,      403.02231763990}, 
    {     0.00000000362,  2.99550257971,      624.91943278700}, 
    {     0.00000000283,  0.67877937506,      395.57870223900}, 
    {     0.00000000329,  5.90836544487,      100.64509366380}, 
    {     0.00000000274,  1.62260137014,      681.54178408960}, 
    {     0.00000000307,  2.71913510791,      406.95447090300}, 
    {     0.00000000284,  3.66870476412,      188.02630117250}, 
    {     0.00000000319,  5.24796235885,      229.97386999440}, 
    {     0.00000000272,  2.70582939183,      953.10776223290}, 
    {     0.00000000335,  4.61515142526,      468.24268865160}, 
    {     0.00000000265,  1.55747103351,      952.35700270750}, 
    {     0.00000000265,  2.61338076723,      739.05790726950}, 
    {     0.00000000261,  4.08135671345,       25.86349509650}, 
    {     0.00000000261,  4.05948643470,      990.22940591440}, 
    {     0.00000000296,  4.49128669347,      693.55069220000}, 
    {     0.00000000259,  3.70714931093,      756.32338265690}, 
    {     0.00000000276,  3.54024051938,      319.31263096340}, 
    {     0.00000000292,  0.65370180027,    25867.49049913539}, 
    {     0.00000000292,  0.12510953311,    25881.71759313700}, 
    {     0.00000000288,  3.98602872988,      707.77778620160}, 
    {     0.00000000285,  1.92324537515,     3134.42687826260}, 
    {     0.00000000284,  2.45405555508,     3120.19978426100}, 
    {     0.00000000251,  5.49392546588,      552.58551477450}, 
    {     0.00000000249,  4.99476670690,      211.60217440860}, 
    {     0.00000000270,  2.96399363494,     2730.20695868920}, 
    {     0.00000000254,  0.93636425304,      462.02291352810}, 
    {     0.00000000258,  1.97005667122,     3267.01147078460}, 
    {     0.00000000333,  4.37215832017,      732.69511979410}, 
    {     0.00000000249,  4.40993480586,      419.53282798500}, 
    {     0.00000000240,  1.43024411751,      823.99143422340}, 
    {     0.00000000266,  2.84140918740,     2531.13495725280}, 
    {     0.00000000271,  3.45824123786,      630.33605875840}, 
    {     0.00000000306,  4.48457949210,      913.00012679230}, 
    {     0.00000000241,  1.53210253391,      662.53120356300}, 
    {     0.00000000246,  6.09302475217,      611.44309831080}, 
    {     0.00000000321,  1.11838394926,      426.55000676620}, 
    {     0.00000000287,  5.68497603085,       33.94024994380}, 
    {     0.00000000232,  5.38365779456,      815.06334611420}, 
    {     0.00000000233,  3.21618054553,      230.56457082540}, 
    {     0.00000000229,  3.80431337124,       58.10682401090}, 
    {     0.00000000230,  2.11147557890,     2943.50605412720}, 
    {     0.00000000239,  3.25558823312,      638.93407846750}, 
    {     0.00000000220,  0.95686592581,     1894.41906467650}, 
    {     0.00000000288,  5.03408953047,      714.67888488130}, 
    {     0.00000000219,  4.97799409159,      354.99798604640}, 
    {     0.00000000217,  1.68511614749,     2524.02141025200}, 
    {     0.00000000222,  3.48856424574,      212.02707105080}, 
    {     0.00000000217,  0.72166809400,      757.21715453420}, 
    {     0.00000000223,  1.92215883184,      938.12990870590}, 
    {     0.00000000217,  3.05680736768,     1130.23137549340}, 
    {     0.00000000275,  1.36259423000,      292.01284726840}, 
    {     0.00000000275,  1.22972617627,     2957.73314812880}, 
    {     0.00000000243,  1.73888991150,      432.01481684740}, 
    {     0.00000000213,  2.96147626163,       67.66805156650}, 
    {     0.00000000253,  3.09431326008,       29.20494752860}, 
    {     0.00000000244,  3.15828383212,        7.00167241620}, 
    {     0.00000000258,  3.94711896782,     1049.08698945070}, 
    {     0.00000000210,  0.92691531069,      864.24208201590}, 
    {     0.00000000216,  0.12205673729,       28.57180808220}, 
    {     0.00000000217,  4.30267078355,      637.44960575920}, 
    {     0.00000000215,  4.11358919807,      540.73666535850}, 
    {     0.00000000226,  3.91981304355,      361.37781986430}, 
    {     0.00000000206,  3.06573974753,      638.41281360570}, 
    {     0.00000000212,  2.07343849515,     1357.61455258110}, 
    {     0.00000000206,  4.76320283392,      244.79166482700}, 
    {     0.00000000215,  1.25169484126,      477.80391620720}, 
    {     0.00000000202,  0.83522072662,     1901.53261167730}, 
    {     0.00000000199,  4.85324797953,      453.42489381900}, 
    {     0.00000000207,  3.81971465476,      287.93768165340}, 
    {     0.00000000203,  2.14025039560,     5856.47765911540}, 
    {     0.00000000250,  5.24129479641,     2015.67108615980}, 
    {     0.00000000236,  4.28324419129,      432.22726516850}, 
    {     0.00000000211,  1.68715027741,      535.91074021810}, 
    {     0.00000000197,  4.71448115756,      394.35486196160}, 
    {     0.00000000195,  5.87802401359,      572.22923474750}, 
    {     0.00000000200,  4.89097544068,     5650.29211067820}, 
    {     0.00000000193,  4.20778436350,      141.69889060840}, 
    {     0.00000000235,  6.03805082386,     1044.40407666220}, 
    {     0.00000000195,  3.38080072732,      334.55111692130}, 
    {     0.00000000215,  4.89303865565,      226.04171673130}, 
    {     0.00000000195,  2.79052383726,    25448.00585526019}, 
    {     0.00000000213,  1.01587660832,      420.44785172170}, 
    {     0.00000000248,  0.66849102314,      627.36711334180}, 
    {     0.00000000195,  0.58357607695,      661.23792731640}, 
    {     0.00000000239,  1.61549656794,      484.70501488690}, 
    {     0.00000000190,  4.59542290510,      464.73122651380}, 
    {     0.00000000236,  4.74825845225,      448.68959140380}, 
    {     0.00000000197,  0.70877760895,     5268.45546294280}, 
    {     0.00000000198,  5.24830954641,      835.78789401270}, 
    {     0.00000000214,  0.49644344151,      114.39910691340}, 
    {     0.00000000200,  3.90819588718,      418.52143602870}, 
    {     0.00000000192,  3.08447389331,      219.89137757700}, 
    {     0.00000000252,  0.59577510798,      481.73606947030}, 
    {     0.00000000210,  1.47873307456,      205.43478891180}, 
    {     0.00000000197,  2.47312566093,     1041.22268292450}, 
    {     0.00000000197,  5.78596362795,     1699.27921650320}, 
    {     0.00000000229,  2.15294563190,       55.13787859430}, 
    {     0.00000000211,  5.72331015659,      465.95506679120}, 
    {     0.00000000219,  5.09141093915,       71.60020482960}, 
    {     0.00000000201,  2.71361439451,      586.31331639720}, 
    {     0.00000000207,  4.09887010479,      432.74853003030}, 
    {     0.00000000210,  0.93478002718,      551.03160609700}, 
    {     0.00000000180,  0.75887949038,      640.86049416050}, 
    {     0.00000000185,  0.06297798536,     9580.50180689780}, 
    {     0.00000000183,  0.75734481539,     4649.89881763120}, 
    {     0.00000000178,  2.54931047505,      426.07692601420}, 
    {     0.00000000183,  5.40214111593,      449.23210812500}, 
    {     0.00000000192,  5.83214375216,      212.40532356070}, 
    {     0.00000000191,  5.76589986514,      188.16931352440}, 
    {     0.00000000200,  1.17340443616,     4952.06359328620}, 
    {     0.00000000175,  3.62894671655,       62.03897727400}, 
    {     0.00000000179,  5.33862243149,      504.56118318100}, 
    {     0.00000000178,  5.46255862891,     1080.72257119160}, 
    {     0.00000000223,  3.48334535620,      827.92358748650}, 
    {     0.00000000206,  1.31950519903,      230.70758317730}, 
    {     0.00000000173,  0.34682515407,      775.23338944700}, 
    {     0.00000000203,  4.55782575605,      398.14400287280}, 
    {     0.00000000171,  5.02502465606,       93.53154666300}, 
    {     0.00000000197,  2.52828823882,      286.59622129700}, 
    {     0.00000000203,  4.46272731830,     1141.13406340540}, 
    {     0.00000000171,  1.17621965762,      439.12836384820}, 
    {     0.00000000235,  0.71854455488,     2854.64037391020}, 
    {     0.00000000170,  2.52247386072,     4230.41417375600}, 
    {     0.00000000170,  5.35148826943,     3060.82592234740}, 
    {     0.00000000171,  0.83639716225,     1165.65609814550}, 
    {     0.00000000202,  4.78048042035,     1596.18644228460}, 
    {     0.00000000168,  4.46665083242,     1251.34038462480}, 
    {     0.00000000216,  2.76419314772,      336.83873878170}, 
    {     0.00000000201,  4.40543178813,      119.76754877500}, 
    {     0.00000000177,  3.71459442547,     1056.20053645150}, 
    {     0.00000000195,  4.50146605932,      172.24529849340}, 
    {     0.00000000178,  3.30601144188,     1670.82502850000}, 
    {     0.00000000187,  0.29230663399,      420.96911658350}, 
    {     0.00000000165,  1.42862210897,      393.46109008430}, 
    {     0.00000000164,  2.21783343046,    19999.97290154599}, 
    {     0.00000000183,  3.54662980988,      639.94547042380}, 
    {     0.00000000197,  6.09329045432,      450.97721326420}, 
    {     0.00000000162,  2.04232180441,      232.94281541100}, 
    {     0.00000000162,  5.41741841020,      597.35901666110}, 
    {     0.00000000161,  5.23936155671,       98.42690777260}, 
    {     0.00000000160,  0.55319954265,     5429.87946823940}, 
    {     0.00000000178,  0.75722309082,     3171.03224356680}, 
    {     0.00000000189,  5.30587912038,     1257.70317210020}, 
    {     0.00000000183,  1.39488377050,      561.93429400900}, 
    {     0.00000000161,  2.58835334097,     1026.24482939750}, 
    {     0.00000000169,  2.39224696880,      214.57111982520}, 
    {     0.00000000160,  0.02332053390,      952.09637027660}, 
    {     0.00000000165,  5.52028556416,      238.42887735160}, 
    {     0.00000000167,  4.22204525301,      121.84272231430}, 
    {     0.00000000156,  2.23201534856,      353.30106501700}, 
    {     0.00000000155,  2.37254283146,     3067.93946934820}, 
    {     0.00000000173,  1.47028209831,       33.13710079170}, 
    {     0.00000000163,  4.38548740081,       81.89514556810}, 
    {     0.00000000165,  2.66510591872,      423.67742956920}, 
    {     0.00000000158,  0.00790966605,      107.75864066460}, 
    {     0.00000000154,  2.82175953097,      428.08266358430}, 
    {     0.00000000174,  1.28271482494,      460.53844081980}, 
    {     0.00000000154,  1.66553955952,      115.62294719080}, 
    {     0.00000000172,  5.68697470237,      364.34676528090}, 
    {     0.00000000157,  1.52766501087,      426.71006546060}, 
    {     0.00000000150,  3.14467817848,      820.05928096030}, 
    {     0.00000000152,  1.25095906759,     1261.63532536330}, 
    {     0.00000000201,  4.38127083242,      418.00017116690}, 
    {     0.00000000155,  2.82889364566,      184.84490743480}, 
    {     0.00000000170,  0.52637509428,      558.00214074590}, 
    {     0.00000000180,  4.57118365613,     1457.52593306200}, 
    {     0.00000000147,  1.04705196368,      100.17201291180}, 
    {     0.00000000146,  1.97663966745,     9360.08916445900}, 
    {     0.00000000179,  3.16621849840,      857.12853501510}, 
    {     0.00000000144,  3.54638621538,      614.62449204850}, 
    {     0.00000000148,  5.79801573208,      856.37777548970}, 
    {     0.00000000191,  6.11542019555,      606.76018552230}, 
    {     0.00000000158,  0.11592836628,      384.05992122310}, 
    {     0.00000000149,  3.60725261749,      205.66428357540}, 
    {     0.00000000187,  6.26535099398,     1037.29052966140}, 
    {     0.00000000183,  3.32728254607,     1262.38608488870}, 
    {     0.00000000164,  4.78384880793,       74.63858621540}, 
    {     0.00000000159,  1.79960566477,      326.68681039510}, 
    {     0.00000000149,  2.79221326468,      427.11945573780}, 
    {     0.00000000169,  3.44710717206,      649.45851386960}, 
    {     0.00000000159,  0.85238137539,      419.43645976540}, 
    {     0.00000000138,  1.19046476833,      422.40540518200}, 
    {     0.00000000142,  2.77065540297,     2847.52682690940}, 
    {     0.00000000163,  4.06958340535,     1372.59240610810}, 
    {     0.00000000145,  5.52904758486,      909.81873305460}, 
    {     0.00000000136,  2.18168456444,     3370.10424500320}, 
    {     0.00000000182,  2.04294180021,      429.51895218280}, 
    {     0.00000000171,  4.16864035753,      213.03846300710}, 
    {     0.00000000133,  1.27630544358,     1578.02719501990}, 
    {     0.00000000152,  0.66132933864,      494.26624244250}, 
    {     0.00000000131,  5.61666236101,      842.90144101350}, 
    {     0.00000000169,  0.34789506026,      639.84910220420}, 
    {     0.00000000173,  2.17720588116,     2435.15573003500}, 
    {     0.00000000128,  1.78174364933,      658.05653357870}, 
    {     0.00000000137,  5.11560090352,     1912.57831194120}, 
    {     0.00000000142,  0.75190926039,      594.65070367540}, 
    {     0.00000000153,  2.78684650106,      476.10699517780}, 
    {     0.00000000154,  4.94704832787,    10220.39909321180}, 
    {     0.00000000128,  5.66820405576,      225.07850888480}, 
    {     0.00000000138,  2.82615622179,     2303.60876781320}, 
    {     0.00000000132,  1.49741990377,      196.03362005060}, 
    {     0.00000000129,  4.41175966459,      433.75992198660}, 
    {     0.00000000171,  6.24909192531,     1051.51762366300}, 
    {     0.00000000160,  1.85890098130,      201.51968199120}, 
    {     0.00000000121,  5.40484928163,      502.86426215160}, 
    {     0.00000000153,  4.63947153460,      427.34895040140}, 
    {     0.00000000121,  3.74544495912,      430.79097657000}, 
    {     0.00000000120,  4.62909460174,      203.26478713040}, 
    {     0.00000000129,  3.53374989244,     1578.77795454530}, 
    {     0.00000000135,  1.43937419165,      850.01498801430}, 
    {     0.00000000137,  4.80520057291,     1570.91364801910}, 
    {     0.00000000121,  4.87948813075,      224.60542813280}, 
    {     0.00000000130,  3.34197255602,        0.52126486180}, 
    {     0.00000000119,  2.83299489060,      373.90799283650}, 
    {     0.00000000125,  4.91969530984,     1152.17976366930}, 
    {     0.00000000115,  5.04850642628,     3377.21779200400}, 
    {     0.00000000138,  4.38122571755,     1159.29331067010}, 
    {     0.00000000134,  0.37323424806,      550.13783421970}, 
    {     0.00000000113,  2.73735702901,     1276.61317889030}, 
    {     0.00000000127,  2.13685901715,     2751.54759969160}, 
    {     0.00000000153,  3.56452485886,     1688.98427576470}, 
    {     0.00000000141,  2.84269332500,      223.33340374560}, 
    {     0.00000000135,  2.18590537692,     3259.89792378380}, 
    {     0.00000000139,  0.66224045852,      425.84743135060}, 
    {     0.00000000123,  4.98137061996,     1286.90811962880}, 
    {     0.00000000110,  1.95470890132,     3686.49611465980}, 
    {     0.00000000141,  4.08645824679,      765.88461021250}, 
    {     0.00000000107,  2.27167812704,     1474.93442080130}, 
    {     0.00000000107,  0.67574920664,      214.52293571540}, 
    {     0.00000000108,  4.14668671928,      402.21916848780}, 
    {     0.00000000109,  0.60965715164,      227.31374111850}, 
    {     0.00000000123,  4.75563063820,     1055.44977692610}, 
    {     0.00000000116,  4.48344664917,     1773.91780271860}, 
    {     0.00000000107,  2.40194959139,      162.09337010680}, 
    {     0.00000000114,  0.31513063843,     1089.12939443900}, 
    {     0.00000000107,  2.78085038171,     1144.31545714310}, 
    {     0.00000000107,  1.45794674623,      212.07525516060}, 
    {     0.00000000117,  3.32755679932,      568.29708148440}, 
    {     0.00000000105,  0.77526801011,     4546.80604341260}, 
    {     0.00000000104,  5.58638472767,      258.54567807660}, 
    {     0.00000000103,  0.00011902774,     1250.58962509940}, 
    {     0.00000000124,  0.75407666346,     1403.33421597170}, 
    {     0.00000000116,  5.58340550636,     4120.20785253660}, 
    {     0.00000000105,  5.65016987846,      299.12639426920}, 
    {     0.00000000107,  5.21539682701,      214.19286731530}, 
    {     0.00000000104,  4.49107029871,     1379.70595310890}, 
    {     0.00000000122,  4.67678900588,      199.28444975750}, 
    {     0.00000000105,  2.31569581172,      200.55647414470}, 
    {     0.00000000105,  4.46551837753,      216.00740842370}, 
    {     0.00000000099,  2.99447140993,       96.87299909510}, 
    {     0.00000000118,  4.76736796759,     1884.12412393800}, 
    {     0.00000000097,  4.51150496941,        0.04818410980}, 
    {     0.00000000102,  1.14650803737,     1268.74887236410}, 
    {     0.00000000124,  5.36175829995,     2004.62538589590}, 
    {     0.00000000113,  2.10434715032,      976.73602509570}, 
    {     0.00000000099,  2.06115127438,      210.59078245230}, 
    {     0.00000000102,  0.14631144439,      650.19222705250}, 
    {     0.00000000096,  4.50945686426,      991.71387862270}, 
    {     0.00000000121,  0.53237694918,      838.21852822500}, 
    {     0.00000000111,  3.17587281166,     1987.21689815660}, 
    {     0.00000000113,  0.65690102007,      369.97583957340}, 
    {     0.00000000097,  5.08571198619,      153.49535039770}, 
    {     0.00000000095,  4.10494845439,    10213.28554621100}, 
    {     0.00000000109,  4.59330410482,     1471.00226753820}, 
    {     0.00000000098,  1.97227067133,      555.55446019110}, 
    {     0.00000000099,  3.74114595447,      619.29035849450}, 
    {     0.00000000093,  1.81950573050,     1523.69246557770}, 
    {     0.00000000105,  5.49083925380,      501.23677709140}, 
    {     0.00000000092,  1.24014873712,     1123.11782849260}, 
    {     0.00000000113,  1.72036934079,      220.36445832900}, 
    {     0.00000000091,  0.17221579825,     1097.09427470170}, 
    {     0.00000000098,  1.79805037973,     1254.52177836250}, 
    {     0.00000000112,  4.45867298294,      763.43692965770}, 
    {     0.00000000091,  3.20001937333,      962.50893109410}, 
    {     0.00000000094,  2.86714047622,      548.44091319030}, 
    {     0.00000000101,  3.07892909093,      725.58157279330}, 
    {     0.00000000115,  3.37491688156,      313.94418910180}, 
    {     0.00000000089,  4.83279938124,      657.16276170140}, 
    {     0.00000000106,  3.73569157743,      220.93390730060}, 
    {     0.00000000088,  4.81404995864,      670.49608382570}, 
    {     0.00000000093,  2.11909409613,      731.68372783780}, 
    {     0.00000000091,  2.84990081277,     1158.54255114470}, 
    {     0.00000000088,  5.43215955591,      894.84087952760}, 
    {     0.00000000109,  0.99369307649,       49.50880430180}, 
    {     0.00000000088,  4.57978939179,     3590.51688744200}, 
    {     0.00000000090,  6.22046531228,      206.93630796260}, 
    {     0.00000000089,  1.38380314332,     2431.97433629730}, 
    {     0.00000000089,  0.85422789927,      885.43971066640}, 
    {     0.00000000092,  1.70846492069,     4525.46540241020}, 
    {     0.00000000088,  4.19065380742,    20426.57109242200}, 
    {     0.00000000103,  5.09211864667,      213.45915413240}, 
    {     0.00000000114,  4.77634498556,     2332.06295581640}, 
    {     0.00000000090,  5.94905546946,      434.67494572330}, 
    {     0.00000000085,  6.00473791340,     1997.51183889510}, 
    {     0.00000000093,  4.74694917061,    25874.60404613620}, 
    {     0.00000000088,  3.93572406470,      924.04582705620}, 
    {     0.00000000085,  2.23193157611,     4223.30062675520}, 
    {     0.00000000097,  5.28832295436,      226.63241756230}, 
    {     0.00000000090,  2.77655931107,      355.74874557180}, 
    {     0.00000000087,  2.86761196300,     2005.37614542130}, 
    {     0.00000000101,  5.96125293373,      140.96517742550}, 
    {     0.00000000103,  1.70664595857,      213.13903674360}, 
    {     0.00000000086,  5.87484967593,     5636.06501667660}, 
    {     0.00000000081,  3.27163515580,      392.65794093220}, 
    {     0.00000000110,  2.15873993795,        0.96320784650}, 
    {     0.00000000091,  4.18922453316,      714.53587252940}, 
    {     0.00000000084,  0.82519318544,      875.83029900100}, 
    {     0.00000000090,  1.61216801859,      219.66188291340}, 
    {     0.00000000083,  0.51126636938,      366.04368631030}, 
    {     0.00000000095,  3.18236269647,      401.32539661050}, 
    {     0.00000000080,  0.86894269984,      233.90602325750}, 
    {     0.00000000079,  1.86255607416,     1371.84164658270}, 
    {     0.00000000088,  3.90599024940,     1030.92774218600}, 
    {     0.00000000099,  3.26868558102,      988.53248488500}, 
    {     0.00000000084,  6.03336793666,      199.96577331370}, 
    {     0.00000000090,  2.82003299044,     4841.85727206680}, 
    {     0.00000000084,  2.92855920153,      700.45179087970}, 
    {     0.00000000103,  5.93497932729,     3384.33133900480}, 
    {     0.00000000078,  5.48349540273,     1166.40685767090}, 
    {     0.00000000094,  2.30477326334,     4443.71326919400}, 
    {     0.00000000081,  4.94647597211,      746.92221379570}, 
    {     0.00000000084,  2.56214102684,      960.22130923370}, 
    {     0.00000000082,  0.04782722111,      608.87779767700}, 
    {     0.00000000082,  5.83227223542,      769.81676347560}, 
    {     0.00000000082,  0.85049036010,     2228.97018159780}, 
    {     0.00000000096,  4.26079753884,      562.14674233010}, 
    {     0.00000000085,  5.60454891423,      177.87437278590}, 
    {     0.00000000080,  2.70295280428,     1706.39276350400}, 
    {     0.00000000080,  2.38017647755,     3156.80514956520}, 
    {     0.00000000077,  0.86072619300,      599.64663852150}, 
    {     0.00000000087,  3.23866124089,     9786.68735533500}, 
    {     0.00000000077,  4.92131979643,      628.59095361920}, 
    {     0.00000000086,  1.60736733611,     1048.33622992530}, 
    {     0.00000000078,  5.37725237047,      155.19227142710}, 
    {     0.00000000099,  4.60217992901,     1493.09366806600}, 
    {     0.00000000075,  1.58021212251,     2115.58246664070}, 
    {     0.00000000077,  5.31973680960,      700.66423920080}, 
    {     0.00000000074,  0.97806259478,      455.05237887920}, 
    {     0.00000000099,  0.79638071608,     4017.11507831800}, 
    {     0.00000000078,  3.39406953094,      106.01353552540}, 
    {     0.00000000073,  4.04232842619,      907.37105249980}, 
    {     0.00000000078,  3.51704454140,      969.62247809490}, 
    {     0.00000000074,  3.12025543151,      201.99276274320}, 
    {     0.00000000088,  1.09928677784,     1246.65747183630}, 
    {     0.00000000078,  5.49208074374,      477.00076705510}, 
    {     0.00000000079,  2.75804430794,      847.04604259770}, 
};


static const struct ln_vsop saturn_longitude_l2[LONG_L2] = {
    {     0.00116441330,  1.17988132879,        7.11354700080}, 
    {     0.00091841837,  0.07325195840,      213.29909543800}, 
    {     0.00036661728,  0.00000000000,        0.00000000000}, 
    {     0.00015274496,  4.06493179167,      206.18554843720}, 
    {     0.00010987259,  5.44479188310,      426.59819087600}, 
    {     0.00010629830,  0.25764306189,      220.41264243880}, 
    {     0.00004265404,  1.04596041482,       14.22709400160}, 
    {     0.00001215447,  2.91866579609,      103.09277421860}, 
    {     0.00001142595,  4.63711665368,      639.89728631400}, 
    {     0.00001061494,  5.68896768215,      433.71173787680}, 
    {     0.00001020102,  0.63368457250,        3.18139373770}, 
    {     0.00001044759,  4.04202827818,      199.07200143640}, 
    {     0.00000648857,  4.33990455509,      419.48464387520}, 
    {     0.00000549320,  5.57301151406,        3.93215326310}, 
    {     0.00000456767,  1.26896848480,      110.20632121940}, 
    {     0.00000424918,  0.20908786519,      227.52618943960}, 
    {     0.00000273782,  4.28857061190,       95.97922721780}, 
    {     0.00000161533,  1.38145587317,       11.04570026390}, 
    {     0.00000129502,  1.56592444783,      309.27832265580}, 
    {     0.00000108829,  3.89769392463,      853.19638175200}, 
    {     0.00000100917,  0.89243113369,       21.34064100240}, 
    {     0.00000100710,  4.89713543344,      647.01083331480}, 
    {     0.00000095154,  5.62447011514,      412.37109687440}, 
    {     0.00000081962,  1.02414352999,      117.31986822020}, 
    {     0.00000074860,  4.76187112999,      210.11770170030}, 
    {     0.00000082667,  6.05014465562,      216.48048917570}, 
    {     0.00000095500,  2.91469950689,      316.39186965660}, 
    {     0.00000064191,  0.35066202401,      323.50541665740}, 
    {     0.00000084889,  5.73495539065,      209.36694217490}, 
    {     0.00000066442,  0.48307559227,       10.29494073850}, 
    {     0.00000067164,  0.45592762644,      522.57741809380}, 
    {     0.00000053849,  2.71027004601,      529.69096509460}, 
    {     0.00000052073,  4.77422682479,      632.78373931320}, 
    {     0.00000044991,  5.69247085773,      440.82528487760}, 
    {     0.00000045297,  1.66820818508,      202.25339517410}, 
    {     0.00000042349,  5.70774454577,       88.86568021700}, 
    {     0.00000032050,  0.06977561095,       63.73589830340}, 
    {     0.00000031531,  1.67269081492,      302.16477565500}, 
    {     0.00000031160,  4.16289690897,      191.95845443560}, 
    {     0.00000024709,  5.65552005153,      735.87651353180}, 
    {     0.00000026540,  0.82957323703,      224.34479570190}, 
    {     0.00000020111,  5.94400958785,      217.23124870110}, 
    {     0.00000017562,  4.90127107888,      625.67019231240}, 
    {     0.00000017423,  1.62944882745,      742.99006053260}, 
    {     0.00000013745,  3.76551606198,      195.13984817330}, 
    {     0.00000012239,  4.71655885093,      203.00415469950}, 
    {     0.00000011865,  0.12658169661,      234.63973644040}, 
    {     0.00000015992,  0.58010406176,      515.46387109300}, 
    {     0.00000012178,  3.02991813349,      846.08283475120}, 
    {     0.00000011013,  5.91647084481,      536.80451209540}, 
    {     0.00000013971,  0.20726957441,      838.96928775040}, 
    {     0.00000010983,  5.61246766042,      728.76296653100}, 
    {     0.00000009950,  0.24994105562,      330.61896365820}, 
    {     0.00000009192,  4.15737094186,      860.30992875280}, 
    {     0.00000009424,  3.21424196104,     1066.49547719000}, 
    {     0.00000009432,  0.46528491211,      956.28915597060}, 
    {     0.00000010125,  4.98323117202,      422.66603761290}, 
    {     0.00000008282,  2.14237248360,      269.92144674060}, 
    {     0.00000007182,  5.40492160991,     1052.26838318840}, 
    {     0.00000007530,  5.24653553801,      429.77958461370}, 
    {     0.00000006339,  4.46236888166,      284.14854074220}, 
    {     0.00000005962,  5.41494016179,      149.56319713460}, 
    {     0.00000007482,  4.02606821044,        9.56122755560}, 
    {     0.00000005720,  4.26530477198,      415.55249061210}, 
    {     0.00000006049,  5.93261878105,      405.25754987360}, 
    {     0.00000005707,  0.01088469960,      124.43341522100}, 
    {     0.00000004736,  2.27408430395,       18.15924726470}, 
    {     0.00000005605,  6.02186673660,      223.59403617650}, 
    {     0.00000004492,  4.93190106788,      654.12438031560}, 
    {     0.00000004572,  4.41905037462,      942.06206196900}, 
    {     0.00000005619,  0.29640581964,      127.47179660680}, 
    {     0.00000005427,  5.54628097641,      949.17560896980}, 
    {     0.00000004050,  4.70655233568,       74.78159856730}, 
    {     0.00000004983,  3.20538998582,      277.03499374140}, 
    {     0.00000004231,  2.89079464814,       56.62235130260}, 
    {     0.00000004064,  5.30594179929,     1045.15483618760}, 
    {     0.00000003949,  3.30804079830,      490.33408917940}, 
    {     0.00000003966,  6.12786433144,       81.75213321620}, 
    {     0.00000003740,  4.93207109771,       52.69019803950}, 
    {     0.00000004556,  6.13297205287,     1155.36115740700}, 
    {     0.00000003710,  0.40358664974,      137.03302416240}, 
    {     0.00000003405,  4.28369409738,       99.91138048090}, 
    {     0.00000003385,  1.58207215076,     1059.38193018920}, 
    {     0.00000003946,  0.36427920856,       12.53017297220}, 
    {     0.00000004075,  0.29371909541,      831.85574074960}, 
    {     0.00000003337,  0.22680009908,     1272.68102562720}, 
    {     0.00000003645,  0.15608090085,      437.64389113990}, 
    {     0.00000002882,  3.16980253835,       70.84944530420}, 
    {     0.00000002820,  0.32685718956,      191.20769491020}, 
    {     0.00000002675,  1.87525173150,      295.05122865420}, 
    {     0.00000003593,  4.72358358604,      423.41679713830}, 
    {     0.00000002692,  3.59467219768,      131.40394986990}, 
    {     0.00000002611,  5.15121377007,     1368.66025284500}, 
    {     0.00000002439,  3.90853469376,      210.85141488320}, 
    {     0.00000002460,  1.58503027010,       32.24332891440}, 
    {     0.00000002370,  4.74096554852,      351.81659230870}, 
    {     0.00000002444,  5.81456271395,      106.27416795630}, 
    {     0.00000002213,  2.05928438838,     6076.89030155420}, 
    {     0.00000002206,  5.98426401448,     6062.66320755260}, 
    {     0.00000002163,  5.95837514288,      145.63104387150}, 
    {     0.00000002748,  3.38304528348,      408.43894361130}, 
    {     0.00000002284,  3.14006785569,       22.09140052780}, 
    {     0.00000002089,  3.48276343851,    10007.09999777380}, 
    {     0.00000002078,  1.12426049665,     9992.87290377220}, 
    {     0.00000002575,  5.11506203019,      265.98929347750}, 
    {     0.00000001810,  5.03261959505,     1361.54670584420}, 
    {     0.00000001751,  4.12209032177,      107.02492748170}, 
    {     0.00000001757,  4.17277201762,     1258.45393162560}, 
    {     0.00000001917,  4.52092673239,      138.51749687070}, 
    {     0.00000001660,  1.36759705430,      231.45834270270}, 
    {     0.00000001629,  3.76846556637,      628.85158605010}, 
    {     0.00000002073,  5.24889328333,     1265.56747862640}, 
    {     0.00000001908,  5.87241184631,     1471.75302706360}, 
    {     0.00000001491,  0.47137450159,      340.77089204480}, 
    {     0.00000001469,  5.63066479682,      447.93883187840}, 
    {     0.00000001368,  2.90191179360,      215.74677599280}, 
    {     0.00000001387,  5.85935596482,      430.53034413910}, 
    {     0.00000001722,  6.23117770604,     1148.24761040620}, 
    {     0.00000001303,  0.59972315177,       28.45418800320}, 
    {     0.00000001190,  2.83055605436,      200.76892246580}, 
    {     0.00000001266,  5.78318939698,      543.91805909620}, 
    {     0.00000001159,  3.52473802224,      497.44763618020}, 
    {     0.00000001433,  0.85149270762,     6069.77675455340}, 
    {     0.00000001244,  0.03107328684,     1589.07289528380}, 
    {     0.00000001091,  4.96912261840,     1685.05212250160}, 
    {     0.00000000993,  1.59950662100,     1375.77379984580}, 
    {     0.00000001342,  2.27535909191,     9999.98645077300}, 
    {     0.00000001164,  0.71458004021,      508.35032409220}, 
    {     0.00000001054,  1.40406602585,      483.22054217860}, 
    {     0.00000001108,  1.19549464972,      618.55664531160}, 
    {     0.00000000959,  4.22880834220,      288.08069400530}, 
    {     0.00000001031,  1.08925635580,      184.84490743480}, 
    {     0.00000000926,  2.59820818098,      134.58534360760}, 
    {     0.00000000934,  2.43391814989,      222.86032299360}, 
    {     0.00000000935,  2.65004321100,     1279.79457262800}, 
    {     0.00000000932,  2.47823744049,      703.63318461740}, 
    {     0.00000000894,  4.52571251065,       38.13303563780}, 
    {     0.00000000889,  2.26537788507,     1162.47470440780}, 
    {     0.00000001026,  4.88481004083,      750.10360753340}, 
    {     0.00000000861,  4.72556919318,      362.86229257260}, 
    {     0.00000000987,  4.55508044870,      635.96513305090}, 
    {     0.00000000817,  4.78613243939,     1677.93857550080}, 
    {     0.00000000838,  2.22382688806,      333.65734504400}, 
    {     0.00000000818,  5.77611891155,      416.30325013750}, 
    {     0.00000000770,  3.43128784800,     1073.60902419080}, 
    {     0.00000000775,  2.51136824078,      343.21857259960}, 
    {     0.00000000734,  2.35308297796,      120.35824960600}, 
    {     0.00000000882,  5.59382134246,     1788.14489672020}, 
    {     0.00000000718,  3.92701610563,     1574.84580128220}, 
    {     0.00000000728,  4.85632864351,       76.26607127560}, 
    {     0.00000000696,  3.68169796191,      347.88443904560}, 
    {     0.00000000683,  3.73251938537,      203.73786788240}, 
    {     0.00000000668,  2.85405845694,       92.04707395470}, 
    {     0.00000000846,  5.00619971250,     1581.95934828300}, 
    {     0.00000000714,  5.73513429762,      721.64941953020}, 
    {     0.00000000697,  0.20687083504,       99.16062095550}, 
    {     0.00000000675,  5.62875135263,       17.26547538740}, 
    {     0.00000000838,  5.97145881711,     1464.63948006280}, 
    {     0.00000000641,  0.67589597459,       46.47042291600}, 
    {     0.00000000634,  4.84360016292,      357.44566660120}, 
    {     0.00000000813,  0.65010530865,      113.38771495710}, 
    {     0.00000000779,  0.04397099012,     1169.58825140860}, 
    {     0.00000000654,  5.89612648687,      337.73251065900}, 
    {     0.00000000543,  5.07477971244,      388.46515523820}, 
    {     0.00000000534,  1.21443390921,       62.25142559510}, 
    {     0.00000000530,  5.45074206690,      312.19908396260}, 
    {     0.00000000524,  4.84778928724,      358.93013930950}, 
    {     0.00000000524,  1.53836680827,      195.89060769870}, 
    {     0.00000000598,  0.90807361549,     1692.16566950240}, 
    {     0.00000000521,  3.69000991897,      217.96496188400}, 
    {     0.00000000661,  4.49401694007,      643.07868005170}, 
    {     0.00000000537,  6.17024172829,      182.27960680100}, 
    {     0.00000000539,  0.29923807305,       98.89998852460}, 
    {     0.00000000504,  3.80940628684,      168.05251279940}, 
    {     0.00000000489,  1.08047606868,     5856.47765911540}, 
    {     0.00000000570,  3.22538390359,      208.63322899200}, 
    {     0.00000000542,  6.00891355828,     1905.46476494040}, 
    {     0.00000000468,  2.50179341284,     9786.68735533500}, 
    {     0.00000000478,  4.69534368607,     2001.44399215820}, 
    {     0.00000000468,  0.69718202430,      258.87574647670}, 
    {     0.00000000456,  3.18302424015,      218.92816973050}, 
    {     0.00000000542,  0.56755755204,      404.50679034820}, 
    {     0.00000000418,  4.81455000162,      636.71589257630}, 
    {     0.00000000405,  3.79642493875,       24.37902238820}, 
    {     0.00000000428,  0.98881943857,      160.60889739850}, 
    {     0.00000000395,  3.50540272263,      129.91947716160}, 
    {     0.00000000491,  5.25616442245,      436.89313161450}, 
    {     0.00000000395,  0.63866561227,     5849.36411211460}, 
    {     0.00000000401,  3.91645377349,      565.11568774670}, 
    {     0.00000000385,  3.66039075343,      563.63121503840}, 
    {     0.00000000385,  4.21962510029,      867.42347575360}, 
    {     0.00000000395,  0.79256328399,      767.36908292080}, 
    {     0.00000000397,  1.47228787593,      273.10284047830}, 
    {     0.00000000407,  5.47101735998,     1038.04128918680}, 
    {     0.00000000450,  2.16827084832,      561.18353448360}, 
    {     0.00000000371,  2.92289280832,      212.33588759150}, 
    {     0.00000000471,  0.67355945445,      207.88246946660}, 
    {     0.00000000494,  3.69576582281,      350.33211960040}, 
    {     0.00000000445,  2.54960078264,      313.21047591890}, 
    {     0.00000000430,  5.32368128659,     2104.53676637680}, 
    {     0.00000000360,  0.37557163523,      214.26230328450}, 
    {     0.00000000346,  1.06976563801,      114.13847448250}, 
    {     0.00000000374,  3.12722101473,      621.73803904930}, 
    {     0.00000000349,  1.34436318123,      554.06998748280}, 
    {     0.00000000423,  5.71328898571,      225.82926841020}, 
    {     0.00000000430,  2.66387237515,       77.96299230500}, 
    {     0.00000000380,  5.56440978604,      131.54696222180}, 
    {     0.00000000370,  4.71794670577,     1994.33044515740}, 
    {     0.00000000336,  5.22381691731,      142.44965013380}, 
    {     0.00000000451,  5.70353371091,     1781.03134971940}, 
    {     0.00000000341,  5.92928351979,       26.82670294300}, 
    {     0.00000000413,  5.25442167600,       85.82729883120}, 
    {     0.00000000308,  3.68245311562,     1891.23767093880}, 
    {     0.00000000307,  0.83912741778,     6283.07584999140}, 
    {     0.00000000310,  1.98294407285,     9779.57380833420}, 
    {     0.00000000307,  2.20383229267,    10213.28554621100}, 
    {     0.00000000325,  0.64360996757,       45.57665103870}, 
    {     0.00000000394,  5.76677470794,       39.35687591520}, 
    {     0.00000000330,  5.27653526017,      629.60234557550}, 
    {     0.00000000299,  1.88775208899,     1493.09366806600}, 
    {     0.00000000352,  4.48509640628,     1898.35121793960}, 
    {     0.00000000281,  3.16317079558,      424.15051032120}, 
    {     0.00000000316,  4.97188239617,      757.21715453420}, 
    {     0.00000000287,  0.97698684717,      685.47393735270}, 
    {     0.00000000276,  6.25944561110,      241.75328344120}, 
    {     0.00000000275,  0.90501179953,      245.54242435240}, 
    {     0.00000000300,  0.68979920030,     2008.55753915900}, 
    {     0.00000000295,  3.39770460737,      699.70103135430}, 
    {     0.00000000279,  4.56569473908,      291.26208774300}, 
    {     0.00000000270,  4.56602256237,     1382.88734684660}, 
    {     0.00000000281,  4.02513980273,      472.17484191470}, 
    {     0.00000000351,  2.51708328514,      344.70304530790}, 
    {     0.00000000249,  5.83224046008,      546.95644048200}, 
    {     0.00000000298,  0.40245622540,      824.74219374880}, 
    {     0.00000000253,  1.80130756456,     5643.17856367740}, 
    {     0.00000000255,  1.70309731649,      916.93228005540}, 
    {     0.00000000240,  1.92537411069,      432.22726516850}, 
    {     0.00000000231,  1.13100606986,      519.39602435610}, 
    {     0.00000000257,  3.06004165978,      778.41478318470}, 
    {     0.00000000235,  5.36973988104,      426.55000676620}, 
    {     0.00000000237,  3.37687225050,     1055.44977692610}, 
    {     0.00000000235,  3.22448277667,     9573.38825989700}, 
    {     0.00000000226,  3.88426552477,      576.16138801060}, 
    {     0.00000000222,  3.93659042060,      319.57326339430}, 
    {     0.00000000298,  6.14531746207,      421.18156490460}, 
    {     0.00000000219,  5.77768418505,       92.79783348010}, 
    {     0.00000000301,  5.93880232828,      486.40193591630}, 
    {     0.00000000250,  3.12140604420,      144.14657116320}, 
    {     0.00000000259,  5.84103167814,      650.94298657790}, 
    {     0.00000000268,  5.02934715041,     6275.96230299060}, 
    {     0.00000000250,  3.40150002263,      842.15068148810}, 
    {     0.00000000247,  1.67833021022,      696.51963761660}, 
    {     0.00000000224,  4.81984414234,      945.99421523210}, 
    {     0.00000000269,  5.94851586836,      230.70758317730}, 
    {     0.00000000256,  3.78687318805,      963.40270297140}, 
    {     0.00000000238,  2.37468752028,      306.09692891810}, 
    {     0.00000000211,  0.95998214239,      526.50957135690}, 
    {     0.00000000211,  2.91633331348,     1596.18644228460}, 
    {     0.00000000202,  0.40419643612,      479.28838891550}, 
    {     0.00000000201,  4.15907677541,      572.22923474750}, 
    {     0.00000000218,  2.66042692356,      776.93031047640}, 
    {     0.00000000198,  1.98905153495,      425.63498302950}, 
    {     0.00000000204,  0.88373842674,       31.49256938900}, 
    {     0.00000000197,  2.81822588165,     1286.90811962880}, 
    {     0.00000000196,  2.21181034487,       65.22037101170}, 
    {     0.00000000260,  0.63239909077,      934.94851496820}, 
    {     0.00000000222,  3.92299544057,      289.56516671360}, 
    {     0.00000000192,  5.13699333789,      329.72519178090}, 
    {     0.00000000206,  2.28201140383,      421.93232443000}, 
    {     0.00000000225,  4.85845144987,      116.42609634290}, 
    {     0.00000000236,  5.80481391592,     2221.85663459700}, 
    {     0.00000000197,  4.07875793212,      252.65597135320}, 
    {     0.00000000215,  6.03854865322,     3700.72320866140}, 
    {     0.00000000250,  3.75929924932,     4002.88798431640}, 
    {     0.00000000190,  2.06061340112,      425.11371816770}, 
    {     0.00000000230,  4.58718822052,     2310.72231481400}, 
    {     0.00000000208,  3.08549771485,       41.64449777560}, 
    {     0.00000000202,  3.49000077242,      417.03696332040}, 
    {     0.00000000204,  1.76041711688,      556.51766803760}, 
    {     0.00000000237,  5.80077673064,     1049.08698945070}, 
    {     0.00000000191,  4.75409244295,      953.10776223290}, 
    {     0.00000000185,  0.13733419547,      188.02630117250}, 
    {     0.00000000197,  4.34756838460,      518.38463239980}, 
    {     0.00000000183,  2.73162234448,      710.74673161820}, 
    {     0.00000000195,  5.58380753596,      610.69233878540}, 
    {     0.00000000182,  2.35670801192,      273.85360000370}, 
    {     0.00000000227,  0.10075592589,     1141.13406340540}, 
    {     0.00000000186,  5.88991186489,      842.90144101350}, 
    {     0.00000000181,  1.84005459910,     3281.23856478620}, 
    {     0.00000000204,  4.63761086650,     2730.20695868920}, 
    {     0.00000000219,  0.20858177566,      398.14400287280}, 
    {     0.00000000178,  4.36336156447,     1262.38608488870}, 
    {     0.00000000234,  5.41547130725,     2840.41327990860}, 
    {     0.00000000179,  2.71915583308,      823.99143422340}, 
    {     0.00000000179,  6.16908116316,      429.51895218280}, 
    {     0.00000000221,  4.67090997536,     2317.83586181480}, 
    {     0.00000000218,  4.48655129162,     2214.74308759620}, 
    {     0.00000000178,  4.73985898920,       84.93352695390}, 
    {     0.00000000219,  5.88231558225,      739.80866679490}, 
    {     0.00000000212,  3.55778109357,     3899.79521009780}, 
    {     0.00000000175,  3.98733824496,      181.05576652360}, 
    {     0.00000000170,  3.48655578504,      501.37978944330}, 
    {     0.00000000190,  5.08820154691,      838.21852822500}, 
    {     0.00000000168,  4.17824892556,      601.76425067620}, 
    {     0.00000000186,  6.27969083232,     3384.33133900480}, 
    {     0.00000000170,  4.04307080504,     2627.11418447060}, 
    {     0.00000000210,  6.24922487858,      312.45971639350}, 
    {     0.00000000161,  0.65418381232,      427.11945573780}, 
    {     0.00000000175,  5.76796435765,      427.56139872250}, 
    {     0.00000000170,  4.19634927387,      570.74476203920}, 
    {     0.00000000183,  5.30941051861,     1354.43315884340}, 
    {     0.00000000194,  4.72715532688,     2723.09341168840}, 
    {     0.00000000159,  2.54013792041,      156.67674413540}, 
    {     0.00000000183,  5.05394949061,     1670.82502850000}, 
    {     0.00000000192,  5.30444951399,     2097.42321937600}, 
    {     0.00000000154,  1.43624792504,      238.57188970350}, 
    {     0.00000000166,  4.87871165187,      207.14875628370}, 
    {     0.00000000161,  2.29074640137,      429.04587143080}, 
    {     0.00000000161,  3.10589263843,      381.35160823740}, 
    {     0.00000000193,  6.19289037233,     1485.98012106520}, 
    {     0.00000000148,  3.78227154874,      220.46082654860}, 
    {     0.00000000155,  2.71042195871,     5863.59120611620}, 
    {     0.00000000148,  5.81240331182,      432.01481684740}, 
    {     0.00000000168,  0.85973603244,      216.21985674480}, 
    {     0.00000000147,  2.98831696580,      431.26405732200}, 
    {     0.00000000153,  1.97960511891,       41.05379694460}, 
    {     0.00000000156,  1.78885164774,      905.88657979150}, 
    {     0.00000000144,  0.23243678012,       59.80374504030}, 
    {     0.00000000176,  5.85076256980,     2538.24850425360}, 
    {     0.00000000153,  4.17220193633,     9793.80090233580}, 
    {     0.00000000139,  1.88602485832,      334.55111692130}, 
    {     0.00000000138,  3.86227960029,      305.34616939270}, 
    {     0.00000000146,  6.22852846698,     1795.25844372100}, 
    {     0.00000000143,  3.54423986926,      251.43213107580}, 
    {     0.00000000183,  3.75243223047,      856.37777548970}, 
    {     0.00000000193,  5.96350046980,      732.69511979410}, 
    {     0.00000000144,  0.80418666244,      128.36556848410}, 
    {     0.00000000140,  0.96566780880,      298.23262239190}, 
    {     0.00000000157,  5.60834759134,      551.03160609700}, 
    {     0.00000000131,  1.93665169948,      436.15941843160}, 
    {     0.00000000140,  0.93212776526,      624.91943278700}, 
    {     0.00000000166,  5.70521578740,      643.82943957710}, 
    {     0.00000000142,  4.28104505116,     3046.59882834580}, 
    {     0.00000000133,  0.06539503690,      218.71572140940}, 
    {     0.00000000136,  2.81474654925,     3473.19701922180}, 
    {     0.00000000150,  0.04573957934,      213.25091132820}, 
    {     0.00000000150,  3.24352648336,      213.34727954780}, 
    {     0.00000000124,  0.09580718084,      945.24345570670}, 
    {     0.00000000133,  0.94022058895,     1478.86657406440}, 
    {     0.00000000125,  4.94887245998,      661.23792731640}, 
    {     0.00000000124,  2.97015258114,      692.58748435350}, 
    {     0.00000000126,  1.51394399969,      611.44309831080}, 
    {     0.00000000158,  4.72257677135,      295.19424100610}, 
    {     0.00000000150,  0.60398672305,     2413.81508903260}, 
    {     0.00000000156,  5.12996334469,     2420.92863603340}, 
    {     0.00000000117,  3.64929207405,     3362.99069800240}, 
    {     0.00000000117,  0.79489355403,      444.75743814070}, 
    {     0.00000000115,  1.69119601859,     2118.76386037840}, 
    {     0.00000000114,  1.98550407909,      774.48262992160}, 
    {     0.00000000118,  0.91668991972,      397.39324334740}, 
    {     0.00000000144,  4.33884007719,     2620.00063746980}, 
    {     0.00000000114,  2.79166033655,      235.39049596580}, 
    {     0.00000000115,  4.38822748118,      206.13736432740}, 
    {     0.00000000130,  4.69716812098,     2737.32050569000}, 
    {     0.00000000111,  6.17613645667,      380.12776796000}, 
    {     0.00000000121,  2.03089873253,      525.49817940060}, 
    {     0.00000000114,  1.25282479588,     6290.18939699220}, 
    {     0.00000000116,  4.50304390109,     2531.13495725280}, 
    {     0.00000000116,  3.10820904194,      219.44943459230}, 
    {     0.00000000130,  2.39191628139,      217.49188113200}, 
    {     0.00000000106,  4.99816879211,     2936.39250712640}, 
    {     0.00000000117,  5.47700869225,      209.10630974400}, 
    {     0.00000000108,  2.67653144313,    10220.39909321180}, 
    {     0.00000000106,  0.72832676913,     3480.31056622260}, 
    {     0.00000000109,  3.11293456456,     1688.98427576470}, 
    {     0.00000000132,  4.86619194495,      175.16605980020}, 
    {     0.00000000109,  3.41245137157,     1159.29331067010}, 
    {     0.00000000102,  1.34825182101,      927.83496796740}, 
    {     0.00000000101,  4.38136430289,     3163.91869656600}, 
    {     0.00000000106,  2.63803685685,     1051.51762366300}, 
    {     0.00000000102,  2.04491853976,     4105.98075853500}, 
    {     0.00000000100,  0.94970095252,      835.78789401270}, 
    {     0.00000000117,  4.62934163072,     2332.06295581640}, 
    {     0.00000000101,  3.06953613114,      411.62033734900}, 
    {     0.00000000099,  5.73465398566,     1251.34038462480}, 
    {     0.00000000097,  0.78785936400,      739.05790726950}, 
    {     0.00000000098,  5.27870818864,      395.57870223900}, 
    {     0.00000000097,  1.09461119824,     2324.94940881560}, 
    {     0.00000000095,  1.24118747732,      211.81462272970}, 
    {     0.00000000104,  1.47021057742,     2957.73314812880}, 
    {     0.00000000094,  1.68922220636,      518.64526483070}, 
    {     0.00000000118,  4.22282854428,     2207.62954059540}, 
    {     0.00000000092,  3.41317338100,     3679.38256765900}, 
    {     0.00000000111,  4.66199924249,     2634.22773147140}, 
    {     0.00000000093,  3.01841149764,     3156.80514956520}, 
    {     0.00000000106,  0.35440155109,      543.02428721890}, 
    {     0.00000000090,  0.21699672631,      327.43756992050}, 
    {     0.00000000095,  4.94137031528,       45.24658263860}, 
    {     0.00000000087,  0.64235473812,      214.78356814630}, 
    {     0.00000000111,  0.08892066313,    10206.17199921020}, 
    {     0.00000000115,  4.07375401085,     3686.49611465980}, 
    {     0.00000000084,  2.49438627744,      121.25202148330}, 
    {     0.00000000108,  4.78689047662,      850.01498801430}, 
    {     0.00000000098,  4.83439655178,     3810.92952988080}, 
    {     0.00000000084,  5.63810867849,     3149.69160256440}, 
    {     0.00000000112,  1.14266452718,     1802.37199072180}, 
    {     0.00000000082,  4.77545412312,     3252.78437678300}, 
    {     0.00000000083,  3.73663902299,      207.67002114550}, 
    {     0.00000000082,  2.76806023078,      540.73666535850}, 
    {     0.00000000082,  6.15333814412,      210.37833413120}, 
    {     0.00000000113,  2.14356843768,     2435.15573003500}, 
    {     0.00000000089,  5.86249569421,     2111.65031337760}, 
    {     0.00000000100,  5.06864917409,      864.24208201590}, 
    {     0.00000000080,  6.20664537299,     3590.51688744200}, 
    {     0.00000000089,  5.75815115764,      898.77303279070}, 
    {     0.00000000082,  5.76315175207,     2303.60876781320}, 
    {     0.00000000082,  0.11850539240,        4.66586644600}, 
    {     0.00000000099,  1.45848606541,     4539.69249641180}, 
    {     0.00000000107,  2.75969942717,     4113.09430553580}, 
    {     0.00000000093,  3.44450128400,      849.26422848890}, 
    {     0.00000000080,  5.87232764632,      980.66817835880}, 
    {     0.00000000098,  2.92531705189,      135.33610313300}, 
    {     0.00000000080,  1.95003898969,     4436.59972219320}, 
    {     0.00000000080,  3.17860516663,      320.32402291970}, 
    {     0.00000000078,  5.57840933926,      455.05237887920}, 
    {     0.00000000084,  5.76609235830,     2854.64037391020}, 
    {     0.00000000075,  5.72196904186,     1987.21689815660}, 
    {     0.00000000076,  3.15970573068,     4010.00153131720}, 
    {     0.00000000076,  2.88023671694,      511.53171782990}, 
    {     0.00000000080,  5.74706692909,      831.10498122420}, 
    {     0.00000000079,  1.90014137790,      213.82036029980}, 
    {     0.00000000080,  0.79002014310,      204.70107572890}, 
    {     0.00000000086,  1.59595700348,      173.94221952280}, 
    {     0.00000000074,  4.35316212019,     3583.40334044120}, 
    {     0.00000000078,  1.40832902740,      212.77783057620}, 
    {     0.00000000072,  3.92553125825,     1176.70179840940}, 
    {     0.00000000078,  1.51105649620,     1269.49963188950}, 
    {     0.00000000071,  3.64609589554,      198.32124191100}, 
};


static const struct ln_vsop saturn_longitude_l3[LONG_L3] = {
    {     0.00016038732,  5.73945573267,        7.11354700080}, 
    {     0.00004254737,  4.58877599687,      213.29909543800}, 
    {     0.00001906379,  4.76070843570,      220.41264243880}, 
    {     0.00001464959,  5.91328884284,      206.18554843720}, 
    {     0.00001162062,  5.61974313217,       14.22709400160}, 
    {     0.00001044765,  3.57813061587,      426.59819087600}, 
    {     0.00000236068,  3.85849798708,      433.71173787680}, 
    {     0.00000237009,  5.76820709729,      199.07200143640}, 
    {     0.00000165645,  5.11642167451,        3.18139373770}, 
    {     0.00000131328,  4.74306126145,      227.52618943960}, 
    {     0.00000150882,  2.72695802283,      639.89728631400}, 
    {     0.00000061607,  4.74260728276,      103.09277421860}, 
    {     0.00000063899,  0.08672623762,      419.48464387520}, 
    {     0.00000040405,  5.47280316518,       21.34064100240}, 
    {     0.00000040222,  5.96343977224,       95.97922721780}, 
    {     0.00000038807,  5.83309187434,      110.20632121940}, 
    {     0.00000026949,  3.00877360899,      647.01083331480}, 
    {     0.00000025017,  0.98675576491,        3.93215326310}, 
    {     0.00000032692,  3.14159265359,        0.00000000000}, 
    {     0.00000018051,  1.02181794600,      412.37109687440}, 
    {     0.00000017831,  3.32039911376,      309.27832265580}, 
    {     0.00000015894,  3.89729495217,      440.82528487760}, 
    {     0.00000015768,  5.61263410328,      117.31986822020}, 
    {     0.00000018212,  4.96397771331,       10.29494073850}, 
    {     0.00000018497,  1.92534365710,      853.19638175200}, 
    {     0.00000012927,  1.17950837478,       88.86568021700}, 
    {     0.00000017889,  4.20422746039,      216.48048917570}, 
    {     0.00000011440,  5.57587131751,       11.04570026390}, 
    {     0.00000010554,  5.92710883673,      191.95845443560}, 
    {     0.00000010432,  3.95667199114,      209.36694217490}, 
    {     0.00000008655,  3.39231823414,      302.16477565500}, 
    {     0.00000007523,  4.87915941795,      323.50541665740}, 
    {     0.00000005871,  1.05703393060,      210.11770170030}, 
    {     0.00000005349,  4.63664712061,      234.63973644040}, 
    {     0.00000004986,  0.17277280741,      632.78373931320}, 
    {     0.00000006300,  2.25329355289,      522.57741809380}, 
    {     0.00000003608,  2.30889061812,      515.46387109300}, 
    {     0.00000002933,  2.21148312356,      860.30992875280}, 
    {     0.00000002572,  0.41973213333,      625.67019231240}, 
    {     0.00000002479,  4.94903388247,      224.34479570190}, 
    {     0.00000002175,  3.16635787015,      202.25339517410}, 
    {     0.00000002368,  4.75945968289,      330.61896365820}, 
    {     0.00000002705,  0.65007424536,      529.69096509460}, 
    {     0.00000001981,  4.38259974938,      124.43341522100}, 
    {     0.00000002151,  1.35777052319,      405.25754987360}, 
    {     0.00000002050,  1.03766221834,      728.76296653100}, 
    {     0.00000002129,  3.34889649076,      429.77958461370}, 
    {     0.00000001804,  3.08896387579,      654.12438031560}, 
    {     0.00000001794,  3.09524789608,      422.66603761290}, 
    {     0.00000001767,  4.12428069333,      536.80451209540}, 
    {     0.00000002036,  4.14778460181,      223.59403617650}, 
    {     0.00000001522,  0.30568508593,      316.39186965660}, 
    {     0.00000002003,  1.19811189628,     1066.49547719000}, 
    {     0.00000001824,  5.82606735563,      195.13984817330}, 
    {     0.00000001672,  6.05450203591,      742.99006053260}, 
    {     0.00000001374,  5.00478301043,      956.28915597060}, 
    {     0.00000001330,  3.91860861475,      269.92144674060}, 
    {     0.00000001448,  1.57683663501,       81.75213321620}, 
    {     0.00000001282,  1.64172627600,       63.73589830340}, 
    {     0.00000001530,  2.07185037631,      838.96928775040}, 
    {     0.00000001023,  3.72829174293,      295.05122865420}, 
    {     0.00000001252,  2.40431685132,      217.23124870110}, 
    {     0.00000001325,  1.43168728470,      735.87651353180}, 
    {     0.00000000941,  2.77748068918,      284.14854074220}, 
    {     0.00000000803,  4.71988196699,       56.62235130260}, 
    {     0.00000000948,  2.03116711580,      831.85574074960}, 
    {     0.00000000831,  0.74562303148,      846.08283475120}, 
    {     0.00000000842,  3.33175376920,       18.15924726470}, 
    {     0.00000000824,  0.80001123001,     1045.15483618760}, 
    {     0.00000000857,  2.39067793598,      203.00415469950}, 
    {     0.00000000738,  3.80960374631,      447.93883187840}, 
    {     0.00000000584,  6.25069777652,      942.06206196900}, 
    {     0.00000000538,  2.86495331128,      184.84490743480}, 
    {     0.00000000505,  6.25643434939,     1059.38193018920}, 
    {     0.00000000626,  1.55608850413,      423.41679713830}, 
    {     0.00000000485,  3.46793365763,      149.56319713460}, 
    {     0.00000000484,  4.87301938477,     1272.68102562720}, 
    {     0.00000000433,  2.70775591374,      508.35032409220}, 
    {     0.00000000438,  4.22151675617,      437.64389113990}, 
    {     0.00000000435,  5.39766982546,      408.43894361130}, 
    {     0.00000000352,  0.59786545468,       22.09140052780}, 
    {     0.00000000367,  1.22439337201,     2324.94940881560}, 
    {     0.00000000438,  1.71625572063,     1155.36115740700}, 
    {     0.00000000374,  1.18586297651,      721.64941953020}, 
    {     0.00000000310,  2.42135657973,      127.47179660680}, 
    {     0.00000000309,  0.33610530663,     6076.89030155420}, 
    {     0.00000000309,  1.42279282226,     6062.66320755260}, 
    {     0.00000000305,  5.34819286072,      131.40394986990}, 
    {     0.00000000333,  1.84641267165,     1141.13406340540}, 
    {     0.00000000358,  0.68499202426,     1361.54670584420}, 
    {     0.00000000293,  2.19086882960,      416.30325013750}, 
    {     0.00000000337,  3.29001545070,      750.10360753340}, 
    {     0.00000000293,  2.28323305517,      635.96513305090}, 
    {     0.00000000373,  1.10446940352,     1052.26838318840}, 
    {     0.00000000313,  1.86587122616,     1148.24761040620}, 
    {     0.00000000258,  3.31118509824,      618.55664531160}, 
    {     0.00000000258,  2.56646226279,      415.55249061210}, 
    {     0.00000000252,  1.83229588399,      628.85158605010}, 
    {     0.00000000296,  1.29860021998,      490.33408917940}, 
    {     0.00000000304,  2.58172658788,      362.86229257260}, 
    {     0.00000000293,  4.02595319860,      543.91805909620}, 
    {     0.00000000295,  0.35280179538,     2730.20695868920}, 
    {     0.00000000243,  3.12295878727,     1382.88734684660}, 
    {     0.00000000237,  1.50349467228,       70.84944530420}, 
    {     0.00000000261,  1.55058302472,     1457.52593306200}, 
    {     0.00000000291,  0.88069340340,     2104.53676637680}, 
    {     0.00000000304,  1.86172088151,      824.74219374880}, 
    {     0.00000000289,  1.10556085722,     1788.14489672020}, 
    {     0.00000000257,  1.47442762699,     1073.60902419080}, 
    {     0.00000000236,  2.78922688109,      430.53034413910}, 
    {     0.00000000217,  3.57312838427,      483.22054217860}, 
    {     0.00000000253,  1.52081140336,     1471.75302706360}, 
    {     0.00000000223,  0.29158786156,     2854.64037391020}, 
    {     0.00000000282,  0.18719544473,       99.91138048090}, 
    {     0.00000000206,  1.81343391023,      497.44763618020}, 
    {     0.00000000241,  0.70959972165,     2420.92863603340}, 
    {     0.00000000251,  0.61933213502,     2413.81508903260}, 
    {     0.00000000222,  2.30065576536,      867.42347575360}, 
    {     0.00000000198,  6.11152305398,     1258.45393162560}, 
    {     0.00000000237,  0.41532391633,     1677.93857550080}, 
    {     0.00000000240,  5.33742562346,      231.45834270270}, 
    {     0.00000000244,  0.92932541351,       52.69019803950}, 
    {     0.00000000231,  3.35905530490,      436.89313161450}, 
    {     0.00000000227,  0.43324651601,     2737.32050569000}, 
    {     0.00000000203,  4.11821570036,      337.73251065900}, 
    {     0.00000000207,  0.26876250106,     3046.59882834580}, 
    {     0.00000000215,  3.58355205754,      934.94851496820}, 
    {     0.00000000212,  1.25688162158,     1773.91780271860}, 
    {     0.00000000201,  4.03418221542,      131.54696222180}, 
    {     0.00000000222,  0.38124598378,     1279.79457262800}, 
    {     0.00000000220,  0.95184545950,     1038.04128918680}, 
    {     0.00000000241,  4.63368951189,     1905.46476494040}, 
    {     0.00000000210,  4.19139167658,     2221.85663459700}, 
    {     0.00000000176,  2.94962159722,       74.78159856730}, 
    {     0.00000000211,  5.60391253075,     2943.50605412720}, 
    {     0.00000000181,  0.68460528413,     2001.44399215820}, 
    {     0.00000000185,  0.34812960604,     2317.83586181480}, 
    {     0.00000000160,  1.23508694599,     1596.18644228460}, 
    {     0.00000000175,  4.14605894816,     2090.30967237520}, 
    {     0.00000000152,  0.05796022559,       32.24332891440}, 
    {     0.00000000162,  0.97905647862,     2627.11418447060}, 
    {     0.00000000146,  4.58001707019,      106.27416795630}, 
    {     0.00000000185,  4.74630303607,      319.57326339430}, 
    {     0.00000000152,  3.58854245185,      650.94298657790}, 
    {     0.00000000154,  1.27898590074,      636.71589257630}, 
    {     0.00000000194,  1.21816145647,     2207.62954059540}, 
    {     0.00000000179,  3.37155577752,     2332.06295581640}, 
    {     0.00000000150,  2.52427390338,      643.07868005170}, 
    {     0.00000000147,  6.27122260730,     1994.33044515740}, 
    {     0.00000000166,  0.52445262931,      113.38771495710}, 
    {     0.00000000140,  3.04260087324,      661.23792731640}, 
    {     0.00000000118,  1.12530803349,      215.74677599280}, 
    {     0.00000000117,  0.86867361262,     1574.84580128220}, 
    {     0.00000000108,  4.25077088080,      145.63104387150}, 
    {     0.00000000148,  0.89634027181,     1368.66025284500}, 
    {     0.00000000106,  1.12784071177,     1162.47470440780}, 
    {     0.00000000129,  1.02682913037,      313.21047591890}, 
    {     0.00000000120,  1.01405091659,     2516.90786325120}, 
    {     0.00000000114,  3.30194660143,      757.21715453420}, 
    {     0.00000000124,  4.83905966929,      444.75743814070}, 
    {     0.00000000101,  5.22590586676,     1567.73225428140}, 
    {     0.00000000098,  2.30576007013,     2751.54759969160}, 
    {     0.00000000090,  0.09448012766,     2524.02141025200}, 
    {     0.00000000103,  0.58319919546,     1354.43315884340}, 
    {     0.00000000095,  4.84522108220,     2620.00063746980}, 
    {     0.00000000096,  1.39789423575,      277.03499374140}, 
    {     0.00000000120,  5.05053768078,     2008.55753915900}, 
    {     0.00000000106,  3.69808924883,     2861.75392091100}, 
    {     0.00000000110,  0.16506001444,     1987.21689815660}, 
    {     0.00000000084,  3.94251629849,      156.67674413540}, 
    {     0.00000000085,  0.45004931501,      320.32402291970}, 
    {     0.00000000086,  1.91244115163,     2634.22773147140}, 
    {     0.00000000086,  1.76877765860,     2097.42321937600}, 
    {     0.00000000082,  1.27140666625,     1685.05212250160}, 
    {     0.00000000088,  1.67886685969,     1464.63948006280}, 
    {     0.00000000081,  2.13887651399,      210.85141488320}, 
    {     0.00000000086,  4.55455922748,      241.75328344120}, 
    {     0.00000000087,  1.37882811046,     1781.03134971940}, 
    {     0.00000000094,  4.36001187626,     2641.34127847220}, 
    {     0.00000000080,  0.03222646119,     1670.82502850000}, 
    {     0.00000000080,  5.40919461005,     2744.43405269080}, 
    {     0.00000000090,  2.46737000048,     1802.37199072180}, 
    {     0.00000000086,  2.21461093242,     3156.80514956520}, 
    {     0.00000000088,  0.60411748611,      703.63318461740}, 
    {     0.00000000074,  3.72977862703,     1485.98012106520}, 
    {     0.00000000084,  0.14427542567,     1884.12412393800}, 
    {     0.00000000090,  5.82096787757,     2531.13495725280}, 
    {     0.00000000085,  2.00389715339,     1699.27921650320}, 
    {     0.00000000091,  0.69169111465,     1286.90811962880}, 
    {     0.00000000075,  3.89924996086,     3370.10424500320}, 
    {     0.00000000084,  1.84802318288,      398.14400287280}, 
    {     0.00000000076,  3.33883739305,      195.89060769870}, 
};


static const struct ln_vsop saturn_longitude_l4[LONG_L4] = {
    {     0.00001661877,  3.99824447634,        7.11354700080}, 
    {     0.00000257094,  2.98422287887,      220.41264243880}, 
    {     0.00000236328,  3.90248844320,       14.22709400160}, 
    {     0.00000149520,  2.73191135434,      213.29909543800}, 
    {     0.00000109412,  1.51564560686,      206.18554843720}, 
    {     0.00000069119,  1.74804093636,      426.59819087600}, 
    {     0.00000037680,  1.23800346661,      199.07200143640}, 
    {     0.00000039678,  2.04527339062,      433.71173787680}, 
    {     0.00000031172,  3.01055217526,      227.52618943960}, 
    {     0.00000015026,  0.83249780616,      639.89728631400}, 
    {     0.00000009424,  3.71267465225,       21.34064100240}, 
    {     0.00000005131,  2.14278851183,      419.48464387520}, 
    {     0.00000004379,  1.44314873951,       95.97922721780}, 
    {     0.00000005391,  1.15849076251,      647.01083331480}, 
    {     0.00000004315,  2.11844568875,      440.82528487760}, 
    {     0.00000003215,  4.10085180982,      110.20632121940}, 
    {     0.00000002866,  3.03604951200,       88.86568021700}, 
    {     0.00000002825,  2.76965112625,      412.37109687440}, 
    {     0.00000002584,  6.28047035280,      853.19638175200}, 
    {     0.00000002616,  0.38576038218,      103.09277421860}, 
    {     0.00000001872,  5.13517095425,      309.27832265580}, 
    {     0.00000002210,  3.77003162591,      117.31986822020}, 
    {     0.00000001772,  5.18511152518,      302.16477565500}, 
    {     0.00000001832,  2.84292047890,      234.63973644040}, 
    {     0.00000001759,  2.26487572601,      216.48048917570}, 
    {     0.00000001193,  1.54874757981,      191.95845443560}, 
    {     0.00000000765,  4.76897987642,      210.11770170030}, 
    {     0.00000000644,  4.21681516017,      515.46387109300}, 
    {     0.00000000619,  4.04856580980,      522.57741809380}, 
    {     0.00000000619,  2.37595244026,      209.36694217490}, 
    {     0.00000000611,  3.14631600944,      323.50541665740}, 
    {     0.00000000560,  2.17190605203,      124.43341522100}, 
    {     0.00000000519,  3.20539990880,      405.25754987360}, 
    {     0.00000000443,  0.25912890713,      860.30992875280}, 
    {     0.00000000412,  3.12214166924,      330.61896365820}, 
    {     0.00000000431,  3.39648180302,       81.75213321620}, 
    {     0.00000000329,  4.10003432838,      838.96928775040}, 
    {     0.00000000374,  1.28466223056,      654.12438031560}, 
    {     0.00000000314,  3.24026230608,      529.69096509460}, 
    {     0.00000000291,  2.33783778160,      447.93883187840}, 
    {     0.00000000292,  5.48631134223,     1066.49547719000}, 
    {     0.00000000291,  3.18885372262,     1464.63948006280}, 
    {     0.00000000304,  1.25087313988,      742.99006053260}, 
    {     0.00000000270,  2.18054322187,      632.78373931320}, 
    {     0.00000000298,  2.38540238363,      625.67019231240}, 
    {     0.00000000257,  4.47876331608,     1574.84580128220}, 
    {     0.00000000297,  2.58634568787,     1045.15483618760}, 
    {     0.00000000314,  2.94878103629,      728.76296653100}, 
    {     0.00000000235,  3.67049647573,     1148.24761040620}, 
    {     0.00000000283,  4.56828102737,      423.41679713830}, 
    {     0.00000000221,  3.04602691755,     1781.03134971940}, 
    {     0.00000000236,  3.61825037624,      231.45834270270}, 
    {     0.00000000261,  2.04564143517,     1677.93857550080}, 
    {     0.00000000214,  3.55618873096,     1155.36115740700}, 
    {     0.00000000207,  2.09726651480,     1361.54670584420}, 
    {     0.00000000252,  0.00000000000,        0.00000000000}, 
    {     0.00000000175,  1.27230112159,      422.66603761290}, 
    {     0.00000000190,  2.32718555488,      223.59403617650}, 
    {     0.00000000187,  3.64109764967,      956.28915597060}, 
    {     0.00000000168,  0.69946458053,      824.74219374880}, 
    {     0.00000000177,  5.02653087687,      203.00415469950}, 
    {     0.00000000164,  1.44690006365,      429.77958461370}, 
    {     0.00000000159,  2.80925293490,     1589.07289528380}, 
    {     0.00000000152,  3.88114824142,      831.85574074960}, 
    {     0.00000000129,  4.99346550473,      618.55664531160}, 
    {     0.00000000143,  1.03749104574,      316.39186965660}, 
    {     0.00000000129,  2.77308987628,     1169.58825140860}, 
    {     0.00000000114,  2.00739159822,      295.05122865420}, 
    {     0.00000000109,  1.39540359862,     1354.43315884340}, 
    {     0.00000000109,  6.07865735607,     2001.44399215820}, 
    {     0.00000000123,  2.06227563721,      942.06206196900}, 
    {     0.00000000104,  4.41203428092,     1279.79457262800}, 
    {     0.00000000125,  5.80362410627,     1073.60902419080}, 
    {     0.00000000107,  3.34391463430,      735.87651353180}, 
    {     0.00000000102,  0.61258147793,     1788.14489672020}, 
    {     0.00000000130,  2.23864282613,      536.80451209540}, 
    {     0.00000000095,  2.58259079168,      846.08283475120}, 
    {     0.00000000096,  2.93096385623,      224.34479570190}, 
    {     0.00000000103,  4.92943720757,      508.35032409220}, 
    {     0.00000000090,  6.21432772004,     1265.56747862640}, 
    {     0.00000000083,  1.57021339944,     1038.04128918680}, 
    {     0.00000000094,  2.75644931636,      721.64941953020}, 
    {     0.00000000105,  0.46132848902,      867.42347575360}, 
    {     0.00000000078,  4.50314394179,     2015.67108615980}, 
    {     0.00000000088,  4.99305633625,      444.00667861530}, 
};


static const struct ln_vsop saturn_longitude_l5[LONG_L5] = {
    {     0.00000123607,  2.25923420203,        7.11354700080}, 
    {     0.00000034176,  2.16278773143,       14.22709400160}, 
    {     0.00000027539,  1.19822164604,      220.41264243880}, 
    {     0.00000005763,  1.21171444884,      227.52618943960}, 
    {     0.00000005284,  0.23520891295,      433.71173787680}, 
    {     0.00000003650,  6.20014021207,      426.59819087600}, 
    {     0.00000003061,  2.96839870592,      199.07200143640}, 
    {     0.00000002865,  4.29470838129,      206.18554843720}, 
    {     0.00000001499,  6.21044685389,      213.29909543800}, 
    {     0.00000001262,  5.25209851911,      639.89728631400}, 
    {     0.00000000756,  6.17670364645,      191.95845443560}, 
    {     0.00000000759,  0.69127092329,      302.16477565500}, 
    {     0.00000000820,  5.59433772118,      647.01083331480}, 
    {     0.00000000942,  0.24584020543,      440.82528487760}, 
    {     0.00000000547,  4.87451203466,       88.86568021700}, 
    {     0.00000000503,  4.63319665449,      419.48464387520}, 
    {     0.00000000357,  4.73247835262,      860.30992875280}, 
    {     0.00000000343,  5.70825898673,      654.12438031560}, 
    {     0.00000000243,  2.03429529667,      323.50541665740}, 
    {     0.00000000305,  1.06249794404,      234.63973644040}, 
    {     0.00000000231,  4.36065387404,      853.19638175200}, 
    {     0.00000000232,  0.84968053738,      309.27832265580}, 
    {     0.00000000239,  0.65475141729,      117.31986822020}, 
    {     0.00000000167,  5.24062073200,      405.25754987360}, 
    {     0.00000000165,  2.41456551560,      515.46387109300}, 
    {     0.00000000155,  1.75303344154,      412.37109687440}, 
    {     0.00000000118,  4.41706591175,      632.78373931320}, 
    {     0.00000000093,  5.50595405458,       95.97922721780}, 
    {     0.00000000109,  0.34156541412,      447.93883187840}, 
    {     0.00000000076,  1.01712437818,      522.57741809380}, 
};


static const struct ln_vsop saturn_latitude_b0[LAT_B0] = {
    {     0.04330678039,  3.60284428399,      213.29909543800}, 
    {     0.00240348302,  2.85238489373,      426.59819087600}, 
    {     0.00084745939,  0.00000000000,        0.00000000000}, 
    {     0.00030863357,  3.48441504555,      220.41264243880}, 
    {     0.00034116062,  0.57297307557,      206.18554843720}, 
    {     0.00014734070,  2.11846596715,      639.89728631400}, 
    {     0.00009916667,  5.79003188904,      419.48464387520}, 
    {     0.00006993564,  4.73604689720,        7.11354700080}, 
    {     0.00004807588,  5.43305312061,      316.39186965660}, 
    {     0.00004788392,  4.96512926584,      110.20632121940}, 
    {     0.00003432125,  2.73255746600,      433.71173787680}, 
    {     0.00001506129,  6.01304519391,      103.09277421860}, 
    {     0.00001060298,  5.63099296460,      529.69096509460}, 
    {     0.00000969071,  5.20434966293,      632.78373931320}, 
    {     0.00000942050,  1.39646688872,      853.19638175200}, 
    {     0.00000707645,  3.80302289005,      323.50541665740}, 
    {     0.00000552314,  5.13149119536,      202.25339517410}, 
    {     0.00000399674,  3.35891409671,      227.52618943960}, 
    {     0.00000316063,  1.99716693551,      647.01083331480}, 
    {     0.00000319380,  3.62571687438,      209.36694217490}, 
    {     0.00000284495,  4.88648507126,      224.34479570190}, 
    {     0.00000314224,  0.46510248959,      217.23124870110}, 
    {     0.00000236441,  2.13887684631,       11.04570026390}, 
    {     0.00000215354,  5.94982561020,      846.08283475120}, 
    {     0.00000208523,  2.12003937634,      415.55249061210}, 
    {     0.00000178958,  2.95361337281,       63.73589830340}, 
    {     0.00000207214,  0.73021353207,      199.07200143640}, 
    {     0.00000139140,  1.99821987827,      735.87651353180}, 
    {     0.00000134884,  5.24501026174,      742.99006053260}, 
    {     0.00000140585,  0.64417933116,      490.33408917940}, 
    {     0.00000121669,  3.11537142395,      522.57741809380}, 
    {     0.00000139240,  4.59535592976,       14.22709400160}, 
    {     0.00000115525,  3.10892020920,      216.48048917570}, 
    {     0.00000114218,  0.96262037933,      210.11770170030}, 
    {     0.00000096377,  4.48164269503,      117.31986822020}, 
    {     0.00000080594,  1.31693242934,      277.03499374140}, 
    {     0.00000072953,  3.05987977572,      536.80451209540}, 
    {     0.00000069261,  4.92378376874,      309.27832265580}, 
    {     0.00000074302,  2.89377583784,      149.56319713460}, 
    {     0.00000068041,  2.18001288710,      351.81659230870}, 
    {     0.00000061733,  0.67727575242,     1066.49547719000}, 
    {     0.00000056598,  2.60962477110,      440.82528487760}, 
    {     0.00000048864,  5.78725829726,       95.97922721780}, 
    {     0.00000048242,  2.18211814462,       74.78159856730}, 
    {     0.00000038304,  5.29151507162,     1059.38193018920}, 
    {     0.00000036322,  1.63347180455,      628.85158605010}, 
    {     0.00000035055,  1.71278162034,     1052.26838318840}, 
    {     0.00000034270,  2.45739879861,      422.66603761290}, 
    {     0.00000034314,  5.97994688275,      412.37109687440}, 
    {     0.00000033788,  1.14074435448,      949.17560896980}, 
    {     0.00000031633,  4.14722028612,      437.64389113990}, 
    {     0.00000036834,  6.27770255515,     1162.47470440780}, 
    {     0.00000026984,  1.27148410951,      860.30992875280}, 
    {     0.00000023516,  2.74935309134,      838.96928775040}, 
    {     0.00000023459,  0.98962524752,      210.85141488320}, 
    {     0.00000023599,  4.11386769857,        3.93215326310}, 
    {     0.00000023631,  3.07427178660,      215.74677599280}, 
    {     0.00000020813,  3.51085178074,      330.61896365820}, 
    {     0.00000019509,  2.81860617670,      127.47179660680}, 
    {     0.00000017103,  3.89783901305,      214.26230328450}, 
    {     0.00000017635,  6.19717997355,      703.63318461740}, 
    {     0.00000017824,  2.28523987140,      388.46515523820}, 
    {     0.00000020934,  0.14356449654,      430.53034413910}, 
    {     0.00000016551,  1.66649361181,       38.13303563780}, 
    {     0.00000019099,  2.97700224420,      137.03302416240}, 
    {     0.00000015517,  4.54795623900,      956.28915597060}, 
    {     0.00000017065,  0.16611037368,      212.33588759150}, 
    {     0.00000014169,  0.48937272443,      213.34727954780}, 
    {     0.00000019027,  6.27326596357,      423.41679713830}, 
    {     0.00000013345,  2.37139629634,      429.77958461370}, 
    {     0.00000012565,  1.03177371258,      563.63121503840}, 
    {     0.00000014173,  3.57477472425,      213.25091132820}, 
    {     0.00000011374,  1.45298798816,     1368.66025284500}, 
    {     0.00000010584,  6.17636945166,      200.76892246580}, 
    {     0.00000010600,  3.84356693852,      138.51749687070}, 
    {     0.00000010263,  2.17427018729,       76.26607127560}, 
    {     0.00000010072,  1.33201729128,      565.11568774670}, 
    {     0.00000012058,  0.44148218737,      222.86032299360}, 
    {     0.00000010368,  1.85281517515,      350.33211960040}, 
    {     0.00000008706,  2.58147597130,     1155.36115740700}, 
    {     0.00000008470,  1.97888106159,      625.67019231240}, 
    {     0.00000008518,  4.51648111567,        3.18139373770}, 
    {     0.00000007439,  4.92600810037,      212.77783057620}, 
    {     0.00000007409,  2.03508355026,      288.08069400530}, 
    {     0.00000008137,  3.98505041656,       85.82729883120}, 
    {     0.00000007985,  2.20797256457,      362.86229257260}, 
    {     0.00000006611,  6.14943940547,      417.03696332040}, 
    {     0.00000007753,  6.23664541592,     1478.86657406440}, 
    {     0.00000006318,  1.87385475668,      654.12438031560}, 
    {     0.00000006319,  1.17329432448,     1265.56747862640}, 
    {     0.00000005842,  2.35830893941,      750.10360753340}, 
    {     0.00000005809,  5.01605720364,      479.28838891550}, 
    {     0.00000008079,  0.42573508414,      554.06998748280}, 
    {     0.00000006013,  5.58956703310,      425.11371816770}, 
    {     0.00000007443,  5.41863022509,      213.82036029980}, 
    {     0.00000007567,  2.68448652355,      191.20769491020}, 
    {     0.00000007421,  4.19346867637,        9.56122755560}, 
    {     0.00000005466,  3.21737975737,      234.63973644040}, 
    {     0.00000005661,  1.46972995704,      265.98929347750}, 
    {     0.00000005851,  4.81779259708,        1.48447270830}, 
    {     0.00000005340,  3.45754460657,      203.73786788240}, 
    {     0.00000004959,  1.04652918134,       12.53017297220}, 
    {     0.00000004920,  3.85621572217,      173.94221952280}, 
    {     0.00000004885,  1.94822927870,      195.13984817330}, 
    {     0.00000005622,  0.81876912331,       52.69019803950}, 
    {     0.00000005200,  3.32831141176,      515.46387109300}, 
    {     0.00000004927,  3.81806645978,      225.82926841020}, 
    {     0.00000005033,  0.10753911773,      252.65597135320}, 
    {     0.00000004415,  5.45507718301,      408.43894361130}, 
    {     0.00000004169,  1.21147053668,     1685.05212250160}, 
    {     0.00000004066,  6.24209791402,     1279.79457262800}, 
    {     0.00000003972,  6.13849757304,      217.49188113200}, 
    {     0.00000005397,  5.67209673575,     1375.77379984580}, 
    {     0.00000003916,  5.96103967590,      210.37833413120}, 
    {     0.00000004018,  0.99841407086,      842.15068148810}, 
    {     0.00000003899,  4.58977109833,     1272.68102562720}, 
    {     0.00000003764,  3.30656219997,      212.54833591260}, 
    {     0.00000004345,  3.18572215775,      414.06801790380}, 
    {     0.00000003565,  4.75263028087,      207.88246946660}, 
    {     0.00000003542,  2.30824066107,     1471.75302706360}, 
    {     0.00000003733,  1.61005453160,      635.96513305090}, 
    {     0.00000003709,  2.97075604030,      223.59403617650}, 
    {     0.00000003576,  3.83445473719,      483.22054217860}, 
    {     0.00000004053,  3.72114172268,      942.06206196900}, 
    {     0.00000003756,  0.74980502523,      214.04985496340}, 
    {     0.00000003162,  3.64544174931,      207.67002114550}, 
    {     0.00000003149,  2.27652164307,      728.76296653100}, 
    {     0.00000003971,  4.37874031224,      216.21985674480}, 
    {     0.00000003541,  5.62285095602,      218.71572140940}, 
    {     0.00000002965,  3.40116954988,      650.94298657790}, 
    {     0.00000003949,  4.19725654798,      209.10630974400}, 
    {     0.00000002854,  4.81078713241,      231.45834270270}, 
    {     0.00000002826,  0.86693896405,      217.96496188400}, 
    {     0.00000002970,  5.75170150936,      160.60889739850}, 
    {     0.00000002725,  0.47979226347,      497.44763618020}, 
    {     0.00000002787,  4.03141540529,       62.25142559510}, 
    {     0.00000002605,  5.04158135498,       65.22037101170}, 
    {     0.00000002652,  0.30600516628,      424.15051032120}, 
    {     0.00000002544,  2.76497538450,      543.91805909620}, 
    {     0.00000002486,  5.78393991822,       99.16062095550}, 
    {     0.00000003209,  0.42853180320,      218.92816973050}, 
    {     0.00000002509,  2.94706968663,       70.84944530420}, 
    {     0.00000002308,  0.63864314515,      251.43213107580}, 
    {     0.00000002870,  4.31953619024,      767.36908292080}, 
    {     0.00000002232,  0.56925732199,     1073.60902419080}, 
    {     0.00000002245,  1.69948898267,      488.84961647110}, 
    {     0.00000002283,  1.55577121099,      601.76425067620}, 
    {     0.00000002385,  4.44576406679,       21.34064100240}, 
    {     0.00000002096,  5.77427724778,       88.86568021700}, 
    {     0.00000002363,  3.35780875610,      124.43341522100}, 
    {     0.00000002163,  6.24043411110,     1795.25844372100}, 
    {     0.00000002452,  3.19799065056,      208.63322899200}, 
    {     0.00000002032,  4.87022235349,      327.43756992050}, 
    {     0.00000001951,  5.56009679471,       18.15924726470}, 
    {     0.00000002283,  4.22370918126,       22.09140052780}, 
    {     0.00000002217,  4.61440126600,      302.16477565500}, 
    {     0.00000001887,  5.45618090482,      142.44965013380}, 
    {     0.00000002075,  3.55620806580,     1169.58825140860}, 
    {     0.00000002069,  2.75791541992,      491.81856188770}, 
    {     0.00000001811,  5.96559795987,      213.18722085340}, 
    {     0.00000001813,  1.39785635676,      211.81462272970}, 
    {     0.00000001842,  1.14981052498,      203.00415469950}, 
    {     0.00000001854,  1.41375949092,     1581.95934828300}, 
    {     0.00000001697,  3.23600230705,      427.56139872250}, 
    {     0.00000001737,  5.45931200885,      916.93228005540}, 
    {     0.00000001714,  6.14712457923,      643.82943957710}, 
    {     0.00000001948,  5.70782269431,      425.63498302950}, 
    {     0.00000001771,  3.36168499135,      248.72381809010}, 
    {     0.00000001612,  0.97888345985,     2001.44399215820}, 
    {     0.00000001970,  2.59656817371,      429.04587143080}, 
    {     0.00000001628,  0.73975250664,      177.87437278590}, 
    {     0.00000001564,  2.04331379709,     1788.14489672020}, 
    {     0.00000001578,  6.02224841728,      426.64637498580}, 
    {     0.00000001938,  5.48121921327,      636.71589257630}, 
    {     0.00000001650,  4.61633270100,      621.73803904930}, 
    {     0.00000001552,  2.55530041483,      692.58748435350}, 
    {     0.00000001484,  6.17153831218,       56.62235130260}, 
    {     0.00000001782,  3.26132698511,      175.16605980020}, 
    {     0.00000001504,  2.59954462117,      228.27694896500}, 
    {     0.00000001559,  0.36279929032,      776.93031047640}, 
    {     0.00000001799,  3.46401859786,     1258.45393162560}, 
    {     0.00000001521,  3.75579841603,      213.51154375910}, 
    {     0.00000001811,  4.37544045833,      213.41097002260}, 
    {     0.00000001521,  0.30205469499,      213.08664711690}, 
    {     0.00000001608,  4.66711444750,      269.92144674060}, 
    {     0.00000001525,  1.47929210450,      198.32124191100}, 
    {     0.00000001408,  1.38479725436,      501.37978944330}, 
    {     0.00000001328,  0.23744796611,      148.07872442630}, 
    {     0.00000001306,  2.41189915346,      275.55052103310}, 
    {     0.00000001578,  2.82446177645,      426.55000676620}, 
    {     0.00000001203,  1.36914857586,      235.39049596580}, 
    {     0.00000001295,  5.75202524600,     1692.16566950240}, 
    {     0.00000001296,  3.04111189978,      831.85574074960}, 
    {     0.00000001283,  1.62385668800,      643.07868005170}, 
    {     0.00000001617,  1.31174745624,      214.78356814630}, 
    {     0.00000001347,  4.01273175674,      278.51946644970}, 
    {     0.00000001166,  0.09627606633,      340.77089204480}, 
    {     0.00000001115,  2.20439351972,      221.37585028530}, 
    {     0.00000001176,  1.07507979885,      312.19908396260}, 
    {     0.00000001107,  1.50336763826,      289.56516671360}, 
    {     0.00000001144,  4.40126055317,      213.55972786890}, 
    {     0.00000001254,  0.21632674588,      404.50679034820}, 
    {     0.00000001081,  3.17372260720,       98.89998852460}, 
    {     0.00000001103,  0.23595226512,      617.80588578620}, 
    {     0.00000001077,  3.51664194540,      312.45971639350}, 
    {     0.00000001040,  0.53952129629,      778.41478318470}, 
    {     0.00000001195,  2.11225017751,      205.22234059070}, 
    {     0.00000001093,  5.16257298332,      630.33605875840}, 
    {     0.00000001144,  5.93977666300,      213.03846300710}, 
    {     0.00000001041,  4.79618391843,      106.27416795630}, 
    {     0.00000001100,  0.02510443195,      219.44943459230}, 
    {     0.00000001311,  5.93851599975,      436.15941843160}, 
    {     0.00000001260,  0.72452520369,      355.74874557180}, 
    {     0.00000000950,  2.00808047619,     1045.15483618760}, 
    {     0.00000001186,  1.84895575360,      151.04766984290}, 
    {     0.00000000974,  3.01097260601,      696.51963761660}, 
    {     0.00000000925,  4.88211292859,       39.35687591520}, 
    {     0.00000000962,  2.80149935780,      738.79727483860}, 
    {     0.00000001011,  6.26998804708,      121.25202148330}, 
    {     0.00000000904,  4.15192741336,      426.07692601420}, 
    {     0.00000000905,  4.24229297080,       10.29494073850}, 
    {     0.00000000895,  2.47587599090,      447.93883187840}, 
    {     0.00000001185,  0.85291199481,      525.49817940060}, 
    {     0.00000000824,  3.97540449663,      210.59078245230}, 
    {     0.00000000831,  4.05257243032,      207.14875628370}, 
    {     0.00000000937,  5.44394998560,      344.70304530790}, 
    {     0.00000000823,  2.08746321895,      358.93013930950}, 
    {     0.00000000971,  5.09552461634,     1589.07289528380}, 
    {     0.00000001037,  1.04137394185,        2.44768055480}, 
    {     0.00000000816,  0.62164413625,      188.92007304980}, 
    {     0.00000000799,  3.36371952944,      237.67811782620}, 
    {     0.00000000755,  5.90949038138,      284.14854074220}, 
    {     0.00000000870,  1.62752216846,      114.13847448250}, 
    {     0.00000000734,  6.23533301101,     2111.65031337760}, 
    {     0.00000000767,  2.73664500903,      627.36711334180}, 
    {     0.00000000702,  0.72502286437,    10213.28554621100}, 
    {     0.00000000802,  5.84200950846,      905.88657979150}, 
    {     0.00000000711,  1.78782570541,     2104.53676637680}, 
    {     0.00000000670,  0.75878091288,     2317.83586181480}, 
    {     0.00000000721,  4.95644466131,      638.41281360570}, 
    {     0.00000000796,  4.87618145458,      342.25536475310}, 
    {     0.00000000835,  3.19493605235,     1574.84580128220}, 
    {     0.00000000703,  0.35096590748,      220.46082654860}, 
    {     0.00000000824,  0.08813665925,      216.00740842370}, 
    {     0.00000000653,  4.19584155890,      247.23934538180}, 
    {     0.00000000826,  4.66851909771,      427.11945573780}, 
    {     0.00000000690,  0.41878008133,     5856.47765911540}, 
    {     0.00000000690,  1.34027763379,     6283.07584999140}, 
    {     0.00000000690,  0.58291546593,      213.45915413240}, 
    {     0.00000000639,  1.20313256921,      867.42347575360}, 
    {     0.00000000830,  1.57245339397,     1898.35121793960}, 
    {     0.00000000753,  1.51134840380,      576.16138801060}, 
    {     0.00000000629,  2.83572587420,      420.96911658350}, 
    {     0.00000000690,  3.48062808501,      213.13903674360}, 
    {     0.00000000600,  5.22938546212,      212.02707105080}, 
    {     0.00000000565,  5.28088109001,      423.67742956920}, 
    {     0.00000000552,  5.83275968368,       84.34282612290}, 
    {     0.00000000546,  3.56643191798,     1485.98012106520}, 
    {     0.00000000698,  1.92018887936,      134.58534360760}, 
    {     0.00000000642,  6.14979274963,      179.35884549420}, 
    {     0.00000000648,  5.15908137311,        8.07675484730}, 
    {     0.00000000551,  3.33126728060,      980.66817835880}, 
    {     0.00000000511,  3.87014193733,      125.98732389850}, 
    {     0.00000000506,  0.80320571787,      181.05576652360}, 
    {     0.00000000564,  4.05855236390,      831.10498122420}, 
    {     0.00000000681,  3.45804381274,      220.36445832900}, 
    {     0.00000000541,  2.39250089139,      421.93232443000}, 
    {     0.00000000499,  3.11511715593,      439.12836384820}, 
    {     0.00000000517,  2.75421533096,     1148.24761040620}, 
    {     0.00000000492,  4.47188785467,      558.00214074590}, 
    {     0.00000000467,  4.18104958104,      444.75743814070}, 
    {     0.00000000458,  0.60793900778,      206.23373254700}, 
    {     0.00000000542,  3.28773751990,      245.54242435240}, 
    {     0.00000000476,  5.48498169187,       35.42472265210}, 
    {     0.00000000473,  2.42624729800,      436.89313161450}, 
    {     0.00000000481,  3.72402124244,      206.13736432740}, 
    {     0.00000000435,  1.61738373338,      191.95845443560}, 
    {     0.00000000488,  0.26044630515,      416.30325013750}, 
    {     0.00000000493,  4.13592086433,      518.64526483070}, 
    {     0.00000000595,  5.11706007934,      214.57111982520}, 
    {     0.00000000485,  5.17582938740,       67.66805156650}, 
    {     0.00000000463,  5.53167637735,      418.52143602870}, 
    {     0.00000000421,  5.57349965100,      430.79097657000}, 
    {     0.00000000446,  6.20659186999,       73.29712585900}, 
    {     0.00000000421,  4.65776470174,      543.02428721890}, 
    {     0.00000000434,  2.95308692533,        5.41662597140}, 
    {     0.00000000416,  4.36421141391,      113.38771495710}, 
    {     0.00000000495,  5.38079175722,      391.17346822390}, 
    {     0.00000000520,  3.99931649474,      618.55664531160}, 
    {     0.00000000436,  1.60973242385,     2214.74308759620}, 
    {     0.00000000429,  3.26913352440,      144.14657116320}, 
    {     0.00000000398,  2.38271972354,      299.12639426920}, 
    {     0.00000000399,  0.06286559226,      206.70681329900}, 
    {     0.00000000394,  2.75546648016,      425.84743135060}, 
    {     0.00000000508,  2.86808537292,      337.73251065900}, 
    {     0.00000000475,  5.68509067131,      320.32402291970}, 
    {     0.00000000432,  0.68163112404,      116.42609634290}, 
    {     0.00000000404,  1.84176320262,     9786.68735533500}, 
    {     0.00000000371,  5.83302263848,     2008.55753915900}, 
    {     0.00000000383,  4.24902896165,      387.24131496080}, 
    {     0.00000000416,  3.81981017953,      429.51895218280}, 
    {     0.00000000491,  4.18581559869,      219.89137757700}, 
    {     0.00000000352,  1.65614871433,      963.40270297140}, 
    {     0.00000000353,  5.50247369979,      305.34616939270}, 
    {     0.00000000431,  4.39270197284,      353.30106501700}, 
    {     0.00000000375,  2.67821771477,      319.57326339430}, 
    {     0.00000000359,  3.54670795682,      421.18156490460}, 
    {     0.00000000340,  5.19168674166,       69.15252427480}, 
    {     0.00000000358,  1.11860953046,     1044.40407666220}, 
    {     0.00000000335,  1.84390801866,     1361.54670584420}, 
    {     0.00000000328,  6.07083706546,      710.74673161820}, 
    {     0.00000000328,  1.48617165814,     2420.92863603340}, 
    {     0.00000000359,  5.62844033096,       78.71375183040}, 
    {     0.00000000406,  2.91427166192,     1891.23767093880}, 
    {     0.00000000398,  2.08904340960,        4.66586644600}, 
    {     0.00000000326,  1.62391387691,        5.62907429250}, 
    {     0.00000000406,  1.87387964143,      114.39910691340}, 
    {     0.00000000393,  0.56483175403,      128.95626931510}, 
    {     0.00000000312,  5.29467337499,      347.88443904560}, 
    {     0.00000000310,  0.31238727781,      427.34895040140}, 
    {     0.00000000308,  2.84951154508,      487.36514376280}, 
    {     0.00000000291,  3.26164407025,      494.26624244250}, 
    {     0.00000000303,  4.94026133382,      373.90799283650}, 
    {     0.00000000289,  6.15818236951,      969.62247809490}, 
    {     0.00000000289,  2.05371431350,      214.52293571540}, 
    {     0.00000000289,  2.83591185309,      212.07525516060}, 
    {     0.00000000398,  6.03816982033,      432.22726516850}, 
    {     0.00000000296,  0.30256895246,     1055.44977692610}, 
    {     0.00000000281,  5.41563930133,     1493.09366806600}, 
    {     0.00000000279,  1.29758402126,      241.61027108930}, 
    {     0.00000000316,  6.24175867183,      465.95506679120}, 
    {     0.00000000274,  5.04030677281,      458.84151979040}, 
    {     0.00000000296,  3.04457317761,      211.60217440860}, 
    {     0.00000000274,  2.72694385790,      145.63104387150}, 
    {     0.00000000293,  1.32510426110,      159.12442469020}, 
    {     0.00000000262,  6.11909674971,     2428.04218303420}, 
    {     0.00000000323,  1.17506470507,      815.06334611420}, 
    {     0.00000000345,  5.37087060064,      428.08266358430}, 
    {     0.00000000259,  0.43312375237,     2634.22773147140}, 
    {     0.00000000275,  0.91523125970,      849.26422848890}, 
    {     0.00000000340,  1.29333224497,      329.72519178090}, 
    {     0.00000000245,  3.52292725422,      184.98791978670}, 
    {     0.00000000294,  4.29357944566,        4.19278569400}, 
    {     0.00000000339,  1.03807224042,       32.24332891440}, 
    {     0.00000000243,  3.12855303383,      525.75881183150}, 
    {     0.00000000260,  5.99230748755,       20.60692781950}, 
    {     0.00000000303,  3.96700505482,      934.94851496820}, 
    {     0.00000000285,  5.69508675378,      220.93390730060}, 
    {     0.00000000239,  2.09555267955,      292.01284726840}, 
    {     0.00000000242,  0.98708611400,      282.45161971280}, 
    {     0.00000000278,  2.81623774774,       87.31177153950}, 
    {     0.00000000236,  5.79564763644,      280.96714700450}, 
    {     0.00000000285,  4.76191845771,       54.17467074780}, 
    {     0.00000000246,  1.83689902078,      214.99601646740}, 
    {     0.00000000238,  3.52746857675,      267.47376618580}, 
    {     0.00000000221,  0.48491368453,      153.49535039770}, 
    {     0.00000000293,  5.91443975841,       14.97785352700}, 
    {     0.00000000234,  0.29943001944,       14.01464568050}, 
    {     0.00000000229,  3.91824487445,      182.27960680100}, 
    {     0.00000000217,  3.96246111595,      894.84087952760}, 
    {     0.00000000219,  1.46332840761,     2531.13495725280}, 
    {     0.00000000210,  2.01138855049,      211.86280683950}, 
    {     0.00000000210,  2.87823761610,      214.73538403650}, 
    {     0.00000000238,  1.85151589425,      221.16340196420}, 
    {     0.00000000224,  2.49627363443,     1464.63948006280}, 
    {     0.00000000209,  2.97668922368,      273.10284047830}, 
    {     0.00000000217,  4.03157211714,      835.03713448730}, 
    {     0.00000000210,  2.56879577970,      593.42686339800}, 
    {     0.00000000218,  1.71986486818,        0.96320784650}, 
    {     0.00000000199,  3.53454927143,      219.66188291340}, 
    {     0.00000000197,  2.65217451107,      864.24208201590}, 
    {     0.00000000219,  3.46298090101,     1182.92157353290}, 
    {     0.00000000199,  2.56032050107,      264.50482076920}, 
    {     0.00000000198,  2.03496428789,      757.21715453420}, 
    {     0.00000000237,  5.05389714734,      254.94359321360}, 
    {     0.00000000191,  2.07085765545,      756.32338265690}, 
    {     0.00000000193,  1.67672523671,     1677.93857550080}, 
    {     0.00000000191,  1.05268402350,      702.14871190910}, 
    {     0.00000000181,  1.89155460161,        6.15033915430}, 
    {     0.00000000182,  1.25399442586,     2737.32050569000}, 
    {     0.00000000204,  1.98013238720,      199.28444975750}, 
    {     0.00000000186,  2.81423428570,      569.04784100980}, 
    {     0.00000000246,  3.55854724228,     1251.34038462480}, 
    {     0.00000000215,  4.52280780251,     3060.82592234740}, 
    {     0.00000000191,  4.20339468962,      556.51766803760}, 
    {     0.00000000216,  2.91269882645,      205.43478891180}, 
    {     0.00000000217,  2.64444506679,     2207.62954059540}, 
    {     0.00000000225,  0.14260206070,      131.40394986990}, 
    {     0.00000000189,  1.26887540631,      192.69216761850}, 
    {     0.00000000179,  6.15317278899,        2.92076130680}, 
    {     0.00000000177,  2.01695854061,      705.11765732570}, 
    {     0.00000000188,  2.92470690680,      227.31374111850}, 
    {     0.00000000181,  3.62240562060,      233.90602325750}, 
    {     0.00000000166,  5.85339140145,      637.44960575920}, 
    {     0.00000000163,  3.50597489635,     1382.88734684660}, 
    {     0.00000000159,  0.13374057204,      431.26405732200}, 
    {     0.00000000158,  5.92245215131,       96.87299909510}, 
    {     0.00000000178,  4.55357947656,       46.47042291600}, 
    {     0.00000000157,  1.36083501113,       51.20572533120}, 
    {     0.00000000155,  6.23981289223,      464.73122651380}, 
    {     0.00000000155,  6.02665412124,     1286.90811962880}, 
    {     0.00000000175,  4.95229737861,     1905.46476494040}, 
    {     0.00000000155,  1.36669731999,      206.93630796260}, 
    {     0.00000000153,  6.05959444754,      561.18353448360}, 
    {     0.00000000209,  4.50587176454,       24.37902238820}, 
    {     0.00000000185,  5.49830792597,      205.66428357540}, 
    {     0.00000000160,  4.18196878857,     3340.61242669980}, 
    {     0.00000000160,  2.85370771355,      209.15449385380}, 
    {     0.00000000161,  4.98116500495,     2648.45482547300}, 
    {     0.00000000152,  0.85402744302,      570.74476203920}, 
    {     0.00000000156,  2.03601440129,      217.44369702220}, 
    {     0.00000000199,  3.54516172322,      533.62311835770}, 
    {     0.00000000192,  3.98017256784,      212.40532356070}, 
    {     0.00000000192,  0.90945359875,      214.19286731530}, 
    {     0.00000000160,  2.51655480826,     3127.31333126180}, 
    {     0.00000000145,  0.93224513634,     1994.33044515740}, 
    {     0.00000000141,  5.66792977216,      120.35824960600}, 
    {     0.00000000141,  3.89020113314,      454.90936652730}, 
    {     0.00000000152,  1.01334637716,     2840.41327990860}, 
    {     0.00000000172,  4.15291117436,        2.96894541660}, 
    {     0.00000000146,  5.26793940136,        7.06536289100}, 
    {     0.00000000177,  0.43379056817,      140.00196957900}, 
    {     0.00000000144,  3.95680110529,      300.61086697750}, 
    {     0.00000000152,  4.29519544232,      555.55446019110}, 
    {     0.00000000143,  4.15384555539,       31.01948863700}, 
    {     0.00000000139,  0.79816062945,      166.82867252200}, 
    {     0.00000000138,  4.20351932278,      731.94436026870}, 
    {     0.00000000135,  1.27076215169,       92.94084583200}, 
    {     0.00000000165,  1.95234114570,      107.02492748170}, 
    {     0.00000000153,  3.07459476684,     3480.31056622260}, 
    {     0.00000000125,  3.41715448905,     1802.37199072180}, 
    {     0.00000000128,  5.83871918040,     2324.94940881560}, 
    {     0.00000000129,  2.76004244710,      480.77286162380}, 
    {     0.00000000122,  4.75255632197,     2854.64037391020}, 
    {     0.00000000129,  4.67728640900,      913.96333463880}, 
    {     0.00000000146,  3.71120275400,      546.95644048200}, 
    {     0.00000000121,  1.19996163830,      572.22923474750}, 
    {     0.00000000119,  4.58843728974,      339.28641933650}, 
    {     0.00000000127,  6.19604979468,       59.80374504030}, 
    {     0.00000000123,  5.98410087513,      477.80391620720}, 
    {     0.00000000122,  5.83022118428,      990.22940591440}, 
    {     0.00000000151,  2.39461871323,     2524.02141025200}, 
    {     0.00000000147,  4.98185357367,      850.01498801430}, 
    {     0.00000000127,  0.47350572564,        6.59228213900}, 
    {     0.00000000116,  4.71520095067,     1130.23137549340}, 
    {     0.00000000129,  5.42390176195,     2538.24850425360}, 
    {     0.00000000111,  4.51407828148,     1699.27921650320}, 
    {     0.00000000112,  4.14868763908,      422.40540518200}, 
    {     0.00000000114,  2.06498377101,      952.09637027660}, 
    {     0.00000000111,  5.53282324077,      857.12853501510}, 
    {     0.00000000109,  3.00010064569,      420.44785172170}, 
    {     0.00000000112,  2.20703498575,      395.57870223900}, 
    {     0.00000000147,  1.52595534648,      552.58551477450}, 
    {     0.00000000117,  5.47540280598,     2957.73314812880}, 
    {     0.00000000112,  2.57013750439,      462.02291352810}, 
    {     0.00000000122,  4.96297462820,      638.93407846750}, 
    {     0.00000000104,  1.91100566417,      472.17484191470}, 
    {     0.00000000116,  2.82952794316,      450.97721326420}, 
    {     0.00000000115,  2.25851835662,     1781.03134971940}, 
    {     0.00000000110,  4.86686492403,     2914.01423582380}, 
    {     0.00000000109,  4.43985900785,      405.99126305650}, 
    {     0.00000000102,  5.90339898565,       99.91138048090}, 
    {     0.00000000101,  2.53384198507,      640.86049416050}, 
    {     0.00000000099,  5.92243081537,      411.62033734900}, 
    {     0.00000000112,  5.53973044575,      381.35160823740}, 
    {     0.00000000100,  5.21941099435,      426.48631629140}, 
    {     0.00000000137,  2.20274006149,        7.16173111060}, 
    {     0.00000000098,  1.28529782746,     2847.52682690940}, 
    {     0.00000000116,  5.23339044745,     1119.18567522950}, 
    {     0.00000000095,  4.26064274880,      540.73666535850}, 
    {     0.00000000098,  5.27111748177,      639.94547042380}, 
    {     0.00000000107,  4.38928414646,      412.58354519550}, 
    {     0.00000000093,  5.35804852851,      334.55111692130}, 
    {     0.00000000094,  1.16752767262,     5643.17856367740}, 
    {     0.00000000106,  4.19024947696,      486.40193591630}, 
    {     0.00000000096,  0.59550056424,      714.67888488130}, 
    {     0.00000000094,  0.54288367991,      423.62924545940}, 
    {     0.00000000110,  2.82868370028,      468.24268865160}, 
    {     0.00000000083,  6.12463094765,      380.12776796000}, 
    {     0.00000000084,  2.20225020879,      909.81873305460}, 
    {     0.00000000105,  2.66527620584,      460.53844081980}, 
    {     0.00000000085,  5.20920130922,      562.14674233010}, 
    {     0.00000000084,  0.14539857176,      681.54178408960}, 
    {     0.00000000080,  3.03593152930,      409.92341631960}, 
    {     0.00000000096,  5.09479638103,       92.04707395470}, 
    {     0.00000000110,  2.03631813918,      642.34496686880}, 
    {     0.00000000080,  5.71278977344,      361.37781986430}, 
    {     0.00000000084,  3.00961145051,      426.81063919710}, 
    {     0.00000000085,  4.28770375675,      135.54855145410}, 
    {     0.00000000092,  5.33175140498,      432.01481684740}, 
    {     0.00000000084,  5.83905303666,      426.38574255490}, 
    {     0.00000000086,  1.51279442193,      760.25553592000}, 
    {     0.00000000100,  3.62925349282,      426.71006546060}, 
    {     0.00000000098,  2.07358165085,      639.84910220420}, 
    {     0.00000000093,  4.30269200820,     3377.21779200400}, 
    {     0.00000000075,  2.89079162661,      806.72595883600}, 
    {     0.00000000072,  4.85280339422,      392.65794093220}, 
    {     0.00000000080,  4.11844342601,      774.48262992160}, 
    {     0.00000000080,  0.88340921666,      856.37777548970}, 
    {     0.00000000083,  0.11455345099,      402.21916848780}, 
};


static const struct ln_vsop saturn_latitude_b1[LAT_B1] = {
    {     0.00198927992,  4.93901017903,      213.29909543800}, 
    {     0.00036947916,  3.14159265359,        0.00000000000}, 
    {     0.00017966989,  0.51979431110,      426.59819087600}, 
    {     0.00010919721,  1.79463271368,      220.41264243880}, 
    {     0.00013320265,  2.26481519893,      206.18554843720}, 
    {     0.00003243428,  1.21094033148,      419.48464387520}, 
    {     0.00002900519,  6.17033461979,      639.89728631400}, 
    {     0.00001584712,  0.93416397130,      433.71173787680}, 
    {     0.00001580666,  3.08171717435,        7.11354700080}, 
    {     0.00000700659,  0.20545152078,      316.39186965660}, 
    {     0.00000310902,  4.38351712708,      110.20632121940}, 
    {     0.00000301237,  1.66219956459,      227.52618943960}, 
    {     0.00000303761,  5.46322830151,      853.19638175200}, 
    {     0.00000259878,  3.93026240568,      103.09277421860}, 
    {     0.00000252673,  0.90020925210,      632.78373931320}, 
    {     0.00000182664,  0.12142438148,      647.01083331480}, 
    {     0.00000157532,  2.42607457234,      199.07200143640}, 
    {     0.00000108184,  1.39896246207,      529.69096509460}, 
    {     0.00000088301,  2.17503185037,      323.50541665740}, 
    {     0.00000086875,  2.91365320786,       14.22709400160}, 
    {     0.00000093226,  2.44314958040,      217.23124870110}, 
    {     0.00000076217,  2.73666477702,      210.11770170030}, 
    {     0.00000067406,  1.49053395808,      209.36694217490}, 
    {     0.00000069585,  1.31682001912,      216.48048917570}, 
    {     0.00000053865,  1.74961587267,      202.25339517410}, 
    {     0.00000048657,  0.85586786255,      440.82528487760}, 
    {     0.00000038289,  2.90107344056,      117.31986822020}, 
    {     0.00000030566,  1.28845522495,      412.37109687440}, 
    {     0.00000027841,  4.74764197119,     1066.49547719000}, 
    {     0.00000032708,  2.21818450520,      224.34479570190}, 
    {     0.00000018822,  5.62219514688,      860.30992875280}, 
    {     0.00000019503,  0.67017561839,      846.08283475120}, 
    {     0.00000016933,  1.19325749663,      536.80451209540}, 
    {     0.00000016367,  1.21661206395,       95.97922721780}, 
    {     0.00000018612,  1.22520531243,      309.27832265580}, 
    {     0.00000013682,  4.73321416332,      522.57741809380}, 
    {     0.00000015156,  4.69967052480,       11.04570026390}, 
    {     0.00000011499,  4.14138196473,      415.55249061210}, 
    {     0.00000012837,  2.81845968681,      742.99006053260}, 
    {     0.00000013649,  0.41098020093,      422.66603761290}, 
    {     0.00000010540,  1.81501295981,      330.61896365820}, 
    {     0.00000010912,  1.85613282527,      423.41679713830}, 
    {     0.00000009472,  1.51137573235,       63.73589830340}, 
    {     0.00000008741,  3.12101135745,      625.67019231240}, 
    {     0.00000009441,  0.52002672064,      429.77958461370}, 
    {     0.00000008971,  3.23483186571,      277.03499374140}, 
    {     0.00000007026,  2.45348926519,      430.53034413910}, 
    {     0.00000007163,  4.60387223265,      215.74677599280}, 
    {     0.00000006468,  2.17426030779,      490.33408917940}, 
    {     0.00000006287,  1.51913918673,      234.63973644040}, 
    {     0.00000006166,  0.07222081964,      654.12438031560}, 
    {     0.00000006137,  0.42127140031,      149.56319713460}, 
    {     0.00000007021,  1.75650013390,      437.64389113990}, 
    {     0.00000005019,  5.76559473909,      210.85141488320}, 
    {     0.00000004119,  2.71283218857,        3.18139373770}, 
    {     0.00000003872,  2.99849704980,      949.17560896980}, 
    {     0.00000003675,  5.11600747801,        3.93215326310}, 
    {     0.00000003776,  2.46233837693,     1059.38193018920}, 
    {     0.00000003317,  4.69110070363,      628.85158605010}, 
    {     0.00000003682,  1.19319192495,      223.59403617650}, 
    {     0.00000002680,  3.45355844691,      351.81659230870}, 
    {     0.00000002571,  3.96363456369,     1162.47470440780}, 
    {     0.00000002995,  5.02864811906,      515.46387109300}, 
    {     0.00000003293,  2.33138968543,      956.28915597060}, 
    {     0.00000002415,  2.75650699799,       21.34064100240}, 
    {     0.00000002425,  4.06403215903,     1279.79457262800}, 
    {     0.00000002265,  5.12930941938,      735.87651353180}, 
    {     0.00000002062,  2.91053926178,      203.00415469950}, 
    {     0.00000001990,  5.59520905528,      203.73786788240}, 
    {     0.00000002031,  0.36328856534,      750.10360753340}, 
    {     0.00000001928,  0.86086932932,      408.43894361130}, 
    {     0.00000001903,  1.60746671833,      124.43341522100}, 
    {     0.00000001744,  1.16412193121,       88.86568021700}, 
    {     0.00000001824,  4.86628565112,     1073.60902419080}, 
    {     0.00000002258,  1.66916684346,      138.51749687070}, 
    {     0.00000001563,  6.18545235125,      362.86229257260}, 
    {     0.00000001572,  1.84255832998,      137.03302416240}, 
    {     0.00000001433,  5.47301146569,      217.96496188400}, 
    {     0.00000001593,  0.97421002648,      543.91805909620}, 
    {     0.00000001897,  5.87304157924,      635.96513305090}, 
    {     0.00000001414,  4.02297218519,      728.76296653100}, 
    {     0.00000001386,  2.89672561287,      231.45834270270}, 
    {     0.00000001410,  0.01654408493,     1052.26838318840}, 
    {     0.00000001478,  5.55770825875,      483.22054217860}, 
    {     0.00000001722,  3.44514721962,      838.96928775040}, 
    {     0.00000001218,  3.76245757391,     1478.86657406440}, 
    {     0.00000001219,  2.99492994498,       74.78159856730}, 
    {     0.00000001395,  2.44044866819,      340.77089204480}, 
    {     0.00000001502,  0.37510741765,      127.47179660680}, 
    {     0.00000001391,  3.76629584219,      703.63318461740}, 
    {     0.00000001390,  3.97218003624,      195.13984817330}, 
    {     0.00000001438,  4.85759262158,      208.63322899200}, 
    {     0.00000001148,  0.73433808719,      447.93883187840}, 
    {     0.00000001439,  3.72246499569,      350.33211960040}, 
    {     0.00000001070,  1.49161749546,      218.71572140940}, 
    {     0.00000000972,  1.32032644773,      210.37833413120}, 
    {     0.00000000933,  5.03088016698,      497.44763618020}, 
    {     0.00000001120,  6.03447039073,      191.20769491020}, 
    {     0.00000001012,  2.47272744720,      200.76892246580}, 
    {     0.00000000904,  5.29750627971,      207.67002114550}, 
    {     0.00000000917,  1.38330137048,      636.71589257630}, 
    {     0.00000000888,  2.70253210128,      554.06998748280}, 
    {     0.00000000877,  4.73964021792,      424.15051032120}, 
    {     0.00000000869,  4.30586222071,      222.86032299360}, 
    {     0.00000000972,  1.21745387645,      650.94298657790}, 
    {     0.00000000795,  5.25157958165,      214.26230328450}, 
    {     0.00000001057,  6.01807983373,      643.07868005170}, 
    {     0.00000000815,  2.85642232089,      191.95845443560}, 
    {     0.00000001064,  0.66975646323,       85.82729883120}, 
    {     0.00000000790,  6.10916408265,      265.98929347750}, 
    {     0.00000000762,  3.00363704123,       38.13303563780}, 
    {     0.00000000789,  3.01319859815,     1375.77379984580}, 
    {     0.00000000825,  6.27068316984,       76.26607127560}, 
    {     0.00000000744,  3.54889644845,      388.46515523820}, 
    {     0.00000000747,  2.45543129686,       10.29494073850}, 
    {     0.00000000794,  1.51719014468,      212.33588759150}, 
    {     0.00000000818,  2.37164551834,     1272.68102562720}, 
    {     0.00000000706,  3.57651408795,       18.15924726470}, 
    {     0.00000000802,  1.43897948799,     1169.58825140860}, 
    {     0.00000000805,  2.38534169381,      207.88246946660}, 
    {     0.00000000692,  5.66062877642,      867.42347575360}, 
    {     0.00000000734,  5.32576293330,      565.11568774670}, 
    {     0.00000000679,  5.84446735833,      288.08069400530}, 
    {     0.00000000671,  4.72924743617,      842.15068148810}, 
    {     0.00000000631,  0.75007555324,      142.44965013380}, 
    {     0.00000000666,  6.00233055509,     1368.66025284500}, 
    {     0.00000000663,  1.84236582113,      213.34727954780}, 
    {     0.00000000613,  3.17262568619,     1265.56747862640}, 
    {     0.00000000573,  0.33317816431,      621.73803904930}, 
    {     0.00000000664,  4.72617875679,      831.85574074960}, 
    {     0.00000000611,  2.56279664042,      160.60889739850}, 
    {     0.00000000566,  0.22986063298,      302.16477565500}, 
    {     0.00000000625,  6.10561287765,      209.10630974400}, 
    {     0.00000000675,  0.88783155497,      417.03696332040}, 
    {     0.00000000550,  4.21628927155,     1155.36115740700}, 
    {     0.00000000661,  0.03876588911,      269.92144674060}, 
    {     0.00000000627,  5.21555085323,      942.06206196900}, 
    {     0.00000000606,  4.97367692956,      218.92816973050}, 
    {     0.00000000662,  4.92733502195,      213.25091132820}, 
    {     0.00000000489,  3.49259680997,     1795.25844372100}, 
    {     0.00000000522,  1.52842269561,      479.28838891550}, 
    {     0.00000000600,  4.26053473889,       52.69019803950}, 
    {     0.00000000589,  1.25789673267,      225.82926841020}, 
    {     0.00000000535,  0.62683535518,      436.89313161450}, 
    {     0.00000000534,  1.15876642524,      337.73251065900}, 
    {     0.00000000629,  2.68309212494,      216.21985674480}, 
    {     0.00000000439,  4.59511724407,      235.39049596580}, 
    {     0.00000000427,  2.10428034280,      416.30325013750}, 
    {     0.00000000546,  2.37009249380,      643.82943957710}, 
    {     0.00000000421,  2.66620995581,      404.50679034820}, 
    {     0.00000000420,  1.52849987998,       56.62235130260}, 
    {     0.00000000397,  3.53071543409,     1045.15483618760}, 
    {     0.00000000470,  1.08983824027,      344.70304530790}, 
    {     0.00000000465,  4.40789299623,      429.04587143080}, 
    {     0.00000000359,  4.43392625322,      219.44943459230}, 
    {     0.00000000388,  0.65988376162,      358.93013930950}, 
    {     0.00000000372,  0.84093856644,       22.09140052780}, 
    {     0.00000000350,  6.28201928387,      212.77783057620}, 
    {     0.00000000355,  2.58258544797,      563.63121503840}, 
    {     0.00000000335,  0.93473132492,     1485.98012106520}, 
    {     0.00000000364,  1.16006460025,       70.84944530420}, 
    {     0.00000000349,  0.48985168153,      213.82036029980}, 
    {     0.00000000302,  4.21736561965,      284.14854074220}, 
    {     0.00000000305,  6.11901036200,        1.48447270830}, 
    {     0.00000000305,  2.23436929835,      444.75743814070}, 
    {     0.00000000320,  4.77954182227,      212.54833591260}, 
    {     0.00000000292,  0.77360901796,      757.21715453420}, 
    {     0.00000000303,  2.64780088849,      113.38771495710}, 
    {     0.00000000290,  3.95615953692,     1471.75302706360}, 
    {     0.00000000290,  3.79526794850,       12.53017297220}, 
    {     0.00000000264,  6.03067553053,      934.94851496820}, 
    {     0.00000000258,  2.98397544655,      106.27416795630}, 
    {     0.00000000273,  5.03143616470,      251.43213107580}, 
    {     0.00000000316,  5.06312049223,     1258.45393162560}, 
    {     0.00000000262,  3.22202079840,      916.93228005540}, 
    {     0.00000000252,  5.71472218120,     1685.05212250160}, 
    {     0.00000000231,  3.07386470105,     1361.54670584420}, 
    {     0.00000000263,  5.94315698498,      618.55664531160}, 
    {     0.00000000267,  4.48240400758,     1148.24761040620}, 
    {     0.00000000268,  0.02885423751,      207.14875628370}, 
    {     0.00000000304,  3.82756071659,      217.49188113200}, 
    {     0.00000000217,  2.97086411233,     1692.16566950240}, 
    {     0.00000000235,  4.69585016895,      696.51963761660}, 
    {     0.00000000213,  1.00568423000,      114.39910691340}, 
    {     0.00000000217,  5.15304621208,      220.46082654860}, 
    {     0.00000000269,  4.96401915824,     1574.84580128220}, 
    {     0.00000000235,  2.63847496179,      355.74874557180}, 
    {     0.00000000200,  4.52267084558,      508.35032409220}, 
    {     0.00000000218,  5.38075659660,      245.54242435240}, 
    {     0.00000000192,  3.35237783766,     2111.65031337760}, 
    {     0.00000000229,  1.63754079808,     1589.07289528380}, 
    {     0.00000000251,  4.10813396939,        9.56122755560}, 
    {     0.00000000202,  4.69607229482,      107.02492748170}, 
    {     0.00000000173,  1.59764169255,     6069.77675455340}, 
    {     0.00000000191,  4.73261052600,      121.25202148330}, 
    {     0.00000000207,  1.92813876017,     2420.92863603340}, 
    {     0.00000000191,  5.84855063985,      181.05576652360}, 
    {     0.00000000164,  5.21783359224,      414.06801790380}, 
    {     0.00000000202,  2.29783143388,     1677.93857550080}, 
    {     0.00000000162,  5.51123664884,      576.16138801060}, 
    {     0.00000000161,  3.02107979424,      248.72381809010}, 
    {     0.00000000191,  2.28684786322,     2435.15573003500}, 
    {     0.00000000157,  3.63748850914,     1788.14489672020}, 
    {     0.00000000152,  1.86243245336,      177.87437278590}, 
    {     0.00000000164,  1.00473920687,        4.66586644600}, 
    {     0.00000000169,  3.27701894896,     1493.09366806600}, 
    {     0.00000000151,  5.10275814573,      501.37978944330}, 
    {     0.00000000173,  4.01045552060,       98.89998852460}, 
    {     0.00000000158,  3.11393392977,     2008.55753915900}, 
    {     0.00000000147,  4.27669780086,      710.74673161820}, 
    {     0.00000000147,  0.67882060260,      425.11371816770}, 
    {     0.00000000154,  5.37147054362,      148.07872442630}, 
    {     0.00000000170,  0.18576682177,      151.04766984290}, 
    {     0.00000000153,  6.11985601662,      206.13736432740}, 
    {     0.00000000169,  2.77293672089,     1781.03134971940}, 
    {     0.00000000137,  1.44843193937,      131.54696222180}, 
    {     0.00000000168,  5.92342908737,      173.94221952280}, 
    {     0.00000000158,  3.55883885624,     1581.95934828300}, 
    {     0.00000000184,  4.62097049709,     1891.23767093880}, 
    {     0.00000000134,  3.91403282954,      114.13847448250}, 
    {     0.00000000127,  3.70533738666,      436.15941843160}, 
    {     0.00000000135,  4.66039870198,      778.41478318470}, 
    {     0.00000000129,  5.91798218618,      963.40270297140}, 
    {     0.00000000131,  3.92478528327,      421.93232443000}, 
    {     0.00000000120,  0.55800628755,     1802.37199072180}, 
    {     0.00000000125,  5.47463165452,     2001.44399215820}, 
    {     0.00000000120,  0.70246037996,       81.75213321620}, 
    {     0.00000000114,  4.06514981999,     1286.90811962880}, 
    {     0.00000000103,  2.85758217373,     2428.04218303420}, 
    {     0.00000000110,  5.49603517952,      601.76425067620}, 
    {     0.00000000099,  4.66798566120,      431.26405732200}, 
    {     0.00000000135,  5.19983204299,      849.26422848890}, 
    {     0.00000000118,  2.58641645913,      525.49817940060}, 
    {     0.00000000101,  6.08443910077,      558.00214074590}, 
    {     0.00000000092,  5.92766532505,      175.16605980020}, 
    {     0.00000000099,  4.42902114690,     2317.83586181480}, 
    {     0.00000000099,  4.19847910689,      776.93031047640}, 
    {     0.00000000090,  4.83969848370,     2214.74308759620}, 
    {     0.00000000090,  6.25429035515,      661.23792731640}, 
    {     0.00000000088,  0.53030468857,     1382.88734684660}, 
    {     0.00000000086,  5.60357922616,      289.56516671360}, 
    {     0.00000000093,  4.23197698724,      767.36908292080}, 
    {     0.00000000084,  1.27340099422,     2531.13495725280}, 
    {     0.00000000091,  1.34171959952,      421.18156490460}, 
    {     0.00000000075,  3.24680455233,      488.84961647110}, 
    {     0.00000000072,  3.94806470747,      637.44960575920}, 
    {     0.00000000075,  4.01647621073,      432.22726516850}, 
};


static const struct ln_vsop saturn_latitude_b2[LAT_B2] = {
    {     0.00013884264,  0.08994998691,      213.29909543800}, 
    {     0.00003075713,  3.91610937620,      206.18554843720}, 
    {     0.00002081666,  0.09631968077,      220.41264243880}, 
    {     0.00001452574,  5.48867576013,      426.59819087600}, 
    {     0.00000546808,  2.94585826799,      419.48464387520}, 
    {     0.00000391398,  5.43939792344,      433.71173787680}, 
    {     0.00000319740,  4.34820275048,      639.89728631400}, 
    {     0.00000203518,  1.37396136744,        7.11354700080}, 
    {     0.00000220164,  0.00000000000,        0.00000000000}, 
    {     0.00000116719,  6.24505924943,      227.52618943960}, 
    {     0.00000067605,  1.75135990376,      316.39186965660}, 
    {     0.00000064044,  4.10904350356,      199.07200143640}, 
    {     0.00000055518,  4.56815095513,      647.01083331480}, 
    {     0.00000049875,  3.48944345784,      853.19638175200}, 
    {     0.00000038984,  2.79930428520,      632.78373931320}, 
    {     0.00000027643,  1.22439852303,       14.22709400160}, 
    {     0.00000024804,  4.48123972552,      210.11770170030}, 
    {     0.00000021498,  5.38853499774,      440.82528487760}, 
    {     0.00000015704,  4.28129850675,      217.23124870110}, 
    {     0.00000019538,  5.81992746567,      216.48048917570}, 
    {     0.00000014472,  1.71327951628,      110.20632121940}, 
    {     0.00000012290,  4.06067197339,      103.09277421860}, 
    {     0.00000010826,  0.58425778734,      323.50541665740}, 
    {     0.00000011875,  2.95672558940,      412.37109687440}, 
    {     0.00000010534,  2.51484815706,      529.69096509460}, 
    {     0.00000007971,  1.29072033406,      117.31986822020}, 
    {     0.00000009046,  5.92757785737,      209.36694217490}, 
    {     0.00000006820,  3.73629063516,      860.30992875280}, 
    {     0.00000005266,  3.17424271177,      202.25339517410}, 
    {     0.00000006316,  2.70918854345,     1066.49547719000}, 
    {     0.00000004648,  3.40943979533,      309.27832265580}, 
    {     0.00000003657,  6.10028538147,      234.63973644040}, 
    {     0.00000003034,  3.00141076688,       95.97922721780}, 
    {     0.00000002964,  4.75918273840,      625.67019231240}, 
    {     0.00000002831,  3.72837340664,      423.41679713830}, 
    {     0.00000003060,  4.54921839566,      654.12438031560}, 
    {     0.00000003173,  4.93945460684,      429.77958461370}, 
    {     0.00000002517,  2.84610096404,      846.08283475120}, 
    {     0.00000002755,  0.11130771173,      330.61896365820}, 
    {     0.00000002476,  5.80520556780,      536.80451209540}, 
    {     0.00000002579,  4.80701288066,      422.66603761290}, 
    {     0.00000002252,  0.09608234743,      522.57741809380}, 
    {     0.00000002036,  0.29468198549,      224.34479570190}, 
    {     0.00000001945,  5.61183319602,      735.87651353180}, 
    {     0.00000001649,  6.17255863554,      415.55249061210}, 
    {     0.00000001711,  5.68150133024,      223.59403617650}, 
    {     0.00000001223,  1.07126086594,       21.34064100240}, 
    {     0.00000001510,  1.50174476287,      742.99006053260}, 
    {     0.00000001070,  4.69201775284,      203.00415469950}, 
    {     0.00000001097,  4.44901307448,      430.53034413910}, 
    {     0.00000000959,  0.29003331127,        3.93215326310}, 
    {     0.00000001219,  4.89549127087,      277.03499374140}, 
    {     0.00000000780,  6.11668251851,      124.43341522100}, 
    {     0.00000000810,  5.92587997397,      437.64389113990}, 
    {     0.00000000711,  0.87489137869,        3.18139373770}, 
    {     0.00000000703,  2.88322689246,       88.86568021700}, 
    {     0.00000000741,  5.28664451824,      447.93883187840}, 
    {     0.00000000797,  0.38839628271,      515.46387109300}, 
    {     0.00000000648,  2.16863760555,     1059.38193018920}, 
    {     0.00000000770,  3.01019419227,     1073.60902419080}, 
    {     0.00000000646,  4.44476999591,      191.95845443560}, 
    {     0.00000000763,  4.45009347392,       11.04570026390}, 
    {     0.00000000520,  5.46724081186,      149.56319713460}, 
    {     0.00000000495,  5.65080506007,      728.76296653100}, 
    {     0.00000000572,  1.93890743211,     1279.79457262800}, 
    {     0.00000000413,  2.87450257144,      408.43894361130}, 
    {     0.00000000432,  0.45412432082,      956.28915597060}, 
    {     0.00000000388,  4.94447690735,      949.17560896980}, 
    {     0.00000000360,  6.13193432237,       63.73589830340}, 
    {     0.00000000351,  5.97838746664,      215.74677599280}, 
    {     0.00000000432,  4.88617490870,      838.96928775040}, 
    {     0.00000000308,  5.01490854649,     1052.26838318840}, 
    {     0.00000000303,  1.38736789277,      231.45834270270}, 
    {     0.00000000348,  5.56256651070,      543.91805909620}, 
    {     0.00000000283,  3.29371245264,      490.33408917940}, 
    {     0.00000000293,  3.95078933984,      635.96513305090}, 
    {     0.00000000273,  0.60520392704,       10.29494073850}, 
    {     0.00000000250,  4.80069153282,       74.78159856730}, 
    {     0.00000000281,  4.89543546695,      750.10360753340}, 
    {     0.00000000242,  2.03148855332,     1471.75302706360}, 
    {     0.00000000274,  3.74993232264,      867.42347575360}, 
    {     0.00000000259,  4.13047010772,      643.07868005170}, 
    {     0.00000000216,  0.80763325373,      210.85141488320}, 
    {     0.00000000206,  0.17095872111,      195.13984817330}, 
    {     0.00000000197,  2.31774972985,       18.15924726470}, 
    {     0.00000000250,  4.46843768407,      302.16477565500}, 
    {     0.00000000171,  5.71503506984,     1169.58825140860}, 
    {     0.00000000184,  1.22063055823,      203.73786788240}, 
    {     0.00000000150,  3.38891097774,      636.71589257630}, 
    {     0.00000000183,  0.96894551644,      483.22054217860}, 
    {     0.00000000188,  0.97246012795,     1375.77379984580}, 
    {     0.00000000150,  0.21152728512,     1898.35121793960}, 
    {     0.00000000141,  5.87565118609,      618.55664531160}, 
    {     0.00000000135,  4.89760499349,      436.89313161450}, 
    {     0.00000000119,  3.69061152320,     1581.95934828300}, 
    {     0.00000000128,  4.55726731141,     1162.47470440780}, 
    {     0.00000000108,  3.68308754111,      416.30325013750}, 
    {     0.00000000122,  0.02813545121,      831.85574074960}, 
    {     0.00000000102,  3.40993719364,      497.44763618020}, 
    {     0.00000000136,  3.20634132887,     1155.36115740700}, 
    {     0.00000000115,  3.85804239112,     1265.56747862640}, 
    {     0.00000000103,  5.21716051597,      650.94298657790}, 
    {     0.00000000116,  0.26089900561,     1258.45393162560}, 
    {     0.00000000099,  4.22617563970,      362.86229257260}, 
    {     0.00000000097,  2.73570765102,     1368.66025284500}, 
    {     0.00000000093,  0.38836049436,      942.06206196900}, 
    {     0.00000000081,  4.68801853439,      351.81659230870}, 
    {     0.00000000094,  4.53448741145,      628.85158605010}, 
    {     0.00000000078,  5.47626971516,      337.73251065900}, 
    {     0.00000000102,  0.47334815662,     1272.68102562720}, 
    {     0.00000000073,  2.04208824417,      621.73803904930}, 
};


static const struct ln_vsop saturn_latitude_b3[LAT_B3] = {
    {     0.00000463357,  1.69194209337,      213.29909543800}, 
    {     0.00000487242,  5.57827705588,      206.18554843720}, 
    {     0.00000270686,  4.65445792593,      220.41264243880}, 
    {     0.00000277451,  0.00000000000,        0.00000000000}, 
    {     0.00000066718,  3.66337287998,      433.71173787680}, 
    {     0.00000065617,  4.71263096227,      419.48464387520}, 
    {     0.00000069846,  3.33236270677,      426.59819087600}, 
    {     0.00000030551,  4.53651131935,      227.52618943960}, 
    {     0.00000029704,  2.49374065388,      639.89728631400}, 
    {     0.00000018157,  5.89401285772,        7.11354700080}, 
    {     0.00000017504,  5.79120992263,      199.07200143640}, 
    {     0.00000011684,  2.74773493978,      647.01083331480}, 
    {     0.00000006048,  5.80237729519,       14.22709400160}, 
    {     0.00000006248,  1.60565634016,      853.19638175200}, 
    {     0.00000006420,  3.63996599914,      440.82528487760}, 
    {     0.00000004552,  6.21266119922,      210.11770170030}, 
    {     0.00000004995,  3.21953122449,      316.39186965660}, 
    {     0.00000004166,  4.64321479214,      632.78373931320}, 
    {     0.00000002938,  4.64767028200,      412.37109687440}, 
    {     0.00000002894,  4.02023147538,      216.48048917570}, 
    {     0.00000002225,  0.67809668672,      103.09277421860}, 
    {     0.00000001694,  1.86898759241,      860.30992875280}, 
    {     0.00000001394,  4.39486147395,      234.63973644040}, 
    {     0.00000001272,  5.87144755894,      217.23124870110}, 
    {     0.00000001132,  5.91391008745,      117.31986822020}, 
    {     0.00000000984,  0.89291344192,     1066.49547719000}, 
    {     0.00000000848,  5.10998113739,      323.50541665740}, 
    {     0.00000001018,  2.76708857895,      654.12438031560}, 
    {     0.00000000844,  5.65924574483,      309.27832265580}, 
    {     0.00000000631,  3.09293087763,      429.77958461370}, 
    {     0.00000000524,  0.12316698689,      625.67019231240}, 
    {     0.00000000548,  0.64455286234,      110.20632121940}, 
    {     0.00000000484,  5.32908334165,      202.25339517410}, 
    {     0.00000000511,  4.72373936399,      330.61896365820}, 
    {     0.00000000451,  3.89411630776,      223.59403617650}, 
    {     0.00000000395,  5.60471716690,       21.34064100240}, 
    {     0.00000000441,  4.83224059479,       95.97922721780}, 
    {     0.00000000348,  6.09514028242,      191.95845443560}, 
    {     0.00000000277,  4.37382373255,      529.69096509460}, 
    {     0.00000000276,  4.66453225056,      209.36694217490}, 
    {     0.00000000291,  3.74809602199,      447.93883187840}, 
    {     0.00000000231,  4.32361342543,      124.43341522100}, 
    {     0.00000000240,  4.17865323637,      536.80451209540}, 
    {     0.00000000216,  0.94023041295,      735.87651353180}, 
    {     0.00000000215,  4.63069992131,      846.08283475120}, 
    {     0.00000000253,  5.83932336956,      302.16477565500}, 
    {     0.00000000180,  4.66973939257,      224.34479570190}, 
    {     0.00000000232,  0.72016647797,      203.00415469950}, 
    {     0.00000000182,  4.63702652869,       88.86568021700}, 
    {     0.00000000169,  1.51271620453,      522.57741809380}, 
    {     0.00000000169,  5.79435475585,      423.41679713830}, 
    {     0.00000000133,  2.98510523287,      422.66603761290}, 
    {     0.00000000128,  1.05737228351,     1073.60902419080}, 
    {     0.00000000076,  6.23861369445,     1279.79457262800}, 
};


static const struct ln_vsop saturn_latitude_b4[LAT_B4] = {
    {     0.00000058521,  0.96404269672,      206.18554843720}, 
    {     0.00000027023,  2.97511812746,      213.29909543800}, 
    {     0.00000027345,  2.90816987834,      220.41264243880}, 
    {     0.00000008709,  1.88638219079,      433.71173787680}, 
    {     0.00000006015,  2.81931276694,      227.52618943960}, 
    {     0.00000006059,  0.21576562475,      419.48464387520}, 
    {     0.00000003796,  1.19723799579,      199.07200143640}, 
    {     0.00000003647,  1.71327650497,      426.59819087600}, 
    {     0.00000002054,  0.66410894553,      639.89728631400}, 
    {     0.00000002559,  3.14159265359,        0.00000000000}, 
    {     0.00000001867,  0.93578719925,      647.01083331480}, 
    {     0.00000001256,  4.13175992780,        7.11354700080}, 
    {     0.00000001399,  1.88853247568,      440.82528487760}, 
    {     0.00000000936,  4.08790738476,       14.22709400160}, 
    {     0.00000000618,  6.23879306520,      853.19638175200}, 
    {     0.00000000372,  0.27149825756,      412.37109687440}, 
    {     0.00000000332,  2.65677859091,      234.63973644040}, 
    {     0.00000000247,  0.25604474898,      632.78373931320}, 
    {     0.00000000212,  0.03063135059,      860.30992875280}, 
    {     0.00000000162,  4.96348549494,      117.31986822020}, 
    {     0.00000000129,  0.09615721074,      110.20632121940}, 
    {     0.00000000146,  1.02713520383,      654.12438031560}, 
    {     0.00000000081,  1.92779115537,      625.67019231240}, 
    {     0.00000000072,  5.13732084121,     1066.49547719000}, 
};


static const struct ln_vsop saturn_latitude_b5[LAT_B5] = {
    {     0.00000005442,  2.61186488264,      206.18554843720}, 
    {     0.00000001966,  1.16969532852,      220.41264243880}, 
    {     0.00000000907,  0.10771558371,      433.71173787680}, 
    {     0.00000000829,  1.07640059707,      227.52618943960}, 
    {     0.00000000584,  2.88210646011,      199.07200143640}, 
    {     0.00000000764,  3.14159265359,        0.00000000000}, 
    {     0.00000000177,  2.05357076014,      419.48464387520}, 
    {     0.00000000151,  5.41582267800,      647.01083331480}, 
    {     0.00000000098,  1.68550159247,      213.29909543800}, 
    {     0.00000000120,  0.10893311879,      440.82528487760}, 
    {     0.00000000081,  5.11373096610,      639.89728631400}, 
};


static const struct ln_vsop saturn_radius_r0[RADIUS_R0] = {
    {     9.55758135486,  0.00000000000,        0.00000000000}, 
    {     0.52921382865,  2.39226219573,      213.29909543800}, 
    {     0.01873679867,  5.23549604660,      206.18554843720}, 
    {     0.01464663929,  1.64763042902,      426.59819087600}, 
    {     0.00821891141,  5.93520042303,      316.39186965660}, 
    {     0.00547506923,  5.01532618980,      103.09277421860}, 
    {     0.00371684650,  2.27114821115,      220.41264243880}, 
    {     0.00361778765,  3.13904301847,        7.11354700080}, 
    {     0.00140617506,  5.70406606781,      632.78373931320}, 
    {     0.00108974848,  3.29313390175,      110.20632121940}, 
    {     0.00069006962,  5.94099540992,      419.48464387520}, 
    {     0.00061053367,  0.94037691801,      639.89728631400}, 
    {     0.00048913294,  1.55733638681,      202.25339517410}, 
    {     0.00034143772,  0.19519102597,      277.03499374140}, 
    {     0.00032401773,  5.47084567016,      949.17560896980}, 
    {     0.00020936596,  0.46349251129,      735.87651353180}, 
    {     0.00020839300,  1.52102476129,      433.71173787680}, 
    {     0.00020746751,  5.33255457763,      199.07200143640}, 
    {     0.00015298404,  3.05943814940,      529.69096509460}, 
    {     0.00014296484,  2.60433479142,      323.50541665740}, 
    {     0.00011993338,  5.98050967385,      846.08283475120}, 
    {     0.00011380257,  1.73105427040,      522.57741809380}, 
    {     0.00012884624,  1.64890652873,      138.51749687070}, 
    {     0.00007752664,  5.85190720634,       95.97922721780}, 
    {     0.00009796004,  5.20477537945,     1265.56747862640}, 
    {     0.00006465823,  0.17732249942,     1052.26838318840}, 
    {     0.00006770608,  3.00432308205,       14.22709400160}, 
    {     0.00005850459,  1.45520063003,      415.55249061210}, 
    {     0.00005307420,  0.59742200200,       63.73589830340}, 
    {     0.00004695487,  2.14913875148,      227.52618943960}, 
    {     0.00004044055,  1.64006628713,      209.36694217490}, 
    {     0.00003688237,  0.78017261355,      412.37109687440}, 
    {     0.00003376576,  3.69526804193,      224.34479570190}, 
    {     0.00002885428,  1.38764476428,      838.96928775040}, 
    {     0.00002975955,  5.68469131750,      210.11770170030}, 
    {     0.00003419618,  4.94550542171,     1581.95934828300}, 
    {     0.00003460944,  1.85088698050,      175.16605980020}, 
    {     0.00003400702,  0.55385265588,      350.33211960040}, 
    {     0.00002507656,  3.53854849756,      742.99006053260}, 
    {     0.00002448261,  6.18411000897,     1368.66025284500}, 
    {     0.00002406134,  2.96557066697,      117.31986822020}, 
    {     0.00002881100,  0.17962517668,      853.19638175200}, 
    {     0.00002173933,  0.01504273441,      340.77089204480}, 
    {     0.00002024755,  5.05404443168,       11.04570026390}, 
    {     0.00001740284,  2.34658553206,      309.27832265580}, 
    {     0.00001861491,  5.93369815396,      625.67019231240}, 
    {     0.00001888373,  0.02965674854,        3.93215326310}, 
    {     0.00001610962,  1.17294612833,       74.78159856730}, 
    {     0.00001462651,  1.92592107843,      216.48048917570}, 
    {     0.00001474674,  5.67670456599,      203.73786788240}, 
    {     0.00001395118,  5.93681366484,      127.47179660680}, 
    {     0.00001781073,  0.76321113173,      217.23124870110}, 
    {     0.00001817173,  5.77721016746,      490.33408917940}, 
    {     0.00001472651,  1.40074361969,      137.03302416240}, 
    {     0.00001304238,  0.77242217158,      647.01083331480}, 
    {     0.00001149625,  5.74018465658,     1162.47470440780}, 
    {     0.00001126660,  4.46695542616,      265.98929347750}, 
    {     0.00001277624,  2.98416387533,     1059.38193018920}, 
    {     0.00001207069,  0.75304212507,      351.81659230870}, 
    {     0.00001071373,  1.13559402672,     1155.36115740700}, 
    {     0.00001020836,  5.91216407900,     1685.05212250160}, 
    {     0.00001314853,  5.11211291628,      211.81462272970}, 
    {     0.00001295446,  4.69181789263,     1898.35121793960}, 
    {     0.00001099067,  1.81772713286,      149.56319713460}, 
    {     0.00000998700,  2.63153637392,      200.76892246580}, 
    {     0.00000985887,  2.25994579127,      956.28915597060}, 
    {     0.00000932498,  3.66976516070,      554.06998748280}, 
    {     0.00000664378,  0.60293797633,      728.76296653100}, 
    {     0.00000659773,  4.66626568448,      195.13984817330}, 
    {     0.00000617730,  5.62079509269,      942.06206196900}, 
    {     0.00000626321,  5.94223805240,     1478.86657406440}, 
    {     0.00000482324,  1.84048475590,      479.28838891550}, 
    {     0.00000488024,  2.79370056377,        3.18139373770}, 
    {     0.00000469977,  0.83852490947,     1471.75302706360}, 
    {     0.00000451795,  5.64511397088,     2001.44399215820}, 
    {     0.00000553115,  3.41113180428,      269.92144674060}, 
    {     0.00000534419,  1.26448338991,      275.55052103310}, 
    {     0.00000472465,  1.88197647900,      515.46387109300}, 
    {     0.00000405564,  1.63989371862,      536.80451209540}, 
    {     0.00000516979,  4.44301732436,     2214.74308759620}, 
    {     0.00000453031,  3.00355936608,      302.16477565500}, 
    {     0.00000494358,  2.28631779029,      278.51946644970}, 
    {     0.00000489957,  5.80627763476,      191.20769491020}, 
    {     0.00000427438,  0.05728625421,      284.14854074220}, 
    {     0.00000339681,  1.40193253039,      440.82528487760}, 
    {     0.00000340671,  0.89095123731,      628.85158605010}, 
    {     0.00000385941,  1.99711336197,     1272.68102562720}, 
    {     0.00000288229,  1.12166658438,      422.66603761290}, 
    {     0.00000294130,  0.42566345584,      312.19908396260}, 
    {     0.00000262480,  0.31730778329,     1045.15483618760}, 
    {     0.00000295348,  0.67123785008,       88.86568021700}, 
    {     0.00000342778,  5.85587331618,     1795.25844372100}, 
    {     0.00000341376,  2.37619847718,      525.49817940060}, 
    {     0.00000233840,  4.22716164833,      114.13847448250}, 
    {     0.00000223693,  2.28109311966,      330.61896365820}, 
    {     0.00000275816,  0.47831420035,       38.13303563780}, 
    {     0.00000224509,  0.54737895493,     1788.14489672020}, 
    {     0.00000303382,  0.87951215556,     6069.77675455340}, 
    {     0.00000292033,  6.21435200687,      210.85141488320}, 
    {     0.00000226021,  0.37470024598,      142.44965013380}, 
    {     0.00000277361,  5.32007209923,      692.58748435350}, 
    {     0.00000242981,  5.37191322470,     1258.45393162560}, 
    {     0.00000205518,  0.95727934819,      288.08069400530}, 
    {     0.00000207418,  5.38074389449,     2317.83586181480}, 
    {     0.00000186792,  6.03513906344,      404.50679034820}, 
    {     0.00000218728,  5.25467962646,      212.33588759150}, 
    {     0.00000221952,  5.94565685178,       39.35687591520}, 
    {     0.00000179461,  4.41088860030,      408.43894361130}, 
    {     0.00000241484,  1.12472797872,      388.46515523820}, 
    {     0.00000197242,  3.90215848857,       52.69019803950}, 
    {     0.00000236745,  0.90816434282,     1375.77379984580}, 
    {     0.00000172018,  5.56321647759,      213.34727954780}, 
    {     0.00000169893,  2.85627663958,       99.16062095550}, 
    {     0.00000214211,  4.20220398238,     2531.13495725280}, 
    {     0.00000171967,  2.36549740400,      213.25091132820}, 
    {     0.00000165592,  2.63731901847,      215.74677599280}, 
    {     0.00000230764,  5.49430203101,      191.95845443560}, 
    {     0.00000177457,  0.38131833670,      430.53034413910}, 
    {     0.00000191521,  2.95905308803,      437.64389113990}, 
    {     0.00000163278,  3.45811838277,      617.80588578620}, 
    {     0.00000162306,  5.73059706733,      203.00415469950}, 
    {     0.00000175037,  5.71409014243,     1066.49547719000}, 
    {     0.00000182912,  5.66913964019,     2111.65031337760}, 
    {     0.00000150093,  4.40713052025,      417.03696332040}, 
    {     0.00000187955,  6.07914706117,      563.63121503840}, 
    {     0.00000144751,  5.08115407500,      423.41679713830}, 
    {     0.00000137424,  5.43711941387,      222.86032299360}, 
    {     0.00000172859,  1.84924132022,     1589.07289528380}, 
    {     0.00000165367,  2.89085128458,      214.26230328450}, 
    {     0.00000145738,  1.56566786572,      831.85574074960}, 
    {     0.00000176715,  2.30250511690,     9999.98645077300}, 
    {     0.00000129054,  2.55327736040,      414.06801790380}, 
    {     0.00000120072,  0.04355666836,     1361.54670584420}, 
    {     0.00000143538,  0.99839503339,       76.26607127560}, 
    {     0.00000108866,  2.09239199100,      207.67002114550}, 
    {     0.00000131903,  2.85788215274,      312.45971639350}, 
    {     0.00000112006,  0.26268721967,     2104.53676637680}, 
    {     0.00000125243,  4.78336081984,      205.22234059070}, 
    {     0.00000104426,  3.63700546876,       65.22037101170}, 
    {     0.00000107397,  3.66971473274,      212.77783057620}, 
    {     0.00000108678,  2.85493119127,       21.34064100240}, 
    {     0.00000097432,  5.12133810135,     2634.22773147140}, 
    {     0.00000109144,  1.63235702020,      208.63322899200}, 
    {     0.00000096681,  4.19670884921,      305.34616939270}, 
    {     0.00000096356,  2.56061375123,     1692.16566950240}, 
    {     0.00000085950,  4.54551656203,      210.37833413120}, 
    {     0.00000099199,  5.13700784528,     1574.84580128220}, 
    {     0.00000112586,  5.03077528575,      703.63318461740}, 
    {     0.00000083820,  1.18242417124,      429.77958461370}, 
    {     0.00000089023,  5.38777022000,      107.02492748170}, 
    {     0.00000110307,  2.43652629097,      355.74874557180}, 
    {     0.00000090436,  4.20939381417,      213.82036029980}, 
    {     0.00000095576,  5.44345029853,     2428.04218303420}, 
    {     0.00000094196,  2.39809539458,      483.22054217860}, 
    {     0.00000085658,  0.03212125891,      860.30992875280}, 
    {     0.00000088781,  4.05795823648,      128.95626931510}, 
    {     0.00000081952,  1.66413587720,       62.25142559510}, 
    {     0.00000090968,  3.96769274342,     2847.52682690940}, 
    {     0.00000084136,  4.60800956822,      177.87437278590}, 
    {     0.00000088291,  3.86573756854,      140.00196957900}, 
    {     0.00000093309,  0.73847907603,      831.10498122420}, 
    {     0.00000091950,  2.94820357852,       35.42472265210}, 
    {     0.00000096733,  4.84623402274,      131.40394986990}, 
    {     0.00000086987,  1.33651321637,     1905.46476494040}, 
    {     0.00000071036,  0.99289997732,      405.25754987360}, 
    {     0.00000095225,  2.51496477958,        2.44768055480}, 
    {     0.00000072500,  4.63319492132,      245.54242435240}, 
    {     0.00000082455,  1.52813728425,      145.63104387150}, 
    {     0.00000076780,  3.15262144591,      767.36908292080}, 
    {     0.00000070362,  4.04036200412,      173.94221952280}, 
    {     0.00000086190,  2.29886507805,       85.82729883120}, 
    {     0.00000066726,  4.75093122174,       70.84944530420}, 
    {     0.00000065893,  2.47299311250,      280.96714700450}, 
    {     0.00000065129,  0.09259103795,        9.56122755560}, 
    {     0.00000071669,  0.01187527275,      565.11568774670}, 
    {     0.00000066488,  1.08200099735,      339.28641933650}, 
    {     0.00000063441,  2.01741294636,      234.63973644040}, 
    {     0.00000060956,  5.11950202312,      756.32338265690}, 
    {     0.00000057792,  6.05712220674,     1677.93857550080}, 
    {     0.00000064168,  1.28718951847,     1148.24761040620}, 
    {     0.00000073324,  4.37823969640,      425.11371816770}, 
    {     0.00000057179,  6.26635812249,     2420.92863603340}, 
    {     0.00000055012,  3.85870982169,      342.25536475310}, 
    {     0.00000055347,  1.60366629590,      543.02428721890}, 
    {     0.00000064075,  4.09799744422,      327.43756992050}, 
    {     0.00000057804,  5.46967524925,      347.88443904560}, 
    {     0.00000073568,  3.72317864427,       92.04707395470}, 
    {     0.00000073650,  3.57067095117,        1.48447270830}, 
    {     0.00000065011,  2.44916996344,      267.47376618580}, 
    {     0.00000054545,  3.71490034335,      344.70304530790}, 
    {     0.00000049834,  3.93491116778,      192.69216761850}, 
    {     0.00000049536,  3.22835315683,      333.65734504400}, 
    {     0.00000047617,  3.92991700611,      199.28444975750}, 
    {     0.00000049487,  4.90287053223,      217.49188113200}, 
    {     0.00000046390,  2.63757382235,       10.29494073850}, 
    {     0.00000062822,  4.40222532856,      214.78356814630}, 
    {     0.00000046317,  2.09597817820,      212.54833591260}, 
    {     0.00000054399,  1.06837441326,      362.86229257260}, 
    {     0.00000058898,  2.62274564952,      225.82926841020}, 
    {     0.00000048458,  3.15145995815,      216.21985674480}, 
    {     0.00000046304,  4.86526668367,     2950.61960112800}, 
    {     0.00000046012,  4.97405657859,      198.32124191100}, 
    {     0.00000046680,  2.44971808455,      207.14875628370}, 
    {     0.00000044544,  1.77853306195,      223.59403617650}, 
    {     0.00000044526,  5.55789993555,      264.50482076920}, 
    {     0.00000055807,  4.29420266501,      329.72519178090}, 
    {     0.00000049470,  5.20710403390,     2744.43405269080}, 
    {     0.00000058832,  4.23073251588,      700.66423920080}, 
    {     0.00000052681,  3.79401248595,      343.21857259960}, 
    {     0.00000041599,  0.74365516186,      125.98732389850}, 
    {     0.00000056184,  2.06967234741,      124.43341522100}, 
    {     0.00000047914,  2.38951194877,      207.88246946660}, 
    {     0.00000043427,  1.83764074596,      106.27416795630}, 
    {     0.00000039822,  4.00880264668,       12.53017297220}, 
    {     0.00000053915,  4.97995268146,      134.58534360760}, 
    {     0.00000049974,  5.75533228241,      320.32402291970}, 
    {     0.00000046661,  2.06519866248,     2008.55753915900}, 
    {     0.00000044845,  5.35638703411,      218.92816973050}, 
    {     0.00000040789,  4.92568693313,     1891.23767093880}, 
    {     0.00000042917,  0.39624025575,      357.44566660120}, 
    {     0.00000037986,  2.06627721117,      247.23934538180}, 
    {     0.00000048733,  5.32762223699,     3127.31333126180}, 
    {     0.00000041080,  2.47538730007,      237.67811782620}, 
    {     0.00000034595,  5.62346550573,       99.91138048090}, 
    {     0.00000040736,  4.08372789207,      621.73803904930}, 
    {     0.00000034217,  0.73134343646,      750.10360753340}, 
    {     0.00000033970,  5.31274574257,      206.23373254700}, 
    {     0.00000036432,  1.68823737636,       22.09140052780}, 
    {     0.00000039263,  3.45659244390,      241.61027108930}, 
    {     0.00000039247,  4.39637044405,       18.15924726470}, 
    {     0.00000034703,  2.24942082303,      487.36514376280}, 
    {     0.00000033115,  4.86602845858,      209.10630974400}, 
    {     0.00000032805,  1.06026635194,      252.65597135320}, 
    {     0.00000039031,  3.73882100198,     3163.91869656600}, 
    {     0.00000032427,  2.22874162802,      319.57326339430}, 
    {     0.00000034475,  1.82451837226,      380.12776796000}, 
    {     0.00000041741,  0.08219629974,      210.33015002140}, 
    {     0.00000033602,  5.80228769156,      251.43213107580}, 
    {     0.00000031221,  1.96490815234,      244.31858407500}, 
    {     0.00000034820,  5.96330410021,      217.96496188400}, 
    {     0.00000038505,  4.43924639932,      160.60889739850}, 
    {     0.00000036106,  3.83276808968,       56.62235130260}, 
    {     0.00000030287,  2.25797096745,     1169.58825140860}, 
    {     0.00000031085,  4.90133840375,      144.14657116320}, 
    {     0.00000032208,  3.57884943983,      231.45834270270}, 
    {     0.00000028857,  5.80423567126,     1994.33044515740}, 
    {     0.00000032178,  2.13176978399,      206.13736432740}, 
    {     0.00000031795,  3.81800770982,       73.29712585900}, 
    {     0.00000029001,  2.21676176185,       14.97785352700}, 
    {     0.00000034903,  5.65223709850,      497.44763618020}, 
    {     0.00000032246,  1.92866027151,       98.89998852460}, 
    {     0.00000032119,  0.99531311844,     1464.63948006280}, 
    {     0.00000029114,  5.98247860339,     2737.32050569000}, 
    {     0.00000036706,  4.75493516593,      348.84764689210}, 
    {     0.00000027506,  6.12108141844,      214.04985496340}, 
    {     0.00000028512,  1.68678188105,       78.71375183040}, 
    {     0.00000027266,  0.24241265140,      313.21047591890}, 
    {     0.00000028789,  0.04439781853,        5.62907429250}, 
    {     0.00000032512,  3.77917498543,       33.94024994380}, 
    {     0.00000035016,  3.43495537908,      273.10284047830}, 
    {     0.00000027130,  5.20559983787,      148.07872442630}, 
    {     0.00000033098,  2.44781346214,      969.62247809490}, 
    {     0.00000027876,  1.44457982350,      258.87574647670}, 
    {     0.00000027324,  4.26031692550,      179.35884549420}, 
    {     0.00000029185,  4.84536228119,      905.88657979150}, 
    {     0.00000027869,  0.78770357978,      546.95644048200}, 
    {     0.00000027570,  2.45214321650,      254.94359321360}, 
    {     0.00000028930,  6.03256439022,      188.92007304980}, 
    {     0.00000034313,  6.00978682828,      166.82867252200}, 
    {     0.00000025943,  0.65129538567,      654.12438031560}, 
    {     0.00000033574,  1.23583695762,     2221.85663459700}, 
    {     0.00000024357,  0.52261322301,      894.84087952760}, 
    {     0.00000027769,  5.17801023424,        5.41662597140}, 
    {     0.00000025596,  3.35872554982,        0.96320784650}, 
    {     0.00000022984,  3.52465920210,      458.84151979040}, 
    {     0.00000024471,  0.00612626886,       69.15252427480}, 
    {     0.00000028688,  0.76245403349,      488.84961647110}, 
    {     0.00000023664,  2.54807644282,      196.62432088160}, 
    {     0.00000025432,  5.28932962898,      636.71589257630}, 
    {     0.00000031152,  2.04977568414,      282.45161971280}, 
    {     0.00000025224,  4.97246368293,     3060.82592234740}, 
    {     0.00000029605,  3.92681945757,      206.70681329900}, 
    {     0.00000022223,  3.25151461044,      681.54178408960}, 
    {     0.00000027913,  2.72520521957,       32.24332891440}, 
    {     0.00000022107,  4.75818706798,      213.18722085340}, 
    {     0.00000021662,  4.61542319262,     3267.01147078460}, 
    {     0.00000027048,  2.86264558816,       24.37902238820}, 
    {     0.00000022107,  3.16802956645,      213.41097002260}, 
    {     0.00000020731,  1.67138184255,      274.06604832480}, 
    {     0.00000025352,  5.12122578609,      168.05251279940}, 
    {     0.00000028000,  4.72415728042,      552.58551477450}, 
    {     0.00000026154,  1.59534268938,      491.81856188770}, 
    {     0.00000021984,  0.87565381783,      635.96513305090}, 
    {     0.00000027121,  5.53473514339,      555.55446019110}, 
    {     0.00000025282,  1.78091725384,      182.27960680100}, 
    {     0.00000019559,  2.14658471778,       54.17467074780}, 
    {     0.00000027020,  3.57938591854,      561.18353448360}, 
    {     0.00000021398,  3.86074898701,      116.42609634290}, 
    {     0.00000019880,  5.59172876182,        4.19278569400}, 
    {     0.00000019455,  0.10611239153,      218.71572140940}, 
    {     0.00000019933,  2.90526601486,      120.35824960600}, 
    {     0.00000025474,  1.62678013615,     2324.94940881560}, 
    {     0.00000025565,  2.09824642636,      248.72381809010}, 
    {     0.00000019858,  2.52079265160,     1485.98012106520}, 
    {     0.00000018516,  2.54810951896,      213.51154375910}, 
    {     0.00000018516,  5.37755110510,      213.08664711690}, 
    {     0.00000019770,  0.07539381290,      842.15068148810}, 
    {     0.00000023660,  1.60734696991,      738.79727483860}, 
    {     0.00000020404,  2.95125083804,       59.80374504030}, 
    {     0.00000024267,  3.15706315958,      240.38643081190}, 
    {     0.00000018338,  3.18779671933,      295.05122865420}, 
    {     0.00000017466,  2.90466924741,      477.80391620720}, 
    {     0.00000020744,  1.06468673750,      494.26624244250}, 
    {     0.00000020425,  1.84152404390,      533.62311835770}, 
    {     0.00000021401,  0.64115941242,      189.72322220190}, 
    {     0.00000016379,  3.98279877350,        2.92076130680}, 
    {     0.00000016058,  0.59325161303,      746.92221379570}, 
    {     0.00000017014,  4.74645535598,     2207.62954059540}, 
    {     0.00000020479,  6.05098286202,      173.68158709190}, 
    {     0.00000015443,  1.49110952141,      543.91805909620}, 
    {     0.00000019833,  4.93811673788,      121.25202148330}, 
    {     0.00000017073,  0.71316728361,     1781.03134971940}, 
    {     0.00000017213,  0.67923942083,      151.04766984290}, 
    {     0.00000015031,  5.52780819403,     2310.72231481400}, 
    {     0.00000015525,  5.71027236377,     3053.71237534660}, 
    {     0.00000015852,  4.45624558241,      643.82943957710}, 
    {     0.00000016033,  0.63293747499,      358.93013930950}, 
    {     0.00000014591,  5.26184260227,      472.17484191470}, 
    {     0.00000016544,  3.52801242983,     3480.31056622260}, 
    {     0.00000018834,  0.55399472524,        4.66586644600}, 
    {     0.00000017549,  2.26583782913,      672.14061522840}, 
    {     0.00000018022,  2.71080286082,      181.80652604900}, 
    {     0.00000015918,  5.23473369828,      135.54855145410}, 
    {     0.00000013931,  3.19357128657,      213.55972786890}, 
    {     0.00000014074,  0.80929029505,      221.37585028530}, 
    {     0.00000013931,  4.73208739639,      213.03846300710}, 
    {     0.00000014594,  2.65461071698,      292.01284726840}, 
    {     0.00000014383,  0.21121098879,      235.39049596580}, 
    {     0.00000016173,  0.91043299219,      280.00393915800}, 
    {     0.00000013328,  3.54955934512,      205.66428357540}, 
    {     0.00000016559,  5.38896753750,      424.15051032120}, 
    {     0.00000016104,  0.82547975762,      176.65053250850}, 
    {     0.00000012726,  0.75928182731,      721.64941953020}, 
    {     0.00000012745,  3.55415994159,      153.49535039770}, 
    {     0.00000014455,  0.12149539513,      313.68355667090}, 
    {     0.00000016497,  3.26380729084,     6283.07584999140}, 
    {     0.00000016566,  1.62651930127,     5856.47765911540}, 
    {     0.00000015039,  1.25437397471,     2641.34127847220}, 
    {     0.00000015688,  1.18940728810,      486.40193591630}, 
    {     0.00000011898,  0.91072314364,      416.30325013750}, 
    {     0.00000011709,  1.10722547914,       81.75213321620}, 
    {     0.00000012984,  4.74370547048,     3377.21779200400}, 
    {     0.00000013213,  4.95593892766,     1279.79457262800}, 
    {     0.00000016123,  0.98390715272,     2538.24850425360}, 
    {     0.00000014673,  2.63437960547,      618.55664531160}, 
    {     0.00000011539,  0.63828316888,       28.31117565130}, 
    {     0.00000011339,  4.36553205735,     3583.40334044120}, 
    {     0.00000014901,  1.75796184641,      569.04784100980}, 
    {     0.00000011246,  5.99191155570,      193.65537546500}, 
    {     0.00000014753,  2.92291248767,      167.08930495290}, 
    {     0.00000012755,  3.61745093436,       67.66805156650}, 
    {     0.00000013536,  2.50325109462,     1802.37199072180}, 
    {     0.00000012238,  0.27162703042,     1044.40407666220}, 
    {     0.00000011034,  6.28008547861,      629.60234557550}, 
    {     0.00000014387,  0.38039001729,      601.76425067620}, 
    {     0.00000012310,  2.18899826214,      650.94298657790}, 
    {     0.00000010854,  0.14262616333,      501.37978944330}, 
    {     0.00000015105,  2.67152088150,       46.47042291600}, 
    {     0.00000010735,  2.86920913253,      113.38771495710}, 
    {     0.00000014686,  6.05254709898,      468.24268865160}, 
    {     0.00000010576,  2.06017585814,      429.04587143080}, 
    {     0.00000012292,  1.82443833563,      241.87090352020}, 
    {     0.00000011154,  1.20110507523,      172.24529849340}, 
    {     0.00000013687,  2.20307346288,      228.27694896500}, 
    {     0.00000010679,  5.07369541820,      162.89651925890}, 
    {     0.00000012030,  3.18736701996,       72.07328558160}, 
    {     0.00000012160,  4.51222901843,      425.63498302950}, 
    {     0.00000009941,  1.49887209210,      226.63241756230}, 
    {     0.00000012101,  4.14977794208,     1108.13997496560}, 
    {     0.00000010287,  2.10680007794,     1033.35837639830}, 
    {     0.00000010771,  4.68125923293,      129.91947716160}, 
    {     0.00000009592,  4.80075106366,      426.64637498580}, 
    {     0.00000012949,  5.11601756130,      219.44943459230}, 
    {     0.00000009921,  2.81125800889,      518.64526483070}, 
    {     0.00000012272,  5.33779805565,      776.93031047640}, 
    {     0.00000009486,  4.85709302918,      820.05928096030}, 
    {     0.00000011392,  3.86350991469,      405.99126305650}, 
    {     0.00000009281,  0.70440206655,      403.02231763990}, 
    {     0.00000009617,  1.60410621884,      426.55000676620}, 
    {     0.00000010112,  2.76486875630,      210.59078245230}, 
    {     0.00000010872,  1.35809078598,      170.76082578510}, 
    {     0.00000012502,  6.06479177955,      875.83029900100}, 
    {     0.00000010175,  2.36250012243,      685.47393735270}, 
    {     0.00000012211,  2.04456082125,      508.35032409220}, 
    {     0.00000009502,  3.18475934663,      286.59622129700}, 
    {     0.00000010133,  4.02559667441,      381.35160823740}, 
    {     0.00000008889,  3.62576694345,      319.31263096340}, 
    {     0.00000008927,  5.46319224261,     3370.10424500320}, 
    {     0.00000010052,  5.16107251039,      216.00740842370}, 
    {     0.00000008553,  3.87970879218,      630.33605875840}, 
    {     0.00000008401,  5.65557131026,      213.45915413240}, 
    {     0.00000008401,  2.27009862215,      213.13903674360}, 
    {     0.00000009962,  5.97645215717,        6.15033915430}, 
    {     0.00000011664,  0.95814408096,      694.07195706180}, 
    {     0.00000008686,  2.33879748618,      220.36445832900}, 
    {     0.00000008135,  5.54067608923,      220.46082654860}, 
    {     0.00000009144,  0.45077461958,     2097.42321937600}, 
    {     0.00000009579,  2.76806282069,      556.51766803760}, 
    {     0.00000008128,  5.54123343077,      181.05576652360}, 
    {     0.00000010807,  0.06096432609,      691.10301164520}, 
    {     0.00000009578,  2.84972091302,      184.09414790940}, 
    {     0.00000009848,  2.37490871749,      945.24345570670}, 
    {     0.00000008512,  0.17361504982,      289.56516671360}, 
    {     0.00000008689,  0.84670554895,     2957.73314812880}, 
    {     0.00000007633,  0.00567409646,        7.16173111060}, 
    {     0.00000009022,  3.38436801047,      731.94436026870}, 
    {     0.00000007888,  5.78452089815,      230.82520325630}, 
    {     0.00000009472,  2.26694157732,        8.07675484730}, 
    {     0.00000007461,  5.29596435777,     2627.11418447060}, 
    {     0.00000007616,  3.10561406310,        7.06536289100}, 
    {     0.00000009879,  4.69447221853,    10213.28554621100}, 
    {     0.00000007264,  0.07122374466,      100.64509366380}, 
    {     0.00000008001,  1.60939840798,      696.51963761660}, 
    {     0.00000007601,  4.90123787776,       51.20572533120}, 
    {     0.00000007716,  4.69702238883,      436.15941843160}, 
    {     0.00000009866,  5.25569996364,      699.70103135430}, 
    {     0.00000007375,  4.52777394099,      616.32141307790}, 
    {     0.00000009388,  2.44919199853,     2118.76386037840}, 
    {     0.00000007300,  4.01885475010,      212.02707105080}, 
    {     0.00000009071,  2.75662160229,      130.44074202340}, 
    {     0.00000007175,  5.62469707711,       31.49256938900}, 
    {     0.00000006915,  0.57642247068,      739.80866679490}, 
    {     0.00000008909,  2.19570530999,      427.56139872250}, 
    {     0.00000009167,  2.04679688754,      204.70107572890}, 
    {     0.00000007766,  3.27192916123,     3796.70243587920}, 
    {     0.00000006842,  0.55589113901,      135.33610313300}, 
    {     0.00000009154,  3.04674464726,     9786.68735533500}, 
    {     0.00000008677,  4.27082106143,      141.22580985640}, 
    {     0.00000006709,  5.66109188592,      480.77286162380}, 
    {     0.00000006946,  4.12352001440,      662.53120356300}, 
    {     0.00000007240,  3.90653111215,      214.57111982520}, 
    {     0.00000006717,  4.61311587500,     2524.02141025200}, 
    {     0.00000006566,  2.67659365854,      194.17664032680}, 
    {     0.00000006537,  6.25555511414,       31.01948863700}, 
    {     0.00000007484,  5.56871021201,      271.40591944890}, 
    {     0.00000007956,  5.04685375986,      411.62033734900}, 
    {     0.00000008039,  3.08941959611,      353.30106501700}, 
    {     0.00000007069,  1.10060234302,      282.66406803390}, 
    {     0.00000006105,  0.81728612933,      593.42686339800}, 
    {     0.00000006140,  3.79672318503,      180.16199464630}, 
    {     0.00000006761,  3.84307989405,      412.58354519550}, 
    {     0.00000006034,  5.43418203960,      724.83081326790}, 
    {     0.00000008102,  4.51051495778,      268.43697403230}, 
    {     0.00000006029,  1.24355734058,      447.93883187840}, 
    {     0.00000007613,  0.79977414552,     2854.64037391020}, 
    {     0.00000007425,  2.29359441900,      532.61172640140}, 
    {     0.00000005896,  2.06866571185,      454.90936652730}, 
    {     0.00000006005,  2.87167092054,      426.07692601420}, 
    {     0.00000007278,  0.88193016589,      457.61767951300}, 
    {     0.00000005744,  1.73450672261,       50.40257617910}, 
    {     0.00000006355,  6.27053564712,      313.94418910180}, 
    {     0.00000006193,  3.99658934587,      835.03713448730}, 
    {     0.00000007429,  5.38166639065,      953.10776223290}, 
    {     0.00000005813,  0.52655128116,     1038.04128918680}, 
    {     0.00000006145,  4.52475150505,     3693.60966166060}, 
    {     0.00000005624,  0.46667684775,      610.69233878540}, 
    {     0.00000006075,  3.46609452590,      278.25883401880}, 
    {     0.00000005877,  5.51717146635,     1073.60902419080}, 
    {     0.00000005521,  0.45012859744,      643.07868005170}, 
    {     0.00000006700,  4.22406253654,      916.93228005540}, 
    {     0.00000006720,  4.19624148194,      938.12990870590}, 
    {     0.00000005508,  4.07398606097,     3899.79521009780}, 
    {     0.00000005441,  2.79849882662,      397.39324334740}, 
    {     0.00000006134,  4.90393524057,        0.52126486180}, 
    {     0.00000005695,  4.11782098393,      391.17346822390}, 
    {     0.00000005754,  4.42718264879,      165.60483224460}, 
    {     0.00000005400,  3.26290414060,       20.60692781950}, 
    {     0.00000005879,  6.17871813155,      291.26208774300}, 
    {     0.00000006722,  2.18622342890,      627.36711334180}, 
    {     0.00000005359,  2.29438108352,      331.20966448920}, 
    {     0.00000005390,  3.74281931890,      418.52143602870}, 
    {     0.00000006683,  2.13438701667,      285.63301345050}, 
    {     0.00000006419,  5.65171900155,      518.38463239980}, 
    {     0.00000006193,  4.89768396188,      450.97721326420}, 
    {     0.00000005687,  3.48764525546,      230.56457082540}, 
    {     0.00000005064,  4.09065475521,        6.59228213900}, 
    {     0.00000005037,  2.59990654740,       66.70484372000}, 
    {     0.00000005191,  4.39610445378,       84.34282612290}, 
    {     0.00000004977,  2.71603834658,      558.00214074590}, 
    {     0.00000005308,  0.63718449606,      114.39910691340}, 
    {     0.00000005221,  4.65473413721,      310.71461125430}, 
    {     0.00000004896,  3.77009699230,      423.67742956920}, 
    {     0.00000005931,  2.73953602204,      219.89137757700}, 
    {     0.00000006357,  1.40137012390,      606.76018552230}, 
    {     0.00000006528,  2.95896329675,      624.91943278700}, 
    {     0.00000004734,  0.23182011937,     1063.31408345230}, 
    {     0.00000006408,  1.16687419680,      268.95823889410}, 
    {     0.00000005179,  1.95231681037,     1182.92157353290}, 
    {     0.00000004785,  1.59071523410,      420.96911658350}, 
    {     0.00000006093,  0.30791927132,      524.01370669230}, 
    {     0.00000005161,  0.14373018373,     2413.81508903260}, 
    {     0.00000004854,  5.21382590347,     3686.49611465980}, 
    {     0.00000004648,  3.71025478809,      305.08553696180}, 
    {     0.00000005072,  1.73257574940,      337.73251065900}, 
    {     0.00000004926,  2.12141378228,      104.05598206510}, 
    {     0.00000004959,  0.46912887724,     3274.12501778540}, 
    {     0.00000004797,  3.68003355961,      240.12579838100}, 
    {     0.00000004881,  2.56296192969,      980.66817835880}, 
    {     0.00000004538,  5.06386842515,      103.14095832840}, 
    {     0.00000005243,  4.56756453601,      238.90195810360}, 
    {     0.00000005396,  3.52859562249,      107.28555991260}, 
    {     0.00000004504,  1.68251875362,      196.03362005060}, 
    {     0.00000004897,  4.89294590398,      102.12956637210}, 
    {     0.00000004329,  1.45425771576,      409.92341631960}, 
    {     0.00000004522,  1.86757053063,      103.04459010880}, 
    {     0.00000005627,  1.48094428399,      105.54045477340}, 
    {     0.00000005549,  6.23714371031,      112.65400177420}, 
    {     0.00000005089,  3.40647640515,      427.11945573780}, 
    {     0.00000004206,  0.15752956829,      958.57677783100}, 
    {     0.00000005782,  3.55197606731,    25874.60404613620}, 
    {     0.00000004946,  0.49718145204,      511.53171782990}, 
    {     0.00000004401,  3.75996694142,     1171.87587326900}, 
    {     0.00000004159,  5.94760152108,      316.44005376640}, 
    {     0.00000004129,  4.67603982685,      106.01353552540}, 
    {     0.00000004896,  3.54149603851,      960.22130923370}, 
    {     0.00000005302,  2.03239262703,     2435.15573003500}, 
    {     0.00000004083,  3.22253056977,      775.23338944700}, 
    {     0.00000004044,  3.11555925708,      115.62294719080}, 
    {     0.00000004310,  4.15198847307,      823.99143422340}, 
    {     0.00000005212,  0.72733303302,      810.65811209910}, 
    {     0.00000004007,  2.01729253216,      597.35901666110}, 
    {     0.00000004562,  5.59558196490,      778.41478318470}, 
    {     0.00000004147,  2.75091730849,      316.34368554680}, 
    {     0.00000004254,  3.94241247597,      422.40540518200}, 
    {     0.00000004600,  1.45697260622,      184.98791978670}, 
    {     0.00000003893,  6.03446446847,      945.99421523210}, 
    {     0.00000004020,  1.20560354979,      850.01498801430}, 
    {     0.00000003887,  4.17726970779,       97.67614824720}, 
    {     0.00000004430,  3.99621211317,      393.46109008430}, 
    {     0.00000003840,  1.21234108241,      212.07525516060}, 
    {     0.00000004201,  6.27730992986,        0.75075952540}, 
    {     0.00000004863,  1.13422250397,      526.98265210890}, 
    {     0.00000004447,  1.35547164147,      211.60217440860}, 
    {     0.00000003820,  5.03658989770,     2943.50605412720}, 
    {     0.00000003840,  0.43014354282,      214.52293571540}, 
    {     0.00000004730,  3.62040936733,      638.41281360570}, 
    {     0.00000004868,  5.75868955321,     1246.65747183630}, 
    {     0.00000005306,  1.97377190922,      526.50957135690}, 
    {     0.00000003931,  2.36660571051,      909.81873305460}, 
    {     0.00000003795,  5.98201295154,      325.95309721220}, 
    {     0.00000003660,  2.77163682449,      123.53964334370}, 
    {     0.00000003733,  6.24886866050,      159.12442469020}, 
    {     0.00000003630,  5.31291201362,      406.95447090300}, 
    {     0.00000004125,  2.26202662047,      453.42489381900}, 
    {     0.00000003804,  1.94311852072,      421.18156490460}, 
    {     0.00000003921,  3.03212850210,      317.35507750310}, 
    {     0.00000004474,  0.79005911356,      838.21852822500}, 
    {     0.00000003887,  3.66517061000,      216.26804085460}, 
    {     0.00000004124,  2.07692454360,      988.53248488500}, 
    {     0.00000003826,  5.00388072945,        7.63481186260}, 
    {     0.00000003511,  0.85041677251,      299.12639426920}, 
    {     0.00000004470,  0.81353118479,       43.28902917830}, 
    {     0.00000004400,  1.68614665169,      824.74219374880}, 
    {     0.00000003581,  2.35235960566,      337.80194662820}, 
    {     0.00000004556,  1.19671843654,      421.93232443000}, 
    {     0.00000004606,  3.48411536111,      913.96333463880}, 
    {     0.00000003434,  0.71560801606,       20.44686912510}, 
    {     0.00000004419,  5.41935926211,      963.40270297140}, 
    {     0.00000003733,  2.84428537908,      739.05790726950}, 
    {     0.00000004535,  3.73475254758,       37.87240320690}, 
    {     0.00000003493,  0.95852190622,      436.89313161450}, 
    {     0.00000004367,  6.08179089265,      760.25553592000}, 
    {     0.00000003597,  2.77342512545,      444.75743814070}, 
    {     0.00000003724,  0.59005210557,      256.42806592190}, 
    {     0.00000004626,  1.36732630873,      495.75071515080}, 
    {     0.00000004325,  4.75343402622,       40.84134862350}, 
    {     0.00000004192,  1.53217061691,      298.23262239190}, 
    {     0.00000003397,  3.25386995141,     4113.09430553580}, 
    {     0.00000003534,  5.01937599581,      386.98068252990}, 
    {     0.00000004444,  2.22449419566,      318.83955021140}, 
    {     0.00000003634,  1.51814005753,       41.64449777560}, 
    {     0.00000004432,  1.80184528105,      829.62050851590}, 
    {     0.00000003209,  1.74496507797,      952.35700270750}, 
    {     0.00000004471,  2.64501992639,      832.58945393250}, 
    {     0.00000004170,  3.10349766466,       60.76695288680}, 
    {     0.00000003718,  4.79840355539,      238.42887735160}, 
    {     0.00000003372,  5.52902680091,      143.93412284210}, 
    {     0.00000003231,  4.07749274895,      426.48631629140}, 
    {     0.00000003187,  0.26747560612,     1354.43315884340}, 
    {     0.00000003249,  6.19660166578,      754.83890994860}, 
    {     0.00000003832,  5.62257892389,      315.42866181010}, 
    {     0.00000003102,  2.69222024207,      343.73983746140}, 
    {     0.00000004045,  4.02570628270,      376.19561469690}, 
    {     0.00000003576,  0.38532787280,      214.99601646740}, 
    {     0.00000003231,  2.48733524742,      426.71006546060}, 
    {     0.00000003272,  0.55922563072,      619.29035849450}, 
    {     0.00000003145,  5.53069704309,      402.21916848780}, 
    {     0.00000003594,  3.09973315674,     1048.33622992530}, 
    {     0.00000003913,  5.76369811680,      239.16259053450}, 
    {     0.00000003130,  0.12587768357,     3590.51688744200}, 
    {     0.00000003223,  2.37297249115,      429.51895218280}, 
    {     0.00000002959,  1.88185764818,       93.53154666300}, 
    {     0.00000003401,  5.91727053879,      570.74476203920}, 
    {     0.00000002893,  5.69690703144,     1262.38608488870}, 
    {     0.00000003194,  4.15518147251,      366.79444583570}, 
    {     0.00000003267,  2.08541911320,      806.72595883600}, 
    {     0.00000002923,  1.13173771167,      262.05714021440}, 
    {     0.00000003342,  1.79129601981,      443.86366626340}, 
    {     0.00000003519,  1.86888683578,      439.12836384820}, 
    {     0.00000003331,  6.05086663762,      108.72184851110}, 
    {     0.00000003434,  5.44390765201,       84.93352695390}, 
    {     0.00000002942,  2.72795635418,      541.53981451060}, 
    {     0.00000002965,  0.02681640831,      221.16340196420}, 
    {     0.00000002978,  5.29375140441,      313.47110834980}, 
    {     0.00000003473,  2.06103634915,     1261.63532536330}, 
    {     0.00000003689,  1.11165149425,      395.57870223900}, 
    {     0.00000002793,  0.38781777981,      211.86280683950}, 
    {     0.00000003181,  1.01693719457,      418.00017116690}, 
    {     0.00000003747,  3.89168631842,      220.93390730060}, 
    {     0.00000003290,  0.63073796473,     3171.03224356680}, 
    {     0.00000003086,  2.17469905033,      306.83064210100}, 
    {     0.00000003119,  0.92371206211,      205.43478891180}, 
    {     0.00000002987,  2.01186468194,      117.91056905120}, 
    {     0.00000002793,  1.25466684542,      214.73538403650}, 
    {     0.00000002715,  1.86769320511,      426.81063919710}, 
    {     0.00000002715,  4.69713479126,      426.38574255490}, 
    {     0.00000002890,  0.64154774742,      263.02034806090}, 
    {     0.00000003311,  3.01441319731,      336.83873878170}, 
    {     0.00000002746,  2.69963506849,      380.38840039090}, 
    {     0.00000003123,  2.19601758733,        2.96894541660}, 
    {     0.00000003006,  5.91067479448,        2.70831298570}, 
    {     0.00000002644,  2.97696438264,      384.05992122310}, 
    {     0.00000003645,  5.61049552466,      423.62924545940}, 
    {     0.00000003498,  0.19746089391,      576.16138801060}, 
    {     0.00000002794,  4.27284753268,     4010.00153131720}, 
    {     0.00000003389,  1.49948217445,      885.43971066640}, 
    {     0.00000002663,  4.57051350603,      361.37781986430}, 
    {     0.00000003034,  2.08124822690,     2751.54759969160}, 
    {     0.00000002581,  0.17405799614,     1056.20053645150}, 
    {     0.00000003049,  1.03668168368,      732.69511979410}, 
    {     0.00000002559,  3.96471171390,      430.79097657000}, 
    {     0.00000002715,  6.16166361673,      572.22923474750}, 
    {     0.00000002534,  5.31015667874,      427.34895040140}, 
    {     0.00000002591,  4.91947374252,      464.73122651380}, 
    {     0.00000002715,  4.62802876900,      140.96517742550}, 
    {     0.00000002580,  3.27421375191,      136.06981631590}, 
    {     0.00000002605,  0.99538186951,       92.30770638560}, 
    {     0.00000002498,  0.20316576938,      110.25450532920}, 
    {     0.00000002592,  4.30914764493,      561.93429400900}, 
    {     0.00000003139,  5.41283857071,      328.24071907260}, 
    {     0.00000002668,  1.90490897736,       88.11492069160}, 
    {     0.00000002975,  3.34497161574,      273.85360000370}, 
    {     0.00000002896,  5.62348887158,     1699.27921650320}, 
    {     0.00000003016,  1.06868053473,        7.86430652620}, 
    {     0.00000002711,  2.27577147546,      519.39602435610}, 
    {     0.00000002646,  1.38294890847,      460.53844081980}, 
    {     0.00000002670,  2.55002171454,      195.89060769870}, 
    {     0.00000002465,  3.82257543008,       77.75054398390}, 
    {     0.00000002860,  2.57578667803,      505.31194270640}, 
    {     0.00000002909,  0.81750588929,       45.57665103870}, 
    {     0.00000002434,  4.67002316303,     2840.41327990860}, 
    {     0.00000003297,  1.33975572602,      305.60680182360}, 
    {     0.00000003360,  3.38474137719,      162.09337010680}, 
    {     0.00000003327,  2.32322471286,      285.37238101960}, 
    {     0.00000002434,  3.71460437051,     4216.18707975440}, 
    {     0.00000002400,  4.51737346541,      540.73666535850}, 
    {     0.00000002506,  1.31681285875,       36.64856292950}, 
    {     0.00000002388,  1.13864271701,       23.57587323610}, 
    {     0.00000002367,  0.92796234913,      757.21715453420}, 
    {     0.00000003057,  1.71218695964,      256.58812461630}, 
    {     0.00000002342,  1.45192564703,      131.54696222180}, 
    {     0.00000002514,  0.09021648201,      206.93630796260}, 
    {     0.00000003153,  0.85842354898,      705.11765732570}, 
    {     0.00000002412,  0.54879873444,      107.75864066460}, 
    {     0.00000002427,  2.04627850771,      124.50285119020}, 
    {     0.00000002320,  0.02863836432,      317.14262918200}, 
    {     0.00000002632,  1.41253794767,      211.65456403530}, 
    {     0.00000002871,  5.74770120564,      322.02094394910}, 
    {     0.00000002296,  1.38115687263,      425.84743135060}, 
    {     0.00000003103,  1.03244576602,      100.38446123290}, 
    {     0.00000002323,  4.89135719082,     3259.89792378380}, 
    {     0.00000002708,  5.36850947426,      432.01481684740}, 
    {     0.00000003210,  4.49278521063,      432.22726516850}, 
    {     0.00000002276,  6.04688191978,      214.10224459010}, 
    {     0.00000002276,  1.96882478275,      212.49594628590}, 
    {     0.00000002501,  3.32056063100,      110.15813710960}, 
    {     0.00000002829,  2.66887892162,      141.48644228730}, 
    {     0.00000003092,  6.00298888734,      465.95506679120}, 
    {     0.00000002246,  2.10578934642,      441.57604440300}, 
    {     0.00000002314,  5.22234612103,      303.86169668440}, 
    {     0.00000002588,  0.08042775105,      133.10087089930}, 
    {     0.00000002292,  5.00278268122,      431.26405732200}, 
    {     0.00000002856,  5.42593711539,      315.16802937920}, 
    {     0.00000002201,  5.91127594022,      867.42347575360}, 
    {     0.00000002749,  1.42536872532,       42.53826965290}, 
    {     0.00000003057,  6.17400625369,      109.24311337290}, 
    {     0.00000002263,  4.62327588198,      188.02630117250}, 
    {     0.00000002484,  4.68809498416,     1596.18644228460}, 
    {     0.00000002774,  0.96127776136,       41.05379694460}, 
    {     0.00000002274,  4.94055830711,     4002.88798431640}, 
    {     0.00000002541,  0.83705615200,    12352.85260454480}, 
    {     0.00000002645,  4.96474980727,      710.74673161820}, 
    {     0.00000002236,  5.48729571140,      200.55647414470}, 
    {     0.00000002872,  2.64762368923,       39.61750834610}, 
    {     0.00000002122,  4.04560058177,      118.07062774560}, 
    {     0.00000002944,  3.76699797630,      428.08266358430}, 
    {     0.00000002245,  5.67078632283,     6467.92575796160}, 
    {     0.00000002227,  1.15684015463,      227.31374111850}, 
    {     0.00000002541,  1.09551842708,      184.72728735580}, 
    {     0.00000002311,  6.13117019885,     2730.20695868920}, 
    {     0.00000002523,  1.75026771081,     1578.02719501990}, 
    {     0.00000002826,  1.01897881938,       87.31177153950}, 
    {     0.00000002703,  1.25988186933,       28.57180808220}, 
    {     0.00000002174,  1.22467852410,      209.15449385380}, 
    {     0.00000002079,  3.44743142758,      111.16952906590}, 
    {     0.00000002068,  4.72242654672,      765.88461021250}, 
    {     0.00000002111,  2.19792675105,      449.23210812500}, 
    {     0.00000002456,  4.30511454445,     1382.88734684660}, 
    {     0.00000002072,  0.60946281465,      335.14181775230}, 
    {     0.00000002761,  6.07901608056,     2914.01423582380}, 
    {     0.00000002235,  2.88625133130,      207.07932031450}, 
    {     0.00000002040,  2.51317012035,      426.85882330690}, 
    {     0.00000002068,  4.24177127582,       96.87299909510}, 
    {     0.00000002212,  1.21619926123,      640.86049416050}, 
    {     0.00000002390,  0.81726710450,      550.13783421970}, 
    {     0.00000002518,  2.99015150463,      745.27768239300}, 
    {     0.00000002040,  4.05168623017,      426.33755844510}, 
    {     0.00000002189,  1.65687779035,      219.66188291340}, 
    {     0.00000002529,  4.34280337125,      221.89711514710}, 
    {     0.00000002554,  5.56906813525,      214.19286731530}, 
    {     0.00000002712,  1.60469055821,     1050.99635880120}, 
    {     0.00000002204,  0.38959601910,      217.44369702220}, 
    {     0.00000002252,  3.46799691105,      481.73606947030}, 
    {     0.00000002542,  1.31713271917,      462.02291352810}, 
    {     0.00000002035,  1.13356999548,      842.90144101350}, 
    {     0.00000002013,  2.61457337660,      315.64111013120}, 
    {     0.00000001985,  2.98251882415,      668.20846196530}, 
    {     0.00000001995,  5.36620538717,     1041.22268292450}, 
    {     0.00000002357,  1.94161571159,      233.90602325750}, 
    {     0.00000002072,  2.97593151443,      304.12232911530}, 
    {     0.00000002040,  2.04492641594,     1097.09427470170}, 
    {     0.00000002139,  3.12500079869,     1276.61317889030}, 
    {     0.00000002712,  1.49710379225,     3340.61242669980}, 
    {     0.00000002138,  4.52114042572,      378.90392768260}, 
    {     0.00000002708,  0.01014338187,      389.94962794650}, 
    {     0.00000001989,  2.66756812577,      301.41401612960}, 
    {     0.00000002281,  3.34201090267,      220.20019411770}, 
    {     0.00000001944,  0.04553582326,       16.67477455640}, 
    {     0.00000001941,  5.52054449349,      175.42669223110}, 
    {     0.00000002377,  3.03550341735,      774.48262992160}, 
    {     0.00000002049,  0.27858181430,      146.59425171800}, 
    {     0.00000001907,  1.80796641977,      192.85222631290}, 
    {     0.00000002014,  2.26726355818,      198.10879358990}, 
    {     0.00000001894,  4.66837052854,      220.30076785420}, 
    {     0.00000001953,  3.95325956567,      103.61403908040}, 
    {     0.00000001985,  0.60283431486,     3487.42411322340}, 
    {     0.00000001907,  0.26838618029,      171.65459766240}, 
    {     0.00000002397,  4.52014748152,      484.70501488690}, 
    {     0.00000002215,  2.81175588657,       25.12978191360}, 
    {     0.00000002065,  1.44937608998,      864.24208201590}, 
    {     0.00000002626,  5.01886635967,     1269.49963188950}, 
    {     0.00000001973,  2.73564949410,       14.01464568050}, 
    {     0.00000002433,  3.72005264961,    25558.21217647960}, 
    {     0.00000001878,  5.62259036586,     1310.39337013970}, 
    {     0.00000001908,  0.17685540317,      244.79166482700}, 
    {     0.00000002490,  4.74033063304,      637.44960575920}, 
    {     0.00000001974,  2.68790170927,      769.81676347560}, 
    {     0.00000001843,  0.01683962790,      233.74596456310}, 
    {     0.00000002002,  4.17267014873,      315.87060479480}, 
    {     0.00000002107,  2.88563182217,      328.92204262880}, 
    {     0.00000002506,  5.73769491309,      544.50875992720}, 
    {     0.00000001836,  3.41496980986,      195.77298761970}, 
    {     0.00000002554,  2.35660179716,      212.40532356070}, 
    {     0.00000002133,  3.38876216948,      420.00590873700}, 
    {     0.00000002515,  1.52053666175,      170.01006625970}, 
    {     0.00000001825,  2.10573290416,      326.68681039510}, 
    {     0.00000001825,  4.04945265223,      190.40454575810}, 
    {     0.00000001787,  4.44171369035,     4319.27985397300}, 
    {     0.00000002218,  1.85338838467,      635.23141986800}, 
    {     0.00000002065,  4.56320119053,      316.91313451840}, 
    {     0.00000002069,  0.33119237753,      589.49471013490}, 
    {     0.00000001848,  4.76669755831,     3576.28979344040}, 
    {     0.00000001823,  2.76149096005,       28.45418800320}, 
    {     0.00000002057,  0.15132453320,      354.26427286350}, 
    {     0.00000002195,  2.39000779621,      420.44785172170}, 
    {     0.00000001871,  4.24693452218,     1119.18567522950}, 
    {     0.00000001783,  0.01994273456,     1670.82502850000}, 
    {     0.00000002408,  3.76786817334,     1254.52177836250}, 
    {     0.00000002055,  2.40761448423,      187.43560034150}, 
    {     0.00000001860,  3.67887919311,     1321.43907040360}, 
    {     0.00000001927,  1.44376020353,      230.70758317730}, 
    {     0.00000001909,  2.66281572243,      525.75881183150}, 
    {     0.00000001715,  0.76853202855,      295.19424100610}, 
    {     0.00000001709,  0.87394066872,       92.79783348010}, 
    {     0.00000001988,  3.51782474137,      226.79247625670}, 
    {     0.00000001970,  1.30348659196,     1385.17496870700}, 
    {     0.00000001702,  1.87642719428,      241.75328344120}, 
    {     0.00000001714,  0.24096394211,      314.90739694830}, 
    {     0.00000002221,  4.82210413830,     1585.89150154610}, 
    {     0.00000001897,  0.64334758324,       55.65914345610}, 
    {     0.00000001832,  2.83112577682,      385.54439393140}, 
    {     0.00000001801,  3.92659370910,      334.55111692130}, 
    {     0.00000001677,  2.65266412786,        6.36278747540}, 
    {     0.00000001979,  1.01174165465,       26.82670294300}, 
    {     0.00000002146,  4.95169353871,      186.21176006410}, 
    {     0.00000001737,  5.96819633430,      837.69726336320}, 
    {     0.00000001938,  3.43779546456,      102.57150935680}, 
    {     0.00000002274,  3.50826019622,     1570.91364801910}, 
    {     0.00000002099,  1.88961540842,      598.84348936940}, 
    {     0.00000001808,  4.01090709296,      638.93407846750}, 
    {     0.00000001838,  1.87731292420,     1304.92435454160}, 
    {     0.00000002167,  5.96734709712,      815.06334611420}, 
    {     0.00000001884,  4.24447812450,       13.49338081870}, 
    {     0.00000001880,  0.33845094634,      214.94362684070}, 
    {     0.00000001722,  3.46884545009,      238.57188970350}, 
    {     0.00000001817,  3.07678560214,      220.52451702340}, 
    {     0.00000001683,  5.59063267232,      229.97386999440}, 
    {     0.00000001643,  4.14582161982,      639.94547042380}, 
    {     0.00000001656,  4.18430555350,     4326.39340097380}, 
    {     0.00000001629,  3.24277564727,      281.17959532560}, 
    {     0.00000001836,  3.87300444123,      310.97524368520}, 
    {     0.00000001696,  6.03578305716,      152.53214255120}, 
    {     0.00000001625,  2.29563193313,     3067.93946934820}, 
    {     0.00000001734,  0.01027974479,      827.92358748650}, 
    {     0.00000002223,  2.02052647478,      259.76951835400}, 
    {     0.00000002029,  5.24794186900,     2015.67108615980}, 
    {     0.00000001653,  2.12349382663,      491.55792945680}, 
    {     0.00000001759,  5.55819179511,      170.97327410620}, 
    {     0.00000001935,  4.82674512778,      101.86893394120}, 
    {     0.00000001952,  0.80897783353,     1049.08698945070}, 
    {     0.00000001932,  5.93295011372,      249.94765836750}, 
    {     0.00000001586,  2.23089970089,      749.20983565610}, 
    {     0.00000001645,  0.94872114837,      639.84910220420}, 
    {     0.00000001773,  2.55608046714,     9985.75935677140}, 
    {     0.00000001773,  1.22355983261,      199.96577331370}, 
    {     0.00000001795,  3.78543930681,      172.45774681450}, 
    {     0.00000001847,  4.51726084312,      199.80571461930}, 
    {     0.00000001571,  5.97174519645,      280.21638747910}, 
    {     0.00000001744,  1.92870917122,      934.94851496820}, 
    {     0.00000002133,  4.62326373227,      271.61836777000}, 
    {     0.00000002108,  2.43724800610,      453.68552624990}, 
    {     0.00000001609,  4.96540433043,      285.11174858870}, 
    {     0.00000001575,  2.61587292010,      632.73555520340}, 
    {     0.00000001752,  5.21532265401,    25448.00585526019}, 
    {     0.00000002157,  3.55259066996,      594.65070367540}, 
    {     0.00000001536,  1.78514076335,      913.75088631770}, 
    {     0.00000001870,  6.14683645342,      347.36317418380}, 
    {     0.00000001536,  4.09095438925,      236.19364511790}, 
    {     0.00000001553,  0.37345849706,       17.26547538740}, 
    {     0.00000001608,  0.14675669740,      364.34676528090}, 
    {     0.00000002122,  5.47722724050,      369.08206769610}, 
    {     0.00000001691,  3.73922627413,       10.03430830760}, 
    {     0.00000001787,  3.85525912954,      392.65794093220}, 
    {     0.00000001562,  0.79805735081,       66.18357885820}, 
    {     0.00000001495,  2.19380669823,      407.47573576480}, 
    {     0.00000001515,  4.70072295492,      211.29335786790}, 
    {     0.00000001767,  3.11910667879,     2921.12778282460}, 
    {     0.00000001515,  3.31498374761,      215.30483300810}, 
    {     0.00000001871,  5.21036243597,      248.46318565920}, 
    {     0.00000001557,  5.64355948418,      200.03520928290}, 
    {     0.00000001486,  5.75676101208,      632.83192342300}, 
    {     0.00000001718,  2.85718283854,     1364.72809958190}, 
    {     0.00000001843,  0.48469493939,     1127.04998175570}, 
    {     0.00000001511,  1.99675973060,      205.97310011610}, 
    {     0.00000001633,  2.07074945596,      378.64329525170}, 
    {     0.00000001661,  5.25307910207,      219.51887056150}, 
    {     0.00000001937,  4.84740152093,      857.12853501510}, 
    {     0.00000001437,  6.25465521582,     1379.70595310890}, 
    {     0.00000001542,  1.21935754108,      398.14400287280}, 
    {     0.00000001620,  2.84316789810,      633.74694715970}, 
    {     0.00000001489,  4.10155671855,    77837.11123384659}, 
    {     0.00000001573,  4.23741356107,      203.89792657680}, 
    {     0.00000001631,  2.40624856411,      419.43645976540}, 
    {     0.00000001690,  0.65475720351,     2700.71514038580}, 
    {     0.00000001869,  3.54435221295,      354.52490529440}, 
    {     0.00000001929,  4.34743346077,      971.10695080320}, 
    {     0.00000001451,  0.99592525811,      642.34496686880}, 
    {     0.00000001743,  2.48841204719,      976.73602509570}, 
    {     0.00000001817,  3.95203885550,     6076.89030155420}, 
    {     0.00000001758,  3.58375338295,      968.13800538660}, 
    {     0.00000001399,  4.59770409984,      224.60542813280}, 
    {     0.00000001484,  5.76191841490,      448.68959140380}, 
    {     0.00000001523,  0.78390897622,      661.23792731640}, 
    {     0.00000001655,  1.31748248488,    25668.41849769900}, 
    {     0.00000001438,  5.12958189872,       71.81265315070}, 
    {     0.00000001423,  6.22837994155,      904.40210708320}, 
    {     0.00000001929,  4.90721606846,      206.39799675830}, 
    {     0.00000001510,  3.77771207288,      222.70026429920}, 
    {     0.00000001636,  1.44790851578,     1894.41906467650}, 
    {     0.00000001419,  0.21487856183,      434.67494572330}, 
    {     0.00000001767,  0.25099531027,      125.18417474640}, 
    {     0.00000001564,  3.94804398924,     9566.27471289620}, 
    {     0.00000001802,  2.42800455399,      348.63519857100}, 
    {     0.00000001880,  4.95438371109,      201.51968199120}, 
    {     0.00000001630,  0.09698687303,      155.78297225810}, 
    {     0.00000001406,  3.65940442223,      316.50374424120}, 
    {     0.00000001495,  0.77832279170,     5959.57043333400}, 
    {     0.00000001407,  5.37485378705,      317.87634236490}, 
    {     0.00000001356,  3.09618769665,      254.14044406150}, 
    {     0.00000001408,  5.24970924980,      316.27999507200}, 
    {     0.00000001544,  5.13922144133,      768.85355562910}, 
    {     0.00000001881,  4.12588104870,      562.14674233010}, 
    {     0.00000001370,  4.74495578534,     1357.61455258110}, 
    {     0.00000001485,  2.18712736768,     9889.78012955360}, 
    {     0.00000001369,  1.31846306523,     1160.83017300510}, 
    {     0.00000001394,  5.66924517860,     1736.99156101570}, 
    {     0.00000001811,  1.57682442573,     1141.13406340540}, 
    {     0.00000001546,  5.46572516167,      226.04171673130}, 
    {     0.00000001455,  5.49358339565,      504.56118318100}, 
    {     0.00000001495,  5.96827635581,     1226.21060271120}, 
    {     0.00000001447,  1.44933809994,      893.35640681930}, 
    {     0.00000001307,  2.55868405014,      310.76279536410}, 
    {     0.00000001301,  5.76220041204,      714.67888488130}, 
    {     0.00000001471,  4.33649196996,       25.27279426550}, 
    {     0.00000001492,  0.22387011859,      702.14871190910}, 
    {     0.00000001345,  3.00386561569,      843.63515419640}, 
    {     0.00000001306,  2.90378602257,     1091.62525910360}, 
    {     0.00000001434,  3.43728063453,      251.17149864490}, 
    {     0.00000001651,  4.31521847696,     2228.97018159780}, 
    {     0.00000001315,  4.99261176008,       17.52610781830}, 
    {     0.00000001407,  5.79229630947,      188.16931352440}, 
    {     0.00000001544,  3.66627022939,      373.90799283650}, 
    {     0.00000001479,  3.22975472634,      395.10562148700}, 
    {     0.00000001323,  0.24630123172,      346.39996633730}, 
    {     0.00000001544,  5.17153313343,      141.69889060840}, 
    {     0.00000001302,  3.67881511748,      253.45912050530}, 
    {     0.00000001274,  5.73640322425,     2303.60876781320}, 
    {     0.00000001747,  0.24653700930,      263.70167161710}, 
    {     0.00000001690,  5.50438014857,      419.53282798500}, 
    {     0.00000001242,  5.02512547428,      354.99798604640}, 
    {     0.00000001744,  3.70453251764,      147.11551657980}, 
    {     0.00000001498,  4.70203004844,      100.17201291180}, 
    {     0.00000001331,  1.03420766654,     1159.29331067010}, 
    {     0.00000001557,  0.57740217353,     3178.14579056760}, 
    {     0.00000001531,  5.60136729946,      260.36021918500}, 
    {     0.00000001597,  4.46013103327,      432.74853003030}, 
    {     0.00000001291,  0.77502618084,       48.75804477640}, 
    {     0.00000001228,  0.10949459285,     1372.59240610810}, 
    {     0.00000001573,  4.00132484524,     1264.29545423920}, 
    {     0.00000001464,  4.41842460719,      763.43692965770}, 
    {     0.00000001269,  6.06534948978,       25.86349509650}, 
    {     0.00000001572,  1.31215103171,      322.61164478010}, 
    {     0.00000001287,  4.82368466592,      535.91074021810}, 
    {     0.00000001205,  0.24105241435,      466.75821594330}, 
    {     0.00000001188,  1.27112537278,     1184.40604624120}, 
    {     0.00000001199,  1.78020373551,      102.34201469320}, 
    {     0.00000001186,  4.72251265892,      795.68025857210}, 
    {     0.00000001497,  3.44614317326,     3024.22055704320}, 
    {     0.00000001265,  5.78046227081,      531.97858695500}, 
    {     0.00000001230,  5.18147817992,      752.39122939380}, 
    {     0.00000001158,  2.23776758082,      318.67949151700}, 
    {     0.00000001175,  4.35535063059,     3892.68166309700}, 
    {     0.00000001571,  1.60745561424,       67.88049988760}, 
    {     0.00000001150,  3.42711148400,      306.09692891810}, 
    {     0.00000001385,  0.89711064123,     6073.70890781650}, 
    {     0.00000001136,  5.53065311813,     1578.77795454530}, 
    {     0.00000001247,  1.94513483418,      623.22251175760}, 
    {     0.00000001366,  3.99684537321,     6065.84460129030}, 
    {     0.00000001142,  4.35845106342,     1834.61531963620}, 
    {     0.00000001140,  3.13401303125,      611.44309831080}, 
    {     0.00000001127,  0.61883337338,     1166.40685767090}, 
    {     0.00000001403,  0.92404432675,      799.61241183520}, 
    {     0.00000001174,  1.77470409548,     3384.33133900480}, 
    {     0.00000001173,  5.43655584105,      494.47869076360}, 
    {     0.00000001425,  2.65840274172,     1253.77101883710}, 
    {     0.00000001314,  0.15326588436,      493.30303459600}, 
    {     0.00000001134,  1.16341619317,      255.83736509090}, 
    {     0.00000001564,  1.09100285617,      683.02625679790}, 
    {     0.00000001217,  2.18290106978,       17.40848773930}, 
    {     0.00000001410,  4.08121265308,       97.46369992610}, 
    {     0.00000001297,  6.02104813490,      225.07850888480}, 
    {     0.00000001108,  1.99635939822,     3700.72320866140}, 
    {     0.00000001142,  5.96306227849,     1144.31545714310}, 
    {     0.00000001304,  5.24544813643,     5650.29211067820}, 
    {     0.00000001304,  0.78547708972,     1773.91780271860}, 
    {     0.00000001138,  4.47018614395,      680.05731138130}, 
    {     0.00000001384,  3.74284963831,      272.58157561650}, 
    {     0.00000001411,  1.62072757889,    25771.51127191760}, 
    {     0.00000001149,  4.21885813289,      332.17287233570}, 
    {     0.00000001098,  3.75659421786,      318.39760722670}, 
    {     0.00000001117,  3.50712069727,      847.04604259770}, 
    {     0.00000001072,  1.41288617325,     1268.74887236410}, 
    {     0.00000001295,  2.32056477953,    10003.91860403610}, 
    {     0.00000001094,  5.12244388591,      314.38613208650}, 
    {     0.00000001128,  4.05700139843,      118.87377689770}, 
    {     0.00000001277,  5.42029902662,     9996.05429750990}, 
    {     0.00000001086,  1.80330451960,     1457.52593306200}, 
    {     0.00000001265,  5.85587479874,       82.85835341460}, 
    {     0.00000001058,  0.73867502165,      670.91677495100}, 
    {     0.00000001188,  2.10062104482,      423.88987789030}, 
    {     0.00000001051,  1.50055229907,      196.83676920270}, 
    {     0.00000001296,  2.88467024494,      223.33340374560}, 
    {     0.00000001049,  3.43787192741,      771.30123618390}, 
    {     0.00000001360,  4.79139479372,      321.80849562800}, 
    {     0.00000001204,  3.03693665003,      608.40471692500}, 
    {     0.00000001068,  3.48313991728,      754.03576079650}, 
    {     0.00000001175,  0.91096377814,      740.06929922580}, 
    {     0.00000001391,  4.58075086255,     1248.14194454460}, 
    {     0.00000001378,  1.56539991797,      409.18970313670}, 
    {     0.00000001110,  0.75388880657,     1482.79872732750}, 
    {     0.00000001152,  4.43705273794,    10220.39909321180}, 
    {     0.00000001043,  1.17588440529,      398.28701522470}, 
    {     0.00000001115,  3.88267720500,      128.36556848410}, 
    {     0.00000001293,  0.02397468965,     2723.09341168840}, 
    {     0.00000001044,  4.55436071665,       89.75945209430}, 
    {     0.00000001190,  4.49552956816,      429.30650386170}, 
    {     0.00000001253,  1.16885224716,      455.16999895820}, 
    {     0.00000001122,  5.72161306640,    78263.70942472259}, 
    {     0.00000001050,  2.29914438978,      848.53051530600}, 
    {     0.00000001083,  4.69013639040,        1.27202438720}, 
    {     0.00000001252,  5.28238896229,     6080.82245481730}, 
    {     0.00000001036,  1.37191316671,     1251.34038462480}, 
    {     0.00000001047,  6.05833150471,      206.44618086810}, 
    {     0.00000001106,  4.43961682956,      633.30500417500}, 
    {     0.00000001083,  5.04862249728,      629.86297800640}, 
    {     0.00000001024,  4.87634491793,      433.75992198660}, 
    {     0.00000001087,  3.62653860280,      582.38116313410}, 
    {     0.00000001082,  4.07686503205,     1245.17299912800}, 
    {     0.00000001161,  4.20513144049,      827.17282796110}, 
    {     0.00000001010,  0.83370133581,       16.46232623530}, 
    {     0.00000001415,  0.47625687277,      774.00954916960}, 
    {     0.00000001258,  0.13038090471,      101.60830151030}, 
    {     0.00000001197,  0.79148395839,     9580.50180689780}, 
    {     0.00000001402,  4.82957073563,      883.79517926370}, 
    {     0.00000000999,  2.32497777320,       61.28821774860}, 
    {     0.00000001110,  5.88801273512,      657.16276170140}, 
    {     0.00000000996,  4.99081075982,      426.75824957040}, 
    {     0.00000001117,  6.11410083484,      870.46185713940}, 
    {     0.00000001070,  0.29336435059,      119.76754877500}, 
    {     0.00000000996,  1.60533807172,      426.43813218160}, 
    {     0.00000001032,  4.72428387546,      201.99276274320}, 
    {     0.00000001101,  3.93919206905,      632.26247445140}, 
    {     0.00000001118,  4.40767803642,      532.13864564940}, 
    {     0.00000001014,  5.79119811472,     6460.81221096080}, 
    {     0.00000001064,  0.19404592323,     6386.16862421000}, 
    {     0.00000001336,  4.79375117329,     2332.06295581640}, 
    {     0.00000001002,  5.95184354004,     3906.90875709860}, 
    {     0.00000001310,  0.60237129875,     1123.11782849260}, 
    {     0.00000000984,  0.24370826999,      229.76142167330}, 
    {     0.00000001192,  0.39183403313,     1178.98942026980}, 
    {     0.00000000983,  6.19356591342,      962.50893109410}, 
    {     0.00000001032,  5.86748597956,      108.50940019000}, 
    {     0.00000001105,  3.86281159011,      736.83972137830}, 
    {     0.00000001056,  4.23985464910,      113.12708252620}, 
    {     0.00000000976,  1.83523959034,        5.88970672340}, 
    {     0.00000001043,  3.02320720148,      347.41135829360}, 
    {     0.00000001063,  3.90644958468,      683.18631549230}, 
    {     0.00000001041,  2.36429894351,      821.54375366860}, 
    {     0.00000000972,  4.01268690768,      469.72716135990}, 
    {     0.00000001106,  5.22834029531,     1459.95656727430}, 
    {     0.00000001217,  4.61800510389,      990.22940591440}, 
    {     0.00000001171,  0.42265751679,    10011.03215103690}, 
    {     0.00000001171,  6.15008203965,      737.31280213030}, 
    {     0.00000000950,  2.20627976392,      199.12018554620}, 
    {     0.00000001155,  4.33358864948,     1055.44977692610}, 
    {     0.00000000976,  1.05304205075,        8.33738727820}, 
    {     0.00000000986,  4.77927211762,      109.68505635760}, 
    {     0.00000000965,  4.09286645443,      522.52923398400}, 
    {     0.00000001203,  5.48783494218,     2810.92146160520}, 
    {     0.00000001139,  1.05860663139,      369.97583957340}, 
    {     0.00000001083,  3.06419651551,      700.45179087970}, 
    {     0.00000000962,  5.58253892259,       47.06112374700}, 
    {     0.00000001097,  4.27064998408,      384.27236954420}, 
    {     0.00000001006,  5.89037944896,    10007.09999777380}, 
    {     0.00000000967,  1.56852913547,      157.63995198190}, 
    {     0.00000001213,  0.31515805319,      707.56533788050}, 
    {     0.00000001114,  5.58206045644,       92.94084583200}, 
    {     0.00000000937,  5.19215522052,      316.13123722570}, 
    {     0.00000000951,  3.65476455359,     1235.61177157240}, 
    {     0.00000000981,  2.37620383333,       35.21227433100}, 
    {     0.00000000929,  6.06911430142,        0.04818410980}, 
    {     0.00000000961,  1.69324063398,      433.66355376700}, 
    {     0.00000000933,  3.13487131274,      387.24131496080}, 
    {     0.00000000993,  3.58058926281,      735.82832942200}, 
    {     0.00000001287,  6.08212342139,     1329.30337692980}, 
    {     0.00000001015,  6.19122845232,      401.32539661050}, 
    {     0.00000001024,  1.90798238649,     1175.80802653210}, 
    {     0.00000001037,  0.76313958988,      733.42883297700}, 
    {     0.00000001072,  4.95817300234,      631.82053146670}, 
    {     0.00000000993,  0.31814583417,     1365.47885910730}, 
    {     0.00000001134,  5.87478488618,     6058.73105428950}, 
    {     0.00000000999,  3.52478664564,       27.08733537390}, 
    {     0.00000000959,  5.43627627442,       46.20979048510}, 
    {     0.00000000915,  4.87266214195,       18.91000679010}, 
    {     0.00000000999,  1.19719347548,      104.57724692690}, 
    {     0.00000000963,  2.72059732893,      308.31511480930}, 
    {     0.00000001166,  0.83821274577,        4.14460158420}, 
    {     0.00000001039,  2.40020830681,     6475.03930496240}, 
    {     0.00000001141,  2.92863924940,     1037.29052966140}, 
    {     0.00000001005,  6.12430441703,     6275.96230299060}, 
    {     0.00000001224,  1.73535287415,     5120.60114558360}, 
    {     0.00000000924,  5.70601816488,      614.83694036960}, 
    {     0.00000000976,  3.65075292234,     3281.23856478620}, 
    {     0.00000001042,  1.10027795842,     1518.22344997960}, 
    {     0.00000000890,  4.03192782386,     1314.32552340280}, 
    {     0.00000000919,  4.36994806815,     1151.42900414390}, 
    {     0.00000000988,  4.17719296131,       98.42690777260}, 
    {     0.00000001224,  1.56813277780,      498.93210888850}, 
    {     0.00000000914,  0.84094751548,        8.81046803020}, 
    {     0.00000001226,  3.52834223937,       80.41067285980}, 
    {     0.00000000882,  0.83665470112,      294.30046912880}, 
    {     0.00000001049,  0.47324130220,      495.96316347190}, 
    {     0.00000000939,  4.68295941083,     4105.98075853500}, 
    {     0.00000000896,  3.65029741088,      414.81877742920}, 
    {     0.00000001235,  1.23871819142,      357.23321828010}, 
    {     0.00000001218,  0.18349810348,     1090.40141882620}, 
    {     0.00000000909,  5.12780284661,     1173.52040467170}, 
    {     0.00000000948,  5.30478380123,      199.02381732660}, 
    {     0.00000001075,  2.39947623423,      311.72600321060}, 
    {     0.00000000871,  0.34963934486,      338.48327018440}, 
    {     0.00000000895,  1.41605139181,      877.10232338820}, 
    {     0.00000000895,  6.05936094663,     1987.21689815660}, 
    {     0.00000001151,  1.92096829093,      757.80785536520}, 
    {     0.00000000864,  0.73362618982,     1152.17976366930}, 
    {     0.00000001161,  5.43333581656,     1089.12939443900}, 
    {     0.00000000957,  3.12919808399,      628.59095361920}, 
    {     0.00000000860,  5.69748024851,      103.84353374400}, 
    {     0.00000000910,  3.29147304619,      159.71512552120}, 
    {     0.00000000870,  0.77956473768,      907.37105249980}, 
    {     0.00000001158,  3.33343863758,     6290.18939699220}, 
    {     0.00000001036,  3.11936047271,     5429.87946823940}, 
    {     0.00000000852,  6.23629650974,      938.88066823130}, 
    {     0.00000000888,  5.86925802792,      156.67674413540}, 
    {     0.00000000832,  5.19725706044,      475.35623565240}, 
    {     0.00000001039,  4.56635505777,     1912.57831194120}, 
    {     0.00000000850,  4.08197558202,     3333.49887969900}, 
    {     0.00000000890,  0.24277485157,     3803.81598288000}, 
    {     0.00000000887,  3.46938383985,     1748.78802080500}, 
    {     0.00000000862,  3.35450376868,      425.32616648880}, 
    {     0.00000000812,  4.75534187737,      620.25356634100}, 
    {     0.00000000876,  4.06819335830,      413.85556958270}, 
    {     0.00000000920,  5.33063977936,      110.72758608120}, 
    {     0.00000001065,  0.20426944617,      439.93151300030}, 
    {     0.00000000898,  5.42633037147,      236.87496867410}, 
    {     0.00000000862,  3.24167644464,      427.87021526320}, 
    {     0.00000000839,  4.55976894141,       77.96299230500}, 
    {     0.00000000793,  5.01131700831,      109.99387289830}, 
    {     0.00000000883,  5.91547058278,       13.33332212430}, 
    {     0.00000000791,  2.21809404489,      110.41876954050}, 
    {     0.00000000842,  5.04957483607,      444.12429869430}, 
    {     0.00000000844,  3.26239911598,      635.70450062000}, 
    {     0.00000000887,  4.23752031725,     3553.91152213780}, 
    {     0.00000000813,  1.94182459500,      627.15466502070}, 
    {     0.00000000953,  1.84900597155,      835.78789401270}, 
    {     0.00000000966,  4.55013458162,     9360.08916445900}, 
    {     0.00000001092,  0.58153747940,      203.26478713040}, 
    {     0.00000000814,  4.01510494376,      604.47256366190}, 
    {     0.00000000811,  1.22144185843,      254.35289238260}, 
    {     0.00000000786,  3.84829878956,      194.38908864790}, 
    {     0.00000000774,  3.76050639310,      219.14061805160}, 
    {     0.00000000781,  5.08832725435,      802.79380557290}, 
    {     0.00000000876,  5.19448877884,      948.21240112330}, 
    {     0.00000001077,  4.29979657165,     5753.38488489680}, 
    {     0.00000000901,  1.36051594017,     1201.83158032300}, 
    {     0.00000000774,  4.80415223158,      394.35486196160}, 
    {     0.00000000780,  4.94962976798,      532.87235883230}, 
    {     0.00000000827,  5.64337714429,     2620.00063746980}, 
    {     0.00000000772,  2.30361551098,      949.12742486000}, 
    {     0.00000000818,  2.52609626540,    26301.20223701220}, 
    {     0.00000000855,  3.28701649613,       95.01601937130}, 
    {     0.00000000928,  0.72021151346,      740.28174754690}, 
    {     0.00000000974,  1.55167938413,      186.47239249500}, 
    {     0.00000000895,  5.83218231202,     4539.69249641180}, 
    {     0.00000000824,  3.48188126089,      845.33207522580}, 
    {     0.00000000751,  5.07329791290,      476.10699517780}, 
    {     0.00000000773,  2.77996323939,      688.65533109040}, 
    {     0.00000000939,  3.68460642343,      817.77165909990}, 
    {     0.00000000910,  4.40175612169,     2648.45482547300}, 
    {     0.00000000753,  0.04254534997,     1534.73816584160}, 
    {     0.00000000741,  0.04675642866,      846.13101886100}, 
    {     0.00000000736,  0.63322927327,       58.10682401090}, 
    {     0.00000000776,  5.42586716249,     5540.08578945880}, 
    {     0.00000000860,  4.24463603685,       29.20494752860}, 
    {     0.00000000751,  2.43181413413,      625.88264063350}, 
    {     0.00000000852,  3.11058720799,      232.42155054920}, 
    {     0.00000000722,  5.34176028966,      949.22379307960}, 
    {     0.00000000722,  0.45293446355,      522.62560220360}, 
    {     0.00000000896,  0.32751625766,      229.34073054800}, 
    {     0.00000000722,  3.96121088528,     1474.93442080130}, 
    {     0.00000000715,  4.41679796625,       19.12245511120}, 
    {     0.00000000788,  0.99170388242,      121.84272231430}, 
    {     0.00000000713,  3.68141955548,     4532.57894941100}, 
    {     0.00000000722,  4.16734185316,      232.20910222810}, 
    {     0.00000000969,  2.31953080666,      566.60016045500}, 
    {     0.00000000795,  6.16762624120,     1475.68518032670}, 
    {     0.00000000713,  0.83529892802,     1884.12412393800}, 
    {     0.00000000731,  6.11847213487,     1239.54392483550}, 
    {     0.00000000871,  5.94461985599,       11.30633269480}, 
    {     0.00000000750,  5.31040934310,     9683.59458111640}, 
    {     0.00000000861,  1.84312756285,      984.60033162190}, 
    {     0.00000000695,  4.78088165969,    10419.47109464820}, 
    {     0.00000000746,  1.40148355303,      782.34693644780}, 
    {     0.00000000829,  5.85923720925,      845.11962690470}, 
    {     0.00000000739,  5.21951835749,     3679.38256765900}, 
    {     0.00000000692,  3.38736418117,     6489.26139842860}, 
    {     0.00000000694,  3.07863807714,      316.60431797770}, 
    {     0.00000000690,  5.86681311380,      316.17942133550}, 
    {     0.00000000714,  5.38707933404,      567.82400073240}, 
    {     0.00000000774,  3.17401887776,      846.03465064140}, 
    {     0.00000000750,  3.05400490211,       66.91729204110}, 
    {     0.00000000767,  0.12081849650,      485.88067105450}, 
    {     0.00000000705,  0.57839934869,     1053.75285589670}, 
    {     0.00000000684,  4.88442270630,     2545.36205125440}, 
    {     0.00000000684,  5.35202323443,     1193.96727379680}, 
    {     0.00000000692,  3.63694823733,      599.64663852150}, 
    {     0.00000000883,  1.46307267703,      112.91463420510}, 
    {     0.00000000827,  2.59300433753,      232.94281541100}, 
    {     0.00000000686,  2.16126205234,      529.73914920440}, 
};


static const struct ln_vsop saturn_radius_r1[RADIUS_R1] = {
    {     0.06182981340,  0.25843511480,      213.29909543800}, 
    {     0.00506577242,  0.71114625261,      206.18554843720}, 
    {     0.00341394029,  5.79635741658,      426.59819087600}, 
    {     0.00188491195,  0.47215589652,      220.41264243880}, 
    {     0.00186261486,  3.14159265359,        0.00000000000}, 
    {     0.00143891146,  1.40744822888,        7.11354700080}, 
    {     0.00049621208,  6.01744279820,      103.09277421860}, 
    {     0.00020928426,  5.09244947411,      639.89728631400}, 
    {     0.00019952564,  1.17560606130,      419.48464387520}, 
    {     0.00018839544,  1.60818334043,      110.20632121940}, 
    {     0.00012892843,  5.94329433020,      433.71173787680}, 
    {     0.00013876849,  0.75884928866,      199.07200143640}, 
    {     0.00005396842,  1.28853589711,       14.22709400160}, 
    {     0.00004869289,  0.86797227054,      323.50541665740}, 
    {     0.00004247221,  0.39294984732,      227.52618943960}, 
    {     0.00003252331,  1.25850154330,       95.97922721780}, 
    {     0.00002856066,  2.16731283870,      735.87651353180}, 
    {     0.00002909540,  4.60680719251,      202.25339517410}, 
    {     0.00003081410,  3.43662543526,      522.57741809380}, 
    {     0.00001987731,  2.45053765034,      412.37109687440}, 
    {     0.00001941443,  6.02392296904,      209.36694217490}, 
    {     0.00001581782,  1.29189091556,      210.11770170030}, 
    {     0.00001339521,  4.30812522038,      853.19638175200}, 
    {     0.00001315459,  1.25295611814,      117.31986822020}, 
    {     0.00001202869,  1.86661895487,      316.39186965660}, 
    {     0.00001090827,  0.07529636493,      216.48048917570}, 
    {     0.00000954300,  5.15171167674,      647.01083331480}, 
    {     0.00000965957,  0.47988871608,      632.78373931320}, 
    {     0.00000882063,  1.88467410042,     1052.26838318840}, 
    {     0.00000874310,  1.40216274572,      224.34479570190}, 
    {     0.00000897508,  0.98347755563,      529.69096509460}, 
    {     0.00000784828,  3.06374185689,      838.96928775040}, 
    {     0.00000739765,  1.38209924525,      625.67019231240}, 
    {     0.00000612930,  3.03309390383,       63.73589830340}, 
    {     0.00000658132,  4.14374715020,      309.27832265580}, 
    {     0.00000649590,  1.72473111863,      742.99006053260}, 
    {     0.00000599227,  2.54946247931,      217.23124870110}, 
    {     0.00000502951,  2.12941646895,        3.93215326310}, 
    {     0.00000412937,  4.59321186186,      415.55249061210}, 
    {     0.00000355987,  2.30328555624,      728.76296653100}, 
    {     0.00000344652,  5.88820160547,      440.82528487760}, 
    {     0.00000394995,  0.53397103760,      956.28915597060}, 
    {     0.00000335677,  1.61590789073,     1368.66025284500}, 
    {     0.00000362976,  4.70597807520,      302.16477565500}, 
    {     0.00000321577,  0.97932351230,        3.18139373770}, 
    {     0.00000277708,  0.25951592662,      195.13984817330}, 
    {     0.00000291180,  2.83137010050,     1155.36115740700}, 
    {     0.00000265342,  2.42688922787,       88.86568021700}, 
    {     0.00000264620,  5.82810809153,      149.56319713460}, 
    {     0.00000316952,  3.58395969651,      515.46387109300}, 
    {     0.00000294362,  2.81544110682,       11.04570026390}, 
    {     0.00000244591,  1.04536406733,      942.06206196900}, 
    {     0.00000215355,  3.56547915194,      490.33408917940}, 
    {     0.00000263891,  1.28577306550,     1059.38193018920}, 
    {     0.00000245985,  0.90791252506,      191.95845443560}, 
    {     0.00000221909,  5.13181138104,      269.92144674060}, 
    {     0.00000195132,  4.56582271431,      846.08283475120}, 
    {     0.00000182943,  2.67926427647,      127.47179660680}, 
    {     0.00000181431,  4.93450656865,       74.78159856730}, 
    {     0.00000174706,  3.44549385972,      137.03302416240}, 
    {     0.00000165475,  5.99806063883,      536.80451209540}, 
    {     0.00000154921,  1.19719941288,      265.98929347750}, 
    {     0.00000169692,  4.63444302692,      284.14854074220}, 
    {     0.00000151250,  0.52845074060,      330.61896365820}, 
    {     0.00000152300,  5.43871996026,      422.66603761290}, 
    {     0.00000140611,  2.02083462656,     1045.15483618760}, 
    {     0.00000157686,  2.99426635258,      340.77089204480}, 
    {     0.00000139555,  1.35322655321,     1685.05212250160}, 
    {     0.00000140990,  1.27118040150,      203.00415469950}, 
    {     0.00000135874,  5.01655087212,      351.81659230870}, 
    {     0.00000153415,  0.26924047897,     1272.68102562720}, 
    {     0.00000129293,  1.14375799011,       21.34064100240}, 
    {     0.00000127810,  2.53730683511,     1471.75302706360}, 
    {     0.00000126354,  3.00342230503,      277.03499374140}, 
    {     0.00000100208,  3.61417145482,     1066.49547719000}, 
    {     0.00000103009,  0.38169227203,      203.73786788240}, 
    {     0.00000107261,  4.31791292903,      210.85141488320}, 
    {     0.00000096106,  0.79400471601,     1258.45393162560}, 
    {     0.00000082432,  0.28130594750,      234.63973644040}, 
    {     0.00000098329,  2.56113375171,      191.20769491020}, 
    {     0.00000097253,  3.26221061562,      831.85574074960}, 
    {     0.00000072231,  4.37989037807,      860.30992875280}, 
    {     0.00000070663,  0.73027101376,      437.64389113990}, 
    {     0.00000070354,  0.87651138500,      423.41679713830}, 
    {     0.00000071862,  5.58023540653,      429.77958461370}, 
    {     0.00000073026,  0.62391865714,     1375.77379984580}, 
    {     0.00000066398,  2.68226810752,      405.25754987360}, 
    {     0.00000063500,  1.75147930200,     1361.54670584420}, 
    {     0.00000061591,  1.09281357936,     2001.44399215820}, 
    {     0.00000067049,  0.06892389889,      408.43894361130}, 
    {     0.00000068948,  2.47236189878,      949.17560896980}, 
    {     0.00000060266,  2.25229650271,     1788.14489672020}, 
    {     0.00000066978,  5.45314123697,      200.76892246580}, 
    {     0.00000065588,  0.05566059213,     1589.07289528380}, 
    {     0.00000049380,  4.17156251836,      138.51749687070}, 
    {     0.00000055431,  4.59287180519,      628.85158605010}, 
    {     0.00000050576,  6.26929954106,      223.59403617650}, 
    {     0.00000047838,  0.83640381014,       10.29494073850}, 
    {     0.00000046677,  2.17434678208,      312.19908396260}, 
    {     0.00000054368,  0.28245674140,      124.43341522100}, 
    {     0.00000049402,  3.79857810717,      215.74677599280}, 
    {     0.00000039837,  5.17790796777,     1478.86657406440}, 
    {     0.00000039385,  0.56431193299,     1574.84580128220}, 
    {     0.00000034944,  4.68657210063,       38.13303563780}, 
    {     0.00000036698,  0.62957662315,       52.69019803950}, 
    {     0.00000042625,  2.98722916534,     1148.24761040620}, 
    {     0.00000039684,  0.28575318525,      131.40394986990}, 
    {     0.00000031822,  5.18978322396,       76.26607127560}, 
    {     0.00000032894,  1.97423476342,      142.44965013380}, 
    {     0.00000041928,  4.82822003035,      288.08069400530}, 
    {     0.00000030753,  1.47899080224,     1677.93857550080}, 
    {     0.00000042664,  3.38153700265,      208.63322899200}, 
    {     0.00000029240,  4.95613345683,     1795.25844372100}, 
    {     0.00000029268,  5.09912997273,      654.12438031560}, 
    {     0.00000032781,  6.12212232937,      145.63104387150}, 
    {     0.00000028968,  2.74363421275,      404.50679034820}, 
    {     0.00000028114,  0.83461605023,     2317.83586181480}, 
    {     0.00000027672,  2.24392488187,      430.53034413910}, 
    {     0.00000029995,  1.96800014066,     2104.53676637680}, 
    {     0.00000033001,  3.28430957393,      222.86032299360}, 
    {     0.00000031850,  6.02546244620,     1905.46476494040}, 
    {     0.00000027041,  5.24903909688,      388.46515523820}, 
    {     0.00000026641,  0.99264332766,      107.02492748170}, 
    {     0.00000025510,  2.87428732059,      703.63318461740}, 
    {     0.00000025131,  6.23420740285,      106.27416795630}, 
    {     0.00000024878,  1.07497317697,       99.91138048090}, 
    {     0.00000024759,  0.80405733736,      312.45971639350}, 
    {     0.00000024276,  0.55199141887,      214.26230328450}, 
    {     0.00000028499,  0.83349243224,     1692.16566950240}, 
    {     0.00000023219,  5.08264293708,      479.28838891550}, 
    {     0.00000024526,  3.10619175315,      212.33588759150}, 
    {     0.00000022349,  3.90137970384,      563.63121503840}, 
    {     0.00000022702,  4.87840606475,      295.05122865420}, 
    {     0.00000021955,  6.06698971563,       85.82729883120}, 
    {     0.00000021324,  5.10526973374,      333.65734504400}, 
    {     0.00000026085,  2.20779309963,     1265.56747862640}, 
    {     0.00000020837,  3.28797767286,       70.84944530420}, 
    {     0.00000021581,  3.79617408343,      347.88443904560}, 
    {     0.00000021654,  3.08846245324,      554.06998748280}, 
    {     0.00000022052,  4.22754164002,      217.96496188400}, 
    {     0.00000020731,  1.68960056607,      231.45834270270}, 
    {     0.00000020494,  2.46182647087,       18.15924726470}, 
    {     0.00000020925,  0.39175133338,      319.57326339430}, 
    {     0.00000026026,  4.27724058407,      483.22054217860}, 
    {     0.00000020643,  5.12362856107,      362.86229257260}, 
    {     0.00000022054,  5.50298000967,      343.21857259960}, 
    {     0.00000019345,  2.01922865065,      313.21047591890}, 
    {     0.00000020192,  5.08643103603,      750.10360753340}, 
    {     0.00000020028,  3.42922105654,      213.34727954780}, 
    {     0.00000024142,  0.64640167712,      207.88246946660}, 
    {     0.00000021796,  0.73044797708,       99.16062095550}, 
    {     0.00000017270,  4.71665063052,     2111.65031337760}, 
    {     0.00000020982,  2.69008992251,     1464.63948006280}, 
    {     0.00000018742,  0.05702129406,      245.54242435240}, 
    {     0.00000017629,  3.83853708584,      497.44763618020}, 
    {     0.00000016065,  4.22980270200,      565.11568774670}, 
    {     0.00000021656,  4.16347847969,        2.44768055480}, 
    {     0.00000017000,  1.40795878071,      114.13847448250}, 
    {     0.00000015876,  0.27065386568,      225.82926841020}, 
    {     0.00000015852,  1.20805133747,     1994.33044515740}, 
    {     0.00000015470,  2.82288536731,       81.75213321620}, 
    {     0.00000016429,  3.03873564611,      134.58534360760}, 
    {     0.00000015136,  3.85043836712,     1162.47470440780}, 
    {     0.00000016356,  4.94371307069,      357.44566660120}, 
    {     0.00000015753,  0.32401034699,     1891.23767093880}, 
    {     0.00000020149,  0.23046694374,      213.25091132820}, 
    {     0.00000015979,  1.70399938448,     2420.92863603340}, 
    {     0.00000018200,  5.69547541771,       56.62235130260}, 
    {     0.00000013748,  0.57922924289,     2634.22773147140}, 
    {     0.00000013932,  5.71088147183,       92.04707395470}, 
    {     0.00000017364,  3.55895968238,      218.92816973050}, 
    {     0.00000015270,  1.31086107175,      216.21985674480}, 
    {     0.00000012507,  5.19472995904,      635.96513305090}, 
    {     0.00000012805,  1.60063026728,      320.32402291970}, 
    {     0.00000013030,  0.46515761650,     1169.58825140860}, 
    {     0.00000011971,  5.95102208296,      543.91805909620}, 
    {     0.00000012216,  2.45946622951,      721.64941953020}, 
    {     0.00000011810,  2.80512639599,      217.49188113200}, 
    {     0.00000014690,  5.56197626202,      344.70304530790}, 
    {     0.00000012762,  1.63557330778,      273.10284047830}, 
    {     0.00000013314,  5.76062418273,     2221.85663459700}, 
    {     0.00000011988,  1.77229641324,      160.60889739850}, 
    {     0.00000014265,  0.44725822344,     2008.55753915900}, 
    {     0.00000012411,  1.01142427141,      329.72519178090}, 
    {     0.00000010525,  1.57671345470,      212.77783057620}, 
    {     0.00000012743,  1.91463999780,     1581.95934828300}, 
    {     0.00000011823,  4.43654103110,       32.24332891440}, 
    {     0.00000012921,  3.76048627039,      508.35032409220}, 
    {     0.00000011939,  4.31098492065,      618.55664531160}, 
    {     0.00000011699,  5.10149029775,        4.66586644600}, 
    {     0.00000010438,  2.42664333945,      546.95644048200}, 
    {     0.00000010780,  0.76340329047,      218.71572140940}, 
    {     0.00000009965,  0.48733890713,      305.34616939270}, 
    {     0.00000011374,  3.00672855291,      198.32124191100}, 
    {     0.00000010188,  2.65217753299,      416.30325013750}, 
    {     0.00000009359,  4.45945668775,     2428.04218303420}, 
    {     0.00000009868,  4.04952727454,       62.25142559510}, 
    {     0.00000009739,  1.60270650693,      327.43756992050}, 
    {     0.00000012641,  3.43384418096,      258.87574647670}, 
    {     0.00000011210,  2.41205097192,     1781.03134971940}, 
    {     0.00000009176,  5.46534060702,      414.06801790380}, 
    {     0.00000009835,  3.30296833339,      275.55052103310}, 
    {     0.00000010477,  2.07668803958,      213.82036029980}, 
    {     0.00000009044,  2.92586386765,     1279.79457262800}, 
    {     0.00000009290,  1.11465540663,      113.38771495710}, 
    {     0.00000011089,  1.89011533636,      561.18353448360}, 
    {     0.00000012015,  3.70960372833,      350.33211960040}, 
    {     0.00000008585,  2.17607151845,      425.11371816770}, 
    {     0.00000008579,  1.94628753992,       35.42472265210}, 
    {     0.00000010057,  0.09011158121,      182.27960680100}, 
    {     0.00000008390,  3.76818315225,      251.43213107580}, 
    {     0.00000008492,  0.36083046533,      617.80588578620}, 
    {     0.00000008386,  1.80945274900,      629.60234557550}, 
    {     0.00000008172,  5.14289867445,       22.09140052780}, 
    {     0.00000008147,  5.32044581723,       65.22037101170}, 
    {     0.00000008151,  1.40907734960,        1.48447270830}, 
    {     0.00000007981,  0.94228723999,     2310.72231481400}, 
    {     0.00000008963,  6.16236845633,      621.73803904930}, 
    {     0.00000008224,  0.88795773141,     1485.98012106520}, 
    {     0.00000008265,  3.45191137955,      424.15051032120}, 
    {     0.00000008824,  0.54099064621,      168.05251279940}, 
    {     0.00000008012,  3.37491453205,      144.14657116320}, 
    {     0.00000007866,  5.14081759801,      358.93013930950}, 
    {     0.00000007478,  5.75449166453,      447.93883187840}, 
    {     0.00000008368,  0.33514647428,      278.51946644970}, 
    {     0.00000008084,  1.42623557144,     2737.32050569000}, 
    {     0.00000008080,  0.95897295917,      767.36908292080}, 
    {     0.00000007277,  2.18375316605,      264.50482076920}, 
    {     0.00000008067,  5.44034962793,      254.94359321360}, 
    {     0.00000006773,  1.19893808230,        5.41662597140}, 
    {     0.00000008896,  4.89270901021,      120.35824960600}, 
    {     0.00000006488,  0.32888478249,     2950.61960112800}, 
    {     0.00000007860,  4.57006214060,      280.96714700450}, 
    {     0.00000006488,  3.47445744281,        9.56122755560}, 
    {     0.00000006985,  3.40228409380,       98.89998852460}, 
    {     0.00000007599,  4.50333322023,        5.62907429250}, 
    {     0.00000008097,  0.92606736676,      636.71589257630}, 
    {     0.00000006142,  0.18131149711,     2207.62954059540}, 
    {     0.00000006045,  4.66728537547,      543.02428721890}, 
    {     0.00000006400,  2.12819280953,      274.06604832480}, 
    {     0.00000007002,  3.84517008953,      214.04985496340}, 
    {     0.00000006481,  5.31032923608,     6076.89030155420}, 
    {     0.00000005952,  6.15854896065,      650.94298657790}, 
    {     0.00000005742,  3.56573285563,     1073.60902419080}, 
    {     0.00000006438,  0.44934410249,    10007.09999777380}, 
    {     0.00000005600,  3.61451790802,      125.98732389850}, 
    {     0.00000006258,  3.20899178273,      219.44943459230}, 
    {     0.00000007713,  0.11144371545,     2324.94940881560}, 
    {     0.00000005527,  3.83851162143,      181.05576652360}, 
    {     0.00000005774,  3.03123084747,      121.25202148330}, 
    {     0.00000006617,  1.63984257878,     1898.35121793960}, 
    {     0.00000005881,  1.04006410206,     9992.87290377220}, 
    {     0.00000005831,  5.91627455087,     6062.66320755260}, 
    {     0.00000005653,  2.25485721003,     1038.04128918680}, 
    {     0.00000005908,  6.12631666036,      209.10630974400}, 
    {     0.00000005728,  0.81535963664,      472.17484191470}, 
    {     0.00000006279,  2.11442272676,     2097.42321937600}, 
    {     0.00000005560,  5.81253256927,      237.67811782620}, 
    {     0.00000006143,  4.62450813686,      207.67002114550}, 
    {     0.00000005249,  0.56512879469,      192.69216761850}, 
    {     0.00000005148,  4.85160826999,      267.47376618580}, 
    {     0.00000005330,  4.83867853829,      643.07868005170}, 
    {     0.00000006257,  0.76885025825,      210.37833413120}, 
    {     0.00000005006,  0.83617381840,      247.23934538180}, 
    {     0.00000005102,  4.01017179605,      205.22234059070}, 
    {     0.00000006589,  1.80207391594,       12.53017297220}, 
    {     0.00000004958,  0.25209781984,      129.91947716160}, 
    {     0.00000004879,  4.01833561013,      487.36514376280}, 
    {     0.00000004820,  4.17735674870,     2744.43405269080}, 
    {     0.00000005028,  4.49963257372,      291.26208774300}, 
    {     0.00000005754,  5.50273050205,     2538.24850425360}, 
    {     0.00000005717,  0.56525356391,      116.42609634290}, 
    {     0.00000004721,  5.57698903711,      342.25536475310}, 
    {     0.00000005961,  5.13028344752,      692.58748435350}, 
    {     0.00000005005,  2.67919325691,      417.03696332040}, 
    {     0.00000005371,  3.84343543583,      842.15068148810}, 
    {     0.00000004699,  3.17263913075,      148.07872442630}, 
    {     0.00000006196,  3.80255973994,      339.28641933650}, 
    {     0.00000004531,  5.71955873189,      252.65597135320}, 
    {     0.00000005557,  0.95921182693,     1802.37199072180}, 
    {     0.00000005441,  4.39196994952,      196.62432088160}, 
    {     0.00000004437,  4.92360676724,      184.09414790940}, 
    {     0.00000004981,  1.60730372548,      166.82867252200}, 
    {     0.00000004867,  0.84582358902,       46.47042291600}, 
    {     0.00000004524,  0.25012053389,      128.95626931510}, 
    {     0.00000005519,  6.18074896704,      337.73251065900}, 
    {     0.00000005817,  5.95326497800,      486.40193591630}, 
    {     0.00000004490,  4.72756136280,      151.04766984290}, 
    {     0.00000004229,  4.19753271868,      685.47393735270}, 
    {     0.00000004822,  1.53957590355,      214.78356814630}, 
    {     0.00000004259,  4.89602700674,       14.97785352700}, 
    {     0.00000003976,  2.98413489266,      380.12776796000}, 
    {     0.00000004711,  3.65759071858,      189.72322220190}, 
    {     0.00000004351,  5.42665964067,      436.89313161450}, 
    {     0.00000003867,  3.04703905658,      409.92341631960}, 
    {     0.00000004121,  5.81711354467,      491.81856188770}, 
    {     0.00000003858,  0.73540020809,     2627.11418447060}, 
    {     0.00000004170,  1.17103665385,     3053.71237534660}, 
    {     0.00000003964,  3.09877355914,      710.74673161820}, 
    {     0.00000003700,  1.27418723826,      211.81462272970}, 
    {     0.00000004811,  0.47066044488,      248.72381809010}, 
    {     0.00000004996,  3.35730909586,      824.74219374880}, 
    {     0.00000003907,  3.45934568477,      220.46082654860}, 
    {     0.00000003565,  4.52827067299,      488.84961647110}, 
    {     0.00000004850,  3.70375230989,      235.39049596580}, 
    {     0.00000003549,  2.24093365926,      135.33610313300}, 
    {     0.00000003551,  2.90115048624,      411.62033734900}, 
    {     0.00000003559,  1.11004317365,     6283.07584999140}, 
    {     0.00000003560,  4.54293796144,      601.76425067620}, 
    {     0.00000003527,  1.56280584377,      643.82943957710}, 
    {     0.00000003817,  0.98122521854,      271.40591944890}, 
    {     0.00000003702,  5.50903035820,      458.84151979040}, 
    {     0.00000003603,  3.52371843525,      244.31858407500}, 
    {     0.00000003972,  5.20379695714,      114.39910691340}, 
    {     0.00000003630,  2.21149516722,        2.92076130680}, 
    {     0.00000004441,  3.75471250684,      699.70103135430}, 
    {     0.00000003314,  4.27527294246,      867.42347575360}, 
    {     0.00000004150,  4.21425727533,      501.37978944330}, 
    {     0.00000003259,  4.47232416065,      289.56516671360}, 
    {     0.00000003887,  4.78383139539,      175.16605980020}, 
    {     0.00000003404,  3.49533217629,      963.40270297140}, 
    {     0.00000003223,  5.89367074982,      131.54696222180}, 
    {     0.00000003223,  1.95410765469,      212.02707105080}, 
    {     0.00000003321,  1.95836137959,     1354.43315884340}, 
    {     0.00000003805,  6.21271008290,      268.43697403230}, 
    {     0.00000003380,  1.80720303188,      756.32338265690}, 
    {     0.00000003098,  2.15477201622,      916.93228005540}, 
    {     0.00000003098,  5.51712119470,       24.37902238820}, 
    {     0.00000003082,  6.14482751895,     3267.01147078460}, 
    {     0.00000003113,  4.13740456117,      533.62311835770}, 
    {     0.00000003625,  3.76005340828,      204.70107572890}, 
    {     0.00000003657,  5.27032709245,       67.66805156650}, 
    {     0.00000004003,  6.07055704991,     2641.34127847220}, 
    {     0.00000002882,  0.84196326695,      444.75743814070}, 
    {     0.00000003196,  2.69187071972,      426.64637498580}, 
    {     0.00000003514,  1.39367720888,     2214.74308759620}, 
    {     0.00000003381,  3.69723542122,      229.97386999440}, 
    {     0.00000002850,  4.48074469649,      241.61027108930}, 
    {     0.00000002893,  1.51207793298,      945.99421523210}, 
    {     0.00000003959,  5.96505772017,      212.54833591260}, 
    {     0.00000003540,  1.30228911976,       69.15252427480}, 
    {     0.00000003081,  5.73491728749,      282.66406803390}, 
    {     0.00000003059,  2.59797438443,      905.88657979150}, 
    {     0.00000002794,  3.44247926079,      188.92007304980}, 
    {     0.00000002797,  0.03214799691,      427.56139872250}, 
    {     0.00000002912,  1.70578054502,       28.31117565130}, 
    {     0.00000002788,  0.01934629259,      681.54178408960}, 
    {     0.00000002781,  1.05617356654,       28.45418800320}, 
    {     0.00000003005,  3.90461328299,      526.50957135690}, 
    {     0.00000003279,  2.64942711439,      739.80866679490}, 
    {     0.00000002679,  3.42065965187,      778.41478318470}, 
    {     0.00000002687,  3.21965090864,      776.93031047640}, 
    {     0.00000003193,  2.72165081797,      432.22726516850}, 
    {     0.00000003225,  0.99672485298,     2118.76386037840}, 
    {     0.00000003232,  1.87653144247,     2413.81508903260}, 
    {     0.00000002634,  2.55045330366,    10213.28554621100}, 
    {     0.00000002591,  5.44639271736,      305.08553696180}, 
    {     0.00000002937,  0.84219874440,     2435.15573003500}, 
    {     0.00000002594,  5.42212771611,      207.14875628370}, 
    {     0.00000002552,  3.86374272953,     3060.82592234740}, 
    {     0.00000002549,  5.91713564413,      439.12836384820}, 
    {     0.00000002989,  2.55690619710,      425.63498302950}, 
    {     0.00000003263,  2.59868619716,      213.03846300710}, 
    {     0.00000003107,  4.04496319473,        6.15033915430}, 
    {     0.00000002506,  0.17179793992,      945.24345570670}, 
    {     0.00000002829,  4.83740912540,      397.39324334740}, 
    {     0.00000003167,  5.70962048994,      381.35160823740}, 
    {     0.00000003274,  6.27291197136,      421.18156490460}, 
    {     0.00000002499,  5.28733779933,      299.12639426920}, 
    {     0.00000002584,  4.23448348275,      195.89060769870}, 
    {     0.00000003275,  0.27673788021,      201.51968199120}, 
    {     0.00000002580,  2.62721090534,      213.18722085340}, 
    {     0.00000002491,  5.85060777804,      738.79727483860}, 
    {     0.00000002541,  2.56639705704,      140.00196957900}, 
    {     0.00000002529,  1.99070587972,      319.31263096340}, 
    {     0.00000002467,  3.42927288151,        4.19278569400}, 
    {     0.00000002420,  2.36333597473,       84.34282612290}, 
    {     0.00000002372,  2.19097141324,       17.26547538740}, 
    {     0.00000002346,  3.77641630157,      206.23373254700}, 
    {     0.00000002770,  0.44868346595,      285.63301345050}, 
    {     0.00000002461,  5.42065334253,      395.57870223900}, 
    {     0.00000002352,  0.63041319237,      210.59078245230}, 
    {     0.00000002556,  0.31798127807,      326.68681039510}, 
    {     0.00000003257,  5.02353259776,      313.94418910180}, 
    {     0.00000002396,  4.05648460784,      519.39602435610}, 
    {     0.00000002563,  1.24842307195,      724.83081326790}, 
    {     0.00000002439,  3.49398086505,      431.26405732200}, 
    {     0.00000002299,  0.13437111088,     2524.02141025200}, 
    {     0.00000002299,  4.51974731455,      228.27694896500}, 
    {     0.00000002515,  0.70044371265,     2943.50605412720}, 
    {     0.00000003111,  2.77650913154,      732.69511979410}, 
    {     0.00000002453,  3.14780313298,      170.76082578510}, 
    {     0.00000002673,  3.33934506849,     1141.13406340540}, 
    {     0.00000002501,  3.85258138055,      696.51963761660}, 
    {     0.00000002384,  0.80154277885,     3370.10424500320}, 
    {     0.00000002318,  0.79742541663,      426.07692601420}, 
    {     0.00000002204,  0.22323394228,     3259.89792378380}, 
    {     0.00000002647,  2.60111065092,      436.15941843160}, 
    {     0.00000002126,  0.14832317660,      405.99126305650}, 
    {     0.00000002301,  1.25086250691,      427.11945573780}, 
    {     0.00000002752,  3.02333147039,      468.24268865160}, 
    {     0.00000002128,  3.08760310976,      203.26478713040}, 
    {     0.00000002105,  0.46661118435,      184.98791978670}, 
    {     0.00000002354,  2.59778868023,      511.53171782990}, 
    {     0.00000002333,  3.02634928771,      216.00740842370}, 
    {     0.00000002162,  4.27244747747,        7.16173111060}, 
    {     0.00000002581,  4.73385922413,      221.37585028530}, 
    {     0.00000002074,  0.57960021408,      180.16199464630}, 
    {     0.00000002478,  4.72786315991,      556.51766803760}, 
    {     0.00000002580,  1.03705340380,      213.41097002260}, 
    {     0.00000002025,  2.28785218653,      610.69233878540}, 
    {     0.00000002244,  0.12206585141,      259.76951835400}, 
    {     0.00000002005,  3.14124583124,     1382.88734684660}, 
    {     0.00000002052,  0.74291254690,      200.55647414470}, 
    {     0.00000001985,  3.34537824132,      421.93232443000}, 
    {     0.00000002000,  5.26813039382,      661.23792731640}, 
    {     0.00000002153,  0.85935268348,      286.59622129700}, 
    {     0.00000001936,  1.05286934530,     1262.38608488870}, 
    {     0.00000002039,  1.72125271358,     1670.82502850000}, 
    {     0.00000001901,  0.58371277903,      406.95447090300}, 
    {     0.00000001976,  1.31263772907,      135.54855145410}, 
    {     0.00000002447,  0.52794500154,      429.51895218280}, 
    {     0.00000002174,  2.29627370615,     1773.91780271860}, 
    {     0.00000001895,  2.80891695372,      141.69889060840}, 
    {     0.00000001872,  4.35634331322,      572.22923474750}, 
    {     0.00000001863,  1.48314429040,      638.41281360570}, 
    {     0.00000002007,  1.73735242111,      193.65537546500}, 
    {     0.00000001927,  1.56648434889,      391.17346822390}, 
    {     0.00000001844,  6.11579285251,     1261.63532536330}, 
    {     0.00000002179,  6.14304471748,      205.43478891180}, 
    {     0.00000002094,  5.00798053675,      420.96911658350}, 
    {     0.00000002538,  5.83123621858,      426.55000676620}, 
    {     0.00000002168,  0.41741136149,      213.51154375910}, 
    {     0.00000002433,  1.02613363057,       59.80374504030}, 
    {     0.00000001836,  0.30655659532,      938.12990870590}, 
    {     0.00000001830,  5.54146705928,      206.13736432740}, 
    {     0.00000001776,  2.16382412830,       72.07328558160}, 
    {     0.00000002034,  1.21814866092,     3046.59882834580}, 
    {     0.00000001879,  4.43358651290,      576.16138801060}, 
    {     0.00000001753,  0.06020614247,      241.75328344120}, 
    {     0.00000002168,  3.24685294764,      213.08664711690}, 
    {     0.00000001740,  0.14507117402,      196.03362005060}, 
    {     0.00000001840,  2.85531411351,      842.90144101350}, 
    {     0.00000002254,  5.04269960259,      558.00214074590}, 
    {     0.00000002357,  5.39214088781,     2854.64037391020}, 
    {     0.00000001840,  2.81087023611,      179.35884549420}, 
    {     0.00000001765,  3.65425588942,      403.02231763990}, 
    {     0.00000002147,  1.24753861866,      624.91943278700}, 
    {     0.00000001749,  5.29018685566,       87.31177153950}, 
    {     0.00000001903,  2.91827326906,      398.14400287280}, 
    {     0.00000002073,  2.50732735763,       26.82670294300}, 
    {     0.00000001675,  4.80439517678,      181.80652604900}, 
    {     0.00000001902,  2.74426125465,     4952.06359328620}, 
    {     0.00000001962,  3.52111949662,      213.45915413240}, 
    {     0.00000002076,  3.27905969320,     1596.18644228460}, 
    {     0.00000001892,  6.08128888555,      230.70758317730}, 
    {     0.00000001750,  1.10237257017,      586.31331639720}, 
    {     0.00000001710,  2.14595287920,     1056.20053645150}, 
    {     0.00000001616,  2.12300497232,      430.79097657000}, 
    {     0.00000001681,  6.09941304210,      952.35700270750}, 
    {     0.00000001655,  2.26128695913,      418.52143602870}, 
    {     0.00000001871,  5.61838915758,     2957.73314812880}, 
    {     0.00000001962,  0.13564680851,      213.13903674360}, 
    {     0.00000001629,  2.83974065181,       92.79783348010}, 
    {     0.00000002145,  5.44218817748,      627.36711334180}, 
    {     0.00000001792,  1.07109040443,      355.74874557180}, 
    {     0.00000001647,  0.82347900016,      214.57111982520}, 
    {     0.00000001624,  1.17583107487,      739.05790726950}, 
    {     0.00000001524,  2.71525171937,       73.29712585900}, 
    {     0.00000001788,  1.24908512950,      219.89137757700}, 
    {     0.00000001524,  5.26558677448,     5429.87946823940}, 
    {     0.00000001615,  2.98996883280,       45.57665103870}, 
    {     0.00000001692,  1.91984860233,      630.33605875840}, 
    {     0.00000001742,  0.38573693332,      831.10498122420}, 
    {     0.00000001920,  5.19783839519,      550.13783421970}, 
    {     0.00000001936,  2.81335247199,      429.04587143080}, 
    {     0.00000001504,  1.90331343411,      205.66428357540}, 
    {     0.00000001596,  0.99004701777,      953.10776223290}, 
    {     0.00000001782,  3.91453968301,      159.12442469020}, 
    {     0.00000001470,  5.46587523637,      273.85360000370}, 
    {     0.00000001460,  1.31673789760,       84.93352695390}, 
    {     0.00000001479,  5.27664183474,      757.21715453420}, 
    {     0.00000001455,  2.61054780734,      850.01498801430}, 
    {     0.00000001808,  3.96315121347,     1699.27921650320}, 
    {     0.00000001643,  0.57689283331,      532.61172640140}, 
    {     0.00000001887,  2.78798625347,      418.00017116690}, 
    {     0.00000001607,  1.08154126629,      518.38463239980}, 
    {     0.00000001680,  3.17515284087,      105.54045477340}, 
    {     0.00000001641,  2.91802756388,      172.24529849340}, 
    {     0.00000001480,  4.08712341396,      206.93630796260}, 
    {     0.00000001407,  3.23765622180,      453.42489381900}, 
    {     0.00000001631,  1.06286709889,      213.55972786890}, 
    {     0.00000001466,  1.13594271587,      731.94436026870}, 
    {     0.00000001389,  0.40584159469,     9360.08916445900}, 
    {     0.00000001496,  1.12030845793,      423.67742956920}, 
    {     0.00000001668,  4.32873096627,      173.94221952280}, 
    {     0.00000001467,  0.03783145221,      432.01481684740}, 
    {     0.00000001824,  0.24130491507,      220.36445832900}, 
    {     0.00000001408,  3.34120468096,      934.94851496820}, 
    {     0.00000001341,  1.40041251657,      373.90799283650}, 
    {     0.00000001340,  1.30057612449,      428.08266358430}, 
    {     0.00000001663,  2.38182712355,      188.02630117250}, 
    {     0.00000001416,  3.65464640816,        6.85291456990}, 
    {     0.00000001390,  0.72143566917,     2751.54759969160}, 
    {     0.00000001562,  5.99871360541,      292.01284726840}, 
    {     0.00000001388,  1.31100159458,     6275.96230299060}, 
    {     0.00000001351,  5.85616582168,     5863.59120611620}, 
    {     0.00000001475,  1.21040113552,     2531.13495725280}, 
    {     0.00000001481,  4.93476986510,      384.05992122310}, 
    {     0.00000001271,  3.46636801274,      354.99798604640}, 
    {     0.00000001437,  4.05228413274,      177.87437278590}, 
    {     0.00000001619,  2.44942359064,     1049.08698945070}, 
    {     0.00000001626,  3.16002444915,      835.78789401270}, 
    {     0.00000001249,  2.97028182853,    51749.20809227239}, 
    {     0.00000001387,  3.37238340312,      409.18970313670}, 
    {     0.00000001240,  2.66940683813,     2700.71514038580}, 
    {     0.00000001457,  1.85616688056,       96.87299909510}, 
    {     0.00000001230,  4.27283851216,    12139.55350910680}, 
    {     0.00000001221,  4.36973999431,     3914.02230409940}, 
    {     0.00000001251,  5.29882815294,      306.09692891810}, 
    {     0.00000001400,  5.04071080320,      295.19424100610}, 
    {     0.00000001304,  5.77737491864,       60.55450456570}, 
    {     0.00000001247,  0.99106661572,     9793.80090233580}, 
    {     0.00000001174,  6.11392643811,      823.99143422340}, 
    {     0.00000001231,  1.10890530720,     2303.60876781320}, 
    {     0.00000001186,  4.55984967028,     9808.53818466140}, 
    {     0.00000001401,  2.50099443277,      206.70681329900}, 
    {     0.00000001181,  5.81146592434,      569.04784100980}, 
    {     0.00000001234,  2.72607019445,    10206.17199921020}, 
    {     0.00000001334,  4.87244369722,       54.17467074780}, 
    {     0.00000001198,  5.42400970257,      864.24208201590}, 
    {     0.00000001499,  0.34153793328,       17.40848773930}, 
    {     0.00000001143,  1.61667366569,      238.57188970350}, 
    {     0.00000001199,  1.39732488359,     1987.21689815660}, 
    {     0.00000001266,  5.89383144767,      162.89651925890}, 
    {     0.00000001268,  4.10670310052,     3377.21779200400}, 
    {     0.00000001297,  4.35617934153,      606.76018552230}, 
    {     0.00000001270,  2.05134233573,      525.75881183150}, 
    {     0.00000001203,  1.96781078617,      220.93390730060}, 
    {     0.00000001196,  5.13485214850,      227.31374111850}, 
    {     0.00000001537,  3.54197877408,     2015.67108615980}, 
    {     0.00000001098,  5.09543897410,      107.75864066460}, 
    {     0.00000001153,  5.33028034679,      233.90602325750}, 
    {     0.00000001365,  3.08025915574,      427.34895040140}, 
    {     0.00000001075,  3.06444759157,      464.73122651380}, 
    {     0.00000001374,  2.92410533076,     1457.52593306200}, 
    {     0.00000001352,  2.28174856694,      525.49817940060}, 
    {     0.00000001073,  1.11416151647,      221.16340196420}, 
    {     0.00000001344,  1.64695425702,      857.12853501510}, 
    {     0.00000001184,  2.99776919968,      199.28444975750}, 
    {     0.00000001107,  4.12107153730,      188.16931352440}, 
    {     0.00000001048,  0.92836722889,      162.09337010680}, 
    {     0.00000001042,  3.19127595332,      394.35486196160}, 
    {     0.00000001117,  3.74367882111,      214.19286731530}, 
    {     0.00000001348,  3.91347414537,      318.83955021140}, 
    {     0.00000001423,  5.55111750760,     3274.12501778540}, 
    {     0.00000001002,  3.38741565397,      211.60217440860}, 
    {     0.00000001230,  5.41217826890,      425.84743135060}, 
    {     0.00000000990,  4.85610832843,      611.44309831080}, 
    {     0.00000001038,  2.75247985959,      637.44960575920}, 
    {     0.00000001033,  3.81628585983,      504.56118318100}, 
    {     0.00000001167,  5.17428865567,      838.21852822500}, 
    {     0.00000001014,  5.86348763799,     1268.74887236410}, 
    {     0.00000000971,  0.71587860892,      353.30106501700}, 
    {     0.00000000979,  3.76338750757,     5856.47765911540}, 
    {     0.00000001162,  0.39950647000,      393.46109008430}, 
    {     0.00000001132,  6.20586626566,       42.53826965290}, 
    {     0.00000000993,  2.43898404688,      361.37781986430}, 
    {     0.00000000968,  4.34102490096,       92.94084583200}, 
    {     0.00000000992,  3.44191274254,      244.79166482700}, 
    {     0.00000001040,  2.09854075205,     6290.18939699220}, 
    {     0.00000001199,  4.50333414597,      465.95506679120}, 
    {     0.00000001045,  4.35802840016,      199.96577331370}, 
    {     0.00000000997,  4.30943991893,      212.40532356070}, 
    {     0.00000001112,  2.01573268377,      401.32539661050}, 
    {     0.00000001126,  3.10437252196,     2332.06295581640}, 
    {     0.00000000947,  1.94989936958,     1159.29331067010}, 
    {     0.00000001004,  3.82717589308,      238.42887735160}, 
    {     0.00000000987,  1.93295365583,      184.84490743480}, 
    {     0.00000001267,  2.15471388627,       78.71375183040}, 
    {     0.00000001012,  3.24365897308,      153.49535039770}, 
    {     0.00000000895,  0.68991951614,      731.68372783780}, 
    {     0.00000000984,  3.65764548940,      226.63241756230}, 
    {     0.00000000889,  1.76327775185,      223.33340374560}, 
    {     0.00000000901,  1.12876279070,       51.20572533120}, 
    {     0.00000000895,  1.86564778046,      622.48879857470}, 
    {     0.00000001020,  5.53181822898,        0.04818410980}, 
    {     0.00000000873,  5.78462965667,      480.77286162380}, 
    {     0.00000000854,  1.63255087291,      328.24071907260}, 
    {     0.00000000853,  1.59662886472,      477.80391620720}, 
    {     0.00000000952,  1.99527233195,      969.62247809490}, 
    {     0.00000000858,  5.33623034689,      450.97721326420}, 
    {     0.00000000867,  2.93211582569,      532.87235883230}, 
    {     0.00000000900,  1.32666825337,      700.45179087970}, 
    {     0.00000001123,  4.07401922216,     3693.60966166060}, 
    {     0.00000000870,  5.51456846454,      159.71512552120}, 
    {     0.00000000890,  1.03814593125,      960.22130923370}, 
    {     0.00000001007,  2.73615455688,     4841.85727206680}, 
    {     0.00000000940,  4.20216070094,      597.35901666110}, 
    {     0.00000000941,  5.31417860339,      369.97583957340}, 
    {     0.00000000811,  0.48369226007,      219.66188291340}, 
    {     0.00000001031,  5.83082902191,      460.53844081980}, 
    {     0.00000000818,  0.74630905568,     1048.33622992530}, 
    {     0.00000000954,  5.17333118080,      263.70167161710}, 
    {     0.00000000804,  1.29176785836,     2847.52682690940}, 
    {     0.00000000816,  5.61212780797,      885.43971066640}, 
    {     0.00000000876,  3.52478548820,    10220.39909321180}, 
    {     0.00000000814,  0.18673966399,     2840.41327990860}, 
    {     0.00000000823,  5.54820600927,     3171.03224356680}, 
    {     0.00000000861,  4.39588667312,      552.58551477450}, 
    {     0.00000000791,  2.62306937203,     1912.57831194120}, 
    {     0.00000000754,  3.62688875653,     2648.45482547300}, 
    {     0.00000000852,  1.03470840672,     2620.00063746980}, 
    {     0.00000000791,  3.97836634968,      171.65459766240}, 
    {     0.00000000784,  5.95489308729,      561.93429400900}, 
    {     0.00000000972,  4.53754130765,      570.74476203920}, 
    {     0.00000000739,  3.57172839746,      775.23338944700}, 
    {     0.00000000874,  4.15274163736,       41.64449777560}, 
    {     0.00000000831,  1.41326596696,      287.93768165340}, 
    {     0.00000000707,  2.18372065037,       29.20494752860}, 
    {     0.00000000711,  0.00981284716,     2115.58246664070}, 
    {     0.00000000724,  1.54245854571,      201.99276274320}, 
    {     0.00000000939,  0.46037763932,     5488.86810538160}, 
    {     0.00000000939,  1.85473712038,     5062.26991450560}, 
    {     0.00000000724,  1.62856264107,     2200.51599359460}, 
    {     0.00000000706,  0.31965789145,      898.77303279070}, 
    {     0.00000000681,  6.01812948937,       91.78644152380}, 
};


static const struct ln_vsop saturn_radius_r2[RADIUS_R2] = {
    {     0.00436902572,  4.78671677509,      213.29909543800}, 
    {     0.00071922498,  2.50070069930,      206.18554843720}, 
    {     0.00049766872,  4.97167777235,      220.41264243880}, 
    {     0.00043220783,  3.86941044212,      426.59819087600}, 
    {     0.00029645766,  5.96309886479,        7.11354700080}, 
    {     0.00004141687,  4.10673009419,      433.71173787680}, 
    {     0.00004720822,  2.47524028389,      199.07200143640}, 
    {     0.00003789321,  3.09771189740,      639.89728631400}, 
    {     0.00002963981,  1.37198670946,      103.09277421860}, 
    {     0.00002556403,  2.85066948131,      419.48464387520}, 
    {     0.00002208473,  6.27590108662,      110.20632121940}, 
    {     0.00002187311,  5.85545017140,       14.22709400160}, 
    {     0.00001956779,  4.92451269861,      227.52618943960}, 
    {     0.00002326777,  0.00000000000,        0.00000000000}, 
    {     0.00000923829,  5.46389688910,      323.50541665740}, 
    {     0.00000705974,  2.97065900638,       95.97922721780}, 
    {     0.00000545943,  4.12843012325,      412.37109687440}, 
    {     0.00000373763,  5.83412146980,      117.31986822020}, 
    {     0.00000360843,  3.27730304283,      647.01083331480}, 
    {     0.00000356448,  3.19046275776,      210.11770170030}, 
    {     0.00000390607,  4.48122593284,      216.48048917570}, 
    {     0.00000431231,  5.17807636127,      522.57741809380}, 
    {     0.00000325474,  2.26775488379,      853.19638175200}, 
    {     0.00000404424,  4.17313476718,      209.36694217490}, 
    {     0.00000204458,  0.08803952503,      202.25339517410}, 
    {     0.00000206684,  4.02119282093,      735.87651353180}, 
    {     0.00000177973,  4.09718163123,      440.82528487760}, 
    {     0.00000179903,  3.59725930296,      632.78373931320}, 
    {     0.00000153635,  3.13514267989,      625.67019231240}, 
    {     0.00000147816,  0.13561171385,      302.16477565500}, 
    {     0.00000123132,  4.18808223900,       88.86568021700}, 
    {     0.00000132767,  2.59540724138,      191.95845443560}, 
    {     0.00000100365,  5.46047886103,        3.18139373770}, 
    {     0.00000131964,  5.93411082120,      309.27832265580}, 
    {     0.00000097129,  4.01875371334,      728.76296653100}, 
    {     0.00000110801,  4.78116393398,      838.96928775040}, 
    {     0.00000118896,  5.55283545372,      224.34479570190}, 
    {     0.00000093927,  4.38412535132,      217.23124870110}, 
    {     0.00000108788,  5.29339369085,      515.46387109300}, 
    {     0.00000078560,  5.72528816327,       21.34064100240}, 
    {     0.00000081356,  5.10874041756,      956.28915597060}, 
    {     0.00000096525,  6.25894400082,      742.99006053260}, 
    {     0.00000069181,  4.05005297120,        3.93215326310}, 
    {     0.00000064830,  3.78002548365,     1052.26838318840}, 
    {     0.00000063978,  5.81225801002,      529.69096509460}, 
    {     0.00000062365,  2.18095710071,      195.13984817330}, 
    {     0.00000057229,  3.14757658238,      203.00415469950}, 
    {     0.00000055804,  4.84263005967,      234.63973644040}, 
    {     0.00000053036,  5.07508755229,      330.61896365820}, 
    {     0.00000050918,  2.77244266104,      942.06206196900}, 
    {     0.00000044966,  0.58212370012,      269.92144674060}, 
    {     0.00000041393,  4.78657175977,       63.73589830340}, 
    {     0.00000041412,  3.73171033163,      316.39186965660}, 
    {     0.00000052786,  3.92075360300,      949.17560896980}, 
    {     0.00000038591,  3.74711996033,     1045.15483618760}, 
    {     0.00000037347,  4.19076534429,      536.80451209540}, 
    {     0.00000035490,  2.91778598255,      284.14854074220}, 
    {     0.00000033650,  3.80330571653,      149.56319713460}, 
    {     0.00000040900,  4.58137310079,     1155.36115740700}, 
    {     0.00000030568,  2.48114941443,      860.30992875280}, 
    {     0.00000031258,  4.84287013662,     1272.68102562720}, 
    {     0.00000039345,  3.51497594706,      422.66603761290}, 
    {     0.00000030267,  4.35601859659,      405.25754987360}, 
    {     0.00000029735,  1.58889278109,     1066.49547719000}, 
    {     0.00000035157,  5.94690982234,     1059.38193018920}, 
    {     0.00000025796,  3.55173788540,     1368.66025284500}, 
    {     0.00000026344,  4.80468984306,      124.43341522100}, 
    {     0.00000029862,  3.66430349958,      429.77958461370}, 
    {     0.00000032890,  4.96719279752,      831.85574074960}, 
    {     0.00000022072,  2.76570533706,      415.55249061210}, 
    {     0.00000026103,  4.45521807210,      223.59403617650}, 
    {     0.00000023925,  5.30856839441,       10.29494073850}, 
    {     0.00000027199,  1.66568373581,      277.03499374140}, 
    {     0.00000021600,  1.03111763332,       11.04570026390}, 
    {     0.00000019791,  2.53638693425,     1258.45393162560}, 
    {     0.00000017040,  3.27716162306,      654.12438031560}, 
    {     0.00000017345,  3.49852392962,     1361.54670584420}, 
    {     0.00000015726,  1.72390137596,      490.33408917940}, 
    {     0.00000020965,  3.62456217146,     1265.56747862640}, 
    {     0.00000017893,  4.30763518069,     1471.75302706360}, 
    {     0.00000013547,  0.32283926763,      295.05122865420}, 
    {     0.00000012646,  3.13027912532,       74.78159856730}, 
    {     0.00000015208,  3.59590956406,      265.98929347750}, 
    {     0.00000011701,  2.33365710225,      210.85141488320}, 
    {     0.00000015492,  5.01357631979,      127.47179660680}, 
    {     0.00000012792,  4.61580100969,     1589.07289528380}, 
    {     0.00000010737,  5.04941789777,      191.20769491020}, 
    {     0.00000014117,  3.04728052859,      423.41679713830}, 
    {     0.00000011052,  4.51972952811,       81.75213321620}, 
    {     0.00000013338,  4.88999937030,      437.64389113990}, 
    {     0.00000010549,  5.02936454854,      137.03302416240}, 
    {     0.00000014258,  4.69192994950,     1148.24761040620}, 
    {     0.00000013432,  1.91117077070,      408.43894361130}, 
    {     0.00000010094,  5.20250555714,      340.77089204480}, 
    {     0.00000010411,  3.33366465751,     1685.05212250160}, 
    {     0.00000009520,  3.19193162671,      351.81659230870}, 
    {     0.00000011397,  5.48081632887,     1375.77379984580}, 
    {     0.00000008777,  2.80839077219,       99.91138048090}, 
    {     0.00000008733,  3.22125033819,     1677.93857550080}, 
    {     0.00000007850,  2.36712432378,     1574.84580128220}, 
    {     0.00000007658,  6.08736238432,      231.45834270270}, 
    {     0.00000009222,  3.40983965001,     1581.95934828300}, 
    {     0.00000008222,  4.04654478628,     1788.14489672020}, 
    {     0.00000007179,  2.00932392414,      131.40394986990}, 
    {     0.00000007672,  3.69477797972,      846.08283475120}, 
    {     0.00000006723,  4.38526201358,      145.63104387150}, 
    {     0.00000006408,  1.31732334919,      215.74677599280}, 
    {     0.00000006290,  4.01002594556,      447.93883187840}, 
    {     0.00000007239,  3.29158763151,      750.10360753340}, 
    {     0.00000006054,  0.55440901153,       18.15924726470}, 
    {     0.00000005878,  4.48086148593,      106.27416795630}, 
    {     0.00000006140,  3.78862477414,      313.21047591890}, 
    {     0.00000006911,  4.84071390677,      319.57326339430}, 
    {     0.00000006823,  5.44107387955,      508.35032409220}, 
    {     0.00000006072,  2.90739860693,      138.51749687070}, 
    {     0.00000007309,  4.37976118424,     1464.63948006280}, 
    {     0.00000005615,  4.17617555150,      721.64941953020}, 
    {     0.00000005140,  2.65252687662,      288.08069400530}, 
    {     0.00000005311,  3.62520849510,     6076.89030155420}, 
    {     0.00000005193,  5.04861839155,    10007.09999777380}, 
    {     0.00000005472,  1.17083335740,       56.62235130260}, 
    {     0.00000005383,  4.35702878688,     1905.46476494040}, 
    {     0.00000005195,  4.18394941363,      543.91805909620}, 
    {     0.00000004765,  3.32372808126,       76.26607127560}, 
    {     0.00000004694,  6.25649673541,      483.22054217860}, 
    {     0.00000004519,  1.21202742896,      200.76892246580}, 
    {     0.00000004922,  3.14333262849,     2001.44399215820}, 
    {     0.00000004712,  1.26507812515,     6062.66320755260}, 
    {     0.00000004851,  2.42490640186,      628.85158605010}, 
    {     0.00000005155,  4.45128636150,      416.30325013750}, 
    {     0.00000004626,  2.68842971043,     9992.87290377220}, 
    {     0.00000004261,  2.01635516905,      347.88443904560}, 
    {     0.00000004843,  5.93693841859,      618.55664531160}, 
    {     0.00000004556,  0.75092365616,      333.65734504400}, 
    {     0.00000004249,  0.82449917175,      222.86032299360}, 
    {     0.00000004342,  0.96273515770,      343.21857259960}, 
    {     0.00000004444,  5.77025648302,      184.84490743480}, 
    {     0.00000004169,  2.95237909837,      107.02492748170}, 
    {     0.00000003894,  2.91997373157,       38.13303563780}, 
    {     0.00000003898,  1.97004731481,      497.44763618020}, 
    {     0.00000003994,  2.91478526694,     1994.33044515740}, 
    {     0.00000005097,  3.13189365474,     1898.35121793960}, 
    {     0.00000003629,  3.25010351543,      362.86229257260}, 
    {     0.00000003699,  4.17117563916,      430.53034413910}, 
    {     0.00000003560,  3.48224021080,      388.46515523820}, 
    {     0.00000003694,  0.89402011536,      703.63318461740}, 
    {     0.00000003606,  0.03487737820,       32.24332891440}, 
    {     0.00000003484,  1.83233211242,       70.84944530420}, 
    {     0.00000003611,  3.27859535883,      635.96513305090}, 
    {     0.00000003479,  1.96759778624,      203.73786788240}, 
    {     0.00000003390,  1.23134045790,      134.58534360760}, 
    {     0.00000003551,  3.29904637657,      357.44566660120}, 
    {     0.00000004236,  5.47583443571,     1692.16566950240}, 
    {     0.00000003289,  0.57265070971,    10213.28554621100}, 
    {     0.00000003247,  5.47801108148,     6283.07584999140}, 
    {     0.00000003125,  2.18412055759,     1891.23767093880}, 
    {     0.00000003319,  3.54362618400,      629.60234557550}, 
    {     0.00000003030,  3.91108704620,      312.19908396260}, 
    {     0.00000004163,  5.19007572863,      404.50679034820}, 
    {     0.00000004076,  4.10841252077,     1781.03134971940}, 
    {     0.00000003774,  3.80557045886,     2104.53676637680}, 
    {     0.00000003206,  3.89813077889,     1038.04128918680}, 
    {     0.00000002872,  2.19770396420,      217.96496188400}, 
    {     0.00000003294,  5.62584228838,      113.38771495710}, 
    {     0.00000003157,  2.95571558329,       52.69019803950}, 
    {     0.00000002888,  2.56166067768,      867.42347575360}, 
    {     0.00000002860,  2.34237875942,      181.05576652360}, 
    {     0.00000003180,  4.22909289398,      337.73251065900}, 
    {     0.00000002899,  5.12520635604,      312.45971639350}, 
    {     0.00000002998,  5.44837420714,      258.87574647670}, 
    {     0.00000003032,  4.11818125540,     1478.86657406440}, 
    {     0.00000003013,  1.61330987129,     1073.60902419080}, 
    {     0.00000002716,  3.14448153596,      358.93013930950}, 
    {     0.00000002765,  6.16872527649,      273.10284047830}, 
    {     0.00000002766,  1.01040617017,     1279.79457262800}, 
    {     0.00000003082,  5.60019300569,      216.21985674480}, 
    {     0.00000003254,  3.92690377039,       85.82729883120}, 
    {     0.00000002661,  2.31705497350,      565.11568774670}, 
    {     0.00000002771,  5.77771382441,      160.60889739850}, 
    {     0.00000002452,  5.31997974830,      444.75743814070}, 
    {     0.00000002410,  0.00880493603,      195.89060769870}, 
    {     0.00000002810,  1.68907631956,      213.34727954780}, 
    {     0.00000002811,  4.77447520427,      213.25091132820}, 
    {     0.00000002434,  4.76729826936,      218.71572140940}, 
    {     0.00000003133,  2.49319891100,     6069.77675455340}, 
    {     0.00000002884,  0.32368080181,      561.18353448360}, 
    {     0.00000002784,  4.19942485410,      650.94298657790}, 
    {     0.00000002554,  5.04372588100,     1169.58825140860}, 
    {     0.00000002981,  3.91292350334,     9999.98645077300}, 
    {     0.00000002631,  1.12699455399,      344.70304530790}, 
    {     0.00000002678,  5.09176744531,      824.74219374880}, 
    {     0.00000002679,  1.68971401870,      208.63322899200}, 
    {     0.00000002648,  2.94415462727,      643.07868005170}, 
    {     0.00000002120,  2.31088616664,     2627.11418447060}, 
    {     0.00000002118,  3.28098774331,      320.32402291970}, 
    {     0.00000002226,  4.08089457879,      131.54696222180}, 
    {     0.00000002553,  3.43332044217,     6275.96230299060}, 
    {     0.00000002670,  3.55722356494,     2420.92863603340}, 
    {     0.00000002005,  2.02382593901,      144.14657116320}, 
    {     0.00000002124,  1.61210282593,      218.92816973050}, 
    {     0.00000002444,  2.95506585634,     2214.74308759620}, 
    {     0.00000001995,  3.54870355383,       22.09140052780}, 
    {     0.00000001938,  4.22895382496,      546.95644048200}, 
    {     0.00000002152,  3.95372746872,     1795.25844372100}, 
    {     0.00000001909,  0.85189037198,      121.25202148330}, 
    {     0.00000001925,  2.91107035422,      636.71589257630}, 
    {     0.00000002195,  3.74800214181,      436.89313161450}, 
    {     0.00000001872,  4.66994466499,      188.02630117250}, 
    {     0.00000002061,  2.87712309214,     2310.72231481400}, 
    {     0.00000002208,  4.83492066978,     1141.13406340540}, 
    {     0.00000002135,  3.00526791204,     2317.83586181480}, 
    {     0.00000001816,  2.80175511920,      291.26208774300}, 
    {     0.00000001897,  1.68036754832,      350.33211960040}, 
    {     0.00000002279,  5.43456146966,      207.88246946660}, 
    {     0.00000001769,  3.54746039561,      329.72519178090}, 
    {     0.00000001759,  1.64172549261,      424.15051032120}, 
    {     0.00000001848,  2.24194286719,      168.05251279940}, 
    {     0.00000001779,  1.36026967744,      212.33588759150}, 
    {     0.00000002106,  4.22304768571,     2221.85663459700}, 
    {     0.00000001711,  1.92063117332,      129.91947716160}, 
    {     0.00000002223,  5.23762818237,       99.16062095550}, 
    {     0.00000001781,  3.29852655586,     1670.82502850000}, 
    {     0.00000001766,  3.55341010945,     1354.43315884340}, 
    {     0.00000002051,  3.73308531316,     2097.42321937600}, 
    {     0.00000001691,  5.10160176441,      214.26230328450}, 
    {     0.00000001757,  4.60923293699,      182.27960680100}, 
    {     0.00000001733,  5.28757672531,       45.57665103870}, 
    {     0.00000001977,  4.85653036081,    10206.17199921020}, 
    {     0.00000001567,  4.47742703992,      210.37833413120}, 
    {     0.00000001551,  2.15558953807,      207.67002114550}, 
    {     0.00000001779,  3.40399834670,     2428.04218303420}, 
    {     0.00000001541,  6.09374778360,      554.06998748280}, 
    {     0.00000001821,  4.15498729351,      225.82926841020}, 
    {     0.00000001483,  1.31282416766,      219.44943459230}, 
    {     0.00000001456,  5.90544857131,        1.48447270830}, 
    {     0.00000001560,  1.01224093587,      235.39049596580}, 
    {     0.00000001753,  0.10174553335,       12.53017297220}, 
    {     0.00000001461,  2.45326772796,      305.34616939270}, 
    {     0.00000001542,  5.51223038941,      204.70107572890}, 
    {     0.00000001723,  5.94689036034,      196.62432088160}, 
    {     0.00000001508,  0.72241135463,      429.04587143080}, 
    {     0.00000001581,  2.64780225512,      207.14875628370}, 
    {     0.00000001476,  6.12782257368,      212.77783057620}, 
    {     0.00000001548,  0.53240818911,      120.35824960600}, 
    {     0.00000001474,  0.33626790634,      213.82036029980}, 
    {     0.00000001370,  5.51600816906,       92.79783348010}, 
    {     0.00000001428,  3.25039966249,      945.99421523210}, 
    {     0.00000001444,  5.69264187185,     1485.98012106520}, 
    {     0.00000001329,  1.97967282090,      198.32124191100}, 
    {     0.00000001752,  2.70090942746,       12.74262129330}, 
    {     0.00000001317,  1.73769800248,     1382.88734684660}, 
    {     0.00000001434,  4.37660077473,     5863.59120611620}, 
    {     0.00000001408,  0.80461100746,     1585.14074202070}, 
    {     0.00000001271,  5.70165238307,        2.92076130680}, 
    {     0.00000001313,  5.57979182873,      128.36556848410}, 
    {     0.00000001250,  0.35839694485,      334.55111692130}, 
    {     0.00000001337,  3.27439246509,      193.65537546500}, 
    {     0.00000001298,  6.18760666624,      526.50957135690}, 
    {     0.00000001319,  5.67233796212,      298.23262239190}, 
    {     0.00000001346,  5.79997037285,     9793.80090233580}, 
    {     0.00000001402,  3.16235877831,      175.16605980020}, 
    {     0.00000001202,  2.88792018909,     2413.81508903260}, 
    {     0.00000001562,  5.00012041556,     2008.55753915900}, 
    {     0.00000001354,  0.94866727482,      217.49188113200}, 
    {     0.00000001292,  5.13478886171,     1162.47470440780}, 
    {     0.00000001197,  1.74106457854,     2207.62954059540}, 
    {     0.00000001281,  0.47848987165,      525.49817940060}, 
    {     0.00000001244,  5.99520374248,       28.45418800320}, 
    {     0.00000001148,  2.17212855226,     1055.44977692610}, 
    {     0.00000001282,  6.12823934151,     1802.37199072180}, 
    {     0.00000001304,  0.37337923280,     3473.19701922180}, 
    {     0.00000001215,  3.87917402622,      209.10630974400}, 
    {     0.00000001117,  3.33328660827,      661.23792731640}, 
    {     0.00000001367,  1.00973749169,      621.73803904930}, 
    {     0.00000001395,  3.82109633863,     2111.65031337760}, 
    {     0.00000001279,  2.87401595453,      142.44965013380}, 
    {     0.00000001081,  4.11745082549,      156.67674413540}, 
    {     0.00000001094,  0.95082594069,      842.15068148810}, 
    {     0.00000001295,  4.70261675421,     9786.68735533500}, 
    {     0.00000001238,  0.48462207051,     3906.90875709860}, 
    {     0.00000001011,  2.15806773600,      251.43213107580}, 
    {     0.00000001276,  4.48356586181,      732.69511979410}, 
    {     0.00000001316,  4.72331667671,      398.14400287280}, 
    {     0.00000000980,  1.88269080686,      501.37978944330}, 
    {     0.00000000962,  5.92160366799,      519.39602435610}, 
    {     0.00000001182,  3.69482624364,     2854.64037391020}, 
    {     0.00000000945,  4.87513739959,      241.75328344120}, 
    {     0.00000000970,  2.89031410383,     1987.21689815660}, 
    {     0.00000001194,  3.26293060096,     5856.47765911540}, 
    {     0.00000000936,  5.49997099924,      739.05790726950}, 
    {     0.00000001129,  5.17087619935,       98.89998852460}, 
    {     0.00000001024,  5.62644279982,      479.28838891550}, 
    {     0.00000001129,  5.48559615849,     3995.77443731560}, 
    {     0.00000000978,  5.31362529668,      114.13847448250}, 
    {     0.00000001167,  2.19961653985,     1699.27921650320}, 
    {     0.00000000864,  0.25714937203,      436.15941843160}, 
    {     0.00000001062,  5.13323858077,     2751.54759969160}, 
    {     0.00000000947,  4.98276726039,      699.70103135430}, 
    {     0.00000000886,  3.03398159069,      306.09692891810}, 
    {     0.00000000916,  4.99280834008,     4209.07353275360}, 
    {     0.00000001048,  0.86254115639,      525.75881183150}, 
    {     0.00000000894,  2.41362473223,      289.56516671360}, 
    {     0.00000000800,  1.26419353964,      710.74673161820}, 
    {     0.00000000791,  2.14989417962,     2620.00063746980}, 
    {     0.00000000795,  2.09247626825,      563.63121503840}, 
    {     0.00000000787,  5.25336286912,      214.78356814630}, 
    {     0.00000000783,  1.29408648806,      685.47393735270}, 
    {     0.00000001060,  1.56954240117,     5849.36411211460}, 
    {     0.00000000784,  5.30418962830,      327.43756992050}, 
    {     0.00000000764,  4.56705124334,      380.12776796000}, 
    {     0.00000000811,  6.20098147255,      245.54242435240}, 
    {     0.00000000857,  1.78247179649,      135.33610313300}, 
    {     0.00000000801,  1.86383119100,     3039.48528134500}, 
    {     0.00000000801,  0.46947170994,     3466.08347222100}, 
    {     0.00000000968,  3.02618272726,     2634.22773147140}, 
    {     0.00000000814,  1.96028453251,      417.03696332040}, 
    {     0.00000000810,  4.13540095430,      831.10498122420}, 
    {     0.00000000739,  2.27110740297,     2303.60876781320}, 
    {     0.00000000747,  0.29245063260,      916.93228005540}, 
    {     0.00000000889,  4.44997608522,      230.70758317730}, 
    {     0.00000000726,  2.54556193643,      576.16138801060}, 
    {     0.00000000982,  1.94714680471,      229.97386999440}, 
    {     0.00000000728,  1.11567846944,      540.73666535850}, 
    {     0.00000000728,  1.30997967935,      511.53171782990}, 
    {     0.00000000711,  4.55074874644,      980.66817835880}, 
    {     0.00000000716,  3.74192651696,     3053.71237534660}, 
    {     0.00000000769,  3.34498423969,      953.10776223290}, 
    {     0.00000000920,  3.83992182117,      348.63519857100}, 
    {     0.00000000789,  3.15830383443,      739.80866679490}, 
    {     0.00000000896,  4.82222996928,     4216.18707975440}, 
    {     0.00000000712,  0.43380103197,     1493.09366806600}, 
    {     0.00000000840,  4.85251148183,      326.68681039510}, 
    {     0.00000000724,  0.75790117400,      486.40193591630}, 
    {     0.00000000790,  0.48073040004,     4017.11507831800}, 
    {     0.00000000831,  3.48853527081,       84.93352695390}, 
    {     0.00000000745,  6.22304530635,     1269.49963188950}, 
    {     0.00000000679,  0.78943373396,      273.85360000370}, 
    {     0.00000000932,  5.20456188216,      849.26422848890}, 
};


static const struct ln_vsop saturn_radius_r3[RADIUS_R3] = {
    {     0.00020315239,  3.02186068237,      213.29909543800}, 
    {     0.00008923679,  3.19144467228,      220.41264243880}, 
    {     0.00006908768,  4.35175288182,      206.18554843720}, 
    {     0.00004087056,  4.22398596149,        7.11354700080}, 
    {     0.00003878848,  2.01051759517,      426.59819087600}, 
    {     0.00001070754,  4.20372656114,      199.07200143640}, 
    {     0.00000907379,  2.28356519128,      433.71173787680}, 
    {     0.00000605936,  3.17456913264,      227.52618943960}, 
    {     0.00000596411,  4.13395467306,       14.22709400160}, 
    {     0.00000483108,  1.17313249713,      639.89728631400}, 
    {     0.00000393213,  0.00000000000,        0.00000000000}, 
    {     0.00000229396,  4.69783424016,      419.48464387520}, 
    {     0.00000187917,  4.59089264920,      110.20632121940}, 
    {     0.00000149326,  3.20334759568,      103.09277421860}, 
    {     0.00000121613,  3.76751430846,      323.50541665740}, 
    {     0.00000101300,  5.81716272185,      412.37109687440}, 
    {     0.00000102030,  4.70997918436,       95.97922721780}, 
    {     0.00000092737,  1.43601934858,      647.01083331480}, 
    {     0.00000072411,  4.15100432048,      117.31986822020}, 
    {     0.00000084197,  2.63457296718,      216.48048917570}, 
    {     0.00000061913,  2.31131212952,      440.82528487760}, 
    {     0.00000045220,  4.37634609863,      191.95845443560}, 
    {     0.00000049426,  2.38844043734,      209.36694217490}, 
    {     0.00000054819,  0.30627159494,      853.19638175200}, 
    {     0.00000040466,  1.83906916098,      302.16477565500}, 
    {     0.00000038104,  5.93442433914,       88.86568021700}, 
    {     0.00000032001,  4.01244131364,       21.34064100240}, 
    {     0.00000040737,  0.68516563011,      522.57741809380}, 
    {     0.00000028116,  5.76512437390,      210.11770170030}, 
    {     0.00000024831,  3.06280485014,      234.63973644040}, 
    {     0.00000025254,  0.73965366740,      515.46387109300}, 
    {     0.00000020713,  4.92639343420,      625.67019231240}, 
    {     0.00000017714,  5.72683468372,      728.76296653100}, 
    {     0.00000018131,  1.43975542803,      309.27832265580}, 
    {     0.00000016495,  3.52692613051,        3.18139373770}, 
    {     0.00000012918,  3.36684920510,      330.61896365820}, 
    {     0.00000011094,  3.37261850494,      224.34479570190}, 
    {     0.00000010869,  3.43386860676,      956.28915597060}, 
    {     0.00000010016,  1.59530701443,      202.25339517410}, 
    {     0.00000011527,  5.96454139918,      735.87651353180}, 
    {     0.00000010427,  6.07038986657,      405.25754987360}, 
    {     0.00000009198,  2.93495179548,      124.43341522100}, 
    {     0.00000008733,  4.65644352017,      632.78373931320}, 
    {     0.00000009909,  0.58906585168,      860.30992875280}, 
    {     0.00000007397,  4.53722615699,      942.06206196900}, 
    {     0.00000009877,  0.25973572185,      838.96928775040}, 
    {     0.00000009223,  2.57680550459,      223.59403617650}, 
    {     0.00000007483,  1.46542234710,      654.12438031560}, 
    {     0.00000008102,  1.77706845061,      429.77958461370}, 
    {     0.00000007173,  5.49665397606,     1045.15483618760}, 
    {     0.00000006882,  1.47851183871,      422.66603761290}, 
    {     0.00000007832,  0.44349627838,      831.85574074960}, 
    {     0.00000008107,  4.50187795175,      742.99006053260}, 
    {     0.00000006920,  4.81164954413,      316.39186965660}, 
    {     0.00000008075,  4.21886190434,      195.13984817330}, 
    {     0.00000005803,  2.35419372850,      269.92144674060}, 
    {     0.00000005616,  1.20479876549,      284.14854074220}, 
    {     0.00000005782,  4.19740457842,      529.69096509460}, 
    {     0.00000004920,  2.16694660987,      295.05122865420}, 
    {     0.00000005415,  2.47123991920,      536.80451209540}, 
    {     0.00000005965,  6.06077183500,     1066.49547719000}, 
    {     0.00000005490,  0.84597599620,      217.23124870110}, 
    {     0.00000005849,  3.40892096038,       10.29494073850}, 
    {     0.00000004178,  3.22951777344,     1272.68102562720}, 
    {     0.00000004391,  0.88818379722,      203.00415469950}, 
    {     0.00000003566,  6.23461945528,       81.75213321620}, 
    {     0.00000004005,  0.12257495486,     1155.36115740700}, 
    {     0.00000003099,  4.35795864442,     1258.45393162560}, 
    {     0.00000003394,  0.86274027413,      508.35032409220}, 
    {     0.00000003447,  0.20752334492,     1148.24761040620}, 
    {     0.00000003642,  5.97995786501,     1052.26838318840}, 
    {     0.00000003059,  4.96923422399,     1677.93857550080}, 
    {     0.00000002893,  1.90456088258,      149.56319713460}, 
    {     0.00000002740,  5.70053888010,        3.93215326310}, 
    {     0.00000003014,  5.36409568893,     1361.54670584420}, 
    {     0.00000002608,  2.99591016813,     1589.07289528380}, 
    {     0.00000002464,  2.25182696243,      447.93883187840}, 
    {     0.00000002295,  3.77182395165,      408.43894361130}, 
    {     0.00000002449,  5.87771646576,      721.64941953020}, 
    {     0.00000002441,  3.18918907436,      319.57326339430}, 
    {     0.00000001967,  1.29771144286,      184.84490743480}, 
    {     0.00000002510,  4.26899907719,     1059.38193018920}, 
    {     0.00000002337,  5.73749856685,      313.21047591890}, 
    {     0.00000002438,  2.20340625323,      543.91805909620}, 
    {     0.00000001967,  5.54991356049,     1038.04128918680}, 
    {     0.00000002159,  6.13002461326,     1464.63948006280}, 
    {     0.00000002033,  6.23409374980,     1471.75302706360}, 
    {     0.00000001679,  0.53404387418,      635.96513305090}, 
    {     0.00000001667,  2.31776149711,      337.73251065900}, 
    {     0.00000001743,  4.57646237847,     1994.33044515740}, 
    {     0.00000001913,  5.17436386408,     2854.64037391020}, 
    {     0.00000001612,  0.53564663022,      416.30325013750}, 
    {     0.00000001660,  5.71352144007,       11.04570026390}, 
    {     0.00000002034,  1.58251242401,      750.10360753340}, 
    {     0.00000001577,  0.55789908488,     2324.94940881560}, 
    {     0.00000001659,  2.57526072926,     2090.30967237520}, 
    {     0.00000001483,  0.02105633480,      490.33408917940}, 
    {     0.00000001424,  0.96656932678,      415.55249061210}, 
    {     0.00000001677,  5.93355681450,     1781.03134971940}, 
    {     0.00000001632,  2.35226638604,      131.54696222180}, 
    {     0.00000001402,  0.60008117843,      210.85141488320}, 
    {     0.00000001677,  6.13301097969,     1073.60902419080}, 
    {     0.00000001478,  3.89120179199,     1251.34038462480}, 
    {     0.00000001773,  0.03977695852,      423.41679713830}, 
    {     0.00000001442,  5.32547705924,     2538.24850425360}, 
    {     0.00000001490,  5.26389041723,     1354.43315884340}, 
    {     0.00000001610,  3.02368875538,      437.64389113990}, 
    {     0.00000001462,  3.28599831588,     1884.12412393800}, 
    {     0.00000001346,  5.09589748079,       25.27279426550}, 
    {     0.00000001480,  0.47735175322,      824.74219374880}, 
    {     0.00000001312,  3.79347668996,     1567.73225428140}, 
    {     0.00000001335,  1.74107324653,      195.89060769870}, 
    {     0.00000001329,  3.20676992162,     2207.62954059540}, 
    {     0.00000001252,  4.12592480127,     1574.84580128220}, 
    {     0.00000001526,  1.83391016543,      436.89313161450}, 
    {     0.00000001204,  5.83523069063,      215.74677599280}, 
    {     0.00000001431,  2.26632806642,     2420.92863603340}, 
    {     0.00000001202,  0.89248153731,      127.47179660680}, 
    {     0.00000001403,  1.02096357086,      643.07868005170}, 
    {     0.00000001176,  3.91611015213,     1891.23767093880}, 
    {     0.00000001137,  0.35727698514,      497.44763618020}, 
    {     0.00000001117,  6.17430918265,       63.73589830340}, 
    {     0.00000001138,  0.82455844655,      867.42347575360}, 
    {     0.00000001145,  3.10797488346,     2200.51599359460}, 
    {     0.00000001082,  3.72589445510,      131.40394986990}, 
    {     0.00000001387,  1.42954726378,     2634.22773147140}, 
    {     0.00000001311,  1.45489259116,      430.53034413910}, 
    {     0.00000001003,  1.81530935794,      618.55664531160}, 
    {     0.00000001219,  5.39420447728,     1279.79457262800}, 
    {     0.00000001342,  5.63184874016,     1382.88734684660}, 
    {     0.00000000943,  2.27529460454,     1478.86657406440}, 
    {     0.00000001034,  4.72095936110,     1987.21689815660}, 
    {     0.00000000910,  4.75468748593,      113.38771495710}, 
    {     0.00000000901,  5.71833080761,      265.98929347750}, 
    {     0.00000001017,  3.79640287208,     1375.77379984580}, 
    {     0.00000000887,  2.86363894581,      934.94851496820}, 
    {     0.00000000914,  3.03946255874,      241.75328344120}, 
    {     0.00000000879,  2.65659265685,      145.63104387150}, 
    {     0.00000001082,  4.48298283322,     2214.74308759620}, 
    {     0.00000000968,  4.18488402192,      231.45834270270}, 
    {     0.00000000888,  5.98816755324,     2524.02141025200}, 
    {     0.00000000809,  2.89742868175,     2008.55753915900}, 
    {     0.00000000872,  5.95699654230,     1368.66025284500}, 
    {     0.00000000814,  6.26605263515,     2015.67108615980}, 
    {     0.00000000990,  5.32604038017,     2428.04218303420}, 
    {     0.00000000795,  2.38178135810,     2228.97018159780}, 
    {     0.00000000765,  4.70033674940,     1670.82502850000}, 
    {     0.00000000719,  3.14082277075,       56.62235130260}, 
    {     0.00000000725,  5.87999254075,     1685.05212250160}, 
    {     0.00000000772,  1.15596098579,     3053.71237534660}, 
    {     0.00000000944,  4.19194509927,     1802.37199072180}, 
    {     0.00000000823,  0.15294957676,     1141.13406340540}, 
    {     0.00000000738,  4.90593328066,     1485.98012106520}, 
    {     0.00000000685,  1.70083536518,      483.22054217860}, 
};


static const struct ln_vsop saturn_radius_r4[RADIUS_R4] = {
    {     0.00001202117,  1.41498340225,      220.41264243880}, 
    {     0.00000707794,  1.16151449537,      213.29909543800}, 
    {     0.00000516224,  6.24049105350,      206.18554843720}, 
    {     0.00000426107,  2.46891791825,        7.11354700080}, 
    {     0.00000267495,  0.18644716875,      426.59819087600}, 
    {     0.00000170055,  5.96000580678,      199.07200143640}, 
    {     0.00000144813,  1.44265291294,      227.52618943960}, 
    {     0.00000150056,  0.47968186381,      433.71173787680}, 
    {     0.00000121067,  2.40476128629,       14.22709400160}, 
    {     0.00000047503,  5.56874777537,      639.89728631400}, 
    {     0.00000015651,  2.89076603229,      110.20632121940}, 
    {     0.00000016364,  0.53928792415,      440.82528487760}, 
    {     0.00000018973,  5.85514753020,      647.01083331480}, 
    {     0.00000014490,  1.31356947305,      412.37109687440}, 
    {     0.00000012310,  2.10618416544,      323.50541665740}, 
    {     0.00000014688,  0.29685965949,      419.48464387520}, 
    {     0.00000010893,  2.45288604864,      117.31986822020}, 
    {     0.00000011348,  0.17490312278,       95.97922721780}, 
    {     0.00000009210,  2.30108004686,       21.34064100240}, 
    {     0.00000009007,  1.55461797818,       88.86568021700}, 
    {     0.00000008089,  3.62570131736,      302.16477565500}, 
    {     0.00000008668,  0.69662054025,      216.48048917570}, 
    {     0.00000007794,  4.50477684881,      853.19638175200}, 
    {     0.00000008261,  1.27827363929,      234.63973644040}, 
    {     0.00000009616,  3.14159265359,        0.00000000000}, 
    {     0.00000004937,  2.61740899859,      515.46387109300}, 
    {     0.00000004365,  0.05807483283,      191.95845443560}, 
    {     0.00000005944,  5.17118993601,      103.09277421860}, 
    {     0.00000003675,  3.26106349552,      210.11770170030}, 
    {     0.00000004387,  4.98731675488,      860.30992875280}, 
    {     0.00000004001,  1.58149127982,      330.61896365820}, 
    {     0.00000003875,  6.01795427919,      654.12438031560}, 
    {     0.00000003956,  1.58112427915,      405.25754987360}, 
    {     0.00000002962,  2.67872711614,      522.57741809380}, 
    {     0.00000002961,  0.73625753769,      209.36694217490}, 
    {     0.00000003102,  1.28964935689,      728.76296653100}, 
    {     0.00000002266,  3.17206848552,      203.00415469950}, 
    {     0.00000002160,  1.08089139585,      124.43341522100}, 
    {     0.00000002118,  6.14470291334,      429.77958461370}, 
    {     0.00000002066,  3.92049451838,     1066.49547719000}, 
    {     0.00000002211,  0.80527848095,      625.67019231240}, 
    {     0.00000002147,  0.49411458094,      447.93883187840}, 
    {     0.00000001927,  0.78578237497,      295.05122865420}, 
    {     0.00000001793,  0.12585846743,      942.06206196900}, 
    {     0.00000001706,  1.43840425376,      224.34479570190}, 
    {     0.00000001986,  1.95084664432,      831.85574074960}, 
    {     0.00000001600,  5.41185167676,      824.74219374880}, 
    {     0.00000001717,  0.83103173636,      223.59403617650}, 
    {     0.00000001598,  1.93650947414,      529.69096509460}, 
    {     0.00000001303,  5.54181517607,      316.39186965660}, 
    {     0.00000001288,  1.91850903205,      956.28915597060}, 
    {     0.00000001184,  3.02295343322,      184.84490743480}, 
    {     0.00000001234,  0.93431249316,      721.64941953020}, 
    {     0.00000001212,  6.13915785712,      422.66603761290}, 
    {     0.00000001249,  5.97947803636,      195.13984817330}, 
    {     0.00000001142,  0.96309096169,      536.80451209540}, 
    {     0.00000001011,  1.14653787675,      838.96928775040}, 
    {     0.00000001031,  1.15377008428,     1148.24761040620}, 
    {     0.00000001109,  1.63414938335,       17.40848773930}, 
    {     0.00000001094,  0.98475168289,     1045.15483618760}, 
    {     0.00000000985,  3.05768671768,     1574.84580128220}, 
    {     0.00000000887,  2.52072621499,      508.35032409220}, 
    {     0.00000000986,  1.63414986297,      735.87651353180}, 
    {     0.00000000753,  4.90938931967,       56.62235130260}, 
    {     0.00000000791,  2.74375014558,      423.41679713830}, 
};


static const struct ln_vsop saturn_radius_r5[RADIUS_R5] = {
    {     0.00000128668,  5.91279864289,      220.41264243880}, 
    {     0.00000032196,  0.69558284384,        7.11354700080}, 
    {     0.00000026737,  5.91270395039,      227.52618943960}, 
    {     0.00000019837,  0.67396852960,       14.22709400160}, 
    {     0.00000019994,  4.95031713518,      433.71173787680}, 
    {     0.00000013627,  1.47747814594,      199.07200143640}, 
    {     0.00000013706,  4.59824754628,      426.59819087600}, 
    {     0.00000014068,  2.63892426573,      206.18554843720}, 
    {     0.00000007324,  4.64667642371,      213.29909543800}, 
    {     0.00000004916,  3.63019930267,      639.89728631400}, 
    {     0.00000002985,  4.64378755577,      191.95845443560}, 
    {     0.00000002675,  0.51742057647,      323.50541665740}, 
    {     0.00000003420,  4.91489841099,      440.82528487760}, 
    {     0.00000003171,  4.10118061147,      647.01083331480}, 
    {     0.00000002885,  3.24108476164,      419.48464387520}, 
    {     0.00000002173,  5.39877301813,      302.16477565500}, 
    {     0.00000001873,  3.22101902976,       95.97922721780}, 
    {     0.00000002055,  3.60842101774,       88.86568021700}, 
    {     0.00000001509,  2.68946095921,      853.19638175200}, 
    {     0.00000001518,  0.89692431439,      515.46387109300}, 
    {     0.00000001737,  0.41793799128,      117.31986822020}, 
    {     0.00000001640,  0.00000000000,        0.00000000000}, 
    {     0.00000001285,  5.82563377753,      234.63973644040}, 
    {     0.00000000983,  5.91256391941,        3.18139373770}, 
    {     0.00000001054,  0.20778977120,      412.37109687440}, 
    {     0.00000000719,  5.20973072924,      216.48048917570}, 
    {     0.00000000706,  2.65805151133,      110.20632121940}, 
};

/*! \fn void ln_get_saturn_equ_coords (double JD, struct ln_equ_posn * position);
* \param JD julian Day
* \param position Pointer to store position
*
* Calculates Saturn's equatorial position for given julian day.
* This function includes calculations for planetary aberration and refers
* to the FK5 reference frame.
*
* To get the complete equatorial coordinates, corrections for nutation
* have to be applied.
*
* The position returned is accurate to within 0.1 arcsecs..
*/ 
void ln_get_saturn_equ_coords (double JD, struct ln_equ_posn * position)
{
	struct ln_helio_posn h_sol, h_saturn;
	struct ln_rect_posn g_sol, g_saturn;
	double a,b,c;
	double ra, dec, delta, diff, last, t = 0;
	
	/* need typdef for solar heliocentric coords */
	ln_get_solar_geom_coords (JD, &h_sol);
	ln_get_rect_from_helio (&h_sol,  &g_sol);
	
	do {
		last = t;
		ln_get_saturn_helio_coords (JD - t, &h_saturn);
		ln_get_rect_from_helio (&h_saturn, &g_saturn);

		/* equ 33.10 pg 229 */
		a = g_sol.X + g_saturn.X;
		b = g_sol.Y + g_saturn.Y;
		c = g_sol.Z + g_saturn.Z;
	
		delta = a*a + b*b + c*c;
		delta = sqrt (delta);
		t = delta * 0.0057755183;
		diff = t - last;
	} while (diff > 0.0001 || diff < -0.0001);
	
	ra = atan2 (b,a);
	dec = c / delta;
	dec = asin (dec);

	/* back to hours, degrees */
	position->ra = ln_range_degrees(ln_rad_to_deg (ra));
	position->dec = ln_rad_to_deg (dec);
}
	
/*! \fn void ln_get_saturn_helio_coords (double JD, struct ln_helio_posn * position)
* \param JD Julian Day
* \param position Pointer to store heliocentric position
*
* Calculate Saturns heliocentric (refered to the centre of the Sun) coordinates
* in the FK5 reference frame for the given julian day.
* Longitude and Latitude are in degrees, whilst radius vector is in AU.
*/ 
/* Chapter 31 Pg 206-207 Equ 31.1 31.2 , 31.3 using VSOP 87 
*/
void ln_get_saturn_helio_coords (double JD, struct ln_helio_posn * position)
{
	double t, t2, t3, t4, t5;
	double L0, L1, L2, L3, L4, L5;
	double B0, B1, B2, B3, B4, B5;
	double R0, R1, R2, R3, R4, R5;
           	
	/* check cache first */
	if (JD == cJD) {
		/* cache hit */
		position->L = cL;
		position->B = cB;
		position->R = cR;
		return;
	}
	
	/* get julian ephemeris day */
	t = (JD - 2451545.0) / 365250;
	t2 = t * t;
	t3 = t2 * t;
	t4 = t3 * t;
	t5 = t4 * t;
	
	/* calc L series */
	L0 = ln_calc_series (saturn_longitude_l0, LONG_L0, t);
	L1 = ln_calc_series (saturn_longitude_l1, LONG_L1, t);
	L2 = ln_calc_series (saturn_longitude_l2, LONG_L2, t);
	L3 = ln_calc_series (saturn_longitude_l3, LONG_L3, t);
	L4 = ln_calc_series (saturn_longitude_l4, LONG_L4, t);
	L5 = ln_calc_series (saturn_longitude_l5, LONG_L5, t);
	position->L = (L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5);

	/* calc B series */
	B0 = ln_calc_series (saturn_latitude_b0, LAT_B0, t);
	B1 = ln_calc_series (saturn_latitude_b1, LAT_B1, t);
	B2 = ln_calc_series (saturn_latitude_b2, LAT_B2, t);
	B3 = ln_calc_series (saturn_latitude_b3, LAT_B3, t);
	B4 = ln_calc_series (saturn_latitude_b4, LAT_B4, t);
	B5 = ln_calc_series (saturn_latitude_b5, LAT_B5, t);
	position->B = (B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5);


	/* calc R series */
	R0 = ln_calc_series (saturn_radius_r0, RADIUS_R0, t);
	R1 = ln_calc_series (saturn_radius_r1, RADIUS_R1, t);
	R2 = ln_calc_series (saturn_radius_r2, RADIUS_R2, t);
	R3 = ln_calc_series (saturn_radius_r3, RADIUS_R3, t);
	R4 = ln_calc_series (saturn_radius_r4, RADIUS_R4, t);
	R5 = ln_calc_series (saturn_radius_r5, RADIUS_R5, t);
	position->R = (R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5);
	
	/* change to degrees in correct quadrant */
	position->L = ln_rad_to_deg(position->L);
	position->B = ln_rad_to_deg(position->B);
	position->L = ln_range_degrees(position->L);
	
	/* change to fk5 reference frame */
	ln_vsop87_to_fk5 (position, JD);
	
	/* save cache */
	cJD = JD;
	cL = position->L;
	cB = position->B;
	cR = position->R;
}

/*! \fn double ln_get_saturn_earth_dist (double JD);
* \param JD Julian day
* \brief Calculate the distance between Saturn and the Earth in AU
* \return Distance in AU
*
* Calculates the distance in AU between the Earth and Saturn for 
* the given julian day.
*/
double ln_get_saturn_earth_dist (double JD)
{
	struct ln_helio_posn  h_saturn, h_earth;
	struct ln_rect_posn g_saturn, g_earth;
	double x, y, z;
	
	/* get heliocentric positions */
	ln_get_saturn_helio_coords (JD, &h_saturn);
	ln_get_earth_helio_coords (JD, &h_earth);
	
	/* get geocentric coords */
	ln_get_rect_from_helio (&h_saturn, &g_saturn);
	ln_get_rect_from_helio (&h_earth, &g_earth);
	
	/* use pythag */
	x = g_saturn.X - g_earth.X;
	y = g_saturn.Y - g_earth.Y;
	z = g_saturn.Z - g_earth.Z;
	x = x * x;
	y = y * y;
	z = z * z;

	return sqrt (x + y + z);
}
	
/*! \fn double ln_get_saturn_solar_dist (double JD);
* \param JD Julian day
* \brief Calculate the distance between Saturn and the Sun in AU
* \return Distance in AU
*
* Calculates the distance in AU between the Sun and Saturn for
* the given julian day.
*/ 
double ln_get_saturn_solar_dist (double JD)
{
	struct ln_helio_posn h_saturn;

	/* get heliocentric position */
	ln_get_saturn_helio_coords (JD, &h_saturn);
	return h_saturn.R;
}
	
/*! \fn double ln_get_saturn_magnitude (double JD);
* \param JD Julian day
* \brief Calculate the visible magnitude of Saturn
* \return Visisble magnitude of saturn
* \todo Calculate rings brightness
*
* Calculate the visible magnitude of Saturn for the given
* julian day.
*/ 
double ln_get_saturn_magnitude (double JD)
{
	double delta, r;
	
	/* get distances */
	r = ln_get_saturn_solar_dist (JD);
	delta = ln_get_saturn_earth_dist (JD);

	return -8.88 + 5 * log10 (r * delta); /* + 0.044 * U - 2.6 * sin (B) + 1.25 * (sin (B) * sin (B)); */
}

/*! \fn double ln_get_saturn_disk (double JD);
* \param JD Julian day
* \brief Calculate the illuminated fraction of Saturn's disk
* \return Illuminated fraction of Saturns disk. (Value between 0..1)
*
* Calculate the illuminated fraction of Saturn's disk for the given Julian
* day.
*/ 
/* Chapter 41 */
double ln_get_saturn_disk (double JD)
{
	double r,delta,R;	
	
	/* get distances */
	R = ln_get_earth_solar_dist (JD);
	r = ln_get_saturn_solar_dist (JD);
	delta = ln_get_saturn_earth_dist (JD);
	
	/* calc fraction angle */
	return (((r + delta) * (r + delta)) - R * R) / (4 * r * delta);
}

/*! \fn double ln_get_saturn_phase (double JD);
* \brief Calculate the phase angle of Saturn (Sun - Saturn - Earth)
* \return Phase angle of Saturn (degrees)
*
* Calculates the phase angle of Saturn, that is, the angle Sun -
* Saturn - Earth for the given Julian day.
*/ 
/* Chapter 41 */
double ln_get_saturn_phase (double JD)
{
	double i,r,delta,R;	
	
	/* get distances */
	R = ln_get_earth_solar_dist (JD);
	r = ln_get_saturn_solar_dist (JD);
	delta = ln_get_saturn_earth_dist (JD);

	/* calc phase */
	i = (r * r + delta * delta - R * R) / (2 * r * delta);
	i = acos (i);
	return ln_rad_to_deg (i);
}

/*! \fn double ln_get_saturn_rst (double JD, struct ln_lnlat_posn * observer, struct ln_rst_time * rst);
* \param JD Julian day
* \param observer Observers position
* \param rst Pointer to store Rise, Set and Transit time in JD
* \return 0 for success, else 1 for circumpolar.
*
* Calculate the time the rise, set and transit (crosses the local meridian at upper culmination)
* time of Saturn for the given Julian day.
*
* Note: this functions returns 1 if Saturn is circumpolar, that is it remains the whole
* day either above or below the horizon.
*/
int ln_get_saturn_rst (double JD, struct ln_lnlat_posn * observer, struct ln_rst_time * rst)
{
	return ln_get_body_rst_horizon (JD, observer, ln_get_saturn_equ_coords, LN_STAR_STANDART_HORIZON, rst);
}

/*! \fn double ln_get_saturn_equ_sdiam (double JD)
* \param JD Julian day
* \return Semidiameter in arc seconds
*
* Calculate the equatorial semidiameter of Saturn in arc seconds for the 
* given julian day.
*/
double ln_get_saturn_equ_sdiam (double JD)
{
	double So = 82.73; /* at 1 AU */
	double dist;
	
	dist = ln_get_saturn_earth_dist (JD);
	return So / dist;
}

/*! \fn double ln_get_saturn_pol_sdiam (double JD)
* \param JD Julian day
* \return Semidiameter in arc seconds
* \todo Use Saturnicentric lat of Earth 
*
* Calculate the polar semidiameter of Saturn in arc seconds for the 
* given julian day.
*/
double ln_get_saturn_pol_sdiam (double JD)
{
	double So = 73.82; /* at 1 AU */
	double dist;
	
	dist = ln_get_saturn_earth_dist (JD);
	return So / dist;
}


/*! \fn void ln_get_saturn_rect_helio (double JD, struct ln_rect_posn * position)
* \param JD Julian day.
* \param position pointer to return position
*
* Calculate Saturns rectangular heliocentric coordinates for the
* given Julian day. Coordinates are in AU.
*/
void ln_get_saturn_rect_helio (double JD, struct ln_rect_posn * position)
{
	struct ln_helio_posn saturn;
		
	ln_get_saturn_helio_coords (JD, &saturn);
	ln_get_rect_from_helio (&saturn, position);
}
