#============================================================= -*-Perl-*-
#
# Lemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Lemplate distribution).
#
#========================================================================

package Lemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = '0.15';

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ~=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'INSERT' => 24,
			'UNLESS' => 26,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'RAW' => 22,
			'NUMBER' => 61,
			'IDENT' => 18,
			'WRAPPER' => 19,
			"\${" => 17,
			'NEXT' => 56,
			"[" => 59,
			'LAST' => 57,
			'INCLUDE' => 12,
			'SWITCH' => 15,
			"(" => 13,
			'TEXT' => 14,
			'rawperl' => 49,
			'VIEW' => 48,
			"\"" => 9,
			'GET' => 52,
			'FOR' => 5,
			"\$" => 4,
			'perl' => 6,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47,
			'USE' => 45,
			'WHILE' => 75,
			'LITERAL' => 39,
			'IF' => 73,
			'STOP' => 74,
			'SET' => 40,
			'BLOCK' => 37,
			'FILTER' => 36,
			";" => -19,
			'RETURN' => 70,
			'NOT' => 69,
			'THROW' => 68,
			'REF' => 67,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'META' => 66,
			'TRY' => 65
		},
		DEFAULT => -3,
		GOTOS => {
			'chunks' => 25,
			'atomdir' => 62,
			'ident' => 23,
			'use' => 16,
			'expr' => 58,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'condition' => 55,
			'chunk' => 10,
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50,
			'statement' => 3,
			'node' => 7,
			'loop' => 1,
			'defblock' => 44,
			'directive' => 43,
			'setlist' => 42,
			'assign' => 72,
			'anonblock' => 41,
			'template' => 38,
			'item' => 71,
			'sterm' => 35,
			'block' => 32,
			'filter' => 31,
			'macro' => 63,
			'try' => 30,
			'capture' => 64,
			'term' => 28,
			'atomexpr' => 27,
			'switch' => 29
		}
	},
	{#State 1
		DEFAULT => -24
	},
	{#State 2
		ACTIONS => {
			"(" => 13,
			"{" => 46,
			'NOT' => 69,
			"[" => 59,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			'REF' => 67
		},
		GOTOS => {
			'expr' => 78,
			'item' => 71,
			'node' => 7,
			'term' => 28,
			'sterm' => 35,
			'ident' => 77,
			'lterm' => 51
		}
	},
	{#State 3
		ACTIONS => {
			";" => 79
		}
	},
	{#State 4
		ACTIONS => {
			'IDENT' => 80
		}
	},
	{#State 5
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61,
			'IDENT' => 83,
			"\$" => 4,
			"\${" => 17,
			"[" => 59,
			"{" => 46
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'loopvar' => 82,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'term' => 81
		}
	},
	{#State 6
		DEFAULT => -27
	},
	{#State 7
		DEFAULT => -128
	},
	{#State 8
		ACTIONS => {
			'IDENT' => 85
		},
		DEFAULT => -88,
		GOTOS => {
			'metadata' => 86,
			'meta' => 87,
			'blockargs' => 84
		}
	},
	{#State 9
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 88
		}
	},
	{#State 10
		DEFAULT => -5
	},
	{#State 11
		DEFAULT => -15
	},
	{#State 12
		ACTIONS => {
			'FILENAME' => 97,
			'IDENT' => 90,
			"\$" => 92,
			"\"" => 91,
			'NUMBER' => 95,
			'LITERAL' => 93
		},
		GOTOS => {
			'name' => 96,
			'filepart' => 98,
			'filename' => 99,
			'nameargs' => 89,
			'names' => 94
		}
	},
	{#State 13
		ACTIONS => {
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"[" => 59,
			'NOT' => 69,
			"{" => 46,
			"(" => 13,
			'REF' => 67,
			'LITERAL' => 39,
			'NUMBER' => 61,
			"\"" => 9
		},
		GOTOS => {
			'term' => 28,
			'sterm' => 35,
			'expr' => 102,
			'item' => 71,
			'node' => 7,
			'assign' => 101,
			'ident' => 100,
			'lterm' => 51
		}
	},
	{#State 14
		DEFAULT => -6
	},
	{#State 15
		ACTIONS => {
			"\$" => 4,
			'IDENT' => 18,
			"\${" => 17,
			"[" => 59,
			'NOT' => 69,
			"{" => 46,
			"(" => 13,
			'REF' => 67,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61
		},
		GOTOS => {
			'sterm' => 35,
			'ident' => 77,
			'lterm' => 51,
			'term' => 28,
			'expr' => 103,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 16
		DEFAULT => -13
	},
	{#State 17
		ACTIONS => {
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			'REF' => 67,
			"\"" => 9,
			'NUMBER' => 61,
			'LITERAL' => 76
		},
		GOTOS => {
			'ident' => 77,
			'sterm' => 104,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 18
		DEFAULT => -131
	},
	{#State 19
		ACTIONS => {
			'NUMBER' => 95,
			"\"" => 91,
			'LITERAL' => 93,
			'FILENAME' => 97,
			'IDENT' => 90,
			"\$" => 92
		},
		GOTOS => {
			'filename' => 99,
			'name' => 96,
			'filepart' => 98,
			'names' => 94,
			'nameargs' => 105
		}
	},
	{#State 20
		ACTIONS => {
			'IDENT' => 106
		}
	},
	{#State 21
		ACTIONS => {
			'IDENT' => 90,
			'FILENAME' => 97,
			"\$" => 92,
			"\"" => 91,
			'NUMBER' => 95,
			'LITERAL' => 93
		},
		GOTOS => {
			'names' => 94,
			'nameargs' => 107,
			'filename' => 99,
			'filepart' => 98,
			'name' => 96
		}
	},
	{#State 22
		ACTIONS => {
			"\"" => 111,
			'NUMBER' => 95,
			'LITERAL' => 108,
			'FILENAME' => 97,
			'IDENT' => 112,
			"\$" => 110,
			"\${" => 17
		},
		GOTOS => {
			'filepart' => 98,
			'filename' => 99,
			'lnameargs' => 109,
			'item' => 115,
			'name' => 96,
			'lvalue' => 113,
			'nameargs' => 114,
			'names' => 94
		}
	},
	{#State 23
		ACTIONS => {
			'DOT' => 116,
			'ASSIGN' => 117
		},
		DEFAULT => -110
	},
	{#State 24
		ACTIONS => {
			'LITERAL' => 93,
			"\"" => 91,
			'NUMBER' => 95,
			'FILENAME' => 97,
			"\$" => 92,
			'IDENT' => 90
		},
		GOTOS => {
			'names' => 94,
			'nameargs' => 118,
			'filename' => 99,
			'filepart' => 98,
			'name' => 96
		}
	},
	{#State 25
		ACTIONS => {
			'RETURN' => 70,
			'FILTER' => 36,
			";" => -19,
			'BLOCK' => 37,
			'NOT' => 69,
			'WHILE' => 75,
			'USE' => 45,
			'SET' => 40,
			'STOP' => 74,
			'IF' => 73,
			'LITERAL' => 39,
			'TRY' => 65,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'REF' => 67,
			'THROW' => 68,
			'META' => 66,
			'LAST' => 57,
			"[" => 59,
			'NEXT' => 56,
			"\${" => 17,
			'IDENT' => 18,
			'WRAPPER' => 19,
			"(" => 13,
			'TEXT' => 14,
			'SWITCH' => 15,
			'INCLUDE' => 12,
			'UNLESS' => 26,
			'INSERT' => 24,
			'NUMBER' => 61,
			'RAW' => 22,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'perl' => 6,
			"\$" => 4,
			'FOR' => 5,
			'CLEAR' => 47,
			'CALL' => 2,
			"{" => 46,
			'GET' => 52,
			"\"" => 9,
			'VIEW' => 48,
			'rawperl' => 49
		},
		DEFAULT => -2,
		GOTOS => {
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'anonblock' => 41,
			'ident' => 23,
			'assign' => 72,
			'atomdir' => 62,
			'defblock' => 44,
			'directive' => 43,
			'setlist' => 42,
			'switch' => 29,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'try' => 30,
			'node' => 7,
			'capture' => 64,
			'statement' => 3,
			'macro' => 63,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'chunk' => 119,
			'filter' => 31
		}
	},
	{#State 26
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"[" => 59,
			"{" => 46,
			'NOT' => 69,
			"(" => 13
		},
		GOTOS => {
			'lterm' => 51,
			'ident' => 77,
			'sterm' => 35,
			'term' => 28,
			'item' => 71,
			'node' => 7,
			'expr' => 120
		}
	},
	{#State 27
		ACTIONS => {
			'UNLESS' => 125,
			'FOR' => 126,
			'WRAPPER' => 124,
			'FILTER' => 123,
			'WHILE' => 121,
			'IF' => 122
		}
	},
	{#State 28
		DEFAULT => -147
	},
	{#State 29
		DEFAULT => -23
	},
	{#State 30
		DEFAULT => -25
	},
	{#State 31
		DEFAULT => -45
	},
	{#State 32
		DEFAULT => -1
	},
	{#State 33
		ACTIONS => {
			";" => 127
		}
	},
	{#State 34
		ACTIONS => {
			'IDENT' => 90,
			'FILENAME' => 97,
			"\$" => 92,
			"\"" => 91,
			'NUMBER' => 95,
			'LITERAL' => 93
		},
		GOTOS => {
			'filename' => 99,
			'filepart' => 98,
			'name' => 96,
			'names' => 94,
			'nameargs' => 128
		}
	},
	{#State 35
		DEFAULT => -105
	},
	{#State 36
		ACTIONS => {
			'NUMBER' => 95,
			"\"" => 111,
			'LITERAL' => 108,
			"\${" => 17,
			'FILENAME' => 97,
			'IDENT' => 112,
			"\$" => 110
		},
		GOTOS => {
			'filepart' => 98,
			'filename' => 99,
			'lnameargs' => 129,
			'item' => 115,
			'name' => 96,
			'lvalue' => 113,
			'nameargs' => 114,
			'names' => 94
		}
	},
	{#State 37
		ACTIONS => {
			'NUMBER' => 95,
			'LITERAL' => 130,
			'FILENAME' => 97,
			'IDENT' => 133
		},
		DEFAULT => -88,
		GOTOS => {
			'blockargs' => 131,
			'filepart' => 98,
			'filename' => 134,
			'blockname' => 132,
			'metadata' => 86,
			'meta' => 87
		}
	},
	{#State 38
		ACTIONS => {
			'' => 135
		}
	},
	{#State 39
		ACTIONS => {
			'ASSIGN' => 136
		},
		DEFAULT => -113
	},
	{#State 40
		ACTIONS => {
			"\$" => 4,
			'IDENT' => 18,
			"\${" => 17,
			'LITERAL' => 139
		},
		GOTOS => {
			'setlist' => 138,
			'node' => 7,
			'item' => 71,
			'assign' => 72,
			'ident' => 137
		}
	},
	{#State 41
		DEFAULT => -10
	},
	{#State 42
		ACTIONS => {
			'LITERAL' => 139,
			'COMMA' => 140,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18
		},
		DEFAULT => -20,
		GOTOS => {
			'ident' => 137,
			'assign' => 141,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 43
		DEFAULT => -8
	},
	{#State 44
		DEFAULT => -9
	},
	{#State 45
		ACTIONS => {
			"\${" => 17,
			'FILENAME' => 97,
			"\$" => 110,
			'IDENT' => 112,
			'LITERAL' => 108,
			'NUMBER' => 95,
			"\"" => 111
		},
		GOTOS => {
			'nameargs' => 114,
			'lvalue' => 113,
			'names' => 94,
			'name' => 96,
			'lnameargs' => 142,
			'item' => 115,
			'filepart' => 98,
			'filename' => 99
		}
	},
	{#State 46
		ACTIONS => {
			"\$" => 4,
			'IDENT' => 18,
			"\${" => 17,
			'LITERAL' => 146
		},
		DEFAULT => -120,
		GOTOS => {
			'item' => 144,
			'param' => 143,
			'params' => 145,
			'hash' => 147
		}
	},
	{#State 47
		DEFAULT => -40
	},
	{#State 48
		ACTIONS => {
			'NUMBER' => 95,
			"\"" => 91,
			'LITERAL' => 93,
			'FILENAME' => 97,
			"\$" => 92,
			'IDENT' => 90
		},
		GOTOS => {
			'nameargs' => 148,
			'names' => 94,
			'name' => 96,
			'filepart' => 98,
			'filename' => 99
		}
	},
	{#State 49
		DEFAULT => -16
	},
	{#State 50
		DEFAULT => -14
	},
	{#State 51
		DEFAULT => -104
	},
	{#State 52
		ACTIONS => {
			"(" => 13,
			"{" => 46,
			'NOT' => 69,
			"[" => 59,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			'REF' => 67
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'expr' => 149,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 53
		DEFAULT => -44
	},
	{#State 54
		DEFAULT => -26
	},
	{#State 55
		DEFAULT => -22
	},
	{#State 56
		DEFAULT => -42
	},
	{#State 57
		DEFAULT => -41
	},
	{#State 58
		ACTIONS => {
			'MOD' => 158,
			'BINOP' => 155,
			'CAT' => 156,
			'CMPOP' => 150,
			"+" => 154,
			'OR' => 157,
			'AND' => 153,
			";" => -17,
			"?" => 159,
			'DIV' => 151,
			"/" => 152
		},
		DEFAULT => -28
	},
	{#State 59
		ACTIONS => {
			'REF' => 67,
			"]" => 163,
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"[" => 59,
			"{" => 46
		},
		GOTOS => {
			'term' => 161,
			'sterm' => 162,
			'item' => 71,
			'node' => 7,
			'list' => 160,
			'ident' => 77,
			'lterm' => 51,
			'range' => 164
		}
	},
	{#State 60
		ACTIONS => {
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			'LITERAL' => 139
		},
		GOTOS => {
			'setlist' => 165,
			'node' => 7,
			'item' => 71,
			'assign' => 72,
			'ident' => 137
		}
	},
	{#State 61
		DEFAULT => -114
	},
	{#State 62
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 63
		DEFAULT => -12
	},
	{#State 64
		DEFAULT => -11
	},
	{#State 65
		ACTIONS => {
			";" => 166
		}
	},
	{#State 66
		ACTIONS => {
			'IDENT' => 85
		},
		GOTOS => {
			'metadata' => 167,
			'meta' => 87
		}
	},
	{#State 67
		ACTIONS => {
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4
		},
		GOTOS => {
			'node' => 7,
			'item' => 71,
			'ident' => 168
		}
	},
	{#State 68
		ACTIONS => {
			"\"" => 91,
			'NUMBER' => 95,
			'LITERAL' => 93,
			"\$" => 92,
			'FILENAME' => 97,
			'IDENT' => 90
		},
		GOTOS => {
			'filename' => 99,
			'filepart' => 98,
			'name' => 96,
			'names' => 94,
			'nameargs' => 169
		}
	},
	{#State 69
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61,
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			"[" => 59,
			"{" => 46,
			'NOT' => 69,
			"(" => 13
		},
		GOTOS => {
			'expr' => 170,
			'item' => 71,
			'node' => 7,
			'sterm' => 35,
			'lterm' => 51,
			'ident' => 77,
			'term' => 28
		}
	},
	{#State 70
		DEFAULT => -38
	},
	{#State 71
		ACTIONS => {
			"(" => 171
		},
		DEFAULT => -129
	},
	{#State 72
		DEFAULT => -150
	},
	{#State 73
		ACTIONS => {
			"\$" => 4,
			'IDENT' => 18,
			"\${" => 17,
			"[" => 59,
			'NOT' => 69,
			"{" => 46,
			"(" => 13,
			'REF' => 67,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61
		},
		GOTOS => {
			'sterm' => 35,
			'lterm' => 51,
			'ident' => 77,
			'term' => 28,
			'expr' => 172,
			'node' => 7,
			'item' => 71
		}
	},
	{#State 74
		DEFAULT => -39
	},
	{#State 75
		ACTIONS => {
			'NOT' => 69,
			"{" => 46,
			"(" => 13,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4,
			"[" => 59,
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			'REF' => 67
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'expr' => 173,
			'term' => 28,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35
		}
	},
	{#State 76
		DEFAULT => -113
	},
	{#State 77
		ACTIONS => {
			'DOT' => 116
		},
		DEFAULT => -110
	},
	{#State 78
		ACTIONS => {
			'DIV' => 151,
			"/" => 152,
			"?" => 159,
			'AND' => 153,
			'OR' => 157,
			"+" => 154,
			'CMPOP' => 150,
			'CAT' => 156,
			'BINOP' => 155,
			'MOD' => 158
		},
		DEFAULT => -31
	},
	{#State 79
		DEFAULT => -7
	},
	{#State 80
		DEFAULT => -133
	},
	{#State 81
		DEFAULT => -157,
		GOTOS => {
			'args' => 174
		}
	},
	{#State 82
		ACTIONS => {
			";" => 175
		}
	},
	{#State 83
		ACTIONS => {
			'IN' => 176,
			'ASSIGN' => 177
		},
		DEFAULT => -131
	},
	{#State 84
		ACTIONS => {
			";" => 178
		}
	},
	{#State 85
		ACTIONS => {
			'ASSIGN' => 179
		}
	},
	{#State 86
		ACTIONS => {
			'COMMA' => 180,
			'IDENT' => 85
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 181
		}
	},
	{#State 87
		DEFAULT => -100
	},
	{#State 88
		ACTIONS => {
			'IDENT' => 18,
			"\$" => 4,
			";" => 182,
			"\${" => 17,
			"\"" => 183,
			'TEXT' => 185
		},
		GOTOS => {
			'quotable' => 186,
			'node' => 7,
			'item' => 71,
			'ident' => 184
		}
	},
	{#State 89
		DEFAULT => -35
	},
	{#State 90
		DEFAULT => -174
	},
	{#State 91
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 187
		}
	},
	{#State 92
		ACTIONS => {
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17
		},
		GOTOS => {
			'ident' => 188,
			'node' => 7,
			'item' => 71
		}
	},
	{#State 93
		DEFAULT => -170
	},
	{#State 94
		ACTIONS => {
			"+" => 189,
			"(" => 190
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 191
		}
	},
	{#State 95
		DEFAULT => -175
	},
	{#State 96
		DEFAULT => -167
	},
	{#State 97
		DEFAULT => -173
	},
	{#State 98
		DEFAULT => -172
	},
	{#State 99
		ACTIONS => {
			'DOT' => 192
		},
		DEFAULT => -169
	},
	{#State 100
		ACTIONS => {
			'DOT' => 116,
			'ASSIGN' => 193
		},
		DEFAULT => -110
	},
	{#State 101
		ACTIONS => {
			")" => 194
		}
	},
	{#State 102
		ACTIONS => {
			'MOD' => 158,
			'OR' => 157,
			'BINOP' => 155,
			'CMPOP' => 150,
			'CAT' => 156,
			'AND' => 153,
			"+" => 154,
			"?" => 159,
			")" => 195,
			"/" => 152,
			'DIV' => 151
		}
	},
	{#State 103
		ACTIONS => {
			"+" => 154,
			"?" => 159,
			";" => 196,
			"/" => 152,
			'DIV' => 151,
			'MOD' => 158,
			'OR' => 157,
			'BINOP' => 155,
			'CMPOP' => 150,
			'CAT' => 156,
			'AND' => 153
		}
	},
	{#State 104
		ACTIONS => {
			"}" => 197
		}
	},
	{#State 105
		ACTIONS => {
			";" => 198
		}
	},
	{#State 106
		ACTIONS => {
			'UNLESS' => 26,
			'INSERT' => 24,
			'NUMBER' => 61,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			"[" => 59,
			'LAST' => 57,
			'WRAPPER' => 19,
			'IDENT' => 18,
			"\${" => 17,
			'NEXT' => 56,
			'SWITCH' => 15,
			"(" => 203,
			'INCLUDE' => 12,
			"\"" => 9,
			'GET' => 52,
			'perl' => 6,
			'FOR' => 5,
			"\$" => 4,
			'CALL' => 2,
			'CLEAR' => 47,
			"{" => 46,
			'WHILE' => 75,
			'STOP' => 74,
			'SET' => 40,
			'LITERAL' => 39,
			'IF' => 73,
			'RETURN' => 70,
			'BLOCK' => 200,
			'FILTER' => 36,
			'NOT' => 69,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'THROW' => 68,
			'REF' => 67,
			'TRY' => 65
		},
		GOTOS => {
			'switch' => 29,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'try' => 30,
			'node' => 7,
			'lterm' => 51,
			'mdir' => 202,
			'filter' => 31,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'wrapper' => 53,
			'item' => 71,
			'expr' => 199,
			'ident' => 100,
			'assign' => 72,
			'atomdir' => 62,
			'setlist' => 42,
			'directive' => 201
		}
	},
	{#State 107
		DEFAULT => -36
	},
	{#State 108
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 109
		DEFAULT => -76
	},
	{#State 110
		ACTIONS => {
			"\$" => 4,
			'IDENT' => 204,
			"\${" => 17
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'ident' => 188
		}
	},
	{#State 111
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 205
		}
	},
	{#State 112
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 113
		ACTIONS => {
			'ASSIGN' => 206
		}
	},
	{#State 114
		DEFAULT => -159
	},
	{#State 115
		DEFAULT => -160
	},
	{#State 116
		ACTIONS => {
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4,
			'NUMBER' => 207
		},
		GOTOS => {
			'node' => 208,
			'item' => 71
		}
	},
	{#State 117
		ACTIONS => {
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'REF' => 67,
			'THROW' => 68,
			'TRY' => 65,
			'SET' => 40,
			'STOP' => 74,
			'LITERAL' => 39,
			'IF' => 73,
			'WHILE' => 75,
			'NOT' => 69,
			'RETURN' => 70,
			'FILTER' => 36,
			'BLOCK' => 200,
			'GET' => 52,
			"\"" => 9,
			'CLEAR' => 47,
			'CALL' => 2,
			"{" => 46,
			'perl' => 6,
			"\$" => 4,
			'FOR' => 5,
			'NUMBER' => 61,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'UNLESS' => 26,
			'INSERT' => 24,
			"(" => 13,
			'SWITCH' => 15,
			'INCLUDE' => 12,
			'LAST' => 57,
			"[" => 59,
			'NEXT' => 56,
			"\${" => 17,
			'IDENT' => 18,
			'WRAPPER' => 19
		},
		GOTOS => {
			'mdir' => 209,
			'filter' => 31,
			'lterm' => 51,
			'try' => 30,
			'node' => 7,
			'switch' => 29,
			'loop' => 1,
			'atomexpr' => 27,
			'term' => 28,
			'atomdir' => 62,
			'directive' => 201,
			'setlist' => 42,
			'ident' => 100,
			'assign' => 72,
			'expr' => 210,
			'item' => 71,
			'sterm' => 35,
			'condition' => 55,
			'wrapper' => 53,
			'javascript' => 54
		}
	},
	{#State 118
		DEFAULT => -34
	},
	{#State 119
		DEFAULT => -4
	},
	{#State 120
		ACTIONS => {
			'CMPOP' => 150,
			'CAT' => 156,
			'AND' => 153,
			'MOD' => 158,
			'OR' => 157,
			'BINOP' => 155,
			'DIV' => 151,
			"/" => 152,
			"+" => 154,
			"?" => 159,
			";" => 211
		}
	},
	{#State 121
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"[" => 59,
			"{" => 46,
			'NOT' => 69,
			"(" => 13
		},
		GOTOS => {
			'term' => 28,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'node' => 7,
			'item' => 71,
			'expr' => 212
		}
	},
	{#State 122
		ACTIONS => {
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			'REF' => 67,
			"(" => 13,
			"{" => 46,
			'NOT' => 69,
			"[" => 59,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'expr' => 213,
			'lterm' => 51,
			'ident' => 77,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 123
		ACTIONS => {
			'NUMBER' => 95,
			"\"" => 111,
			'LITERAL' => 108,
			"\${" => 17,
			"\$" => 110,
			'FILENAME' => 97,
			'IDENT' => 112
		},
		GOTOS => {
			'filename' => 99,
			'filepart' => 98,
			'item' => 115,
			'lnameargs' => 214,
			'name' => 96,
			'names' => 94,
			'lvalue' => 113,
			'nameargs' => 114
		}
	},
	{#State 124
		ACTIONS => {
			'LITERAL' => 93,
			"\"" => 91,
			'NUMBER' => 95,
			'IDENT' => 90,
			'FILENAME' => 97,
			"\$" => 92
		},
		GOTOS => {
			'names' => 94,
			'nameargs' => 215,
			'filename' => 99,
			'filepart' => 98,
			'name' => 96
		}
	},
	{#State 125
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61,
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			"[" => 59,
			"{" => 46,
			'NOT' => 69,
			"(" => 13
		},
		GOTOS => {
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'term' => 28,
			'node' => 7,
			'item' => 71,
			'expr' => 216
		}
	},
	{#State 126
		ACTIONS => {
			'REF' => 67,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			"[" => 59,
			"\${" => 17,
			'IDENT' => 83,
			"\$" => 4,
			"{" => 46
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'loopvar' => 217,
			'sterm' => 35,
			'ident' => 77,
			'lterm' => 51,
			'term' => 81
		}
	},
	{#State 127
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 218
		}
	},
	{#State 128
		DEFAULT => -43
	},
	{#State 129
		ACTIONS => {
			";" => 219
		}
	},
	{#State 130
		DEFAULT => -86
	},
	{#State 131
		ACTIONS => {
			";" => 220
		}
	},
	{#State 132
		DEFAULT => -84
	},
	{#State 133
		ACTIONS => {
			'ASSIGN' => 179
		},
		DEFAULT => -174
	},
	{#State 134
		ACTIONS => {
			'DOT' => 192
		},
		DEFAULT => -85
	},
	{#State 135
		DEFAULT => 0
	},
	{#State 136
		ACTIONS => {
			"[" => 59,
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			"(" => 13,
			"{" => 46,
			'NOT' => 69,
			'REF' => 67,
			"\"" => 9,
			'NUMBER' => 61,
			'LITERAL' => 76
		},
		GOTOS => {
			'term' => 28,
			'sterm' => 35,
			'lterm' => 51,
			'ident' => 77,
			'expr' => 221,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 137
		ACTIONS => {
			'DOT' => 116,
			'ASSIGN' => 193
		}
	},
	{#State 138
		ACTIONS => {
			'COMMA' => 140,
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			'LITERAL' => 139
		},
		DEFAULT => -32,
		GOTOS => {
			'assign' => 141,
			'ident' => 137,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 139
		ACTIONS => {
			'ASSIGN' => 136
		}
	},
	{#State 140
		DEFAULT => -149
	},
	{#State 141
		DEFAULT => -148
	},
	{#State 142
		DEFAULT => -75
	},
	{#State 143
		DEFAULT => -123
	},
	{#State 144
		ACTIONS => {
			'ASSIGN' => 222
		}
	},
	{#State 145
		ACTIONS => {
			'COMMA' => 224,
			'LITERAL' => 146,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4
		},
		DEFAULT => -119,
		GOTOS => {
			'item' => 144,
			'param' => 223
		}
	},
	{#State 146
		ACTIONS => {
			'ASSIGN' => 225
		}
	},
	{#State 147
		ACTIONS => {
			"}" => 226
		}
	},
	{#State 148
		ACTIONS => {
			";" => 227
		}
	},
	{#State 149
		ACTIONS => {
			'AND' => 153,
			'OR' => 157,
			'DIV' => 151,
			"/" => 152,
			"?" => 159,
			'CMPOP' => 150,
			'CAT' => 156,
			'MOD' => 158,
			'BINOP' => 155,
			"+" => 154
		},
		DEFAULT => -30
	},
	{#State 150
		ACTIONS => {
			"[" => 59,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"(" => 13,
			'NOT' => 69,
			"{" => 46,
			'REF' => 67,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76
		},
		GOTOS => {
			'term' => 28,
			'sterm' => 35,
			'ident' => 77,
			'lterm' => 51,
			'expr' => 228,
			'node' => 7,
			'item' => 71
		}
	},
	{#State 151
		ACTIONS => {
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			'REF' => 67,
			"(" => 13,
			"{" => 46,
			'NOT' => 69,
			"[" => 59,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4
		},
		GOTOS => {
			'node' => 7,
			'item' => 71,
			'expr' => 229,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 152
		ACTIONS => {
			"[" => 59,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4,
			"(" => 13,
			'NOT' => 69,
			"{" => 46,
			'REF' => 67,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76
		},
		GOTOS => {
			'expr' => 230,
			'item' => 71,
			'node' => 7,
			'term' => 28,
			'sterm' => 35,
			'lterm' => 51,
			'ident' => 77
		}
	},
	{#State 153
		ACTIONS => {
			"{" => 46,
			'NOT' => 69,
			"(" => 13,
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			"[" => 59,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61,
			'REF' => 67
		},
		GOTOS => {
			'expr' => 231,
			'node' => 7,
			'item' => 71,
			'term' => 28,
			'sterm' => 35,
			'lterm' => 51,
			'ident' => 77
		}
	},
	{#State 154
		ACTIONS => {
			"{" => 46,
			'NOT' => 69,
			"(" => 13,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4,
			"[" => 59,
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			'REF' => 67
		},
		GOTOS => {
			'node' => 7,
			'item' => 71,
			'expr' => 232,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 155
		ACTIONS => {
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61,
			'REF' => 67,
			"{" => 46,
			'NOT' => 69,
			"(" => 13,
			"\$" => 4,
			'IDENT' => 18,
			"\${" => 17,
			"[" => 59
		},
		GOTOS => {
			'term' => 28,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'item' => 71,
			'node' => 7,
			'expr' => 233
		}
	},
	{#State 156
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"[" => 59,
			"{" => 46,
			'NOT' => 69,
			"(" => 13
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'expr' => 234,
			'lterm' => 51,
			'ident' => 77,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 157
		ACTIONS => {
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			'REF' => 67,
			'NOT' => 69,
			"{" => 46,
			"(" => 13,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"[" => 59
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'expr' => 235,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 158
		ACTIONS => {
			"\$" => 4,
			'IDENT' => 18,
			"\${" => 17,
			"[" => 59,
			"{" => 46,
			'NOT' => 69,
			"(" => 13,
			'REF' => 67,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'expr' => 236,
			'lterm' => 51,
			'ident' => 77,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 159
		ACTIONS => {
			"[" => 59,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4,
			"(" => 13,
			'NOT' => 69,
			"{" => 46,
			'REF' => 67,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76
		},
		GOTOS => {
			'term' => 28,
			'sterm' => 35,
			'lterm' => 51,
			'ident' => 77,
			'expr' => 237,
			'node' => 7,
			'item' => 71
		}
	},
	{#State 160
		ACTIONS => {
			"]" => 240,
			'REF' => 67,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			"[" => 59,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"{" => 46,
			'COMMA' => 239
		},
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'term' => 238,
			'sterm' => 35,
			'lterm' => 51,
			'ident' => 77
		}
	},
	{#State 161
		DEFAULT => -117
	},
	{#State 162
		ACTIONS => {
			'TO' => 241
		},
		DEFAULT => -105
	},
	{#State 163
		DEFAULT => -108
	},
	{#State 164
		ACTIONS => {
			"]" => 242
		}
	},
	{#State 165
		ACTIONS => {
			'LITERAL' => 139,
			'COMMA' => 140,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4
		},
		DEFAULT => -33,
		GOTOS => {
			'item' => 71,
			'node' => 7,
			'ident' => 137,
			'assign' => 141
		}
	},
	{#State 166
		ACTIONS => {
			'INSERT' => 24,
			'UNLESS' => 26,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'NUMBER' => 61,
			'RAW' => 22,
			"\${" => 17,
			'NEXT' => 56,
			'WRAPPER' => 19,
			'IDENT' => 18,
			'LAST' => 57,
			"[" => 59,
			'INCLUDE' => 12,
			"(" => 13,
			'TEXT' => 14,
			'SWITCH' => 15,
			'VIEW' => 48,
			'rawperl' => 49,
			'GET' => 52,
			"\"" => 9,
			"\$" => 4,
			'FOR' => 5,
			'perl' => 6,
			"{" => 46,
			'CLEAR' => 47,
			'CALL' => 2,
			'WHILE' => 75,
			'USE' => 45,
			'IF' => 73,
			'LITERAL' => 39,
			'SET' => 40,
			'STOP' => 74,
			";" => -19,
			'FILTER' => 36,
			'BLOCK' => 37,
			'RETURN' => 70,
			'NOT' => 69,
			'REF' => 67,
			'THROW' => 68,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'META' => 66,
			'TRY' => 65
		},
		DEFAULT => -3,
		GOTOS => {
			'use' => 16,
			'item' => 71,
			'expr' => 58,
			'javascript' => 54,
			'wrapper' => 53,
			'view' => 11,
			'condition' => 55,
			'sterm' => 35,
			'chunks' => 25,
			'setlist' => 42,
			'directive' => 43,
			'defblock' => 44,
			'atomdir' => 62,
			'assign' => 72,
			'ident' => 23,
			'anonblock' => 41,
			'statement' => 3,
			'macro' => 63,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'switch' => 29,
			'block' => 243,
			'filter' => 31,
			'chunk' => 10,
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50
		}
	},
	{#State 167
		ACTIONS => {
			'IDENT' => 85,
			'COMMA' => 180
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 181
		}
	},
	{#State 168
		ACTIONS => {
			'DOT' => 116
		},
		DEFAULT => -111
	},
	{#State 169
		DEFAULT => -37
	},
	{#State 170
		ACTIONS => {
			'MOD' => 158,
			"/" => 152,
			'BINOP' => 155,
			'CAT' => 156,
			'CMPOP' => 150,
			"+" => 154,
			'DIV' => 151
		},
		DEFAULT => -143
	},
	{#State 171
		DEFAULT => -157,
		GOTOS => {
			'args' => 244
		}
	},
	{#State 172
		ACTIONS => {
			"/" => 152,
			'DIV' => 151,
			"?" => 159,
			";" => 245,
			"+" => 154,
			'AND' => 153,
			'CMPOP' => 150,
			'CAT' => 156,
			'OR' => 157,
			'BINOP' => 155,
			'MOD' => 158
		}
	},
	{#State 173
		ACTIONS => {
			"/" => 152,
			'DIV' => 151,
			"+" => 154,
			"?" => 159,
			";" => 246,
			'CMPOP' => 150,
			'CAT' => 156,
			'AND' => 153,
			'MOD' => 158,
			'OR' => 157,
			'BINOP' => 155
		}
	},
	{#State 174
		ACTIONS => {
			"[" => 59,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"(" => 13,
			"{" => 46,
			'NOT' => 69,
			'COMMA' => 251,
			'REF' => 67,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 248
		},
		DEFAULT => -66,
		GOTOS => {
			'node' => 7,
			'item' => 252,
			'expr' => 249,
			'sterm' => 35,
			'term' => 28,
			'param' => 250,
			'lterm' => 51,
			'ident' => 247
		}
	},
	{#State 175
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 253
		}
	},
	{#State 176
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61,
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			"[" => 59,
			"{" => 46
		},
		GOTOS => {
			'node' => 7,
			'item' => 71,
			'sterm' => 35,
			'ident' => 77,
			'lterm' => 51,
			'term' => 254
		}
	},
	{#State 177
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"[" => 59,
			"{" => 46
		},
		GOTOS => {
			'term' => 255,
			'lterm' => 51,
			'ident' => 77,
			'sterm' => 35,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 178
		ACTIONS => {
			'rawperl' => 49,
			'VIEW' => 48,
			'GET' => 52,
			"\"" => 9,
			"\$" => 4,
			'FOR' => 5,
			'perl' => 6,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47,
			'INSERT' => 24,
			'UNLESS' => 26,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'NUMBER' => 61,
			'RAW' => 22,
			'WRAPPER' => 19,
			'IDENT' => 18,
			'NEXT' => 56,
			"\${" => 17,
			"[" => 59,
			'LAST' => 57,
			'INCLUDE' => 12,
			'SWITCH' => 15,
			"(" => 13,
			'TEXT' => 14,
			'THROW' => 68,
			'REF' => 67,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'META' => 66,
			'TRY' => 65,
			'USE' => 45,
			'WHILE' => 75,
			'LITERAL' => 39,
			'IF' => 73,
			'STOP' => 74,
			'SET' => 40,
			'BLOCK' => 37,
			'FILTER' => 36,
			";" => -19,
			'RETURN' => 70,
			'NOT' => 69
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 41,
			'assign' => 72,
			'defblock' => 44,
			'setlist' => 42,
			'directive' => 43,
			'sterm' => 35,
			'item' => 71,
			'template' => 256,
			'block' => 32,
			'filter' => 31,
			'switch' => 29,
			'atomexpr' => 27,
			'term' => 28,
			'try' => 30,
			'capture' => 64,
			'macro' => 63,
			'ident' => 23,
			'atomdir' => 62,
			'chunks' => 25,
			'condition' => 55,
			'javascript' => 54,
			'wrapper' => 53,
			'view' => 11,
			'expr' => 58,
			'use' => 16,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'chunk' => 10,
			'loop' => 1,
			'node' => 7,
			'statement' => 3
		}
	},
	{#State 179
		ACTIONS => {
			'LITERAL' => 257,
			"\"" => 258,
			'NUMBER' => 259
		}
	},
	{#State 180
		DEFAULT => -99
	},
	{#State 181
		DEFAULT => -98
	},
	{#State 182
		DEFAULT => -180
	},
	{#State 183
		DEFAULT => -112
	},
	{#State 184
		ACTIONS => {
			'DOT' => 116
		},
		DEFAULT => -178
	},
	{#State 185
		DEFAULT => -179
	},
	{#State 186
		DEFAULT => -176
	},
	{#State 187
		ACTIONS => {
			"\"" => 260,
			'TEXT' => 185,
			'IDENT' => 18,
			"\$" => 4,
			";" => 182,
			"\${" => 17
		},
		GOTOS => {
			'quotable' => 186,
			'item' => 71,
			'node' => 7,
			'ident' => 184
		}
	},
	{#State 188
		ACTIONS => {
			'DOT' => 116
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 261
		}
	},
	{#State 189
		ACTIONS => {
			'FILENAME' => 97,
			'IDENT' => 90,
			'NUMBER' => 95,
			"\"" => 91,
			'LITERAL' => 93
		},
		GOTOS => {
			'name' => 262,
			'filepart' => 98,
			'filename' => 99
		}
	},
	{#State 190
		DEFAULT => -157,
		GOTOS => {
			'args' => 263
		}
	},
	{#State 191
		ACTIONS => {
			"\"" => 9,
			'REF' => 67,
			"{" => 46,
			"\$" => 4,
			'NUMBER' => 61,
			'LITERAL' => 248,
			"(" => 13,
			'NOT' => 69,
			'COMMA' => 251,
			"[" => 59,
			"\${" => 17,
			'IDENT' => 18
		},
		DEFAULT => -164,
		GOTOS => {
			'ident' => 247,
			'lterm' => 51,
			'param' => 250,
			'sterm' => 35,
			'term' => 28,
			'expr' => 249,
			'node' => 7,
			'item' => 252
		}
	},
	{#State 192
		ACTIONS => {
			'NUMBER' => 95,
			'IDENT' => 90,
			'FILENAME' => 97
		},
		GOTOS => {
			'filepart' => 264
		}
	},
	{#State 193
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			'NUMBER' => 61,
			"\"" => 9,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"[" => 59,
			'NOT' => 69,
			"{" => 46,
			"(" => 13
		},
		GOTOS => {
			'expr' => 265,
			'item' => 71,
			'node' => 7,
			'sterm' => 35,
			'lterm' => 51,
			'ident' => 77,
			'term' => 28
		}
	},
	{#State 194
		DEFAULT => -145
	},
	{#State 195
		DEFAULT => -146
	},
	{#State 196
		ACTIONS => {
			'TRY' => 65,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'THROW' => 68,
			'REF' => 67,
			'META' => 66,
			'RETURN' => 70,
			'BLOCK' => 37,
			'FILTER' => 36,
			";" => -19,
			'NOT' => 69,
			'USE' => 45,
			'WHILE' => 75,
			'STOP' => 74,
			'SET' => 40,
			'IF' => 73,
			'LITERAL' => 39,
			'perl' => 6,
			'FOR' => 5,
			"\$" => 4,
			'CALL' => 2,
			'CLEAR' => 47,
			"{" => 46,
			'GET' => 52,
			"\"" => 9,
			'rawperl' => 49,
			'VIEW' => 48,
			"[" => 59,
			'LAST' => 57,
			'IDENT' => 18,
			'WRAPPER' => 19,
			"\${" => 17,
			'NEXT' => 56,
			'SWITCH' => 15,
			"(" => 13,
			'TEXT' => 14,
			'INCLUDE' => 12,
			'UNLESS' => 26,
			'INSERT' => 24,
			'RAW' => 22,
			'NUMBER' => 61,
			'PROCESS' => 21,
			'MACRO' => 20,
			'DEFAULT' => 60
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50,
			'block' => 266,
			'filter' => 31,
			'chunk' => 10,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'switch' => 29,
			'statement' => 3,
			'macro' => 63,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'assign' => 72,
			'anonblock' => 41,
			'ident' => 23,
			'chunks' => 25,
			'directive' => 43,
			'defblock' => 44,
			'setlist' => 42,
			'atomdir' => 62,
			'javascript' => 54,
			'wrapper' => 53,
			'view' => 11,
			'condition' => 55,
			'sterm' => 35,
			'use' => 16,
			'item' => 71,
			'expr' => 58
		}
	},
	{#State 197
		DEFAULT => -132
	},
	{#State 198
		ACTIONS => {
			'DEFAULT' => 60,
			'MACRO' => 20,
			'PROCESS' => 21,
			'RAW' => 22,
			'NUMBER' => 61,
			'INSERT' => 24,
			'UNLESS' => 26,
			'INCLUDE' => 12,
			'TEXT' => 14,
			"(" => 13,
			'SWITCH' => 15,
			'NEXT' => 56,
			"\${" => 17,
			'WRAPPER' => 19,
			'IDENT' => 18,
			'LAST' => 57,
			"[" => 59,
			'VIEW' => 48,
			'rawperl' => 49,
			'GET' => 52,
			"\"" => 9,
			"{" => 46,
			'CLEAR' => 47,
			'CALL' => 2,
			'FOR' => 5,
			"\$" => 4,
			'perl' => 6,
			'IF' => 73,
			'LITERAL' => 39,
			'SET' => 40,
			'STOP' => 74,
			'WHILE' => 75,
			'USE' => 45,
			'NOT' => 69,
			";" => -19,
			'FILTER' => 36,
			'BLOCK' => 37,
			'RETURN' => 70,
			'META' => 66,
			'REF' => 67,
			'THROW' => 68,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'TRY' => 65
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 10,
			'block' => 267,
			'filter' => 31,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'macro' => 63,
			'statement' => 3,
			'switch' => 29,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'atomdir' => 62,
			'chunks' => 25,
			'setlist' => 42,
			'directive' => 43,
			'defblock' => 44,
			'ident' => 23,
			'anonblock' => 41,
			'assign' => 72,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53
		}
	},
	{#State 199
		ACTIONS => {
			"+" => 154,
			'CMPOP' => 150,
			'CAT' => 156,
			'MOD' => 158,
			'BINOP' => 155,
			"/" => 152,
			'DIV' => 151,
			"?" => 159,
			'AND' => 153,
			'OR' => 157
		},
		DEFAULT => -28
	},
	{#State 200
		ACTIONS => {
			";" => 268
		}
	},
	{#State 201
		DEFAULT => -93
	},
	{#State 202
		DEFAULT => -92
	},
	{#State 203
		ACTIONS => {
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 39,
			'REF' => 67,
			"(" => 13,
			'NOT' => 69,
			"{" => 46,
			"[" => 59,
			"\${" => 17,
			'IDENT' => 270,
			"\$" => 4
		},
		GOTOS => {
			'lterm' => 51,
			'ident' => 100,
			'assign' => 101,
			'margs' => 269,
			'sterm' => 35,
			'term' => 28,
			'expr' => 102,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 204
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 205
		ACTIONS => {
			'TEXT' => 185,
			"\"" => 271,
			";" => 182,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4
		},
		GOTOS => {
			'ident' => 184,
			'node' => 7,
			'item' => 71,
			'quotable' => 186
		}
	},
	{#State 206
		ACTIONS => {
			'LITERAL' => 93,
			"\"" => 91,
			'NUMBER' => 95,
			"\$" => 92,
			'FILENAME' => 97,
			'IDENT' => 90
		},
		GOTOS => {
			'filepart' => 98,
			'name' => 96,
			'filename' => 99,
			'nameargs' => 272,
			'names' => 94
		}
	},
	{#State 207
		DEFAULT => -127
	},
	{#State 208
		DEFAULT => -126
	},
	{#State 209
		DEFAULT => -90
	},
	{#State 210
		ACTIONS => {
			'OR' => 157,
			'LITERAL' => -151,
			'AND' => 153,
			"\${" => -151,
			";" => -151,
			'IDENT' => -151,
			"?" => 159,
			"/" => 152,
			'DIV' => 151,
			'COMMA' => -151,
			'BINOP' => 155,
			'MOD' => 158,
			'CAT' => 156,
			'CMPOP' => 150,
			"\$" => -151,
			"+" => 154
		},
		DEFAULT => -28
	},
	{#State 211
		ACTIONS => {
			'INCLUDE' => 12,
			'SWITCH' => 15,
			'TEXT' => 14,
			"(" => 13,
			'IDENT' => 18,
			'WRAPPER' => 19,
			"\${" => 17,
			'NEXT' => 56,
			"[" => 59,
			'LAST' => 57,
			'PROCESS' => 21,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'RAW' => 22,
			'NUMBER' => 61,
			'INSERT' => 24,
			'UNLESS' => 26,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47,
			"\$" => 4,
			'FOR' => 5,
			'perl' => 6,
			'rawperl' => 49,
			'VIEW' => 48,
			"\"" => 9,
			'GET' => 52,
			'NOT' => 69,
			'BLOCK' => 37,
			";" => -19,
			'FILTER' => 36,
			'RETURN' => 70,
			'IF' => 73,
			'LITERAL' => 39,
			'STOP' => 74,
			'SET' => 40,
			'USE' => 45,
			'WHILE' => 75,
			'TRY' => 65,
			'META' => 66,
			'THROW' => 68,
			'REF' => 67,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34
		},
		DEFAULT => -3,
		GOTOS => {
			'assign' => 72,
			'anonblock' => 41,
			'ident' => 23,
			'setlist' => 42,
			'defblock' => 44,
			'directive' => 43,
			'chunks' => 25,
			'atomdir' => 62,
			'wrapper' => 53,
			'view' => 11,
			'javascript' => 54,
			'sterm' => 35,
			'condition' => 55,
			'use' => 16,
			'expr' => 58,
			'item' => 71,
			'defblockname' => 8,
			'raw' => 50,
			'lterm' => 51,
			'filter' => 31,
			'block' => 273,
			'chunk' => 10,
			'loop' => 1,
			'term' => 28,
			'atomexpr' => 27,
			'switch' => 29,
			'macro' => 63,
			'statement' => 3,
			'capture' => 64,
			'try' => 30,
			'node' => 7
		}
	},
	{#State 212
		ACTIONS => {
			'AND' => 153,
			'CAT' => 156,
			'CMPOP' => 150,
			'BINOP' => 155,
			'OR' => 157,
			'MOD' => 158,
			'DIV' => 151,
			"/" => 152,
			"?" => 159,
			"+" => 154
		},
		DEFAULT => -63
	},
	{#State 213
		ACTIONS => {
			'DIV' => 151,
			"/" => 152,
			"+" => 154,
			"?" => 159,
			'CMPOP' => 150,
			'CAT' => 156,
			'AND' => 153,
			'MOD' => 158,
			'OR' => 157,
			'BINOP' => 155
		},
		DEFAULT => -47
	},
	{#State 214
		DEFAULT => -82
	},
	{#State 215
		DEFAULT => -68
	},
	{#State 216
		ACTIONS => {
			'MOD' => 158,
			'BINOP' => 155,
			'OR' => 157,
			'CAT' => 156,
			'CMPOP' => 150,
			'AND' => 153,
			"+" => 154,
			"?" => 159,
			"/" => 152,
			'DIV' => 151
		},
		DEFAULT => -49
	},
	{#State 217
		DEFAULT => -60
	},
	{#State 218
		ACTIONS => {
			'META' => 66,
			'REF' => 67,
			'THROW' => 68,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'TRY' => 65,
			'LITERAL' => 39,
			'IF' => 73,
			'SET' => 40,
			'STOP' => 74,
			'WHILE' => 75,
			'USE' => 45,
			'NOT' => 69,
			'FILTER' => 36,
			";" => -19,
			'BLOCK' => 37,
			'RETURN' => 70,
			'VIEW' => 48,
			'rawperl' => 49,
			'GET' => 52,
			"\"" => 9,
			"{" => 46,
			'CLEAR' => 47,
			'CALL' => 2,
			'FOR' => 5,
			"\$" => 4,
			'perl' => 6,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'PROCESS' => 21,
			'RAW' => 22,
			'NUMBER' => 61,
			'INSERT' => 24,
			'UNLESS' => 26,
			'INCLUDE' => 12,
			"(" => 13,
			'TEXT' => 14,
			'SWITCH' => 15,
			'NEXT' => 56,
			"\${" => 17,
			'IDENT' => 18,
			'WRAPPER' => 19,
			'LAST' => 57,
			"[" => 59
		},
		DEFAULT => -3,
		GOTOS => {
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'statement' => 3,
			'macro' => 63,
			'switch' => 29,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'chunk' => 10,
			'block' => 274,
			'filter' => 31,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'atomdir' => 62,
			'chunks' => 25,
			'directive' => 43,
			'defblock' => 44,
			'setlist' => 42,
			'anonblock' => 41,
			'ident' => 23,
			'assign' => 72
		}
	},
	{#State 219
		ACTIONS => {
			"\$" => 4,
			'FOR' => 5,
			'perl' => 6,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47,
			'rawperl' => 49,
			'VIEW' => 48,
			"\"" => 9,
			'GET' => 52,
			'WRAPPER' => 19,
			'IDENT' => 18,
			"\${" => 17,
			'NEXT' => 56,
			"[" => 59,
			'LAST' => 57,
			'INCLUDE' => 12,
			'SWITCH' => 15,
			'TEXT' => 14,
			"(" => 13,
			'INSERT' => 24,
			'UNLESS' => 26,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'NUMBER' => 61,
			'RAW' => 22,
			'TRY' => 65,
			'THROW' => 68,
			'REF' => 67,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'META' => 66,
			'BLOCK' => 37,
			'FILTER' => 36,
			";" => -19,
			'RETURN' => 70,
			'NOT' => 69,
			'USE' => 45,
			'WHILE' => 75,
			'LITERAL' => 39,
			'IF' => 73,
			'STOP' => 74,
			'SET' => 40
		},
		DEFAULT => -3,
		GOTOS => {
			'raw' => 50,
			'lterm' => 51,
			'defblockname' => 8,
			'chunk' => 10,
			'filter' => 31,
			'block' => 275,
			'switch' => 29,
			'loop' => 1,
			'atomexpr' => 27,
			'term' => 28,
			'capture' => 64,
			'try' => 30,
			'node' => 7,
			'statement' => 3,
			'macro' => 63,
			'ident' => 23,
			'anonblock' => 41,
			'assign' => 72,
			'atomdir' => 62,
			'defblock' => 44,
			'directive' => 43,
			'setlist' => 42,
			'chunks' => 25,
			'sterm' => 35,
			'condition' => 55,
			'view' => 11,
			'wrapper' => 53,
			'javascript' => 54,
			'expr' => 58,
			'item' => 71,
			'use' => 16
		}
	},
	{#State 220
		ACTIONS => {
			'NOT' => 69,
			'RETURN' => 70,
			";" => -19,
			'FILTER' => 36,
			'BLOCK' => 37,
			'SET' => 40,
			'STOP' => 74,
			'LITERAL' => 39,
			'IF' => 73,
			'WHILE' => 75,
			'USE' => 45,
			'TRY' => 65,
			'META' => 66,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'REF' => 67,
			'THROW' => 68,
			'TEXT' => 14,
			"(" => 13,
			'SWITCH' => 15,
			'INCLUDE' => 12,
			'LAST' => 57,
			"[" => 59,
			"\${" => 17,
			'NEXT' => 56,
			'IDENT' => 18,
			'WRAPPER' => 19,
			'NUMBER' => 61,
			'RAW' => 22,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'UNLESS' => 26,
			'INSERT' => 24,
			'CLEAR' => 47,
			'CALL' => 2,
			"{" => 46,
			'perl' => 6,
			'FOR' => 5,
			"\$" => 4,
			'GET' => 52,
			"\"" => 9,
			'VIEW' => 48,
			'rawperl' => 49
		},
		DEFAULT => -3,
		GOTOS => {
			'statement' => 3,
			'macro' => 63,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'switch' => 29,
			'block' => 276,
			'filter' => 31,
			'chunk' => 10,
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50,
			'use' => 16,
			'item' => 71,
			'expr' => 58,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'condition' => 55,
			'sterm' => 35,
			'chunks' => 25,
			'directive' => 43,
			'setlist' => 42,
			'defblock' => 44,
			'atomdir' => 62,
			'assign' => 72,
			'ident' => 23,
			'anonblock' => 41
		}
	},
	{#State 221
		ACTIONS => {
			'BINOP' => 155,
			'MOD' => 158,
			'CMPOP' => 150,
			'CAT' => 156,
			"+" => 154,
			'OR' => 157,
			'AND' => 153,
			"?" => 159,
			'DIV' => 151,
			"/" => 152
		},
		DEFAULT => -152
	},
	{#State 222
		ACTIONS => {
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			'REF' => 67,
			"(" => 13,
			'NOT' => 69,
			"{" => 46,
			"[" => 59,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18
		},
		GOTOS => {
			'term' => 28,
			'sterm' => 35,
			'ident' => 77,
			'lterm' => 51,
			'expr' => 277,
			'node' => 7,
			'item' => 71
		}
	},
	{#State 223
		DEFAULT => -121
	},
	{#State 224
		DEFAULT => -122
	},
	{#State 225
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 76,
			"\"" => 9,
			'NUMBER' => 61,
			"\$" => 4,
			'IDENT' => 18,
			"\${" => 17,
			"[" => 59,
			'NOT' => 69,
			"{" => 46,
			"(" => 13
		},
		GOTOS => {
			'lterm' => 51,
			'ident' => 77,
			'sterm' => 35,
			'term' => 28,
			'node' => 7,
			'item' => 71,
			'expr' => 278
		}
	},
	{#State 226
		DEFAULT => -109
	},
	{#State 227
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 279
		}
	},
	{#State 228
		ACTIONS => {
			'DIV' => 151,
			'BINOP' => 155,
			"+" => 154,
			"/" => 152,
			'MOD' => 158
		},
		DEFAULT => -139
	},
	{#State 229
		ACTIONS => {
			'MOD' => 158
		},
		DEFAULT => -137
	},
	{#State 230
		ACTIONS => {
			'DIV' => 151,
			'MOD' => 158
		},
		DEFAULT => -135
	},
	{#State 231
		ACTIONS => {
			"/" => 152,
			'MOD' => 158,
			'DIV' => 151,
			"+" => 154,
			'BINOP' => 155,
			'CMPOP' => 150,
			'CAT' => 156
		},
		DEFAULT => -141
	},
	{#State 232
		ACTIONS => {
			'DIV' => 151,
			"/" => 152,
			'MOD' => 158
		},
		DEFAULT => -136
	},
	{#State 233
		ACTIONS => {
			'MOD' => 158,
			"/" => 152,
			"+" => 154,
			'DIV' => 151
		},
		DEFAULT => -134
	},
	{#State 234
		ACTIONS => {
			"+" => 154,
			'CMPOP' => 150,
			'BINOP' => 155,
			'DIV' => 151,
			'MOD' => 158,
			"/" => 152
		},
		DEFAULT => -140
	},
	{#State 235
		ACTIONS => {
			"/" => 152,
			'MOD' => 158,
			'DIV' => 151,
			"+" => 154,
			'BINOP' => 155,
			'CAT' => 156,
			'CMPOP' => 150
		},
		DEFAULT => -142
	},
	{#State 236
		DEFAULT => -138
	},
	{#State 237
		ACTIONS => {
			'DIV' => 151,
			"/" => 152,
			"?" => 159,
			"+" => 154,
			'AND' => 153,
			'CMPOP' => 150,
			'CAT' => 156,
			'OR' => 157,
			'BINOP' => 155,
			'MOD' => 158,
			":" => 280
		}
	},
	{#State 238
		DEFAULT => -115
	},
	{#State 239
		DEFAULT => -116
	},
	{#State 240
		DEFAULT => -106
	},
	{#State 241
		ACTIONS => {
			"\"" => 9,
			'NUMBER' => 61,
			'LITERAL' => 76,
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			'REF' => 67
		},
		GOTOS => {
			'ident' => 77,
			'sterm' => 281,
			'node' => 7,
			'item' => 71
		}
	},
	{#State 242
		DEFAULT => -107
	},
	{#State 243
		ACTIONS => {
			'FINAL' => 283,
			'CATCH' => 282
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 284
		}
	},
	{#State 244
		ACTIONS => {
			"(" => 13,
			'NOT' => 69,
			"{" => 46,
			")" => 285,
			'COMMA' => 251,
			"[" => 59,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 248,
			'REF' => 67
		},
		GOTOS => {
			'sterm' => 35,
			'term' => 28,
			'expr' => 249,
			'node' => 7,
			'item' => 252,
			'lterm' => 51,
			'ident' => 247,
			'param' => 250
		}
	},
	{#State 245
		ACTIONS => {
			'NOT' => 69,
			'BLOCK' => 37,
			'FILTER' => 36,
			";" => -19,
			'RETURN' => 70,
			'LITERAL' => 39,
			'IF' => 73,
			'STOP' => 74,
			'SET' => 40,
			'USE' => 45,
			'WHILE' => 75,
			'TRY' => 65,
			'META' => 66,
			'THROW' => 68,
			'REF' => 67,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'INCLUDE' => 12,
			'SWITCH' => 15,
			'TEXT' => 14,
			"(" => 13,
			'WRAPPER' => 19,
			'IDENT' => 18,
			'NEXT' => 56,
			"\${" => 17,
			"[" => 59,
			'LAST' => 57,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'NUMBER' => 61,
			'RAW' => 22,
			'INSERT' => 24,
			'UNLESS' => 26,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47,
			"\$" => 4,
			'FOR' => 5,
			'perl' => 6,
			'rawperl' => 49,
			'VIEW' => 48,
			'GET' => 52,
			"\"" => 9
		},
		DEFAULT => -3,
		GOTOS => {
			'chunks' => 25,
			'defblock' => 44,
			'directive' => 43,
			'setlist' => 42,
			'atomdir' => 62,
			'assign' => 72,
			'ident' => 23,
			'anonblock' => 41,
			'use' => 16,
			'item' => 71,
			'expr' => 58,
			'javascript' => 54,
			'wrapper' => 53,
			'view' => 11,
			'condition' => 55,
			'sterm' => 35,
			'block' => 286,
			'filter' => 31,
			'chunk' => 10,
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50,
			'macro' => 63,
			'statement' => 3,
			'try' => 30,
			'node' => 7,
			'capture' => 64,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'switch' => 29
		}
	},
	{#State 246
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 287
		}
	},
	{#State 247
		ACTIONS => {
			'ASSIGN' => 288,
			'DOT' => 116
		},
		DEFAULT => -110
	},
	{#State 248
		ACTIONS => {
			'ASSIGN' => 225
		},
		DEFAULT => -113
	},
	{#State 249
		ACTIONS => {
			'BINOP' => 155,
			'MOD' => 158,
			'CMPOP' => 150,
			'CAT' => 156,
			"+" => 154,
			'OR' => 157,
			'AND' => 153,
			"?" => 159,
			"/" => 152,
			'DIV' => 151
		},
		DEFAULT => -153
	},
	{#State 250
		DEFAULT => -154
	},
	{#State 251
		DEFAULT => -156
	},
	{#State 252
		ACTIONS => {
			'ASSIGN' => 222,
			"(" => 171
		},
		DEFAULT => -129
	},
	{#State 253
		ACTIONS => {
			'RETURN' => 70,
			";" => -19,
			'FILTER' => 36,
			'BLOCK' => 37,
			'NOT' => 69,
			'WHILE' => 75,
			'USE' => 45,
			'SET' => 40,
			'STOP' => 74,
			'LITERAL' => 39,
			'IF' => 73,
			'TRY' => 65,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'REF' => 67,
			'THROW' => 68,
			'META' => 66,
			'LAST' => 57,
			"[" => 59,
			"\${" => 17,
			'NEXT' => 56,
			'IDENT' => 18,
			'WRAPPER' => 19,
			'TEXT' => 14,
			"(" => 13,
			'SWITCH' => 15,
			'INCLUDE' => 12,
			'UNLESS' => 26,
			'INSERT' => 24,
			'NUMBER' => 61,
			'RAW' => 22,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'perl' => 6,
			'FOR' => 5,
			"\$" => 4,
			'CLEAR' => 47,
			'CALL' => 2,
			"{" => 46,
			'GET' => 52,
			"\"" => 9,
			'VIEW' => 48,
			'rawperl' => 49
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 29,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'try' => 30,
			'node' => 7,
			'capture' => 64,
			'macro' => 63,
			'statement' => 3,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'chunk' => 10,
			'block' => 289,
			'filter' => 31,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'anonblock' => 41,
			'ident' => 23,
			'assign' => 72,
			'atomdir' => 62,
			'chunks' => 25,
			'defblock' => 44,
			'setlist' => 42,
			'directive' => 43
		}
	},
	{#State 254
		DEFAULT => -157,
		GOTOS => {
			'args' => 290
		}
	},
	{#State 255
		DEFAULT => -157,
		GOTOS => {
			'args' => 291
		}
	},
	{#State 256
		ACTIONS => {
			'END' => 292
		}
	},
	{#State 257
		DEFAULT => -101
	},
	{#State 258
		ACTIONS => {
			'TEXT' => 293
		}
	},
	{#State 259
		DEFAULT => -103
	},
	{#State 260
		DEFAULT => -168
	},
	{#State 261
		ACTIONS => {
			"\"" => 9,
			'REF' => 67,
			"{" => 46,
			"\$" => 4,
			'LITERAL' => 248,
			'NUMBER' => 61,
			'COMMA' => 251,
			'NOT' => 69,
			"(" => 13,
			'IDENT' => 18,
			"\${" => 17,
			"[" => 59
		},
		DEFAULT => -163,
		GOTOS => {
			'sterm' => 35,
			'term' => 28,
			'item' => 252,
			'node' => 7,
			'expr' => 249,
			'ident' => 247,
			'lterm' => 51,
			'param' => 250
		}
	},
	{#State 262
		DEFAULT => -166
	},
	{#State 263
		ACTIONS => {
			'IDENT' => 18,
			"\$" => 4,
			"\${" => 17,
			"[" => 59,
			'COMMA' => 251,
			'NOT' => 69,
			")" => 294,
			"{" => 46,
			"(" => 13,
			'REF' => 67,
			'LITERAL' => 248,
			"\"" => 9,
			'NUMBER' => 61
		},
		GOTOS => {
			'param' => 250,
			'ident' => 247,
			'lterm' => 51,
			'expr' => 249,
			'node' => 7,
			'item' => 252,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 264
		DEFAULT => -171
	},
	{#State 265
		ACTIONS => {
			"+" => 154,
			'MOD' => 158,
			'BINOP' => 155,
			'CAT' => 156,
			'CMPOP' => 150,
			"?" => 159,
			"/" => 152,
			'DIV' => 151,
			'OR' => 157,
			'AND' => 153
		},
		DEFAULT => -151
	},
	{#State 266
		ACTIONS => {
			'CASE' => 296
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 295
		}
	},
	{#State 267
		ACTIONS => {
			'END' => 297
		}
	},
	{#State 268
		ACTIONS => {
			'USE' => 45,
			'WHILE' => 75,
			'IF' => 73,
			'LITERAL' => 39,
			'STOP' => 74,
			'SET' => 40,
			'BLOCK' => 37,
			";" => -19,
			'FILTER' => 36,
			'RETURN' => 70,
			'NOT' => 69,
			'THROW' => 68,
			'REF' => 67,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'META' => 66,
			'TRY' => 65,
			'INSERT' => 24,
			'UNLESS' => 26,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'RAW' => 22,
			'NUMBER' => 61,
			'WRAPPER' => 19,
			'IDENT' => 18,
			'NEXT' => 56,
			"\${" => 17,
			"[" => 59,
			'LAST' => 57,
			'INCLUDE' => 12,
			'SWITCH' => 15,
			'TEXT' => 14,
			"(" => 13,
			'rawperl' => 49,
			'VIEW' => 48,
			"\"" => 9,
			'GET' => 52,
			"\$" => 4,
			'FOR' => 5,
			'perl' => 6,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47
		},
		DEFAULT => -3,
		GOTOS => {
			'atomdir' => 62,
			'defblock' => 44,
			'setlist' => 42,
			'directive' => 43,
			'chunks' => 25,
			'ident' => 23,
			'anonblock' => 41,
			'assign' => 72,
			'expr' => 58,
			'item' => 71,
			'use' => 16,
			'sterm' => 35,
			'condition' => 55,
			'view' => 11,
			'wrapper' => 53,
			'javascript' => 54,
			'chunk' => 10,
			'filter' => 31,
			'block' => 298,
			'raw' => 50,
			'lterm' => 51,
			'defblockname' => 8,
			'capture' => 64,
			'try' => 30,
			'node' => 7,
			'macro' => 63,
			'statement' => 3,
			'switch' => 29,
			'loop' => 1,
			'term' => 28,
			'atomexpr' => 27
		}
	},
	{#State 269
		ACTIONS => {
			'IDENT' => 300,
			")" => 299,
			'COMMA' => 301
		}
	},
	{#State 270
		ACTIONS => {
			'IDENT' => -97,
			'COMMA' => -97,
			")" => -97
		},
		DEFAULT => -131
	},
	{#State 271
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 272
		DEFAULT => -158
	},
	{#State 273
		ACTIONS => {
			'ELSE' => 302,
			'ELSIF' => 303
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 304
		}
	},
	{#State 274
		ACTIONS => {
			'END' => 305
		}
	},
	{#State 275
		ACTIONS => {
			'END' => 306
		}
	},
	{#State 276
		ACTIONS => {
			'END' => 307
		}
	},
	{#State 277
		ACTIONS => {
			'MOD' => 158,
			'AND' => 153,
			"?" => 159,
			"/" => 152,
			'BINOP' => 155,
			'CAT' => 156,
			'CMPOP' => 150,
			"+" => 154,
			'OR' => 157,
			'DIV' => 151
		},
		DEFAULT => -125
	},
	{#State 278
		ACTIONS => {
			'OR' => 157,
			'DIV' => 151,
			'CAT' => 156,
			'CMPOP' => 150,
			'BINOP' => 155,
			"+" => 154,
			'AND' => 153,
			"/" => 152,
			"?" => 159,
			'MOD' => 158
		},
		DEFAULT => -124
	},
	{#State 279
		ACTIONS => {
			'GET' => 52,
			"\"" => 9,
			'rawperl' => 49,
			'VIEW' => 48,
			'perl' => 6,
			'FOR' => 5,
			"\$" => 4,
			'CALL' => 2,
			'CLEAR' => 47,
			"{" => 46,
			'UNLESS' => 26,
			'INSERT' => 24,
			'NUMBER' => 61,
			'RAW' => 22,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			"[" => 59,
			'LAST' => 57,
			'IDENT' => 18,
			'WRAPPER' => 19,
			'NEXT' => 56,
			"\${" => 17,
			'SWITCH' => 15,
			'TEXT' => 14,
			"(" => 13,
			'INCLUDE' => 12,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'THROW' => 68,
			'REF' => 67,
			'META' => 66,
			'TRY' => 65,
			'USE' => 45,
			'WHILE' => 75,
			'STOP' => 74,
			'SET' => 40,
			'LITERAL' => 39,
			'IF' => 73,
			'RETURN' => 70,
			'BLOCK' => 37,
			'FILTER' => 36,
			";" => -19,
			'NOT' => 69
		},
		DEFAULT => -3,
		GOTOS => {
			'atomdir' => 62,
			'chunks' => 25,
			'defblock' => 44,
			'directive' => 43,
			'setlist' => 42,
			'ident' => 23,
			'anonblock' => 41,
			'assign' => 72,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'chunk' => 10,
			'block' => 308,
			'filter' => 31,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'macro' => 63,
			'statement' => 3,
			'switch' => 29,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1
		}
	},
	{#State 280
		ACTIONS => {
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			'REF' => 67,
			"(" => 13,
			"{" => 46,
			'NOT' => 69,
			"[" => 59,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4
		},
		GOTOS => {
			'term' => 28,
			'sterm' => 35,
			'ident' => 77,
			'lterm' => 51,
			'expr' => 309,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 281
		DEFAULT => -118
	},
	{#State 282
		ACTIONS => {
			'NUMBER' => 95,
			'DEFAULT' => 312,
			";" => 311,
			'FILENAME' => 97,
			'IDENT' => 90
		},
		GOTOS => {
			'filename' => 310,
			'filepart' => 98
		}
	},
	{#State 283
		ACTIONS => {
			";" => 313
		}
	},
	{#State 284
		ACTIONS => {
			'END' => 314
		}
	},
	{#State 285
		DEFAULT => -130
	},
	{#State 286
		ACTIONS => {
			'ELSIF' => 303,
			'ELSE' => 302
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 315
		}
	},
	{#State 287
		ACTIONS => {
			'USE' => 45,
			'WHILE' => 75,
			'LITERAL' => 39,
			'IF' => 73,
			'STOP' => 74,
			'SET' => 40,
			'BLOCK' => 37,
			'FILTER' => 36,
			";" => -19,
			'RETURN' => 70,
			'NOT' => 69,
			'THROW' => 68,
			'REF' => 67,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'META' => 66,
			'TRY' => 65,
			'INSERT' => 24,
			'UNLESS' => 26,
			'PROCESS' => 21,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'RAW' => 22,
			'NUMBER' => 61,
			'WRAPPER' => 19,
			'IDENT' => 18,
			'NEXT' => 56,
			"\${" => 17,
			"[" => 59,
			'LAST' => 57,
			'INCLUDE' => 12,
			'SWITCH' => 15,
			'TEXT' => 14,
			"(" => 13,
			'rawperl' => 49,
			'VIEW' => 48,
			"\"" => 9,
			'GET' => 52,
			"\$" => 4,
			'FOR' => 5,
			'perl' => 6,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 316,
			'filter' => 31,
			'chunk' => 10,
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50,
			'statement' => 3,
			'macro' => 63,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'switch' => 29,
			'chunks' => 25,
			'setlist' => 42,
			'directive' => 43,
			'defblock' => 44,
			'atomdir' => 62,
			'assign' => 72,
			'anonblock' => 41,
			'ident' => 23,
			'use' => 16,
			'item' => 71,
			'expr' => 58,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'condition' => 55,
			'sterm' => 35
		}
	},
	{#State 288
		ACTIONS => {
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76,
			'REF' => 67,
			"(" => 13,
			'NOT' => 69,
			"{" => 46,
			"[" => 59,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4
		},
		GOTOS => {
			'lterm' => 51,
			'ident' => 77,
			'sterm' => 35,
			'term' => 28,
			'item' => 71,
			'node' => 7,
			'expr' => 317
		}
	},
	{#State 289
		ACTIONS => {
			'END' => 318
		}
	},
	{#State 290
		ACTIONS => {
			'LITERAL' => 248,
			'NUMBER' => 61,
			"\"" => 9,
			'REF' => 67,
			'NOT' => 69,
			"{" => 46,
			'COMMA' => 251,
			"(" => 13,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4,
			"[" => 59
		},
		DEFAULT => -65,
		GOTOS => {
			'param' => 250,
			'ident' => 247,
			'lterm' => 51,
			'expr' => 249,
			'node' => 7,
			'item' => 252,
			'term' => 28,
			'sterm' => 35
		}
	},
	{#State 291
		ACTIONS => {
			'REF' => 67,
			'LITERAL' => 248,
			'NUMBER' => 61,
			"\"" => 9,
			"\${" => 17,
			'IDENT' => 18,
			"\$" => 4,
			"[" => 59,
			'NOT' => 69,
			"{" => 46,
			'COMMA' => 251,
			"(" => 13
		},
		DEFAULT => -64,
		GOTOS => {
			'sterm' => 35,
			'term' => 28,
			'node' => 7,
			'item' => 252,
			'expr' => 249,
			'lterm' => 51,
			'ident' => 247,
			'param' => 250
		}
	},
	{#State 292
		DEFAULT => -83
	},
	{#State 293
		ACTIONS => {
			"\"" => 319
		}
	},
	{#State 294
		DEFAULT => -165
	},
	{#State 295
		ACTIONS => {
			'END' => 320
		}
	},
	{#State 296
		ACTIONS => {
			"{" => 46,
			"[" => 59,
			"\${" => 17,
			";" => 322,
			'IDENT' => 18,
			"\$" => 4,
			'NUMBER' => 61,
			"\"" => 9,
			'DEFAULT' => 321,
			'LITERAL' => 76,
			'REF' => 67
		},
		GOTOS => {
			'term' => 323,
			'lterm' => 51,
			'ident' => 77,
			'sterm' => 35,
			'item' => 71,
			'node' => 7
		}
	},
	{#State 297
		DEFAULT => -67
	},
	{#State 298
		ACTIONS => {
			'END' => 324
		}
	},
	{#State 299
		ACTIONS => {
			'LAST' => 57,
			"[" => 59,
			'NEXT' => 56,
			"\${" => 17,
			'WRAPPER' => 19,
			'IDENT' => 18,
			"(" => 13,
			'SWITCH' => 15,
			'INCLUDE' => 12,
			'UNLESS' => 26,
			'INSERT' => 24,
			'NUMBER' => 61,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'perl' => 6,
			"\$" => 4,
			'FOR' => 5,
			'CLEAR' => 47,
			'CALL' => 2,
			"{" => 46,
			"\"" => 9,
			'GET' => 52,
			'RETURN' => 70,
			'FILTER' => 36,
			'BLOCK' => 200,
			'NOT' => 69,
			'WHILE' => 75,
			'SET' => 40,
			'STOP' => 74,
			'IF' => 73,
			'LITERAL' => 39,
			'TRY' => 65,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'REF' => 67,
			'THROW' => 68
		},
		GOTOS => {
			'item' => 71,
			'expr' => 199,
			'javascript' => 54,
			'wrapper' => 53,
			'condition' => 55,
			'sterm' => 35,
			'setlist' => 42,
			'directive' => 201,
			'atomdir' => 62,
			'assign' => 72,
			'ident' => 100,
			'try' => 30,
			'node' => 7,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'switch' => 29,
			'mdir' => 325,
			'filter' => 31,
			'lterm' => 51
		}
	},
	{#State 300
		DEFAULT => -95
	},
	{#State 301
		DEFAULT => -96
	},
	{#State 302
		ACTIONS => {
			";" => 326
		}
	},
	{#State 303
		ACTIONS => {
			"[" => 59,
			"\${" => 17,
			"\$" => 4,
			'IDENT' => 18,
			"(" => 13,
			'NOT' => 69,
			"{" => 46,
			'REF' => 67,
			'NUMBER' => 61,
			"\"" => 9,
			'LITERAL' => 76
		},
		GOTOS => {
			'node' => 7,
			'item' => 71,
			'expr' => 327,
			'ident' => 77,
			'lterm' => 51,
			'sterm' => 35,
			'term' => 28
		}
	},
	{#State 304
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 305
		DEFAULT => -80
	},
	{#State 306
		DEFAULT => -81
	},
	{#State 307
		DEFAULT => -89
	},
	{#State 308
		ACTIONS => {
			'END' => 329
		}
	},
	{#State 309
		ACTIONS => {
			'OR' => 157,
			'DIV' => 151,
			'BINOP' => 155,
			'CMPOP' => 150,
			'CAT' => 156,
			"+" => 154,
			'AND' => 153,
			"?" => 159,
			"/" => 152,
			'MOD' => 158
		},
		DEFAULT => -144
	},
	{#State 310
		ACTIONS => {
			'DOT' => 192,
			";" => 330
		}
	},
	{#State 311
		ACTIONS => {
			'VIEW' => 48,
			'rawperl' => 49,
			'GET' => 52,
			"\"" => 9,
			"\$" => 4,
			'FOR' => 5,
			'perl' => 6,
			"{" => 46,
			'CLEAR' => 47,
			'CALL' => 2,
			'INSERT' => 24,
			'UNLESS' => 26,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'NUMBER' => 61,
			'RAW' => 22,
			'NEXT' => 56,
			"\${" => 17,
			'IDENT' => 18,
			'WRAPPER' => 19,
			'LAST' => 57,
			"[" => 59,
			'INCLUDE' => 12,
			"(" => 13,
			'TEXT' => 14,
			'SWITCH' => 15,
			'REF' => 67,
			'THROW' => 68,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'META' => 66,
			'TRY' => 65,
			'WHILE' => 75,
			'USE' => 45,
			'IF' => 73,
			'LITERAL' => 39,
			'SET' => 40,
			'STOP' => 74,
			'FILTER' => 36,
			";" => -19,
			'BLOCK' => 37,
			'RETURN' => 70,
			'NOT' => 69
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 331,
			'filter' => 31,
			'chunk' => 10,
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50,
			'macro' => 63,
			'statement' => 3,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'switch' => 29,
			'chunks' => 25,
			'setlist' => 42,
			'directive' => 43,
			'defblock' => 44,
			'atomdir' => 62,
			'assign' => 72,
			'anonblock' => 41,
			'ident' => 23,
			'use' => 16,
			'item' => 71,
			'expr' => 58,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'condition' => 55,
			'sterm' => 35
		}
	},
	{#State 312
		ACTIONS => {
			";" => 332
		}
	},
	{#State 313
		ACTIONS => {
			'WHILE' => 75,
			'USE' => 45,
			'LITERAL' => 39,
			'IF' => 73,
			'SET' => 40,
			'STOP' => 74,
			'FILTER' => 36,
			";" => -19,
			'BLOCK' => 37,
			'RETURN' => 70,
			'NOT' => 69,
			'REF' => 67,
			'THROW' => 68,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'META' => 66,
			'TRY' => 65,
			'INSERT' => 24,
			'UNLESS' => 26,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'NUMBER' => 61,
			'RAW' => 22,
			"\${" => 17,
			'NEXT' => 56,
			'IDENT' => 18,
			'WRAPPER' => 19,
			'LAST' => 57,
			"[" => 59,
			'INCLUDE' => 12,
			"(" => 13,
			'TEXT' => 14,
			'SWITCH' => 15,
			'VIEW' => 48,
			'rawperl' => 49,
			'GET' => 52,
			"\"" => 9,
			'FOR' => 5,
			"\$" => 4,
			'perl' => 6,
			"{" => 46,
			'CLEAR' => 47,
			'CALL' => 2
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 29,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'try' => 30,
			'node' => 7,
			'capture' => 64,
			'statement' => 3,
			'macro' => 63,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'chunk' => 10,
			'block' => 333,
			'filter' => 31,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'wrapper' => 53,
			'view' => 11,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'ident' => 23,
			'anonblock' => 41,
			'assign' => 72,
			'atomdir' => 62,
			'chunks' => 25,
			'defblock' => 44,
			'setlist' => 42,
			'directive' => 43
		}
	},
	{#State 314
		DEFAULT => -69
	},
	{#State 315
		ACTIONS => {
			'END' => 334
		}
	},
	{#State 316
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 317
		ACTIONS => {
			"?" => 159,
			'DIV' => 151,
			"/" => 152,
			'OR' => 157,
			'AND' => 153,
			"+" => 154,
			'BINOP' => 155,
			'MOD' => 158,
			'CMPOP' => 150,
			'CAT' => 156
		},
		DEFAULT => -155
	},
	{#State 318
		DEFAULT => -59
	},
	{#State 319
		DEFAULT => -102
	},
	{#State 320
		DEFAULT => -53
	},
	{#State 321
		ACTIONS => {
			";" => 336
		}
	},
	{#State 322
		ACTIONS => {
			"\"" => 9,
			'GET' => 52,
			'rawperl' => 49,
			'VIEW' => 48,
			'CALL' => 2,
			'CLEAR' => 47,
			"{" => 46,
			'perl' => 6,
			"\$" => 4,
			'FOR' => 5,
			'NUMBER' => 61,
			'RAW' => 22,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'UNLESS' => 26,
			'INSERT' => 24,
			'SWITCH' => 15,
			'TEXT' => 14,
			"(" => 13,
			'INCLUDE' => 12,
			"[" => 59,
			'LAST' => 57,
			'WRAPPER' => 19,
			'IDENT' => 18,
			"\${" => 17,
			'NEXT' => 56,
			'META' => 66,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'THROW' => 68,
			'REF' => 67,
			'TRY' => 65,
			'STOP' => 74,
			'SET' => 40,
			'LITERAL' => 39,
			'IF' => 73,
			'USE' => 45,
			'WHILE' => 75,
			'NOT' => 69,
			'RETURN' => 70,
			'BLOCK' => 37,
			";" => -19,
			'FILTER' => 36
		},
		DEFAULT => -3,
		GOTOS => {
			'raw' => 50,
			'lterm' => 51,
			'defblockname' => 8,
			'chunk' => 10,
			'filter' => 31,
			'block' => 337,
			'switch' => 29,
			'loop' => 1,
			'term' => 28,
			'atomexpr' => 27,
			'capture' => 64,
			'try' => 30,
			'node' => 7,
			'macro' => 63,
			'statement' => 3,
			'anonblock' => 41,
			'ident' => 23,
			'assign' => 72,
			'atomdir' => 62,
			'setlist' => 42,
			'defblock' => 44,
			'directive' => 43,
			'chunks' => 25,
			'sterm' => 35,
			'condition' => 55,
			'wrapper' => 53,
			'view' => 11,
			'javascript' => 54,
			'expr' => 58,
			'item' => 71,
			'use' => 16
		}
	},
	{#State 323
		ACTIONS => {
			";" => 338
		}
	},
	{#State 324
		DEFAULT => -94
	},
	{#State 325
		DEFAULT => -91
	},
	{#State 326
		ACTIONS => {
			'perl' => 6,
			'FOR' => 5,
			"\$" => 4,
			'CLEAR' => 47,
			'CALL' => 2,
			"{" => 46,
			"\"" => 9,
			'GET' => 52,
			'VIEW' => 48,
			'rawperl' => 49,
			'LAST' => 57,
			"[" => 59,
			"\${" => 17,
			'NEXT' => 56,
			'WRAPPER' => 19,
			'IDENT' => 18,
			"(" => 13,
			'TEXT' => 14,
			'SWITCH' => 15,
			'INCLUDE' => 12,
			'UNLESS' => 26,
			'INSERT' => 24,
			'RAW' => 22,
			'NUMBER' => 61,
			'MACRO' => 20,
			'DEFAULT' => 60,
			'PROCESS' => 21,
			'TRY' => 65,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'REF' => 67,
			'THROW' => 68,
			'META' => 66,
			'RETURN' => 70,
			'FILTER' => 36,
			";" => -19,
			'BLOCK' => 37,
			'NOT' => 69,
			'WHILE' => 75,
			'USE' => 45,
			'SET' => 40,
			'STOP' => 74,
			'IF' => 73,
			'LITERAL' => 39
		},
		DEFAULT => -3,
		GOTOS => {
			'assign' => 72,
			'ident' => 23,
			'anonblock' => 41,
			'chunks' => 25,
			'defblock' => 44,
			'directive' => 43,
			'setlist' => 42,
			'atomdir' => 62,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'condition' => 55,
			'sterm' => 35,
			'use' => 16,
			'item' => 71,
			'expr' => 58,
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50,
			'block' => 339,
			'filter' => 31,
			'chunk' => 10,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'switch' => 29,
			'statement' => 3,
			'macro' => 63,
			'node' => 7,
			'try' => 30,
			'capture' => 64
		}
	},
	{#State 327
		ACTIONS => {
			"/" => 152,
			'DIV' => 151,
			"+" => 154,
			";" => 340,
			"?" => 159,
			'CAT' => 156,
			'CMPOP' => 150,
			'AND' => 153,
			'MOD' => 158,
			'BINOP' => 155,
			'OR' => 157
		}
	},
	{#State 328
		DEFAULT => -48
	},
	{#State 329
		DEFAULT => -78
	},
	{#State 330
		ACTIONS => {
			'RETURN' => 70,
			'FILTER' => 36,
			";" => -19,
			'BLOCK' => 37,
			'NOT' => 69,
			'WHILE' => 75,
			'USE' => 45,
			'SET' => 40,
			'STOP' => 74,
			'IF' => 73,
			'LITERAL' => 39,
			'TRY' => 65,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'REF' => 67,
			'THROW' => 68,
			'META' => 66,
			'LAST' => 57,
			"[" => 59,
			"\${" => 17,
			'NEXT' => 56,
			'WRAPPER' => 19,
			'IDENT' => 18,
			'TEXT' => 14,
			"(" => 13,
			'SWITCH' => 15,
			'INCLUDE' => 12,
			'UNLESS' => 26,
			'INSERT' => 24,
			'RAW' => 22,
			'NUMBER' => 61,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'PROCESS' => 21,
			'perl' => 6,
			"\$" => 4,
			'FOR' => 5,
			'CLEAR' => 47,
			'CALL' => 2,
			"{" => 46,
			'GET' => 52,
			"\"" => 9,
			'VIEW' => 48,
			'rawperl' => 49
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 10,
			'block' => 341,
			'filter' => 31,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'statement' => 3,
			'macro' => 63,
			'switch' => 29,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'atomdir' => 62,
			'chunks' => 25,
			'directive' => 43,
			'defblock' => 44,
			'setlist' => 42,
			'anonblock' => 41,
			'ident' => 23,
			'assign' => 72,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53
		}
	},
	{#State 331
		ACTIONS => {
			'FINAL' => 283,
			'CATCH' => 282
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 342
		}
	},
	{#State 332
		ACTIONS => {
			'BLOCK' => 37,
			";" => -19,
			'FILTER' => 36,
			'RETURN' => 70,
			'NOT' => 69,
			'USE' => 45,
			'WHILE' => 75,
			'LITERAL' => 39,
			'IF' => 73,
			'STOP' => 74,
			'SET' => 40,
			'TRY' => 65,
			'THROW' => 68,
			'REF' => 67,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'META' => 66,
			'IDENT' => 18,
			'WRAPPER' => 19,
			'NEXT' => 56,
			"\${" => 17,
			"[" => 59,
			'LAST' => 57,
			'INCLUDE' => 12,
			'SWITCH' => 15,
			'TEXT' => 14,
			"(" => 13,
			'INSERT' => 24,
			'UNLESS' => 26,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'RAW' => 22,
			'NUMBER' => 61,
			'FOR' => 5,
			"\$" => 4,
			'perl' => 6,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47,
			'rawperl' => 49,
			'VIEW' => 48,
			"\"" => 9,
			'GET' => 52
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 343,
			'filter' => 31,
			'chunk' => 10,
			'defblockname' => 8,
			'lterm' => 51,
			'raw' => 50,
			'macro' => 63,
			'statement' => 3,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'term' => 28,
			'atomexpr' => 27,
			'loop' => 1,
			'switch' => 29,
			'chunks' => 25,
			'setlist' => 42,
			'defblock' => 44,
			'directive' => 43,
			'atomdir' => 62,
			'assign' => 72,
			'anonblock' => 41,
			'ident' => 23,
			'use' => 16,
			'item' => 71,
			'expr' => 58,
			'javascript' => 54,
			'wrapper' => 53,
			'view' => 11,
			'condition' => 55,
			'sterm' => 35
		}
	},
	{#State 333
		DEFAULT => -73
	},
	{#State 334
		DEFAULT => -46
	},
	{#State 335
		DEFAULT => -62
	},
	{#State 336
		ACTIONS => {
			'NOT' => 69,
			";" => -19,
			'FILTER' => 36,
			'BLOCK' => 37,
			'RETURN' => 70,
			'IF' => 73,
			'LITERAL' => 39,
			'SET' => 40,
			'STOP' => 74,
			'WHILE' => 75,
			'USE' => 45,
			'TRY' => 65,
			'META' => 66,
			'REF' => 67,
			'THROW' => 68,
			'DEBUG' => 34,
			'JAVASCRIPT' => 33,
			'INCLUDE' => 12,
			"(" => 13,
			'TEXT' => 14,
			'SWITCH' => 15,
			"\${" => 17,
			'NEXT' => 56,
			'IDENT' => 18,
			'WRAPPER' => 19,
			'LAST' => 57,
			"[" => 59,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'PROCESS' => 21,
			'NUMBER' => 61,
			'RAW' => 22,
			'INSERT' => 24,
			'UNLESS' => 26,
			"{" => 46,
			'CLEAR' => 47,
			'CALL' => 2,
			'FOR' => 5,
			"\$" => 4,
			'perl' => 6,
			'VIEW' => 48,
			'rawperl' => 49,
			'GET' => 52,
			"\"" => 9
		},
		DEFAULT => -3,
		GOTOS => {
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'chunk' => 10,
			'block' => 344,
			'filter' => 31,
			'switch' => 29,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'macro' => 63,
			'statement' => 3,
			'anonblock' => 41,
			'ident' => 23,
			'assign' => 72,
			'atomdir' => 62,
			'chunks' => 25,
			'setlist' => 42,
			'directive' => 43,
			'defblock' => 44,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'wrapper' => 53,
			'view' => 11,
			'item' => 71,
			'expr' => 58,
			'use' => 16
		}
	},
	{#State 337
		DEFAULT => -56
	},
	{#State 338
		ACTIONS => {
			'FOR' => 5,
			"\$" => 4,
			'perl' => 6,
			"{" => 46,
			'CALL' => 2,
			'CLEAR' => 47,
			'rawperl' => 49,
			'VIEW' => 48,
			"\"" => 9,
			'GET' => 52,
			'WRAPPER' => 19,
			'IDENT' => 18,
			'NEXT' => 56,
			"\${" => 17,
			"[" => 59,
			'LAST' => 57,
			'INCLUDE' => 12,
			'SWITCH' => 15,
			"(" => 13,
			'TEXT' => 14,
			'INSERT' => 24,
			'UNLESS' => 26,
			'PROCESS' => 21,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'RAW' => 22,
			'NUMBER' => 61,
			'TRY' => 65,
			'THROW' => 68,
			'REF' => 67,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'META' => 66,
			'BLOCK' => 37,
			'FILTER' => 36,
			";" => -19,
			'RETURN' => 70,
			'NOT' => 69,
			'USE' => 45,
			'WHILE' => 75,
			'LITERAL' => 39,
			'IF' => 73,
			'STOP' => 74,
			'SET' => 40
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 10,
			'block' => 345,
			'filter' => 31,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'macro' => 63,
			'statement' => 3,
			'switch' => 29,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'atomdir' => 62,
			'chunks' => 25,
			'directive' => 43,
			'defblock' => 44,
			'setlist' => 42,
			'anonblock' => 41,
			'ident' => 23,
			'assign' => 72,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'wrapper' => 53,
			'view' => 11
		}
	},
	{#State 339
		DEFAULT => -51
	},
	{#State 340
		ACTIONS => {
			'LAST' => 57,
			"[" => 59,
			'NEXT' => 56,
			"\${" => 17,
			'IDENT' => 18,
			'WRAPPER' => 19,
			"(" => 13,
			'TEXT' => 14,
			'SWITCH' => 15,
			'INCLUDE' => 12,
			'UNLESS' => 26,
			'INSERT' => 24,
			'RAW' => 22,
			'NUMBER' => 61,
			'DEFAULT' => 60,
			'MACRO' => 20,
			'PROCESS' => 21,
			'perl' => 6,
			'FOR' => 5,
			"\$" => 4,
			'CLEAR' => 47,
			'CALL' => 2,
			"{" => 46,
			'GET' => 52,
			"\"" => 9,
			'VIEW' => 48,
			'rawperl' => 49,
			'RETURN' => 70,
			";" => -19,
			'FILTER' => 36,
			'BLOCK' => 37,
			'NOT' => 69,
			'WHILE' => 75,
			'USE' => 45,
			'SET' => 40,
			'STOP' => 74,
			'IF' => 73,
			'LITERAL' => 39,
			'TRY' => 65,
			'JAVASCRIPT' => 33,
			'DEBUG' => 34,
			'REF' => 67,
			'THROW' => 68,
			'META' => 66
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 29,
			'atomexpr' => 27,
			'term' => 28,
			'loop' => 1,
			'node' => 7,
			'try' => 30,
			'capture' => 64,
			'macro' => 63,
			'statement' => 3,
			'lterm' => 51,
			'raw' => 50,
			'defblockname' => 8,
			'chunk' => 10,
			'block' => 346,
			'filter' => 31,
			'condition' => 55,
			'sterm' => 35,
			'javascript' => 54,
			'view' => 11,
			'wrapper' => 53,
			'item' => 71,
			'expr' => 58,
			'use' => 16,
			'anonblock' => 41,
			'ident' => 23,
			'assign' => 72,
			'atomdir' => 62,
			'chunks' => 25,
			'directive' => 43,
			'setlist' => 42,
			'defblock' => 44
		}
	},
	{#State 341
		ACTIONS => {
			'CATCH' => 282,
			'FINAL' => 283
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 347
		}
	},
	{#State 342
		DEFAULT => -72
	},
	{#State 343
		ACTIONS => {
			'CATCH' => 282,
			'FINAL' => 283
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 348
		}
	},
	{#State 344
		DEFAULT => -55
	},
	{#State 345
		ACTIONS => {
			'CASE' => 296
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 349
		}
	},
	{#State 346
		ACTIONS => {
			'ELSIF' => 303,
			'ELSE' => 302
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 350
		}
	},
	{#State 347
		DEFAULT => -70
	},
	{#State 348
		DEFAULT => -71
	},
	{#State 349
		DEFAULT => -54
	},
	{#State 350
		DEFAULT => -50
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("tt2_not($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("tt2_not($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "{ }"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "math_floor($_[1] / $_[3])"         }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] .. $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "tt2_true($_[1]) and tt2_true($_[3])"                   }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "tt2_true($_[1]) or tt2_true($_[3])"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "tt2_not($_[2])"                         }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "tt2_true($_[1]) and $_[3] or $_[5]"          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
