package Git::Glog;

use 5.008;
use strict;
use warnings;

=head1 NAME

Git::Glog - Spicey git-log with a hint of gravatars, nutmeg and cinnamon

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';


=head1 SYNOPSIS

Git::Glog contains the script L<git-glog>, which is where all the action
happens.  Go check it out.

=head1 AUTHOR

Colin Kennedy, C<< <moshen at cpan.org> >>

=head1 BUGS

Please report any bugs directly to me, or through the web interface 
at L<https://github.com/moshen/Git-Glog/issues>.  
I will be notified, and then you'll automatically be notified of progress 
on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Git::Glog
    perldoc git-glog


You can also look for information at:

=over 4

=item * Git-Glog on GitHub (report bugs here)

L<https://github.com/moshen/Git-Glog>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Git-Glog>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Git-Glog>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Git-Glog>

=item * Search CPAN

L<http://search.cpan.org/dist/Git-Glog/>

=back


=head1 ACKNOWLEDGEMENTS

L<Git!|http://git-scm.com/>

=head1 LICENSE AND COPYRIGHT

Copyright 2011 Colin Kennedy

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.


=cut

1; # End of Git::Glog
