/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalParameterSet {
    private HashMap<StructuredQName, Sequence> params = new HashMap(10);

    public GlobalParameterSet() {
    }

    public GlobalParameterSet(GlobalParameterSet parameterSet) {
        this.params = new HashMap<StructuredQName, Sequence>(parameterSet.params);
    }

    public void put(StructuredQName qName, Sequence value) {
        if (value == null) {
            this.params.remove(qName);
        } else {
            this.params.put(qName, value);
        }
    }

    public Sequence get(StructuredQName qName) {
        return this.params.get(qName);
    }

    public boolean containsKey(StructuredQName qName) {
        return this.params.containsKey(qName);
    }

    public Sequence convertParameterValue(StructuredQName qName, SequenceType requiredType, boolean convert, XPathContext context) throws XPathException {
        Sequence val = this.get(qName);
        if (val == null) {
            return null;
        }
        if (requiredType != null) {
            if (convert) {
                RoleDiagnostic role = new RoleDiagnostic(3, qName.getDisplayName(), -1);
                Configuration config = context.getConfiguration();
                val = config.getTypeHierarchy().applyFunctionConversionRules(val, requiredType, role, ExplicitLocation.UNKNOWN_LOCATION);
            } else {
                XPathException err = TypeChecker.testConformance(val, requiredType, context);
                if (err != null) {
                    throw err;
                }
            }
        }
        return val;
    }

    public void clear() {
        this.params.clear();
    }

    public Collection<StructuredQName> getKeys() {
        return this.params.keySet();
    }

    public int getNumberOfKeys() {
        return this.params.size();
    }
}

