package PDLx::Bin1D::Utils;

use strict;
use warnings;

use Exporter 'import';

our $VERSION = '0.23'; # TRIAL

our @EXPORT = qw[ _bitflags _flags ];

sub _bitflags {
    my $bit = 1;
    return shift(), 1,
      map { $bit <<= 1; $_ => $bit; } @_;
}

sub _flags {
    my $bits = shift;
    croak( "unknown flag: $_ " ) for grep { ! defined $bits->{$_} } @_;
    my $mask;
    $mask |= $_ for @{$bits}{@_};
    return $mask
}

1;

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory

=head1 NAME

PDLx::Bin1D::Utils

=head1 VERSION

version 0.23

=head1 PDLx::Bin1D::Utils - internal routines for PDLx::Bin1D

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

=head1 AUTHOR

Diab Jerius, E<lt>djerius@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2014 Smithsonian Astrophysical Observatory

This software is released under the GNU General Public License.  You
may find a copy at

          http://www.gnu.org/licenses

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-pdlx-bin1d@rt.cpan.org  or through the web interface at: https://rt.cpan.org/Public/Dist/Display.html?Name=PDLx-Bin1D

=head2 Source

Source is available at

  https://gitlab.com/djerius/pdlx-bin1d

and may be cloned from

  https://gitlab.com/djerius/pdlx-bin1d.git

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<PDLx::Bin1D.pd|PDLx::Bin1D.pd>

=back

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2021 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
