package Biblio::ILL::ISO::SupplyMediumType;

=head1 NAME

Biblio::ILL::ISO::SupplyMediumType

=cut

use Biblio::ILL::ISO::ILLASNtype;
use Biblio::ILL::ISO::ENUMERATED;

use Carp;

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';
#---------------------------------------------------------------------------
# Mods
# 0.01 - 2003.07.15 - original version
#---------------------------------------------------------------------------

=head1 DESCRIPTION

Biblio::ILL::ISO::SupplyMediumType is a derivation of Biblio::ILL::ISO::ENUMERATED.

=head1 USES

 None.

=head1 USED IN

 Biblio::ILL::ISO::SupplyDetails

=cut

BEGIN{@ISA = qw ( Biblio::ILL::ISO::ENUMERATED 
		  Biblio::ILL::ISO::ILLASNtype );}   # inherit from ILLASNtype

=head1 FROM THE ASN DEFINITION
 
 Yes, it *is* different than MediumType... it includes 'photocopy'.
 
 Supply-Medium-Type ::= ENUMERATED {
	printed	(1),
	photocopy	(2),
	microform	(3),
	film-or-video-recording	(4),
	audio-recording	(5),
	machine-readable	(6),
	other	(7)
	}

=cut

=head1 METHODS

=cut


#---------------------------------------------------------------
#
#---------------------------------------------------------------
=head1

=head2 new( $s )

 Creates a new SupplyMediumType object. 
 Valid paramaters are listed in the FROM THE ASN DEFINITION section
 (e.g. "printed").

=cut
sub new {
    my $class = shift;
    my $self = {};

    $self->{"ENUM_LIST"} = {"printed" => 1,
			    "photocopy" => 2,
			    "microform" => 3,
			    "film-or-video-recording" => 4,
			    "audio-recording" => 5,
			    "machine-readable" => 6,
			    "other" => 7
			    };

    if (@_) {
	my $s = shift;
	
	if ( exists $self->{"ENUM_LIST"}->{$s} ) {
	    $self->{"ENUMERATED"} = $self->{"ENUM_LIST"}->{$s};
	} else {
	    croak "invalid SupplyMediumListType: [$s]";
	}
    }

    bless($self, ref($class) || $class);
    return ($self);
}

=head1 SEE ALSO

See the README for system design notes.
See the parent class(es) for other available methods.

For more information on Interlibrary Loan standards (ISO 10160/10161),
a good place to start is:

http://www.nlc-bnc.ca/iso/ill/main.htm

=cut

=head1 AUTHOR

David Christensen, <DChristensenSPAMLESS@westman.wave.ca>

=cut


=head1 COPYRIGHT AND LICENSE

Copyright 2003 by David Christensen

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1;
