# DESCRIPTION

Query the KvK API via their OpenAPI definition.

# SYNOPSIS

    use WebService::KvKAPI;
    my $api = WebService::KvKAPI->new(
        api_key => 'foobar',
        # optional
        api_host => 'foo.bar', # send the request to a different host
        spoof => 1, # enable spoof mode, uses the test api of the KvK

    );

    $api->search(%args);
    $api->get_location_profile($location_number);
    $api->get_basic_profile($kvk_number);
    $api->get_owner($kvk_number);
    $api->get_main_location($kvk_number);
    $api->get_locations($kvk_number);

# ATTRIBUTES

## api\_key

The KvK API key. You can request one at [https://developers.kvk.nl/](https://developers.kvk.nl/).

## client

An [OpenAPI::Client](https://metacpan.org/pod/OpenAPI%3A%3AClient) object. Build for you.

## api\_host

Optional API host to allow overriding the default host `api.kvk.nl`.

# METHODS

## has\_api\_host

Check if you have an API host set or if you use the default. Publicly available
for those who need it.

## profile

Retreive detailed information of one company. Dies when the company cannot be
found. Make sure to call ["search" in WebService::KvKAPI](https://metacpan.org/pod/WebService%3A%3AKvKAPI#search) first in case you don't
want to die.

## search

Search the KVK, only retrieves the first 10 entries.

    my $results = $self->search(kvkNumber => 12345678, ...);
    foreach (@$results) {
        ...;
    }

# SSL certificates

The KvK now uses private root certificates, please be aware of this, see also:

    L<https://developers.kvk.nl/guides>.

# SEE ALSO

The KvK also has test endpoints. While they are supported via the direct
`api_call` method, you can instantiate a model that works only in
spoofmode: [WebService::KvKAPI::Spoof](https://metacpan.org/pod/WebService%3A%3AKvKAPI%3A%3ASpoof)
