/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.FailedResource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.MappingJavaIterator;
import net.sf.saxon.tree.util.Navigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogCollection
extends AbstractResourceCollection {
    private boolean stable;
    private SpaceStrippingRule whitespaceRules;

    public CatalogCollection(Configuration config, String collectionURI) {
        super(config);
        this.collectionURI = collectionURI;
    }

    @Override
    public Iterator<String> getResourceURIs(XPathContext context) throws XPathException {
        if (this.collectionURI == null) {
            XPathException err = new XPathException("No default collection has been defined");
            err.setErrorCode("FODC0002");
            err.setXPathContext(context);
            throw err;
        }
        return this.catalogContents(this.collectionURI, context);
    }

    public Iterator<Resource> getResources(final XPathContext context) throws XPathException {
        if (this.collectionURI == null) {
            XPathException err = new XPathException("No default collection has been defined");
            err.setErrorCode("FODC0002");
            err.setXPathContext(context);
            throw err;
        }
        Iterator<String> resourceURIs = this.getResourceURIs(context);
        return new MappingJavaIterator<String, Resource>(resourceURIs, new MappingJavaIterator.Mapper<String, Resource>(){

            @Override
            public Resource map(String in) {
                try {
                    AbstractResourceCollection.InputDetails id = CatalogCollection.this.getInputDetails(in);
                    id.parseOptions = new ParseOptions(context.getConfiguration().getParseOptions());
                    id.parseOptions.setSpaceStrippingRule(CatalogCollection.this.whitespaceRules);
                    return CatalogCollection.this.makeResource(context.getConfiguration(), id, in);
                }
                catch (XPathException e) {
                    int onError = CatalogCollection.this.params.getOnError();
                    if (onError == 1) {
                        return new FailedResource(in, e);
                    }
                    if (onError == 2) {
                        context.getController().warning("collection(): failed to parse " + in + ": " + e.getMessage(), e.getErrorCodeLocalPart(), null);
                        return null;
                    }
                    return null;
                }
            }
        });
    }

    @Override
    public boolean isStable(XPathContext context) {
        return this.stable;
    }

    public static StringBuilder makeStringBuilderFromStream(InputStream in, String encoding) throws IOException {
        InputStreamReader is = new InputStreamReader(in, Charset.forName(encoding));
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(is);
        String read = br.readLine();
        while (read != null) {
            sb.append(read);
            read = br.readLine();
        }
        br.close();
        return sb;
    }

    protected Iterator<String> catalogContents(String href, XPathContext context) throws XPathException {
        NodeInfo item;
        Source source = DocumentFn.resolveURI(href, null, null, context);
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(4);
        TreeInfo catalog = context.getConfiguration().buildDocumentTree(source, options);
        if (catalog == null) {
            XPathException err = new XPathException("Failed to load collection catalog " + href);
            err.setErrorCode("FODC0004");
            err.setXPathContext(context);
            throw err;
        }
        AxisIterator iter = catalog.getRootNode().iterateAxis((byte)3, NodeKindTest.ELEMENT);
        NodeInfo top = iter.next();
        if (top == null || !"collection".equals(top.getLocalPart()) || !top.getURI().isEmpty()) {
            String message = top == null ? "No outermost element found in collection catalog" : "Outermost element of collection catalog should be Q{}catalog (found Q{" + top.getURI() + "}" + top.getLocalPart() + ")";
            XPathException err = new XPathException(message);
            err.setErrorCode("FODC0004");
            err.setXPathContext(context);
            throw err;
        }
        iter.close();
        String stableAtt = top.getAttributeValue("", "stable");
        if (stableAtt != null) {
            if ("true".equals(stableAtt)) {
                this.stable = true;
            } else if ("false".equals(stableAtt)) {
                this.stable = false;
            } else {
                XPathException err = new XPathException("The 'stable' attribute of element <collection> must be true or false");
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
        }
        AxisIterator documents = top.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        ArrayList<String> result = new ArrayList<String>();
        while ((item = documents.next()) != null) {
            String uri;
            if (!"doc".equals(item.getLocalPart()) || !item.getURI().isEmpty()) {
                XPathException err = new XPathException("children of <collection> element must be <doc> elements");
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
            String hrefAtt = Navigator.getAttributeValue(item, "", "href");
            if (hrefAtt == null) {
                XPathException err = new XPathException("\"<doc> element in catalog has no @href attribute\"");
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
            try {
                uri = new URI(item.getBaseURI()).resolve(hrefAtt).toString();
            }
            catch (URISyntaxException e) {
                XPathException err = new XPathException("Invalid base URI or href URI in collection catalog: (" + item.getBaseURI() + ", " + hrefAtt + ")");
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
            result.add(uri);
        }
        return result.iterator();
    }
}

