use strict;
use warnings;
package Rubric;
# ABSTRACT: a notes and bookmarks manager with tagging
$Rubric::VERSION = '0.155';
# =head1 DESCRIPTION
#
# This module is currently just a placeholder and a container for documentation.
# You don't want to actually C<use Rubric>, even if you want to use Rubric.
#
# Rubric is a note-keeping system that also serves as a bookmark manager.  Users
# store entries, which are small (or large) notes with a set of categorizing
# "tags."  Entries may also refer to URIs.
#
# Rubric was inspired by the excellent L<http://del.icio.us/> service and the
# Notational Velocity note-taking software for Mac OS.
#
# =head1 WARNING
#
# This is young software, likely to have bugs and likely to change in strange
# ways.  I will try to keep the documented API stable, but not if it makes
# writing Rubric too inconvenient.
#
# Basically, just take note that this software works, but it's still very much
# under construction.
#
# =head1 INSTALLING AND UPGRADING
#
# Consult the README file in this distribution for instructions on installation
# and upgrades.
#
# =head1 TODO
#
# For now, consult the C<todo.html> template for future milestones, or check
# L<http://rjbs.manxome.org/rubric/docs/todo>.
#
# =head1 THANKS
#
# ...to a lot of people whom I will try to name, in time.  Among these helpful
# people are Ian Langworth, Shawn Sorichetti, John Cappiello, and Dave O'Neill.
#
# =head1 SEE ALSO
#
# =for :list
# * L<http://del.icio.us/>
# one of my original inspirations
# * L<http://notational.net/>
# Notational Velocity, another of my inspirations
# * L<http://unalog.com/>
# a social bookmarks system, written in Python
#
# =cut

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Rubric - a notes and bookmarks manager with tagging

=head1 VERSION

version 0.155

=head1 DESCRIPTION

This module is currently just a placeholder and a container for documentation.
You don't want to actually C<use Rubric>, even if you want to use Rubric.

Rubric is a note-keeping system that also serves as a bookmark manager.  Users
store entries, which are small (or large) notes with a set of categorizing
"tags."  Entries may also refer to URIs.

Rubric was inspired by the excellent L<http://del.icio.us/> service and the
Notational Velocity note-taking software for Mac OS.

=head1 WARNING

This is young software, likely to have bugs and likely to change in strange
ways.  I will try to keep the documented API stable, but not if it makes
writing Rubric too inconvenient.

Basically, just take note that this software works, but it's still very much
under construction.

=head1 INSTALLING AND UPGRADING

Consult the README file in this distribution for instructions on installation
and upgrades.

=head1 TODO

For now, consult the C<todo.html> template for future milestones, or check
L<http://rjbs.manxome.org/rubric/docs/todo>.

=head1 THANKS

...to a lot of people whom I will try to name, in time.  Among these helpful
people are Ian Langworth, Shawn Sorichetti, John Cappiello, and Dave O'Neill.

=head1 SEE ALSO

=over 4

=item *

L<http://del.icio.us/>

one of my original inspirations

=item *

L<http://notational.net/>

Notational Velocity, another of my inspirations

=item *

L<http://unalog.com/>

a social bookmarks system, written in Python

=back

=head1 AUTHOR

Ricardo SIGNES <rjbs@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2004 by Ricardo SIGNES.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
