#-*- perl -*-
#-*- coding: utf-8 -*-

use strict;
use warnings;
no utf8;
use Test::More tests => (14 * 2);

use Encode qw(encode_utf8);
use Unicode::BiDiRule qw(check BIDIRULE_LTR BIDIRULE_RTL);

# Cases taken from:
# https://www.icann.org/en/system/files/files/idn-test-labels.pdf
# decoding Punycode.
my @tests = (
    # カ18バ
    [0x30AB, 0x31, 0x38, 0x30D0] => BIDIRULE_LTR,
    # hippo18potamus
    [   0x68, 0x69, 0x70, 0x70, 0x6F, 0x31, 0x38, 0x70,
        0x6F, 0x74, 0x61, 0x6D, 0x75, 0x73
    ] => BIDIRULE_LTR,
    # 하18마
    [0xD558, 0x31, 0x38, 0xB9C8] => BIDIRULE_LTR,
    # 河18馬
    [0x6CB3, 0x31, 0x38, 0x99AC] => BIDIRULE_LTR,
    # flod18häst
    [0x66, 0x6C, 0x6F, 0x64, 0x31, 0x38, 0x68, 0xE4, 0x73, 0x74] =>
        BIDIRULE_LTR,
    # اسب18آبی
    [0x627, 0x633, 0x628, 0x31, 0x38, 0x622, 0x628, 0x6CC] => BIDIRULE_RTL,
    # فرس18النهر
    [0x641, 0x631, 0x633, 0x31, 0x38, 0x627, 0x644, 0x646, 0x647, 0x631] =>
        BIDIRULE_RTL,
    # நீர்18யானை
    [0xBA8, 0xBC0, 0xBB0, 0xBCD, 0x31, 0x38, 0xBAF, 0xBBE, 0xBA9, 0xBC8] =>
        BIDIRULE_LTR,
    # दरियाई18घोड़ा
    [   0x926, 0x930, 0x93F, 0x92F, 0x93E, 0x908, 0x31, 0x38,
        0x918, 0x94B, 0x921, 0x93C, 0x93E
    ] => BIDIRULE_LTR,
    # היפּאָ18פּאָטאַם
    [   0x5D4, 0x5D9, 0x5E4, 0x5BC, 0x5D0, 0x5B8, 0x31,  0x38,
        0x5E4, 0x5BC, 0x5D0, 0x5B8, 0x5D8, 0x5D0, 0x5B7, 0x5DD
    ] => BIDIRULE_RTL,
    # гиппо18потамгиппо18потам
    [   0x433, 0x438, 0x43F, 0x43F, 0x43E, 0x31,  0x38,  0x43F,
        0x43E, 0x442, 0x430, 0x43C, 0x433, 0x438, 0x43F, 0x43F,
        0x43E, 0x31,  0x38,  0x43F, 0x43E, 0x442, 0x430, 0x43C
    ] => BIDIRULE_LTR,
    # ฮิปโปโ18ปเตมัสฮิปโปโ18ปเตมัส
    [   0xE2E, 0xE34, 0xE1B, 0xE42, 0xE1B, 0xE42, 0x31,  0x38,
        0xE1B, 0xE40, 0xE15, 0xE21, 0xE31, 0xE2A, 0xE2E, 0xE34,
        0xE1B, 0xE42, 0xE1B, 0xE42, 0x31,  0x38,  0xE1B, 0xE40,
        0xE15, 0xE21, 0xE31, 0xE2A
    ] => BIDIRULE_LTR,
    # ιππο18πόταμοσιππο18πόταμοσιππο18πόταμοσ
    [   0x3B9, 0x3C0, 0x3C0, 0x3BF, 0x31,  0x38,  0x3C0, 0x3CC,
        0x3C4, 0x3B1, 0x3BC, 0x3BF, 0x3C3, 0x3B9, 0x3C0, 0x3C0,
        0x3BF, 0x31,  0x38,  0x3C0, 0x3CC, 0x3C4, 0x3B1, 0x3BC,
        0x3BF, 0x3C3, 0x3B9, 0x3C0, 0x3C0, 0x3BF, 0x31,  0x38,
        0x3C0, 0x3CC, 0x3C4, 0x3B1, 0x3BC, 0x3BF, 0x3C3
    ] => BIDIRULE_LTR,
    # floĴd1Ŕ8åhäsſtůfĳĳloœĐdĴ18ďhästfĳůålod1ĐœĴ8hästfœlƃoďd18åhœĴĳäsďtflod1ĎĎďŧ8œhäståŮŮŒŒŊĳflod1ŹäœĎŮĳ8ăŒďĩ
    [   0x66,  0x6C,  0x6F,  0x134, 0x64,  0x31,  0x154, 0x38,
        0xE5,  0x68,  0xE4,  0x73,  0x17F, 0x74,  0x16F, 0x66,
        0x133, 0x133, 0x6C,  0x6F,  0x153, 0x110, 0x64,  0x134,
        0x31,  0x38,  0x10F, 0x68,  0xE4,  0x73,  0x74,  0x66,
        0x133, 0x16F, 0xE5,  0x6C,  0x6F,  0x64,  0x31,  0x110,
        0x153, 0x134, 0x38,  0x68,  0xE4,  0x73,  0x74,  0x66,
        0x153, 0x6C,  0x183, 0x6F,  0x10F, 0x64,  0x31,  0x38,
        0xE5,  0x68,  0x153, 0x134, 0x133, 0xE4,  0x73,  0x10F,
        0x74,  0x66,  0x6C,  0x6F,  0x64,  0x31,  0x10E, 0x10E,
        0x10F, 0x167, 0x38,  0x153, 0x68,  0xE4,  0x73,  0x74,
        0xE5,  0x16E, 0x16E, 0x152, 0x152, 0x14A, 0x133, 0x66,
        0x6C,  0x6F,  0x64,  0x31,  0x179, 0xE4,  0x153, 0x10E,
        0x16E, 0x133, 0x38,  0x103, 0x152, 0x10F, 0x129
    ] => BIDIRULE_LTR,
);

my $i = 1;
while (@tests) {
    my $test   = shift @tests;
    my $result = shift @tests;

    my $str = pack 'U*', @$test;
    is_deeply(
        [check($str)],
        [result => $result, offset => scalar @$test],
        sprintf 'Case %d (Unicode)', $i
    );
    $str = encode_utf8($str);
    is_deeply(
        [check($str)],
        [result => $result, offset => length $str],
        sprintf 'Case %d (byte)', $i
    );
    $i++;
}
