use RPM::Make;

my @filelist=('tmproot/file1.txt',
              'tmproot/file2.txt',
              'tmproot/file3.txt',
              'tmproot/file4.txt');

my %doc; my %conf; my %metadata;
$doc{'tmproot/file1.txt'}=1;
$conf{'tmproot/file2.txt'}=1;
$confnoreplace{'tmproot/file3.txt'}=1;

my $pathprefix='tmproot';
my $tag='Test';
my $version='0.1';
my $release='1';
my $arch='i386';
print(<<END);
This script will try to build an RPM assuming an i386 architecture.
END

%metadata=(
           'vendor'=>'Laboratory for GeeksLikeMeNeedExercise Medicine',
           'summary'=>'Test Software Package',
           'name'=>$tag,
           'copyrightname'=>'',
           'group'=>'Utilities/System',
           'AutoReqProv'=>'no',
           'requires'=>[('PreReq: setup',
                         'PreReq: passwd',
                         'PreReq: util-linux'
                         )],
           'description'=>'This package is generated by RPM::Make. '.
                  'This implements the '.$tag.' software package',
   'pre'=>'echo "You are installing a package built by RPM::Make; '.
          'RPM::Make is available at http://www.cpan.org/."',
           );

my $buildloc='TempBuildLoc';
RPM::Make::execute($tag,$version,$release,$arch,$buildloc,$pathprefix,
                   \@filelist,\%doc,\%conf,\%confnoreplace,
                   \%metadata);

# execution can also be done with multiple smaller steps
# (equivalent functionality)

RPM::Make::rpmsrc($tag,$version,$release,$buildloc,$pathprefix,
                  \@filelist,\%doc,\%conf,\%confnoreplace,
                  \%metadata);

my $currentdir=`pwd`; chomp($currentdir); my $invokingdir=$currentdir;
$currentdir.='/'.$buildloc;

RPM::Make::compilerpm($buildloc,$tag,$version,$release,$arch,
		      $currentdir,$invokingdir);

RPM::Make::cleanbuildloc($buildloc);
