package Task::Curses::UI;

# Pragmas.
use strict;
use warnings;

# Version.
our $VERSION = 0.02;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Curses::UI - Install the Curses::UI modules.

=head1 SYNOPSIS

 cpanm Task::Curses::UI

=head1 SEE ALSO

=over

=item L<Curses::UI>

A curses based OO user interface framework

=item L<Curses::UI::Buttonbox>

Create and manipulate button widgets

=item L<Curses::UI::Calendar>

Create and manipulate calendar widgets

=item L<Curses::UI::Checkbox>

Create and manipulate checkbox widgets

=item L<Curses::UI::Color>

Color support module

=item L<Curses::UI::Common>

Common methods for Curses::UI

=item L<Curses::UI::Container>

Create and manipulate container widgets

=item L<Curses::UI::DelimitedTextViewer>

Displays delimited files as fixed width.

=item L<Curses::UI::Dialog::Basic>

Create and manipulate basic dialogs

=item L<Curses::UI::Dialog::Calendar>

Create and manipulate calendar dialogs

=item L<Curses::UI::Dialog::Dirbrowser>

Create and manipulate filebrowser dialogs

=item L<Curses::UI::Dialog::Error>

Create and manipulate error dialogs

=item L<Curses::UI::Dialog::Filebrowser>

Create and manipulate filebrowser dialogs

=item L<Curses::UI::Dialog::Progress>

Create and manipulate progress dialogs

=item L<Curses::UI::Dialog::Question>

Pose a simple question to the user

=item L<Curses::UI::Dialog::Status>

Create and manipulate status dialogs

=item L<Curses::UI::Grid>

Create and manipulate data in grid model

=item L<Curses::UI::Grid::Cell>

Create and manipulate cell in grid model.

=item L<Curses::UI::Grid::Row>

Create and manipulate row in grid model.

=item L<Curses::UI::Label>

Create and manipulate label widgets

=item L<Curses::UI::Listbox>

Create and manipulate listbox widgets

=item L<Curses::UI::Menubar>

Create and manipulate menubar widgets

=item L<Curses::UI::Notebook>

Create and manipulate notebook widgets.

=item L<Curses::UI::Mousehandler::GPM>

Curses::UI GPM Bindings

=item L<Curses::UI::Number>

Create and manipulate number widgets.

=item L<Curses::UI::PasswordEntry>

Create and manipulate passwordentry widgets

=item L<Curses::UI::POE>

A subclass makes Curses::UI POE Friendly.

=item L<Curses::UI::Popupmenu>

Create and manipulate popupbox widgets

=item L<Curses::UI::Progressbar>

Create and manipulate progressbar widgets

=item L<Curses::UI::Radiobuttonbox>

Create and manipulate radiobuttonbox widgets

=item L<Curses::UI::Searchable>

Add 'less'-like search abilities to a widget

=item L<Curses::UI::TextEditor>

Create and manipulate texteditor widgets

=item L<Curses::UI::TextEntry>

Create and manipulate textentry widgets

=item L<Curses::UI::TextViewer>

Create and manipulate textviewer widgets

=item L<Curses::UI::Time>

Create and manipulate time widgets.

=item L<Curses::UI::Tutorial>

Tutorial for the Curses::UI framework

=item L<Curses::UI::Volume>

Create and manipulate volume widgets.

=item L<Curses::UI::Widget>

The base class for all widgets

=item L<Curses::UI::Window>

Create and manipulate Window widgets

=back

=head1 REPOSITORY

L<https://github.com/tupinek/Task-Curses-UI>

=head1 AUTHOR

Michal Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

 © 2015 Michal Špaček
 Artistic License
 BSD 2-Clause License

=head1 VERSION

0.02

=cut
