{

    package Sub::HandlesVia::Toolkit::Moose;
    use strict;
    use warnings;
    no warnings qw( once void );

    our $USES_MITE    = "Mite::Class";
    our $MITE_SHIM    = "Sub::HandlesVia::Mite";
    our $MITE_VERSION = "0.010002";

    # Mite keywords
    BEGIN {
        my ( $SHIM, $CALLER ) =
          ( "Sub::HandlesVia::Mite", "Sub::HandlesVia::Toolkit::Moose" );
        ( *after, *around, *before, *extends, *has, *signature_for, *with ) =
          do {

            package Sub::HandlesVia::Mite;
            no warnings 'redefine';
            (
                sub { $SHIM->HANDLE_after( $CALLER, "class", @_ ) },
                sub { $SHIM->HANDLE_around( $CALLER, "class", @_ ) },
                sub { $SHIM->HANDLE_before( $CALLER, "class", @_ ) },
                sub { },
                sub { $SHIM->HANDLE_has( $CALLER, has => @_ ) },
                sub { $SHIM->HANDLE_signature_for( $CALLER, "class", @_ ) },
                sub { $SHIM->HANDLE_with( $CALLER, @_ ) },
            );
          };
    }

    BEGIN {
        require Sub::HandlesVia::Toolkit;

        use mro 'c3';
        our @ISA;
        push @ISA, "Sub::HandlesVia::Toolkit";
    }

    # See UNIVERSAL
    sub DOES {
        my ( $self, $role ) = @_;
        our %DOES;
        return $DOES{$role} if exists $DOES{$role};
        return 1            if $role eq __PACKAGE__;
        return $self->SUPER::DOES($role);
    }

    # Alias for Moose/Moo-compatibility
    sub does {
        shift->DOES(@_);
    }

    1;
}
