/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClass=DomCharacterData.class, value={SupportedBrowser.IE})
public class XMLDOMCharacterData
extends XMLDOMNode {
    @JsxGetter
    public Object getData() {
        DomCharacterData domCharacterData = this.getDomNodeOrDie();
        return domCharacterData.getData();
    }

    @JsxSetter
    public void setData(String newData) {
        if (newData == null || "null".equals(newData)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        DomCharacterData domCharacterData = this.getDomNodeOrDie();
        domCharacterData.setData(newData);
    }

    @JsxGetter
    public int getLength() {
        DomCharacterData domCharacterData = this.getDomNodeOrDie();
        return domCharacterData.getLength();
    }

    @Override
    public void setText(Object newText) {
        this.setData(newText == null ? null : Context.toString(newText));
    }

    @Override
    public Object getXml() {
        String xmlString;
        Object xml = super.getXml();
        if (xml instanceof String && (xmlString = (String)xml).indexOf(10) >= 0) {
            xml = xmlString.replaceAll("([^\r])\n", "$1\r\n");
        }
        return xml;
    }

    @JsxFunction
    public void appendData(String data) {
        if (data == null || "null".equals(data)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        DomCharacterData domCharacterData = this.getDomNodeOrDie();
        domCharacterData.appendData(data);
    }

    @JsxFunction
    public void deleteData(int offset, int count) {
        if (offset < 0) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        if (count < 0) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        if (count == 0) {
            return;
        }
        DomCharacterData domCharacterData = this.getDomNodeOrDie();
        if (offset > domCharacterData.getLength()) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        domCharacterData.deleteData(offset, count);
    }

    @JsxFunction
    public void insertData(int offset, String data) {
        if (data == null || "null".equals(data)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        if (data.isEmpty()) {
            return;
        }
        if (offset < 0) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        DomCharacterData domCharacterData = this.getDomNodeOrDie();
        if (offset > domCharacterData.getLength()) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        domCharacterData.insertData(offset, data);
    }

    @JsxFunction
    public void replaceData(int offset, int count, String data) {
        if (offset < 0) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        if (count < 0) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        if (data == null || "null".equals(data)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        DomCharacterData domCharacterData = this.getDomNodeOrDie();
        if (offset > domCharacterData.getLength()) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        domCharacterData.replaceData(offset, count, data);
    }

    @JsxFunction
    public String substringData(int offset, int count) {
        if (offset < 0) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        if (count < 0) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        DomCharacterData domCharacterData = this.getDomNodeOrDie();
        if (offset > domCharacterData.getLength()) {
            throw Context.reportRuntimeError("The offset must be 0 or a positive number that is not greater than the number of characters in the data.");
        }
        return domCharacterData.substringData(offset, count);
    }

    @Override
    public DomCharacterData getDomNodeOrDie() {
        return (DomCharacterData)super.getDomNodeOrDie();
    }
}

