/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClass=HtmlImage.class)
public class HTMLImageElement
extends HTMLElement {
    private static final Map<String, String> NORMALIZED_ALIGN_VALUES = new HashMap<String, String>();
    private boolean endTagForbidden_ = true;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public void jsConstructor() {
        SgmlPage page = (SgmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        DomElement fake = HTMLParser.getFactory("img").createElement(page, "img", new AttributesImpl());
        this.setDomNode(fake);
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if ("image".equalsIgnoreCase(domNode.getLocalName())) {
            this.endTagForbidden_ = false;
        }
    }

    @JsxSetter
    public void setSrc(String src) {
        HtmlElement img = this.getDomNodeOrDie();
        img.setAttribute("src", src);
    }

    @JsxGetter
    public String getSrc() {
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        String src = img.getSrcAttribute();
        if ("".equals(src)) {
            return src;
        }
        try {
            HtmlPage page = (HtmlPage)img.getPage();
            return page.getFullyQualifiedUrl(src).toExternalForm();
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create fully qualified URL for src attribute of image " + e.getMessage();
            throw Context.reportRuntimeError(msg);
        }
    }

    @Override
    public void setOnload(Object onload) {
        super.setOnload(onload);
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        img.doOnLoad();
    }

    @JsxGetter
    public String getAlt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        return alt;
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        return border;
    }

    @JsxSetter
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        String align = this.getDomNodeOrDie().getAttribute("align");
        if (acceptArbitraryValues) {
            return align;
        }
        String normalizedValue = NORMALIZED_ALIGN_VALUES.get(align.toLowerCase(Locale.ROOT));
        if (null != normalizedValue) {
            return normalizedValue;
        }
        return "";
    }

    @JsxSetter
    public void setAlign(String align) {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        if (acceptArbitraryValues) {
            this.getDomNodeOrDie().setAttribute("align", align);
            return;
        }
        String normalizedValue = NORMALIZED_ALIGN_VALUES.get(align.toLowerCase(Locale.ROOT));
        if (null != normalizedValue) {
            this.getDomNodeOrDie().setAttribute("align", normalizedValue);
            return;
        }
        throw Context.reportRuntimeError("Cannot set the align property to invalid value: '" + align + "'");
    }

    @Override
    @JsxGetter
    public int getWidth() {
        String src;
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        String widthAttrib = img.getWidthAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED != widthAttrib) {
            try {
                return Integer.parseInt(widthAttrib);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (DomElement.ATTRIBUTE_NOT_DEFINED != (src = img.getSrcAttribute())) {
            try {
                return img.getWidth();
            }
            catch (IOException e) {
                BrowserVersion browserVersion = this.getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                    return 28;
                }
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_18x20_0x0)) {
                    if (StringUtils.isBlank(src)) {
                        return 0;
                    }
                    return 20;
                }
                return 24;
            }
        }
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
            return 28;
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_18x20_0x0) || browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_0x0_0x0)) {
            return 0;
        }
        return 24;
    }

    @JsxSetter
    public void setWidth(String width) {
        this.getDomNodeOrDie().setAttribute("width", width);
    }

    @Override
    @JsxGetter
    public int getHeight() {
        String src;
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        String height = img.getHeightAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED != height) {
            try {
                return Integer.parseInt(height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (DomElement.ATTRIBUTE_NOT_DEFINED != (src = img.getSrcAttribute())) {
            try {
                return img.getHeight();
            }
            catch (IOException e) {
                BrowserVersion browserVersion = this.getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                    return 30;
                }
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_18x20_0x0)) {
                    if (StringUtils.isBlank(src)) {
                        return 0;
                    }
                    return 20;
                }
                return 24;
            }
        }
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
            return 30;
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_18x20_0x0) || browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_0x0_0x0)) {
            return 0;
        }
        return 24;
    }

    @JsxSetter
    public void setHeight(String height) {
        this.getDomNodeOrDie().setAttribute("height", height);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }

    @JsxGetter
    public boolean isComplete() {
        return ((HtmlImage)this.getDomNodeOrDie()).isComplete();
    }

    @JsxGetter
    public int getNaturalWidth() {
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        try {
            return img.getWidth();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @JsxGetter
    public int getNaturalHeight() {
        HtmlImage img = (HtmlImage)this.getDomNodeOrDie();
        try {
            return img.getHeight();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttribute("name");
    }

    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    static {
        NORMALIZED_ALIGN_VALUES.put("center", "center");
        NORMALIZED_ALIGN_VALUES.put("left", "left");
        NORMALIZED_ALIGN_VALUES.put("right", "right");
        NORMALIZED_ALIGN_VALUES.put("bottom", "bottom");
        NORMALIZED_ALIGN_VALUES.put("middle", "middle");
        NORMALIZED_ALIGN_VALUES.put("top", "top");
        NORMALIZED_ALIGN_VALUES.put("absbottom", "absBottom");
        NORMALIZED_ALIGN_VALUES.put("absmiddle", "absMiddle");
        NORMALIZED_ALIGN_VALUES.put("baseline", "baseline");
        NORMALIZED_ALIGN_VALUES.put("texttop", "textTop");
    }
}

