/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HandshakeResponse;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;

class W3CHandshakeResponse
implements HandshakeResponse {
    private final Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> error = tuple -> {
        Object rawValue = tuple.getData().get("value");
        if (!(rawValue instanceof Map)) {
            return Optional.empty();
        }
        Map rawMap = (Map)rawValue;
        Object rawMessage = rawMap.get("message");
        Object rawError = rawMap.get("error");
        Object rawStackTrace = rawMap.get("stacktrace");
        String string = rawStackTrace = rawStackTrace == null ? "" : rawStackTrace;
        if (!(rawError instanceof String) || !(rawMessage instanceof String)) {
            return Optional.empty();
        }
        if (!(rawStackTrace instanceof String)) {
            rawStackTrace = String.valueOf(rawStackTrace);
        }
        Response response = new Response();
        response.setState((String)rawError);
        response.setStatus(new ErrorCodes().toStatus((String)rawError, Optional.of(tuple.getStatusCode())));
        Class<? extends WebDriverException> type = new ErrorCodes().getExceptionType((String)rawError);
        try {
            WebDriverException exception = type.getConstructor(String.class).newInstance((String)rawMessage);
            exception.addInfo("remote stacktrace", (String)rawStackTrace);
            response.setValue(exception);
        }
        catch (ReflectiveOperationException e) {
            response.setValue(rawMessage);
        }
        new ErrorHandler().throwIfResponseFailed(response, tuple.getRequestDuration().toMillis());
        return Optional.empty();
    };
    private final Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> success = tuple -> {
        if (tuple.getData().containsKey("status")) {
            return Optional.empty();
        }
        Object rawValue = tuple.getData().get("value");
        if (!(rawValue instanceof Map)) {
            return Optional.empty();
        }
        Map rawMap = (Map)rawValue;
        Object rawSessionId = rawMap.get("sessionId");
        Object rawCapabilities = rawMap.get("capabilities");
        if (!(rawSessionId instanceof String) || !(rawCapabilities instanceof Map)) {
            return Optional.empty();
        }
        for (Object key : ((Map)rawCapabilities).keySet()) {
            if (key instanceof String) continue;
            return Optional.empty();
        }
        Map caps = (Map)rawCapabilities;
        String sessionId = (String)rawSessionId;
        return Optional.of(new ProtocolHandshake.Result(Dialect.W3C, sessionId, caps));
    };

    W3CHandshakeResponse() {
    }

    @Override
    public Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> getResponseFunction() {
        return resp -> {
            Optional<ProtocolHandshake.Result> result = this.error.apply((InitialHandshakeResponse)resp);
            if (!result.isPresent()) {
                result = this.success.apply((InitialHandshakeResponse)resp);
            }
            return result;
        };
    }
}

