use strict;
use warnings;
package Perl::Critic::Lax;
# ABSTRACT: policies that let you slide on common exceptions
$Perl::Critic::Lax::VERSION = '0.012';
#pod =head1 DESCRIPTION
#pod
#pod The Perl-Critic-Lax distribution includes versions of core Perl::Critic modules
#pod with built-in exceptions.  If you really like a Perl::Critic policy, but find
#pod that you often violate it in a specific way that seems pretty darn reasonable,
#pod maybe there's a Lax policy.  If there isn't, send one in!
#pod
#pod =cut

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Perl::Critic::Lax - policies that let you slide on common exceptions

=head1 VERSION

version 0.012

=head1 DESCRIPTION

The Perl-Critic-Lax distribution includes versions of core Perl::Critic modules
with built-in exceptions.  If you really like a Perl::Critic policy, but find
that you often violate it in a specific way that seems pretty darn reasonable,
maybe there's a Lax policy.  If there isn't, send one in!

=head1 AUTHOR

Ricardo Signes <rjbs@cpan.org>

=head1 CONTRIBUTORS

=for stopwords Andreas Schröter Ricardo SIGNES

=over 4

=item *

Andreas Schröter <andreas.schroeter@autinity.de>

=item *

Ricardo SIGNES <rjbs@codesimply.com>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Ricardo Signes <rjbs@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
