#!/usr/bin/pugs

use v6;
require Test;

plan 880;

is(eval '"abc" ~~ rx:perl5/abc/ && $0', "abc", 're_tests 1/0 (1)');
is(eval '"abc" ~~ rx:perl5/abc/ && getpos($/, 0)', 0, 're_tests 1/0 (2)', :todo(1));
ok(eval 'not ("xbc" ~~ rx:perl5/abc/)', 're_tests 3  (5)');
ok(eval 'not ("axc" ~~ rx:perl5/abc/)', 're_tests 5  (7)');
ok(eval 'not ("abx" ~~ rx:perl5/abc/)', 're_tests 7  (9)');
is(eval '"xabcy" ~~ rx:perl5/abc/ && $0', "abc", 're_tests 9/0 (11)');
is(eval '"xabcy" ~~ rx:perl5/abc/ && getpos($/, 0)', 1, 're_tests 9/0 (12)', :todo(1));
is(eval '"ababc" ~~ rx:perl5/abc/ && $0', "abc", 're_tests 11/0 (15)');
is(eval '"ababc" ~~ rx:perl5/abc/ && getpos($/, 0)', 2, 're_tests 11/0 (16)', :todo(1));
is(eval '"abc" ~~ rx:perl5/ab*c/ && $0', "abc", 're_tests 13/0 (19)');
is(eval '"abc" ~~ rx:perl5/ab*c/ && getpos($/, 0)', 0, 're_tests 13/0 (20)', :todo(1));
is(eval '"abc" ~~ rx:perl5/ab*bc/ && $0', "abc", 're_tests 15/0 (23)');
is(eval '"abc" ~~ rx:perl5/ab*bc/ && getpos($/, 0)', 0, 're_tests 15/0 (24)', :todo(1));
is(eval '"abbc" ~~ rx:perl5/ab*bc/ && $0', "abbc", 're_tests 17/0 (27)');
is(eval '"abbc" ~~ rx:perl5/ab*bc/ && getpos($/, 0)', 0, 're_tests 17/0 (28)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab*bc/ && $0', "abbbbc", 're_tests 19/0 (31)');
is(eval '"abbbbc" ~~ rx:perl5/ab*bc/ && getpos($/, 0)', 0, 're_tests 19/0 (32)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/.{1}/ && $0', "a", 're_tests 21/0 (35)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/.{1}/ && getpos($/, 0)', 0, 're_tests 21/0 (36)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/.{3,4}/ && $0', "abbb", 're_tests 23/0 (39)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/.{3,4}/ && getpos($/, 0)', 0, 're_tests 23/0 (40)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab{0,}bc/ && $0', "abbbbc", 're_tests 25/0 (43)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab{0,}bc/ && getpos($/, 0)', 0, 're_tests 25/0 (44)', :todo(1));
is(eval '"abbc" ~~ rx:perl5/ab+bc/ && $0', "abbc", 're_tests 27/0 (47)');
is(eval '"abbc" ~~ rx:perl5/ab+bc/ && getpos($/, 0)', 0, 're_tests 27/0 (48)', :todo(1));
ok(eval 'not ("abc" ~~ rx:perl5/ab+bc/)', 're_tests 29  (51)');
ok(eval 'not ("abq" ~~ rx:perl5/ab+bc/)', 're_tests 31  (53)');
ok(eval 'not ("abq" ~~ rx:perl5/ab{1,}bc/)', 're_tests 33  (55)');
is(eval '"abbbbc" ~~ rx:perl5/ab+bc/ && $0', "abbbbc", 're_tests 35/0 (57)');
is(eval '"abbbbc" ~~ rx:perl5/ab+bc/ && getpos($/, 0)', 0, 're_tests 35/0 (58)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab{1,}bc/ && $0', "abbbbc", 're_tests 37/0 (61)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab{1,}bc/ && getpos($/, 0)', 0, 're_tests 37/0 (62)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab{1,3}bc/ && $0', "abbbbc", 're_tests 39/0 (65)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab{1,3}bc/ && getpos($/, 0)', 0, 're_tests 39/0 (66)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab{3,4}bc/ && $0', "abbbbc", 're_tests 41/0 (69)', :todo(1));
is(eval '"abbbbc" ~~ rx:perl5/ab{3,4}bc/ && getpos($/, 0)', 0, 're_tests 41/0 (70)', :todo(1));
ok(eval 'not ("abbbbc" ~~ rx:perl5/ab{4,5}bc/)', 're_tests 43  (73)');
is(eval '"abbc" ~~ rx:perl5/ab?bc/ && $0', "abbc", 're_tests 45/0 (75)');
is(eval '"abc" ~~ rx:perl5/ab?bc/ && $0', "abc", 're_tests 47/0 (77)');
is(eval '"abc" ~~ rx:perl5/ab{0,1}bc/ && $0', "abc", 're_tests 49/0 (79)', :todo(1));
ok(eval 'not ("abbbbc" ~~ rx:perl5/ab?bc/)', 're_tests 51  (81)');
is(eval '"abc" ~~ rx:perl5/ab?c/ && $0', "abc", 're_tests 53/0 (83)');
is(eval '"abc" ~~ rx:perl5/ab{0,1}c/ && $0', "abc", 're_tests 55/0 (85)', :todo(1));
is(eval '"abc" ~~ rx:perl5/^abc$/ && $0', "abc", 're_tests 57/0 (87)');
ok(eval 'not ("abcc" ~~ rx:perl5/^abc$/)', 're_tests 59  (89)');
is(eval '"abcc" ~~ rx:perl5/^abc/ && $0', "abc", 're_tests 61/0 (91)');
ok(eval 'not ("aabc" ~~ rx:perl5/^abc$/)', 're_tests 63  (93)');
is(eval '"aabc" ~~ rx:perl5/abc$/ && $0', "abc", 're_tests 65/0 (95)');
ok(eval 'not ("aabcd" ~~ rx:perl5/abc$/)', 're_tests 67  (97)');
is(eval '"abc" ~~ rx:perl5/^/ && $0', "", 're_tests 69/0 (99)');
is(eval '"abc" ~~ rx:perl5/$/ && $0', "", 're_tests 71/0 (101)');
is(eval '"abc" ~~ rx:perl5/a.c/ && $0', "abc", 're_tests 73/0 (103)');
is(eval '"axc" ~~ rx:perl5/a.c/ && $0', "axc", 're_tests 75/0 (105)');
is(eval '"axyzc" ~~ rx:perl5/a.*c/ && $0', "axyzc", 're_tests 77/0 (107)');
ok(eval 'not ("axyzd" ~~ rx:perl5/a.*c/)', 're_tests 79  (109)');
ok(eval 'not ("abc" ~~ rx:perl5/a[bc]d/)', 're_tests 81  (111)');
is(eval '"abd" ~~ rx:perl5/a[bc]d/ && $0', "abd", 're_tests 83/0 (113)');
ok(eval 'not ("abd" ~~ rx:perl5/a[b-d]e/)', 're_tests 85  (115)');
is(eval '"ace" ~~ rx:perl5/a[b-d]e/ && $0', "ace", 're_tests 87/0 (117)');
is(eval '"aac" ~~ rx:perl5/a[b-d]/ && $0', "ac", 're_tests 89/0 (119)');
is(eval '"a-" ~~ rx:perl5/a[-b]/ && $0', "a-", 're_tests 91/0 (121)');
is(eval '"a-" ~~ rx:perl5/a[b-]/ && $0', "a-", 're_tests 93/0 (123)');
is(eval '"a]" ~~ rx:perl5/a]/ && $0', "a]", 're_tests 95/0 (125)');
is(eval '"a]b" ~~ rx:perl5/a[]]b/ && $0', "a]b", 're_tests 97/0 (127)');
is(eval '"aed" ~~ rx:perl5/a[^bc]d/ && $0', "aed", 're_tests 99/0 (129)');
ok(eval 'not ("abd" ~~ rx:perl5/a[^bc]d/)', 're_tests 101  (131)');
is(eval '"adc" ~~ rx:perl5/a[^-b]c/ && $0', "adc", 're_tests 103/0 (133)');
ok(eval 'not ("a-c" ~~ rx:perl5/a[^-b]c/)', 're_tests 105  (135)');
ok(eval 'not ("a]c" ~~ rx:perl5/a[^]b]c/)', 're_tests 107  (137)');
is(eval '"adc" ~~ rx:perl5/a[^]b]c/ && $0', "adc", 're_tests 109/0 (139)');
ok(eval '"a-" ~~ rx:perl5/\ba\b/', 're_tests 111  (141)');
ok(eval '"-a" ~~ rx:perl5/\ba\b/', 're_tests 113  (143)');
ok(eval '"-a-" ~~ rx:perl5/\ba\b/', 're_tests 115  (145)');
ok(eval 'not ("xy" ~~ rx:perl5/\by\b/)', 're_tests 117  (147)');
ok(eval 'not ("yz" ~~ rx:perl5/\by\b/)', 're_tests 119  (149)');
ok(eval 'not ("xyz" ~~ rx:perl5/\by\b/)', 're_tests 121  (151)');
ok(eval 'not ("a-" ~~ rx:perl5/\Ba\B/)', 're_tests 123  (153)');
ok(eval 'not ("-a" ~~ rx:perl5/\Ba\B/)', 're_tests 125  (155)');
ok(eval 'not ("-a-" ~~ rx:perl5/\Ba\B/)', 're_tests 127  (157)');
ok(eval '"xy" ~~ rx:perl5/\By\b/', 're_tests 129  (159)');
is(eval '"xy" ~~ rx:perl5/\By\b/ && getpos($/, 0)', 1, 're_tests 131/0 (161)', :todo(1));
ok(eval '"xy" ~~ rx:perl5/\By\b/', 're_tests 133  (163)');
ok(eval '"yz" ~~ rx:perl5/\by\B/', 're_tests 135  (165)');
ok(eval '"xyz" ~~ rx:perl5/\By\B/', 're_tests 137  (167)');
ok(eval '"a" ~~ rx:perl5/\w/', 're_tests 139  (169)');
ok(eval 'not ("-" ~~ rx:perl5/\w/)', 're_tests 141  (171)');
ok(eval 'not ("a" ~~ rx:perl5/\W/)', 're_tests 143  (173)');
ok(eval '"-" ~~ rx:perl5/\W/', 're_tests 145  (175)');
ok(eval '"a b" ~~ rx:perl5/a\sb/', 're_tests 147  (177)');
ok(eval 'not ("a-b" ~~ rx:perl5/a\sb/)', 're_tests 149  (179)');
ok(eval 'not ("a b" ~~ rx:perl5/a\Sb/)', 're_tests 151  (181)');
ok(eval '"a-b" ~~ rx:perl5/a\Sb/', 're_tests 153  (183)');
ok(eval '"1" ~~ rx:perl5/\d/', 're_tests 155  (185)');
ok(eval 'not ("-" ~~ rx:perl5/\d/)', 're_tests 157  (187)');
ok(eval 'not ("1" ~~ rx:perl5/\D/)', 're_tests 159  (189)');
ok(eval '"-" ~~ rx:perl5/\D/', 're_tests 161  (191)');
ok(eval '"a" ~~ rx:perl5/[\w]/', 're_tests 163  (193)');
ok(eval 'not ("-" ~~ rx:perl5/[\w]/)', 're_tests 165  (195)');
ok(eval 'not ("a" ~~ rx:perl5/[\W]/)', 're_tests 167  (197)');
ok(eval '"-" ~~ rx:perl5/[\W]/', 're_tests 169  (199)');
ok(eval '"a b" ~~ rx:perl5/a[\s]b/', 're_tests 171  (201)');
ok(eval 'not ("a-b" ~~ rx:perl5/a[\s]b/)', 're_tests 173  (203)');
ok(eval 'not ("a b" ~~ rx:perl5/a[\S]b/)', 're_tests 175  (205)');
ok(eval '"a-b" ~~ rx:perl5/a[\S]b/', 're_tests 177  (207)');
ok(eval '"1" ~~ rx:perl5/[\d]/', 're_tests 179  (209)');
ok(eval 'not ("-" ~~ rx:perl5/[\d]/)', 're_tests 181  (211)');
ok(eval 'not ("1" ~~ rx:perl5/[\D]/)', 're_tests 183  (213)');
ok(eval '"-" ~~ rx:perl5/[\D]/', 're_tests 185  (215)');
is(eval '"abc" ~~ rx:perl5/ab|cd/ && $0', "ab", 're_tests 187/0 (217)');
is(eval '"abcd" ~~ rx:perl5/ab|cd/ && $0', "ab", 're_tests 189/0 (219)');
is(eval '"def" ~~ rx:perl5/()ef/ && $0', "ef", 're_tests 191/0 (221)');
is(eval '"def" ~~ rx:perl5/()ef/ && $1', "", 're_tests 191/1 (222)');
is(eval '"def" ~~ rx:perl5/()ef/ && getpos($/, 0)', 1, 're_tests 193/0 (225)', :todo(1));
is(eval '"def" ~~ rx:perl5/()ef/ && getpos($/, 1)', 1, 're_tests 195/1 (227)', :todo(1));
ok(eval 'not ("b" ~~ rx:perl5/$b/)', 're_tests 197  (229)', :todo(1));
is(eval '"a(b" ~~ rx:perl5/a\(b/ && $0', "a(b", 're_tests 199/0 (231)');
is(eval '"a(b" ~~ rx:perl5/a\(b/ && $1', "", 're_tests 199/1 (232)');
is(eval '"ab" ~~ rx:perl5/a\(*b/ && $0', "ab", 're_tests 201/0 (235)');
is(eval '"a((b" ~~ rx:perl5/a\(*b/ && $0', "a((b", 're_tests 203/0 (237)');
is(eval '"a\b" ~~ rx:perl5/a\\b/ && $0', "a\b", 're_tests 205/0 (239)', :todo(1));
is(eval '"abc" ~~ rx:perl5/((a))/ && $0', "a", 're_tests 207/0 (241)');
is(eval '"abc" ~~ rx:perl5/((a))/ && $1', "a", 're_tests 207/1 (242)');
is(eval '"abc" ~~ rx:perl5/((a))/ && $2', "a", 're_tests 207/2 (243)');
is(eval '"abc" ~~ rx:perl5/(a)b(c)/ && $0', "abc", 're_tests 209/0 (247)');
is(eval '"abc" ~~ rx:perl5/(a)b(c)/ && $1', "a", 're_tests 209/1 (248)');
is(eval '"abc" ~~ rx:perl5/(a)b(c)/ && $2', "c", 're_tests 209/2 (249)');
is(eval '"aabbabc" ~~ rx:perl5/a+b+c/ && $0', "abc", 're_tests 211/0 (253)');
is(eval '"aabbabc" ~~ rx:perl5/a{1,}b{1,}c/ && $0', "abc", 're_tests 213/0 (255)', :todo(1));
is(eval '"abcabc" ~~ rx:perl5/a.+?c/ && $0', "abc", 're_tests 215/0 (257)');
is(eval '"ab" ~~ rx:perl5/(a+|b)*/ && $0', "ab", 're_tests 217/0 (259)');
is(eval '"ab" ~~ rx:perl5/(a+|b)*/ && $1', "b", 're_tests 217/1 (260)');
is(eval '"ab" ~~ rx:perl5/(a+|b)*/ && getpos($/, 0)', 0, 're_tests 219/0 (263)', :todo(1));
is(eval '"ab" ~~ rx:perl5/(a+|b)*/ && getpos($/, 1)', 1, 're_tests 221/1 (265)', :todo(1));
is(eval '"ab" ~~ rx:perl5/(a+|b){0,}/ && $0', "ab", 're_tests 223/0 (267)', :todo(1));
is(eval '"ab" ~~ rx:perl5/(a+|b){0,}/ && $1', "b", 're_tests 223/1 (268)', :todo(1));
is(eval '"ab" ~~ rx:perl5/(a+|b)+/ && $0', "ab", 're_tests 225/0 (271)');
is(eval '"ab" ~~ rx:perl5/(a+|b)+/ && $1', "b", 're_tests 225/1 (272)');
is(eval '"ab" ~~ rx:perl5/(a+|b){1,}/ && $0', "ab", 're_tests 227/0 (275)', :todo(1));
is(eval '"ab" ~~ rx:perl5/(a+|b){1,}/ && $1', "b", 're_tests 227/1 (276)', :todo(1));
is(eval '"ab" ~~ rx:perl5/(a+|b)?/ && $0', "a", 're_tests 229/0 (279)');
is(eval '"ab" ~~ rx:perl5/(a+|b)?/ && $1', "a", 're_tests 229/1 (280)');
is(eval '"ab" ~~ rx:perl5/(a+|b){0,1}/ && $0', "a", 're_tests 231/0 (283)', :todo(1));
is(eval '"ab" ~~ rx:perl5/(a+|b){0,1}/ && $1', "a", 're_tests 231/1 (284)', :todo(1));
is(eval '"cde" ~~ rx:perl5/[^ab]*/ && $0', "cde", 're_tests 233/0 (287)');
ok(eval 'not ("" ~~ rx:perl5/abc/)', 're_tests 235  (289)');
is(eval '"" ~~ rx:perl5/a*/ && $0', "", 're_tests 237/0 (291)');
is(eval '"abbbcd" ~~ rx:perl5/([abc])*d/ && $0', "abbbcd", 're_tests 239/0 (293)');
is(eval '"abbbcd" ~~ rx:perl5/([abc])*d/ && $1', "c", 're_tests 239/1 (294)');
is(eval '"abcd" ~~ rx:perl5/([abc])*bcd/ && $0', "abcd", 're_tests 241/0 (297)');
is(eval '"abcd" ~~ rx:perl5/([abc])*bcd/ && $1', "a", 're_tests 241/1 (298)');
is(eval '"e" ~~ rx:perl5/a|b|c|d|e/ && $0', "e", 're_tests 243/0 (301)');
is(eval '"ef" ~~ rx:perl5/(a|b|c|d|e)f/ && $0', "ef", 're_tests 245/0 (303)');
is(eval '"ef" ~~ rx:perl5/(a|b|c|d|e)f/ && $1', "e", 're_tests 245/1 (304)');
is(eval '"ef" ~~ rx:perl5/(a|b|c|d|e)f/ && getpos($/, 0)', 0, 're_tests 247/0 (307)', :todo(1));
is(eval '"ef" ~~ rx:perl5/(a|b|c|d|e)f/ && getpos($/, 1)', 0, 're_tests 249/1 (309)', :todo(1));
is(eval '"abcdefg" ~~ rx:perl5/abcd*efg/ && $0', "abcdefg", 're_tests 251/0 (311)');
is(eval '"xabyabbbz" ~~ rx:perl5/ab*/ && $0', "ab", 're_tests 253/0 (313)');
is(eval '"xayabbbz" ~~ rx:perl5/ab*/ && $0', "a", 're_tests 255/0 (315)');
is(eval '"abcde" ~~ rx:perl5/(ab|cd)e/ && $0', "cde", 're_tests 257/0 (317)');
is(eval '"abcde" ~~ rx:perl5/(ab|cd)e/ && $1', "cd", 're_tests 257/1 (318)');
is(eval '"hij" ~~ rx:perl5/[abhgefdc]ij/ && $0', "hij", 're_tests 259/0 (321)');
is(eval '"abcdef" ~~ rx:perl5/(abc|)ef/ && $0', "ef", 're_tests 261/0 (323)');
is(eval '"abcdef" ~~ rx:perl5/(abc|)ef/ && $1', "", 're_tests 261/1 (324)');
is(eval '"abcd" ~~ rx:perl5/(a|b)c*d/ && $0', "bcd", 're_tests 263/0 (327)');
is(eval '"abcd" ~~ rx:perl5/(a|b)c*d/ && $1', "b", 're_tests 263/1 (328)');
is(eval '"abc" ~~ rx:perl5/(ab|ab*)bc/ && $0', "abc", 're_tests 265/0 (331)');
is(eval '"abc" ~~ rx:perl5/(ab|ab*)bc/ && $1', "a", 're_tests 265/1 (332)');
is(eval '"abc" ~~ rx:perl5/a([bc]*)c*/ && $0', "abc", 're_tests 267/0 (335)');
is(eval '"abc" ~~ rx:perl5/a([bc]*)c*/ && $1', "bc", 're_tests 267/1 (336)');
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c*d)/ && $0', "abcd", 're_tests 269/0 (339)');
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c*d)/ && $1', "bc", 're_tests 269/1 (340)');
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c*d)/ && $2', "d", 're_tests 269/2 (341)');
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c*d)/ && getpos($/, 0)', 0, 're_tests 271/0 (345)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c*d)/ && getpos($/, 1)', 1, 're_tests 273/1 (347)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c*d)/ && getpos($/, 2)', 3, 're_tests 275/2 (349)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/a([bc]+)(c*d)/ && $0', "abcd", 're_tests 277/0 (351)');
is(eval '"abcd" ~~ rx:perl5/a([bc]+)(c*d)/ && $1', "bc", 're_tests 277/1 (352)');
is(eval '"abcd" ~~ rx:perl5/a([bc]+)(c*d)/ && $2', "d", 're_tests 277/2 (353)');
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c+d)/ && $0', "abcd", 're_tests 279/0 (357)');
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c+d)/ && $1', "b", 're_tests 279/1 (358)');
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c+d)/ && $2', "cd", 're_tests 279/2 (359)');
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c+d)/ && getpos($/, 0)', 0, 're_tests 281/0 (363)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c+d)/ && getpos($/, 1)', 1, 're_tests 283/1 (365)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/a([bc]*)(c+d)/ && getpos($/, 2)', 2, 're_tests 285/2 (367)', :todo(1));
is(eval '"adcdcde" ~~ rx:perl5/a[bcd]*dcdcde/ && $0', "adcdcde", 're_tests 287/0 (369)');
ok(eval 'not ("adcdcde" ~~ rx:perl5/a[bcd]+dcdcde/)', 're_tests 289  (371)');
is(eval '"abc" ~~ rx:perl5/(ab|a)b*c/ && $0', "abc", 're_tests 291/0 (373)');
is(eval '"abc" ~~ rx:perl5/(ab|a)b*c/ && $1', "ab", 're_tests 291/1 (374)');
is(eval '"abc" ~~ rx:perl5/(ab|a)b*c/ && getpos($/, 0)', 0, 're_tests 293/0 (377)', :todo(1));
is(eval '"abc" ~~ rx:perl5/(ab|a)b*c/ && getpos($/, 1)', 0, 're_tests 295/1 (379)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/((a)(b)c)(d)/ && getpos($/, 0)', 0, 're_tests 297/0 (381)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/((a)(b)c)(d)/ && getpos($/, 1)', 0, 're_tests 299/1 (383)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/((a)(b)c)(d)/ && getpos($/, 2)', 0, 're_tests 301/2 (385)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/((a)(b)c)(d)/ && getpos($/, 3)', 1, 're_tests 303/3 (387)', :todo(1));
is(eval '"abcd" ~~ rx:perl5/((a)(b)c)(d)/ && getpos($/, 4)', 3, 're_tests 305/4 (389)', :todo(1));
is(eval '"alpha" ~~ rx:perl5/[a-zA-Z_][a-zA-Z0-9_]*/ && $0', "alpha", 're_tests 307/0 (391)');
is(eval '"abh" ~~ rx:perl5/^a(bc+|b[eh])g|.h$/ && $0', "bh", 're_tests 309/0 (393)');
is(eval '"abh" ~~ rx:perl5/^a(bc+|b[eh])g|.h$/ && $1', "", 're_tests 309/1 (394)');
is(eval '"effgz" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $0', "effgz", 're_tests 311/0 (397)');
is(eval '"effgz" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $1', "effgz", 're_tests 311/1 (398)');
is(eval '"effgz" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $2', "", 're_tests 311/2 (399)');
is(eval '"ij" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $0', "ij", 're_tests 313/0 (403)');
is(eval '"ij" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $1', "ij", 're_tests 313/1 (404)');
is(eval '"ij" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $2', "j", 're_tests 313/2 (405)');
ok(eval 'not ("effg" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/)', 're_tests 315  (409)');
ok(eval 'not ("bcdd" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/)', 're_tests 317  (411)');
is(eval '"reffgz" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $0', "effgz", 're_tests 319/0 (413)');
is(eval '"reffgz" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $1', "effgz", 're_tests 319/1 (414)');
is(eval '"reffgz" ~~ rx:perl5/(bc+d$|ef*g.|h?i(j|k))/ && $2', "", 're_tests 319/2 (415)');
is(eval '"a" ~~ rx:perl5/((((((((((a))))))))))/ && $10', "a", 're_tests 321/10 (419)');
is(eval '"a" ~~ rx:perl5/((((((((((a))))))))))/ && getpos($/, 0)', 0, 're_tests 323/0 (421)', :todo(1));
is(eval '"a" ~~ rx:perl5/((((((((((a))))))))))/ && getpos($/, 10)', 0, 're_tests 325/10 (423)', :todo(1));
is(eval '"aa" ~~ rx:perl5/((((((((((a))))))))))\10/ && $0', "aa", 're_tests 327/0 (425)');
ok(eval 'not ("aa" ~~ rx:perl5/((((((((((a))))))))))${bang}/)', 're_tests 329  (427)', :todo(1));
is(eval '"a!" ~~ rx:perl5/((((((((((a))))))))))${bang}/ && $0', "a!", 're_tests 330/0 (428)', :todo(1));
is(eval '"a" ~~ rx:perl5/(((((((((a)))))))))/ && $0', "a", 're_tests 331/0 (429)');
ok(eval 'not ("uh-uh" ~~ rx:perl5/multiple words of text/)', 're_tests 333  (431)');
is(eval '"multiple words, yeah" ~~ rx:perl5/multiple words/ && $0', "multiple words", 're_tests 335/0 (433)');
is(eval '"abcde" ~~ rx:perl5/(.*)c(.*)/ && $0', "abcde", 're_tests 337/0 (435)');
is(eval '"abcde" ~~ rx:perl5/(.*)c(.*)/ && $1', "ab", 're_tests 337/1 (436)');
is(eval '"abcde" ~~ rx:perl5/(.*)c(.*)/ && $2', "de", 're_tests 337/2 (437)');
ok(eval 'not ("ab" ~~ rx:perl5/[k]/)', 're_tests 339  (441)');
is(eval '"ac" ~~ rx:perl5/a[-]?c/ && $0', "ac", 're_tests 341/0 (443)');
is(eval '"abcabc" ~~ rx:perl5/(abc)\1/ && $1', "abc", 're_tests 343/1 (445)');
is(eval '"abcabc" ~~ rx:perl5/([a-c]*)\1/ && $1', "abc", 're_tests 345/1 (447)');
ok(eval '"a" ~~ rx:perl5/(a)|\1/', 're_tests 347  (449)');
ok(eval 'not ("x" ~~ rx:perl5/(a)|\1/)', 're_tests 349  (451)');
is(eval '"ababbbcbc" ~~ rx:perl5/(([a-c])b*?\2)*/ && $0', "ababb", 're_tests 351/0 (453)');
is(eval '"ababbbcbc" ~~ rx:perl5/(([a-c])b*?\2)*/ && $1', "bb", 're_tests 351/1 (454)');
is(eval '"ababbbcbc" ~~ rx:perl5/(([a-c])b*?\2)*/ && $2', "b", 're_tests 351/2 (455)');
is(eval '"ababbbcbc" ~~ rx:perl5/(([a-c])b*?\2){3}/ && $0', "ababbbcbc", 're_tests 353/0 (459)', :todo(1));
is(eval '"ababbbcbc" ~~ rx:perl5/(([a-c])b*?\2){3}/ && $1', "cbc", 're_tests 353/1 (460)', :todo(1));
is(eval '"ababbbcbc" ~~ rx:perl5/(([a-c])b*?\2){3}/ && $2', "c", 're_tests 353/2 (461)', :todo(1));
ok(eval 'not ("aaxabxbaxbbx" ~~ rx:perl5/((\3|b)\2(a)x)+/)', 're_tests 355  (465)');
is(eval '"b" ~~ rx:perl5/(a)|(b)/ && getpos($/, 0)', 0, 're_tests 357/0 (467)', :todo(1));
is(eval '"b" ~~ rx:perl5/(a)|(b)/ && getpos($/, 2)', 0, 're_tests 359/2 (469)', :todo(1));
is(eval '"ABC" ~~ rx:perl5/(?i)abc/ && $0', "ABC", 're_tests 361/0 (471)');
ok(eval 'not ("XBC" ~~ rx:perl5/(?i)abc/)', 're_tests 363  (473)');
ok(eval 'not ("AXC" ~~ rx:perl5/(?i)abc/)', 're_tests 365  (475)');
ok(eval 'not ("ABX" ~~ rx:perl5/(?i)abc/)', 're_tests 367  (477)');
is(eval '"XABCY" ~~ rx:perl5/(?i)abc/ && $0', "ABC", 're_tests 369/0 (479)');
is(eval '"ABABC" ~~ rx:perl5/(?i)abc/ && $0', "ABC", 're_tests 371/0 (481)');
is(eval '"ABC" ~~ rx:perl5/(?i)ab*c/ && $0', "ABC", 're_tests 373/0 (483)');
is(eval '"ABC" ~~ rx:perl5/(?i)ab*bc/ && $0', "ABC", 're_tests 375/0 (485)');
is(eval '"ABBC" ~~ rx:perl5/(?i)ab*bc/ && $0', "ABBC", 're_tests 377/0 (487)');
is(eval '"ABBBBC" ~~ rx:perl5/(?i)ab*?bc/ && $0', "ABBBBC", 're_tests 379/0 (489)');
is(eval '"ABBBBC" ~~ rx:perl5/(?i)ab{0,}?bc/ && $0', "ABBBBC", 're_tests 381/0 (491)', :todo(1));
is(eval '"ABBC" ~~ rx:perl5/(?i)ab+?bc/ && $0', "ABBC", 're_tests 383/0 (493)');
ok(eval 'not ("ABC" ~~ rx:perl5/(?i)ab+bc/)', 're_tests 385  (495)');
ok(eval 'not ("ABQ" ~~ rx:perl5/(?i)ab+bc/)', 're_tests 387  (497)');
ok(eval 'not ("ABQ" ~~ rx:perl5/(?i)ab{1,}bc/)', 're_tests 389  (499)');
is(eval '"ABBBBC" ~~ rx:perl5/(?i)ab+bc/ && $0', "ABBBBC", 're_tests 391/0 (501)');
is(eval '"ABBBBC" ~~ rx:perl5/(?i)ab{1,}?bc/ && $0', "ABBBBC", 're_tests 393/0 (503)', :todo(1));
is(eval '"ABBBBC" ~~ rx:perl5/(?i)ab{1,3}?bc/ && $0', "ABBBBC", 're_tests 395/0 (505)', :todo(1));
is(eval '"ABBBBC" ~~ rx:perl5/(?i)ab{3,4}?bc/ && $0', "ABBBBC", 're_tests 397/0 (507)', :todo(1));
ok(eval 'not ("ABBBBC" ~~ rx:perl5/(?i)ab{4,5}?bc/)', 're_tests 399  (509)');
is(eval '"ABBC" ~~ rx:perl5/(?i)ab??bc/ && $0', "ABBC", 're_tests 401/0 (511)');
is(eval '"ABC" ~~ rx:perl5/(?i)ab??bc/ && $0', "ABC", 're_tests 403/0 (513)');
is(eval '"ABC" ~~ rx:perl5/(?i)ab{0,1}?bc/ && $0', "ABC", 're_tests 405/0 (515)', :todo(1));
ok(eval 'not ("ABBBBC" ~~ rx:perl5/(?i)ab??bc/)', 're_tests 407  (517)');
is(eval '"ABC" ~~ rx:perl5/(?i)ab??c/ && $0', "ABC", 're_tests 409/0 (519)');
is(eval '"ABC" ~~ rx:perl5/(?i)ab{0,1}?c/ && $0', "ABC", 're_tests 411/0 (521)', :todo(1));
is(eval '"ABC" ~~ rx:perl5/(?i)^abc$/ && $0', "ABC", 're_tests 413/0 (523)');
ok(eval 'not ("ABCC" ~~ rx:perl5/(?i)^abc$/)', 're_tests 415  (525)');
is(eval '"ABCC" ~~ rx:perl5/(?i)^abc/ && $0', "ABC", 're_tests 417/0 (527)');
ok(eval 'not ("AABC" ~~ rx:perl5/(?i)^abc$/)', 're_tests 419  (529)');
is(eval '"AABC" ~~ rx:perl5/(?i)abc$/ && $0', "ABC", 're_tests 421/0 (531)');
is(eval '"ABC" ~~ rx:perl5/(?i)^/ && $0', "", 're_tests 423/0 (533)');
is(eval '"ABC" ~~ rx:perl5/(?i)$/ && $0', "", 're_tests 425/0 (535)');
is(eval '"ABC" ~~ rx:perl5/(?i)a.c/ && $0', "ABC", 're_tests 427/0 (537)');
is(eval '"AXC" ~~ rx:perl5/(?i)a.c/ && $0', "AXC", 're_tests 429/0 (539)');
is(eval '"AXYZC" ~~ rx:perl5/(?i)a.*?c/ && $0', "AXYZC", 're_tests 431/0 (541)');
ok(eval 'not ("AXYZD" ~~ rx:perl5/(?i)a.*c/)', 're_tests 433  (543)');
ok(eval 'not ("ABC" ~~ rx:perl5/(?i)a[bc]d/)', 're_tests 435  (545)');
is(eval '"ABD" ~~ rx:perl5/(?i)a[bc]d/ && $0', "ABD", 're_tests 437/0 (547)');
ok(eval 'not ("ABD" ~~ rx:perl5/(?i)a[b-d]e/)', 're_tests 439  (549)');
is(eval '"ACE" ~~ rx:perl5/(?i)a[b-d]e/ && $0', "ACE", 're_tests 441/0 (551)');
is(eval '"AAC" ~~ rx:perl5/(?i)a[b-d]/ && $0', "AC", 're_tests 443/0 (553)');
is(eval '"A-" ~~ rx:perl5/(?i)a[-b]/ && $0', "A-", 're_tests 445/0 (555)');
is(eval '"A-" ~~ rx:perl5/(?i)a[b-]/ && $0', "A-", 're_tests 447/0 (557)');
is(eval '"A]" ~~ rx:perl5/(?i)a]/ && $0', "A]", 're_tests 449/0 (559)');
is(eval '"A]B" ~~ rx:perl5/(?i)a[]]b/ && $0', "A]B", 're_tests 451/0 (561)');
is(eval '"AED" ~~ rx:perl5/(?i)a[^bc]d/ && $0', "AED", 're_tests 453/0 (563)');
ok(eval 'not ("ABD" ~~ rx:perl5/(?i)a[^bc]d/)', 're_tests 455  (565)');
is(eval '"ADC" ~~ rx:perl5/(?i)a[^-b]c/ && $0', "ADC", 're_tests 457/0 (567)');
ok(eval 'not ("A-C" ~~ rx:perl5/(?i)a[^-b]c/)', 're_tests 459  (569)');
ok(eval 'not ("A]C" ~~ rx:perl5/(?i)a[^]b]c/)', 're_tests 461  (571)');
is(eval '"ADC" ~~ rx:perl5/(?i)a[^]b]c/ && $0', "ADC", 're_tests 463/0 (573)');
is(eval '"ABC" ~~ rx:perl5/(?i)ab|cd/ && $0', "AB", 're_tests 465/0 (575)');
is(eval '"ABCD" ~~ rx:perl5/(?i)ab|cd/ && $0', "AB", 're_tests 467/0 (577)');
is(eval '"DEF" ~~ rx:perl5/(?i)()ef/ && $0', "EF", 're_tests 469/0 (579)');
is(eval '"DEF" ~~ rx:perl5/(?i)()ef/ && $1', "", 're_tests 469/1 (580)');
ok(eval 'not ("B" ~~ rx:perl5/(?i)$b/)', 're_tests 471  (583)', :todo(1));
is(eval '"A(B" ~~ rx:perl5/(?i)a\(b/ && $0', "A(B", 're_tests 473/0 (585)');
is(eval '"A(B" ~~ rx:perl5/(?i)a\(b/ && $1', "", 're_tests 473/1 (586)');
is(eval '"AB" ~~ rx:perl5/(?i)a\(*b/ && $0', "AB", 're_tests 475/0 (589)');
is(eval '"A((B" ~~ rx:perl5/(?i)a\(*b/ && $0', "A((B", 're_tests 477/0 (591)');
is(eval '"A\B" ~~ rx:perl5/(?i)a\\b/ && $0', "A\B", 're_tests 479/0 (593)', :todo(1));
is(eval '"ABC" ~~ rx:perl5/(?i)((a))/ && $0', "A", 're_tests 481/0 (595)');
is(eval '"ABC" ~~ rx:perl5/(?i)((a))/ && $1', "A", 're_tests 481/1 (596)');
is(eval '"ABC" ~~ rx:perl5/(?i)((a))/ && $2', "A", 're_tests 481/2 (597)');
is(eval '"ABC" ~~ rx:perl5/(?i)(a)b(c)/ && $0', "ABC", 're_tests 483/0 (601)');
is(eval '"ABC" ~~ rx:perl5/(?i)(a)b(c)/ && $1', "A", 're_tests 483/1 (602)');
is(eval '"ABC" ~~ rx:perl5/(?i)(a)b(c)/ && $2', "C", 're_tests 483/2 (603)');
is(eval '"AABBABC" ~~ rx:perl5/(?i)a+b+c/ && $0', "ABC", 're_tests 485/0 (607)');
is(eval '"AABBABC" ~~ rx:perl5/(?i)a{1,}b{1,}c/ && $0', "ABC", 're_tests 487/0 (609)', :todo(1));
is(eval '"ABCABC" ~~ rx:perl5/(?i)a.+?c/ && $0', "ABC", 're_tests 489/0 (611)');
is(eval '"ABCABC" ~~ rx:perl5/(?i)a.*?c/ && $0', "ABC", 're_tests 491/0 (613)');
is(eval '"ABCABC" ~~ rx:perl5/(?i)a.{0,5}?c/ && $0', "ABC", 're_tests 493/0 (615)', :todo(1));
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b)*/ && $0', "AB", 're_tests 495/0 (617)');
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b)*/ && $1', "B", 're_tests 495/1 (618)');
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b){0,}/ && $0', "AB", 're_tests 497/0 (621)', :todo(1));
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b){0,}/ && $1', "B", 're_tests 497/1 (622)', :todo(1));
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b)+/ && $0', "AB", 're_tests 499/0 (625)');
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b)+/ && $1', "B", 're_tests 499/1 (626)');
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b){1,}/ && $0', "AB", 're_tests 501/0 (629)', :todo(1));
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b){1,}/ && $1', "B", 're_tests 501/1 (630)', :todo(1));
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b)?/ && $0', "A", 're_tests 503/0 (633)');
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b)?/ && $1', "A", 're_tests 503/1 (634)');
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b){0,1}/ && $0', "A", 're_tests 505/0 (637)', :todo(1));
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b){0,1}/ && $1', "A", 're_tests 505/1 (638)', :todo(1));
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b){0,1}?/ && $0', "", 're_tests 507/0 (641)');
is(eval '"AB" ~~ rx:perl5/(?i)(a+|b){0,1}?/ && $1', "", 're_tests 507/1 (642)');
is(eval '"CDE" ~~ rx:perl5/(?i)[^ab]*/ && $0', "CDE", 're_tests 509/0 (645)');
ok(eval 'not ("" ~~ rx:perl5/(?i)abc/)', 're_tests 511  (647)');
is(eval '"" ~~ rx:perl5/(?i)a*/ && $0', "", 're_tests 513/0 (649)');
is(eval '"ABBBCD" ~~ rx:perl5/(?i)([abc])*d/ && $0', "ABBBCD", 're_tests 515/0 (651)');
is(eval '"ABBBCD" ~~ rx:perl5/(?i)([abc])*d/ && $1', "C", 're_tests 515/1 (652)');
is(eval '"ABCD" ~~ rx:perl5/(?i)([abc])*bcd/ && $0', "ABCD", 're_tests 517/0 (655)');
is(eval '"ABCD" ~~ rx:perl5/(?i)([abc])*bcd/ && $1', "A", 're_tests 517/1 (656)');
is(eval '"E" ~~ rx:perl5/(?i)a|b|c|d|e/ && $0', "E", 're_tests 519/0 (659)');
is(eval '"EF" ~~ rx:perl5/(?i)(a|b|c|d|e)f/ && $0', "EF", 're_tests 521/0 (661)');
is(eval '"EF" ~~ rx:perl5/(?i)(a|b|c|d|e)f/ && $1', "E", 're_tests 521/1 (662)');
is(eval '"ABCDEFG" ~~ rx:perl5/(?i)abcd*efg/ && $0', "ABCDEFG", 're_tests 523/0 (665)');
is(eval '"XABYABBBZ" ~~ rx:perl5/(?i)ab*/ && $0', "AB", 're_tests 525/0 (667)');
is(eval '"XAYABBBZ" ~~ rx:perl5/(?i)ab*/ && $0', "A", 're_tests 527/0 (669)');
is(eval '"ABCDE" ~~ rx:perl5/(?i)(ab|cd)e/ && $0', "CDE", 're_tests 529/0 (671)');
is(eval '"ABCDE" ~~ rx:perl5/(?i)(ab|cd)e/ && $1', "CD", 're_tests 529/1 (672)');
is(eval '"HIJ" ~~ rx:perl5/(?i)[abhgefdc]ij/ && $0', "HIJ", 're_tests 531/0 (675)');
is(eval '"ABCDEF" ~~ rx:perl5/(?i)(abc|)ef/ && $0', "EF", 're_tests 533/0 (677)');
is(eval '"ABCDEF" ~~ rx:perl5/(?i)(abc|)ef/ && $1', "", 're_tests 533/1 (678)');
is(eval '"ABCD" ~~ rx:perl5/(?i)(a|b)c*d/ && $0', "BCD", 're_tests 535/0 (681)');
is(eval '"ABCD" ~~ rx:perl5/(?i)(a|b)c*d/ && $1', "B", 're_tests 535/1 (682)');
is(eval '"ABC" ~~ rx:perl5/(?i)(ab|ab*)bc/ && $0', "ABC", 're_tests 537/0 (685)');
is(eval '"ABC" ~~ rx:perl5/(?i)(ab|ab*)bc/ && $1', "A", 're_tests 537/1 (686)');
is(eval '"ABC" ~~ rx:perl5/(?i)a([bc]*)c*/ && $0', "ABC", 're_tests 539/0 (689)');
is(eval '"ABC" ~~ rx:perl5/(?i)a([bc]*)c*/ && $1', "BC", 're_tests 539/1 (690)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]*)(c*d)/ && $0', "ABCD", 're_tests 541/0 (693)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]*)(c*d)/ && $1', "BC", 're_tests 541/1 (694)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]*)(c*d)/ && $2', "D", 're_tests 541/2 (695)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]+)(c*d)/ && $0', "ABCD", 're_tests 543/0 (699)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]+)(c*d)/ && $1', "BC", 're_tests 543/1 (700)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]+)(c*d)/ && $2', "D", 're_tests 543/2 (701)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]*)(c+d)/ && $0', "ABCD", 're_tests 545/0 (705)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]*)(c+d)/ && $1', "B", 're_tests 545/1 (706)');
is(eval '"ABCD" ~~ rx:perl5/(?i)a([bc]*)(c+d)/ && $2', "CD", 're_tests 545/2 (707)');
is(eval '"ADCDCDE" ~~ rx:perl5/(?i)a[bcd]*dcdcde/ && $0', "ADCDCDE", 're_tests 547/0 (711)');
ok(eval 'not ("ADCDCDE" ~~ rx:perl5/(?i)a[bcd]+dcdcde/)', 're_tests 549  (713)');
is(eval '"ABC" ~~ rx:perl5/(?i)(ab|a)b*c/ && $0', "ABC", 're_tests 551/0 (715)');
is(eval '"ABC" ~~ rx:perl5/(?i)(ab|a)b*c/ && $1', "AB", 're_tests 551/1 (716)');
is(eval '"ALPHA" ~~ rx:perl5/(?i)[a-zA-Z_][a-zA-Z0-9_]*/ && $0', "ALPHA", 're_tests 553/0 (719)');
is(eval '"ABH" ~~ rx:perl5/(?i)^a(bc+|b[eh])g|.h$/ && $0', "BH", 're_tests 555/0 (721)');
is(eval '"ABH" ~~ rx:perl5/(?i)^a(bc+|b[eh])g|.h$/ && $1', "", 're_tests 555/1 (722)');
is(eval '"EFFGZ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $0', "EFFGZ", 're_tests 557/0 (725)');
is(eval '"EFFGZ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $1', "EFFGZ", 're_tests 557/1 (726)');
is(eval '"EFFGZ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $2', "", 're_tests 557/2 (727)');
is(eval '"IJ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $0', "IJ", 're_tests 559/0 (731)');
is(eval '"IJ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $1', "IJ", 're_tests 559/1 (732)');
is(eval '"IJ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $2', "J", 're_tests 559/2 (733)');
ok(eval 'not ("EFFG" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/)', 're_tests 561  (737)');
ok(eval 'not ("BCDD" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/)', 're_tests 563  (739)');
is(eval '"REFFGZ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $0', "EFFGZ", 're_tests 565/0 (741)');
is(eval '"REFFGZ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $1', "EFFGZ", 're_tests 565/1 (742)');
is(eval '"REFFGZ" ~~ rx:perl5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $2', "", 're_tests 565/2 (743)');
is(eval '"A" ~~ rx:perl5/(?i)((((((((((a))))))))))/ && $10', "A", 're_tests 567/10 (747)');
is(eval '"AA" ~~ rx:perl5/(?i)((((((((((a))))))))))\10/ && $0', "AA", 're_tests 569/0 (749)');
ok(eval 'not ("AA" ~~ rx:perl5/(?i)((((((((((a))))))))))${bang}/)', 're_tests 571  (751)', :todo(1));
is(eval '"A!" ~~ rx:perl5/(?i)((((((((((a))))))))))${bang}/ && $0', "A!", 're_tests 572/0 (752)', :todo(1));
is(eval '"A" ~~ rx:perl5/(?i)(((((((((a)))))))))/ && $0', "A", 're_tests 573/0 (753)');
is(eval '"A" ~~ rx:perl5/(?i)(?:(?:(?:(?:(?:(?:(?:(?:(?:(a))))))))))/ && $1', "A", 're_tests 575/1 (755)');
is(eval '"C" ~~ rx:perl5/(?i)(?:(?:(?:(?:(?:(?:(?:(?:(?:(a|b|c))))))))))/ && $1', "C", 're_tests 577/1 (757)');
ok(eval 'not ("UH-UH" ~~ rx:perl5/(?i)multiple words of text/)', 're_tests 579  (759)');
is(eval '"MULTIPLE WORDS, YEAH" ~~ rx:perl5/(?i)multiple words/ && $0', "MULTIPLE WORDS", 're_tests 581/0 (761)');
is(eval '"ABCDE" ~~ rx:perl5/(?i)(.*)c(.*)/ && $0', "ABCDE", 're_tests 583/0 (763)');
is(eval '"ABCDE" ~~ rx:perl5/(?i)(.*)c(.*)/ && $1', "AB", 're_tests 583/1 (764)');
is(eval '"ABCDE" ~~ rx:perl5/(?i)(.*)c(.*)/ && $2', "DE", 're_tests 583/2 (765)');
ok(eval 'not ("AB" ~~ rx:perl5/(?i)[k]/)', 're_tests 585  (769)');
is(eval '"AC" ~~ rx:perl5/(?i)a[-]?c/ && $0', "AC", 're_tests 587/0 (771)');
is(eval '"ABCABC" ~~ rx:perl5/(?i)(abc)\1/ && $1', "ABC", 're_tests 589/1 (773)');
is(eval '"ABCABC" ~~ rx:perl5/(?i)([a-c]*)\1/ && $1', "ABC", 're_tests 591/1 (775)');
is(eval '"abad" ~~ rx:perl5/a(?!b)./ && $0', "ad", 're_tests 593/0 (777)');
is(eval '"abad" ~~ rx:perl5/a(?=d)./ && $0', "ad", 're_tests 595/0 (779)');
is(eval '"abad" ~~ rx:perl5/a(?=c|d)./ && $0', "ad", 're_tests 597/0 (781)');
is(eval '"ace" ~~ rx:perl5/a(?:b|c|d)(.)/ && $1', "e", 're_tests 599/1 (783)');
is(eval '"ace" ~~ rx:perl5/a(?:b|c|d)*(.)/ && $1', "e", 're_tests 601/1 (785)');
is(eval '"ace" ~~ rx:perl5/a(?:b|c|d)+?(.)/ && $1', "e", 're_tests 603/1 (787)');
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d)+?(.)/ && $1', "d", 're_tests 605/1 (789)');
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d)+(.)/ && $1', "e", 're_tests 607/1 (791)');
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){2}(.)/ && $1', "b", 're_tests 609/1 (793)', :todo(1));
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){4,5}(.)/ && $1', "b", 're_tests 611/1 (795)', :todo(1));
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){4,5}?(.)/ && $1', "d", 're_tests 613/1 (797)', :todo(1));
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){6,7}(.)/ && $1', "e", 're_tests 615/1 (799)', :todo(1));
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){6,7}?(.)/ && $1', "e", 're_tests 617/1 (801)', :todo(1));
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){5,6}(.)/ && $1', "e", 're_tests 619/1 (803)', :todo(1));
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){5,6}?(.)/ && $1', "b", 're_tests 621/1 (805)', :todo(1));
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){5,7}(.)/ && $1', "e", 're_tests 623/1 (807)', :todo(1));
is(eval '"acdbcdbe" ~~ rx:perl5/a(?:b|c|d){5,7}?(.)/ && $1', "b", 're_tests 625/1 (809)', :todo(1));
is(eval '"AB" ~~ rx:perl5/^(.+)?B/ && $1', "A", 're_tests 627/1 (811)');
is(eval '"." ~~ rx:perl5/^([^a-z])|(\^)$/ && $1', ".", 're_tests 629/1 (813)');
is(eval '"<&OUT" ~~ rx:perl5/^[<>]&/ && $0', "<&", 're_tests 631/0 (815)');
is(eval '"aaaaaaaaaa" ~~ rx:perl5/^(a\1?){4}$/ && $1', "aaaa", 're_tests 633/1 (817)', :todo(1));
ok(eval 'not ("aaaaaaaaa" ~~ rx:perl5/^(a\1?){4}$/)', 're_tests 635  (819)');
ok(eval 'not ("aaaaaaaaaaa" ~~ rx:perl5/^(a\1?){4}$/)', 're_tests 637  (821)');
is(eval '"aaaaaaaaaa" ~~ rx:perl5/^(a(?(1)\1)){4}$/ && $1', "aaaa", 're_tests 639/1 (823)', :todo(1));
ok(eval 'not ("aaaaaaaaa" ~~ rx:perl5/^(a(?(1)\1)){4}$/)', 're_tests 641  (825)');
ok(eval 'not ("aaaaaaaaaaa" ~~ rx:perl5/^(a(?(1)\1)){4}$/)', 're_tests 643  (827)');
is(eval '"aaaaaaaaa" ~~ rx:perl5/((a{4})+)/ && $1', "aaaaaaaa", 're_tests 645/1 (829)', :todo(1));
is(eval '"aaaaaaaaaa" ~~ rx:perl5/(((aa){2})+)/ && $1', "aaaaaaaa", 're_tests 647/1 (831)', :todo(1));
is(eval '"aaaaaaaaaa" ~~ rx:perl5/(((a{2}){2})+)/ && $1', "aaaaaaaa", 're_tests 649/1 (833)', :todo(1));
is(eval '"ab" ~~ rx:perl5/(?<=a)b/ && $0', "b", 're_tests 651/0 (835)');
ok(eval 'not ("cb" ~~ rx:perl5/(?<=a)b/)', 're_tests 653  (837)');
ok(eval 'not ("b" ~~ rx:perl5/(?<=a)b/)', 're_tests 655  (839)');
is(eval '"ab" ~~ rx:perl5/(?<!c)b/ && $0', "b", 're_tests 657/0 (841)');
ok(eval 'not ("cb" ~~ rx:perl5/(?<!c)b/)', 're_tests 659  (843)');
ok(eval '"b" ~~ rx:perl5/(?<!c)b/', 're_tests 661  (845)');
is(eval '"b" ~~ rx:perl5/(?<!c)b/ && $0', "b", 're_tests 663/0 (847)');
is(eval '"aba" ~~ rx:perl5/(?:..)*a/ && $0', "aba", 're_tests 665/0 (849)');
is(eval '"aba" ~~ rx:perl5/(?:..)*?a/ && $0', "a", 're_tests 667/0 (851)');
is(eval '"abc" ~~ rx:perl5/^(?:b|a(?=(.)))*\1/ && $0', "ab", 're_tests 669/0 (853)');
is(eval '"aax" ~~ rx:perl5/^(a+)*ax/ && $1', "a", 're_tests 671/1 (855)');
is(eval '"aax" ~~ rx:perl5/^((a|b)+)*ax/ && $1', "a", 're_tests 673/1 (857)');
is(eval '"aax" ~~ rx:perl5/^((a|bc)+)*ax/ && $1', "a", 're_tests 675/1 (859)');
is(eval '"ab" ~~ rx:perl5/(?:(?i)a)b/ && $0', "ab", 're_tests 677/0 (861)');
is(eval '"ab" ~~ rx:perl5/((?i)a)b/ && $0', "ab", 're_tests 679/0 (863)');
is(eval '"ab" ~~ rx:perl5/((?i)a)b/ && $1', "a", 're_tests 679/1 (864)');
is(eval '"Ab" ~~ rx:perl5/(?:(?i)a)b/ && $0', "Ab", 're_tests 681/0 (867)');
is(eval '"Ab" ~~ rx:perl5/((?i)a)b/ && $0', "Ab", 're_tests 683/0 (869)');
is(eval '"Ab" ~~ rx:perl5/((?i)a)b/ && $1', "A", 're_tests 683/1 (870)');
ok(eval 'not ("aB" ~~ rx:perl5/(?:(?i)a)b/)', 're_tests 685  (873)');
ok(eval 'not ("aB" ~~ rx:perl5/((?i)a)b/)', 're_tests 687  (875)');
is(eval '"ab" ~~ rx:perl5/(?i:a)b/ && $0', "ab", 're_tests 689/0 (877)');
is(eval '"ab" ~~ rx:perl5/((?i:a))b/ && $0', "ab", 're_tests 691/0 (879)');
is(eval '"ab" ~~ rx:perl5/((?i:a))b/ && $1', "a", 're_tests 691/1 (880)');
is(eval '"Ab" ~~ rx:perl5/(?i:a)b/ && $0', "Ab", 're_tests 693/0 (883)');
is(eval '"Ab" ~~ rx:perl5/((?i:a))b/ && $0', "Ab", 're_tests 695/0 (885)');
is(eval '"Ab" ~~ rx:perl5/((?i:a))b/ && $1', "A", 're_tests 695/1 (886)');
ok(eval 'not ("aB" ~~ rx:perl5/(?i:a)b/)', 're_tests 697  (889)');
ok(eval 'not ("aB" ~~ rx:perl5/((?i:a))b/)', 're_tests 699  (891)');
is(eval '"ab" ~~ rx:perl5/(?i)(?:(?-i)a)b/ && $0', "ab", 're_tests 701/0 (893)');
is(eval '"ab" ~~ rx:perl5/(?i)((?-i)a)b/ && $0', "ab", 're_tests 702/0 (894)');
is(eval '"ab" ~~ rx:perl5/(?i)((?-i)a)b/ && $1', "a", 're_tests 702/1 (895)');
is(eval '"aB" ~~ rx:perl5/(?i)(?:(?-i)a)b/ && $0', "aB", 're_tests 703/0 (896)');
is(eval '"aB" ~~ rx:perl5/(?i)((?-i)a)b/ && $0', "aB", 're_tests 704/0 (897)');
is(eval '"aB" ~~ rx:perl5/(?i)((?-i)a)b/ && $1', "a", 're_tests 704/1 (898)');
ok(eval 'not ("Ab" ~~ rx:perl5/(?i)(?:(?-i)a)b/)', 're_tests 705  (899)');
ok(eval 'not ("Ab" ~~ rx:perl5/(?i)((?-i)a)b/)', 're_tests 706  (900)');
is(eval '"aB" ~~ rx:perl5/(?i)(?:(?-i)a)b/ && $0', "aB", 're_tests 707/0 (901)');
is(eval '"aB" ~~ rx:perl5/(?i)((?-i)a)b/ && $1', "a", 're_tests 708/1 (902)');
ok(eval 'not ("AB" ~~ rx:perl5/(?i)(?:(?-i)a)b/)', 're_tests 709  (903)');
ok(eval 'not ("AB" ~~ rx:perl5/(?i)((?-i)a)b/)', 're_tests 710  (904)');
is(eval '"ab" ~~ rx:perl5/(?i)(?-i:a)b/ && $0', "ab", 're_tests 711/0 (905)');
is(eval '"ab" ~~ rx:perl5/(?i)((?-i:a))b/ && $0', "ab", 're_tests 712/0 (906)');
is(eval '"ab" ~~ rx:perl5/(?i)((?-i:a))b/ && $1', "a", 're_tests 712/1 (907)');
is(eval '"aB" ~~ rx:perl5/(?i)(?-i:a)b/ && $0', "aB", 're_tests 713/0 (908)');
is(eval '"aB" ~~ rx:perl5/(?i)((?-i:a))b/ && $0', "aB", 're_tests 714/0 (909)');
is(eval '"aB" ~~ rx:perl5/(?i)((?-i:a))b/ && $1', "a", 're_tests 714/1 (910)');
ok(eval 'not ("Ab" ~~ rx:perl5/(?i)(?-i:a)b/)', 're_tests 715  (911)');
ok(eval 'not ("Ab" ~~ rx:perl5/(?i)((?-i:a))b/)', 're_tests 716  (912)');
is(eval '"aB" ~~ rx:perl5/(?i)(?-i:a)b/ && $0', "aB", 're_tests 717/0 (913)');
is(eval '"aB" ~~ rx:perl5/(?i)((?-i:a))b/ && $1', "a", 're_tests 718/1 (914)');
ok(eval 'not ("AB" ~~ rx:perl5/(?i)(?-i:a)b/)', 're_tests 719  (915)');
ok(eval 'not ("AB" ~~ rx:perl5/(?i)((?-i:a))b/)', 're_tests 720  (916)');
ok(eval 'not ("a\nB" ~~ rx:perl5/(?i)((?-i:a.))b/)', 're_tests 721  (917)');
is(eval '"a\nB" ~~ rx:perl5/(?i)((?s-i:a.))b/ && $1', "a\n", 're_tests 722/1 (918)');
ok(eval 'not ("B\nB" ~~ rx:perl5/(?i)((?s-i:a.))b/)', 're_tests 723  (919)');
is(eval '"cabbbb" ~~ rx:perl5/(?:c|d)(?:)(?:a(?:)(?:b)(?:b(?:))(?:b(?:)(?:b)))/ && $0', "cabbbb", 're_tests 724/0 (920)');
is(eval '"caaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb" ~~ rx:perl5/(?:c|d)(?:)(?:aaaaaaaa(?:)(?:bbbbbbbb)(?:bbbbbbbb(?:))(?:bbbbbbbb(?:)(?:bbbbbbbb)))/ && $0', "caaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb", 're_tests 726/0 (922)');
is(eval '"Ab4ab" ~~ rx:perl5/(?i)(ab)\d\1/ && $1', "Ab", 're_tests 728/1 (924)');
is(eval '"ab4Ab" ~~ rx:perl5/(?i)(ab)\d\1/ && $1', "ab", 're_tests 730/1 (926)');
is(eval '"foobar1234baz" ~~ rx:perl5/foo\w*\d{4}baz/ && $0', "foobar1234baz", 're_tests 732/0 (928)');
#todo_is(eval '"cabd" ~~ rx:perl5/a(?{})b/ && $0', "ab", 're_tests 734/0 (930)');
#todo_is(eval '"cabd" ~~ rx:perl5/a(?{"\{"})b/ && $0', "ab", 're_tests 735/0 (931)');
ok(eval '"x~~" ~~ rx:perl5/x(~~)*(?:(?:F)?)?/', 're_tests 736  (932)');
is(eval '"aaac" ~~ rx:perl5/^a(?#xxx){3}c/ && $0', "aaac", 're_tests 738/0 (934)', :todo(1));
is(eval '"aaac" ~~ rx:perl5/(?x)^a (?#xxx) (?#yyy) {3}c/ && $0', "aaac", 're_tests 739/0 (935)', :todo(1));
ok(eval 'not ("dbcb" ~~ rx:perl5/(?<![cd])b/)', 're_tests 740  (936)');
is(eval '"dbaacb" ~~ rx:perl5/(?<![cd])[ab]/ && $0', "a", 're_tests 742/0 (938)');
ok(eval 'not ("dbcb" ~~ rx:perl5/(?<!(c|d))b/)', 're_tests 744  (940)');
is(eval '"dbaacb" ~~ rx:perl5/(?<!(c|d))[ab]/ && $0', "a", 're_tests 746/0 (942)');
is(eval '"cdaccb" ~~ rx:perl5/(?<!cd)[ab]/ && $0', "b", 're_tests 748/0 (944)');
ok(eval 'not ("a--" ~~ rx:perl5/^(?:a?b?)*$/)', 're_tests 750  (946)');
is(eval '"a\nb\nc\n" ~~ rx:perl5/((?m)^b$)/ && $1', "b", 're_tests 752/1 (948)');
is(eval '"a\nb\n" ~~ rx:perl5/(?m)^b/ && $0', "b", 're_tests 753/0 (949)');
is(eval '"a\nb\n" ~~ rx:perl5/(?m)^(b)/ && $1', "b", 're_tests 754/1 (950)');
is(eval '"a\nb\n" ~~ rx:perl5/((?m)^b)/ && $1', "b", 're_tests 755/1 (951)');
is(eval '"a\nb\n" ~~ rx:perl5/\n((?m)^b)/ && $1', "b", 're_tests 756/1 (952)');
is(eval '"a\nb\nc\n" ~~ rx:perl5/((?s).)c(?!.)/ && $1', "\n", 're_tests 757/1 (953)');
is(eval '"a\nb\nc\n" ~~ rx:perl5/((?s)b.)c(?!.)/ && $1', "b\n", 're_tests 758/1 (954)');
ok(eval 'not ("a\nb\nc\n" ~~ rx:perl5/^b/)', 're_tests 759  (955)');
ok(eval 'not ("a\nb\nc\n" ~~ rx:perl5/()^b/)', 're_tests 761  (957)');
is(eval '"a\nb\nc\n" ~~ rx:perl5/((?m)^b)/ && $1', "b", 're_tests 763/1 (959)');
ok(eval 'not ("a" ~~ rx:perl5/(?(1)a|b)/)', 're_tests 764  (960)');
is(eval '"a" ~~ rx:perl5/(?(1)b|a)/ && $0', "a", 're_tests 766/0 (962)');
ok(eval 'not ("a" ~~ rx:perl5/(x)?(?(1)a|b)/)', 're_tests 768  (964)');
is(eval '"a" ~~ rx:perl5/(x)?(?(1)b|a)/ && $0', "a", 're_tests 770/0 (966)');
is(eval '"a" ~~ rx:perl5/()?(?(1)b|a)/ && $0', "a", 're_tests 772/0 (968)');
ok(eval 'not ("a" ~~ rx:perl5/()(?(1)b|a)/)', 're_tests 774  (970)');
is(eval '"a" ~~ rx:perl5/()?(?(1)a|b)/ && $0', "a", 're_tests 776/0 (972)');
is(eval '"(blah)" ~~ rx:perl5/^(\()?blah(?(1)(\)))$/ && $2', ")", 're_tests 778/2 (974)');
ok(eval 'not ("blah)" ~~ rx:perl5/^(\()?blah(?(1)(\)))$/)', 're_tests 780  (976)');
ok(eval 'not ("(blah" ~~ rx:perl5/^(\()?blah(?(1)(\)))$/)', 're_tests 782  (978)');
is(eval '"(blah)" ~~ rx:perl5/^(\(+)?blah(?(1)(\)))$/ && $2', ")", 're_tests 784/2 (980)');
ok(eval 'not ("blah)" ~~ rx:perl5/^(\(+)?blah(?(1)(\)))$/)', 're_tests 786  (982)');
ok(eval 'not ("(blah" ~~ rx:perl5/^(\(+)?blah(?(1)(\)))$/)', 're_tests 788  (984)');
#todo_ok(eval 'not ("a" ~~ rx:perl5/(?(?{0})a|b)/)', 're_tests 790  (986)');
#todo_is(eval '"a" ~~ rx:perl5/(?(?{0})b|a)/ && $0', "a", 're_tests 791/0 (987)');
#todo_ok(eval 'not ("a" ~~ rx:perl5/(?(?{1})b|a)/)', 're_tests 792  (988)');
#todo_is(eval '"a" ~~ rx:perl5/(?(?{1})a|b)/ && $0', "a", 're_tests 793/0 (989)');
ok(eval 'not ("a" ~~ rx:perl5/(?(?!a)a|b)/)', 're_tests 794  (990)');
is(eval '"a" ~~ rx:perl5/(?(?!a)b|a)/ && $0', "a", 're_tests 795/0 (991)');
ok(eval 'not ("a" ~~ rx:perl5/(?(?=a)b|a)/)', 're_tests 796  (992)');
is(eval '"a" ~~ rx:perl5/(?(?=a)a|b)/ && $0', "a", 're_tests 797/0 (993)');
is(eval '"aaab" ~~ rx:perl5/(?=(a+?))(\1ab)/ && $2', "aab", 're_tests 798/2 (994)');
ok(eval 'not ("aaab" ~~ rx:perl5/^(?=(a+?))\1ab/)', 're_tests 800  (996)');
is(eval '"one:" ~~ rx:perl5/(\w+:)+/ && $1', "one:", 're_tests 802/1 (998)');
is(eval '"a" ~~ rx:perl5/$(?<=^(a))/ && $1', "a", 're_tests 804/1 (1000)');
is(eval '"aaab" ~~ rx:perl5/(?=(a+?))(\1ab)/ && $2', "aab", 're_tests 806/2 (1002)');
ok(eval 'not ("aaab" ~~ rx:perl5/^(?=(a+?))\1ab/)', 're_tests 808  (1004)');
ok(eval 'not ("abcd:" ~~ rx:perl5/([\w:]+::)?(\w+)$/)', 're_tests 810  (1006)');
is(eval '"abcd" ~~ rx:perl5/([\w:]+::)?(\w+)$/ && $1', "", 're_tests 812/1 (1008)');
is(eval '"abcd" ~~ rx:perl5/([\w:]+::)?(\w+)$/ && $2', "abcd", 're_tests 812/2 (1009)');
is(eval '"xy:z:::abcd" ~~ rx:perl5/([\w:]+::)?(\w+)$/ && $1', "xy:z:::", 're_tests 814/1 (1012)');
is(eval '"xy:z:::abcd" ~~ rx:perl5/([\w:]+::)?(\w+)$/ && $2', "abcd", 're_tests 814/2 (1013)');
is(eval '"aexycd" ~~ rx:perl5/^[^bcd]*(c+)/ && $1', "c", 're_tests 816/1 (1016)');
is(eval '"caab" ~~ rx:perl5/(a*)b+/ && $1', "aa", 're_tests 818/1 (1018)');
ok(eval 'not ("abcd:" ~~ rx:perl5/([\w:]+::)?(\w+)$/)', 're_tests 820  (1020)');
is(eval '"abcd" ~~ rx:perl5/([\w:]+::)?(\w+)$/ && $1', "", 're_tests 822/1 (1022)');
is(eval '"abcd" ~~ rx:perl5/([\w:]+::)?(\w+)$/ && $2', "abcd", 're_tests 822/2 (1023)');
is(eval '"xy:z:::abcd" ~~ rx:perl5/([\w:]+::)?(\w+)$/ && $1', "xy:z:::", 're_tests 824/1 (1026)');
is(eval '"xy:z:::abcd" ~~ rx:perl5/([\w:]+::)?(\w+)$/ && $2', "abcd", 're_tests 824/2 (1027)');
is(eval '"aexycd" ~~ rx:perl5/^[^bcd]*(c+)/ && $1', "c", 're_tests 826/1 (1030)');
ok(eval 'not ("aaab" ~~ rx:perl5/(>a+)ab/)', 're_tests 828  (1032)');
ok(eval '"aaab" ~~ rx:perl5/(?>a+)b/', 're_tests 829  (1033)');
is(eval '"a:[b]:" ~~ rx:perl5/([[:]+)/ && $1', ":[", 're_tests 831/1 (1035)');
is(eval '"a=[b]=" ~~ rx:perl5/([[=]+)/ && $1', "=[", 're_tests 832/1 (1036)');
is(eval '"a.[b]." ~~ rx:perl5/([[.]+)/ && $1', ".[", 're_tests 833/1 (1037)');
is(eval '"abc" ~~ rx:perl5/[a[:]b[:c]/ && $0', "abc", 're_tests 834/0 (1038)');
is(eval '"abc" ~~ rx:perl5/[a[:]b[:c]/ && $0', "abc", 're_tests 835/0 (1039)');
is(eval '"aaab" ~~ rx:perl5/((?>a+)b)/ && $1', "aaab", 're_tests 836/1 (1040)');
is(eval '"aaab" ~~ rx:perl5/(?>(a+))b/ && $1', "aaa", 're_tests 838/1 (1042)');
is(eval '"((abc(ade)ufh()()x" ~~ rx:perl5/((?>[^()]+)|\([^()]*\))+/ && $0', "abc(ade)ufh()()x", 're_tests 840/0 (1044)');
is(eval '"a\nb\n" ~~ rx:perl5/\Z/ && getpos($/, 0)', 3, 're_tests 842/0 (1046)', :todo(1));
is(eval '"a\nb\n" ~~ rx:perl5/\z/ && getpos($/, 0)', 4, 're_tests 844/0 (1048)', :todo(1));
is(eval '"a\nb\n" ~~ rx:perl5/$/ && getpos($/, 0)', 3, 're_tests 846/0 (1050)', :todo(1));
is(eval '"b\na\n" ~~ rx:perl5/\Z/ && getpos($/, 0)', 3, 're_tests 847/0 (1051)', :todo(1));
is(eval '"b\na\n" ~~ rx:perl5/\z/ && getpos($/, 0)', 4, 're_tests 849/0 (1053)', :todo(1));
is(eval '"b\na\n" ~~ rx:perl5/$/ && getpos($/, 0)', 3, 're_tests 851/0 (1055)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/\Z/ && getpos($/, 0)', 3, 're_tests 852/0 (1056)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/\z/ && getpos($/, 0)', 3, 're_tests 854/0 (1058)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/$/ && getpos($/, 0)', 3, 're_tests 856/0 (1060)', :todo(1));
is(eval '"a\nb\n" ~~ rx:perl5/(?m)\Z/ && getpos($/, 0)', 3, 're_tests 857/0 (1061)', :todo(1));
is(eval '"a\nb\n" ~~ rx:perl5/(?m)\z/ && getpos($/, 0)', 4, 're_tests 858/0 (1062)', :todo(1));
is(eval '"a\nb\n" ~~ rx:perl5/(?m)$/ && getpos($/, 0)', 1, 're_tests 859/0 (1063)', :todo(1));
is(eval '"b\na\n" ~~ rx:perl5/(?m)\Z/ && getpos($/, 0)', 3, 're_tests 860/0 (1064)', :todo(1));
is(eval '"b\na\n" ~~ rx:perl5/(?m)\z/ && getpos($/, 0)', 4, 're_tests 861/0 (1065)', :todo(1));
is(eval '"b\na\n" ~~ rx:perl5/(?m)$/ && getpos($/, 0)', 1, 're_tests 862/0 (1066)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/(?m)\Z/ && getpos($/, 0)', 3, 're_tests 863/0 (1067)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/(?m)\z/ && getpos($/, 0)', 3, 're_tests 864/0 (1068)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/(?m)$/ && getpos($/, 0)', 1, 're_tests 865/0 (1069)', :todo(1));
ok(eval 'not ("a\nb\n" ~~ rx:perl5/a\Z/)', 're_tests 866  (1070)');
ok(eval 'not ("a\nb\n" ~~ rx:perl5/a\z/)', 're_tests 868  (1072)');
ok(eval 'not ("a\nb\n" ~~ rx:perl5/a$/)', 're_tests 870  (1074)');
is(eval '"b\na\n" ~~ rx:perl5/a\Z/ && getpos($/, 0)', 2, 're_tests 871/0 (1075)', :todo(1));
ok(eval 'not ("b\na\n" ~~ rx:perl5/a\z/)', 're_tests 873  (1077)');
is(eval '"b\na\n" ~~ rx:perl5/a$/ && getpos($/, 0)', 2, 're_tests 875/0 (1079)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/a\Z/ && getpos($/, 0)', 2, 're_tests 876/0 (1080)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/a\z/ && getpos($/, 0)', 2, 're_tests 878/0 (1082)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/a$/ && getpos($/, 0)', 2, 're_tests 880/0 (1084)', :todo(1));
ok(eval 'not ("a\nb\n" ~~ rx:perl5/(?m)a\Z/)', 're_tests 881  (1085)');
ok(eval 'not ("a\nb\n" ~~ rx:perl5/(?m)a\z/)', 're_tests 882  (1086)');
is(eval '"a\nb\n" ~~ rx:perl5/(?m)a$/ && getpos($/, 0)', 0, 're_tests 883/0 (1087)', :todo(1));
is(eval '"b\na\n" ~~ rx:perl5/(?m)a\Z/ && getpos($/, 0)', 2, 're_tests 884/0 (1088)', :todo(1));
ok(eval 'not ("b\na\n" ~~ rx:perl5/(?m)a\z/)', 're_tests 885  (1089)');
is(eval '"b\na\n" ~~ rx:perl5/(?m)a$/ && getpos($/, 0)', 2, 're_tests 886/0 (1090)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/(?m)a\Z/ && getpos($/, 0)', 2, 're_tests 887/0 (1091)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/(?m)a\z/ && getpos($/, 0)', 2, 're_tests 888/0 (1092)', :todo(1));
is(eval '"b\na" ~~ rx:perl5/(?m)a$/ && getpos($/, 0)', 2, 're_tests 889/0 (1093)', :todo(1));
ok(eval 'not ("aa\nb\n" ~~ rx:perl5/aa\Z/)', 're_tests 890  (1094)');
ok(eval 'not ("aa\nb\n" ~~ rx:perl5/aa\z/)', 're_tests 892  (1096)');
ok(eval 'not ("aa\nb\n" ~~ rx:perl5/aa$/)', 're_tests 894  (1098)');
is(eval '"b\naa\n" ~~ rx:perl5/aa\Z/ && getpos($/, 0)', 2, 're_tests 895/0 (1099)', :todo(1));
ok(eval 'not ("b\naa\n" ~~ rx:perl5/aa\z/)', 're_tests 897  (1101)');
is(eval '"b\naa\n" ~~ rx:perl5/aa$/ && getpos($/, 0)', 2, 're_tests 899/0 (1103)', :todo(1));
is(eval '"b\naa" ~~ rx:perl5/aa\Z/ && getpos($/, 0)', 2, 're_tests 900/0 (1104)', :todo(1));
is(eval '"b\naa" ~~ rx:perl5/aa\z/ && getpos($/, 0)', 2, 're_tests 902/0 (1106)', :todo(1));
is(eval '"b\naa" ~~ rx:perl5/aa$/ && getpos($/, 0)', 2, 're_tests 904/0 (1108)', :todo(1));
ok(eval 'not ("aa\nb\n" ~~ rx:perl5/(?m)aa\Z/)', 're_tests 905  (1109)');
ok(eval 'not ("aa\nb\n" ~~ rx:perl5/(?m)aa\z/)', 're_tests 906  (1110)');
is(eval '"aa\nb\n" ~~ rx:perl5/(?m)aa$/ && getpos($/, 0)', 0, 're_tests 907/0 (1111)', :todo(1));
is(eval '"b\naa\n" ~~ rx:perl5/(?m)aa\Z/ && getpos($/, 0)', 2, 're_tests 908/0 (1112)', :todo(1));
ok(eval 'not ("b\naa\n" ~~ rx:perl5/(?m)aa\z/)', 're_tests 909  (1113)');
is(eval '"b\naa\n" ~~ rx:perl5/(?m)aa$/ && getpos($/, 0)', 2, 're_tests 910/0 (1114)', :todo(1));
is(eval '"b\naa" ~~ rx:perl5/(?m)aa\Z/ && getpos($/, 0)', 2, 're_tests 911/0 (1115)', :todo(1));
is(eval '"b\naa" ~~ rx:perl5/(?m)aa\z/ && getpos($/, 0)', 2, 're_tests 912/0 (1116)', :todo(1));
is(eval '"b\naa" ~~ rx:perl5/(?m)aa$/ && getpos($/, 0)', 2, 're_tests 913/0 (1117)', :todo(1));
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/aa\Z/)', 're_tests 914  (1118)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/aa\z/)', 're_tests 916  (1120)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/aa$/)', 're_tests 918  (1122)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/aa\Z/)', 're_tests 919  (1123)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/aa\z/)', 're_tests 921  (1125)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/aa$/)', 're_tests 923  (1127)');
ok(eval 'not ("b\nac" ~~ rx:perl5/aa\Z/)', 're_tests 924  (1128)');
ok(eval 'not ("b\nac" ~~ rx:perl5/aa\z/)', 're_tests 926  (1130)');
ok(eval 'not ("b\nac" ~~ rx:perl5/aa$/)', 're_tests 928  (1132)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)aa\Z/)', 're_tests 929  (1133)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)aa\z/)', 're_tests 930  (1134)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)aa$/)', 're_tests 931  (1135)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)aa\Z/)', 're_tests 932  (1136)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)aa\z/)', 're_tests 933  (1137)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)aa$/)', 're_tests 934  (1138)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)aa\Z/)', 're_tests 935  (1139)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)aa\z/)', 're_tests 936  (1140)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)aa$/)', 're_tests 937  (1141)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/aa\Z/)', 're_tests 938  (1142)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/aa\z/)', 're_tests 940  (1144)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/aa$/)', 're_tests 942  (1146)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/aa\Z/)', 're_tests 943  (1147)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/aa\z/)', 're_tests 945  (1149)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/aa$/)', 're_tests 947  (1151)');
ok(eval 'not ("b\nca" ~~ rx:perl5/aa\Z/)', 're_tests 948  (1152)');
ok(eval 'not ("b\nca" ~~ rx:perl5/aa\z/)', 're_tests 950  (1154)');
ok(eval 'not ("b\nca" ~~ rx:perl5/aa$/)', 're_tests 952  (1156)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)aa\Z/)', 're_tests 953  (1157)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)aa\z/)', 're_tests 954  (1158)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)aa$/)', 're_tests 955  (1159)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)aa\Z/)', 're_tests 956  (1160)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)aa\z/)', 're_tests 957  (1161)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)aa$/)', 're_tests 958  (1162)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)aa\Z/)', 're_tests 959  (1163)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)aa\z/)', 're_tests 960  (1164)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)aa$/)', 're_tests 961  (1165)');
ok(eval 'not ("ab\nb\n" ~~ rx:perl5/ab\Z/)', 're_tests 962  (1166)');
ok(eval 'not ("ab\nb\n" ~~ rx:perl5/ab\z/)', 're_tests 964  (1168)');
ok(eval 'not ("ab\nb\n" ~~ rx:perl5/ab$/)', 're_tests 966  (1170)');
is(eval '"b\nab\n" ~~ rx:perl5/ab\Z/ && getpos($/, 0)', 2, 're_tests 967/0 (1171)', :todo(1));
ok(eval 'not ("b\nab\n" ~~ rx:perl5/ab\z/)', 're_tests 969  (1173)');
is(eval '"b\nab\n" ~~ rx:perl5/ab$/ && getpos($/, 0)', 2, 're_tests 971/0 (1175)', :todo(1));
is(eval '"b\nab" ~~ rx:perl5/ab\Z/ && getpos($/, 0)', 2, 're_tests 972/0 (1176)', :todo(1));
is(eval '"b\nab" ~~ rx:perl5/ab\z/ && getpos($/, 0)', 2, 're_tests 974/0 (1178)', :todo(1));
is(eval '"b\nab" ~~ rx:perl5/ab$/ && getpos($/, 0)', 2, 're_tests 976/0 (1180)', :todo(1));
ok(eval 'not ("ab\nb\n" ~~ rx:perl5/(?m)ab\Z/)', 're_tests 977  (1181)');
ok(eval 'not ("ab\nb\n" ~~ rx:perl5/(?m)ab\z/)', 're_tests 978  (1182)');
is(eval '"ab\nb\n" ~~ rx:perl5/(?m)ab$/ && getpos($/, 0)', 0, 're_tests 979/0 (1183)', :todo(1));
is(eval '"b\nab\n" ~~ rx:perl5/(?m)ab\Z/ && getpos($/, 0)', 2, 're_tests 980/0 (1184)', :todo(1));
ok(eval 'not ("b\nab\n" ~~ rx:perl5/(?m)ab\z/)', 're_tests 981  (1185)');
is(eval '"b\nab\n" ~~ rx:perl5/(?m)ab$/ && getpos($/, 0)', 2, 're_tests 982/0 (1186)', :todo(1));
is(eval '"b\nab" ~~ rx:perl5/(?m)ab\Z/ && getpos($/, 0)', 2, 're_tests 983/0 (1187)', :todo(1));
is(eval '"b\nab" ~~ rx:perl5/(?m)ab\z/ && getpos($/, 0)', 2, 're_tests 984/0 (1188)', :todo(1));
is(eval '"b\nab" ~~ rx:perl5/(?m)ab$/ && getpos($/, 0)', 2, 're_tests 985/0 (1189)', :todo(1));
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/ab\Z/)', 're_tests 986  (1190)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/ab\z/)', 're_tests 988  (1192)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/ab$/)', 're_tests 990  (1194)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/ab\Z/)', 're_tests 991  (1195)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/ab\z/)', 're_tests 993  (1197)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/ab$/)', 're_tests 995  (1199)');
ok(eval 'not ("b\nac" ~~ rx:perl5/ab\Z/)', 're_tests 996  (1200)');
ok(eval 'not ("b\nac" ~~ rx:perl5/ab\z/)', 're_tests 998  (1202)');
ok(eval 'not ("b\nac" ~~ rx:perl5/ab$/)', 're_tests 1000  (1204)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)ab\Z/)', 're_tests 1001  (1205)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)ab\z/)', 're_tests 1002  (1206)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)ab$/)', 're_tests 1003  (1207)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)ab\Z/)', 're_tests 1004  (1208)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)ab\z/)', 're_tests 1005  (1209)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)ab$/)', 're_tests 1006  (1210)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)ab\Z/)', 're_tests 1007  (1211)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)ab\z/)', 're_tests 1008  (1212)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)ab$/)', 're_tests 1009  (1213)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/ab\Z/)', 're_tests 1010  (1214)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/ab\z/)', 're_tests 1012  (1216)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/ab$/)', 're_tests 1014  (1218)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/ab\Z/)', 're_tests 1015  (1219)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/ab\z/)', 're_tests 1017  (1221)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/ab$/)', 're_tests 1019  (1223)');
ok(eval 'not ("b\nca" ~~ rx:perl5/ab\Z/)', 're_tests 1020  (1224)');
ok(eval 'not ("b\nca" ~~ rx:perl5/ab\z/)', 're_tests 1022  (1226)');
ok(eval 'not ("b\nca" ~~ rx:perl5/ab$/)', 're_tests 1024  (1228)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)ab\Z/)', 're_tests 1025  (1229)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)ab\z/)', 're_tests 1026  (1230)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)ab$/)', 're_tests 1027  (1231)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)ab\Z/)', 're_tests 1028  (1232)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)ab\z/)', 're_tests 1029  (1233)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)ab$/)', 're_tests 1030  (1234)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)ab\Z/)', 're_tests 1031  (1235)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)ab\z/)', 're_tests 1032  (1236)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)ab$/)', 're_tests 1033  (1237)');
ok(eval 'not ("abb\nb\n" ~~ rx:perl5/abb\Z/)', 're_tests 1034  (1238)');
ok(eval 'not ("abb\nb\n" ~~ rx:perl5/abb\z/)', 're_tests 1036  (1240)');
ok(eval 'not ("abb\nb\n" ~~ rx:perl5/abb$/)', 're_tests 1038  (1242)');
is(eval '"b\nabb\n" ~~ rx:perl5/abb\Z/ && getpos($/, 0)', 2, 're_tests 1039/0 (1243)', :todo(1));
ok(eval 'not ("b\nabb\n" ~~ rx:perl5/abb\z/)', 're_tests 1041  (1245)');
is(eval '"b\nabb\n" ~~ rx:perl5/abb$/ && getpos($/, 0)', 2, 're_tests 1043/0 (1247)', :todo(1));
is(eval '"b\nabb" ~~ rx:perl5/abb\Z/ && getpos($/, 0)', 2, 're_tests 1044/0 (1248)', :todo(1));
is(eval '"b\nabb" ~~ rx:perl5/abb\z/ && getpos($/, 0)', 2, 're_tests 1046/0 (1250)', :todo(1));
is(eval '"b\nabb" ~~ rx:perl5/abb$/ && getpos($/, 0)', 2, 're_tests 1048/0 (1252)', :todo(1));
ok(eval 'not ("abb\nb\n" ~~ rx:perl5/(?m)abb\Z/)', 're_tests 1049  (1253)');
ok(eval 'not ("abb\nb\n" ~~ rx:perl5/(?m)abb\z/)', 're_tests 1050  (1254)');
is(eval '"abb\nb\n" ~~ rx:perl5/(?m)abb$/ && getpos($/, 0)', 0, 're_tests 1051/0 (1255)', :todo(1));
is(eval '"b\nabb\n" ~~ rx:perl5/(?m)abb\Z/ && getpos($/, 0)', 2, 're_tests 1052/0 (1256)', :todo(1));
ok(eval 'not ("b\nabb\n" ~~ rx:perl5/(?m)abb\z/)', 're_tests 1053  (1257)');
is(eval '"b\nabb\n" ~~ rx:perl5/(?m)abb$/ && getpos($/, 0)', 2, 're_tests 1054/0 (1258)', :todo(1));
is(eval '"b\nabb" ~~ rx:perl5/(?m)abb\Z/ && getpos($/, 0)', 2, 're_tests 1055/0 (1259)', :todo(1));
is(eval '"b\nabb" ~~ rx:perl5/(?m)abb\z/ && getpos($/, 0)', 2, 're_tests 1056/0 (1260)', :todo(1));
is(eval '"b\nabb" ~~ rx:perl5/(?m)abb$/ && getpos($/, 0)', 2, 're_tests 1057/0 (1261)', :todo(1));
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/abb\Z/)', 're_tests 1058  (1262)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/abb\z/)', 're_tests 1060  (1264)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/abb$/)', 're_tests 1062  (1266)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/abb\Z/)', 're_tests 1063  (1267)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/abb\z/)', 're_tests 1065  (1269)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/abb$/)', 're_tests 1067  (1271)');
ok(eval 'not ("b\nac" ~~ rx:perl5/abb\Z/)', 're_tests 1068  (1272)');
ok(eval 'not ("b\nac" ~~ rx:perl5/abb\z/)', 're_tests 1070  (1274)');
ok(eval 'not ("b\nac" ~~ rx:perl5/abb$/)', 're_tests 1072  (1276)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)abb\Z/)', 're_tests 1073  (1277)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)abb\z/)', 're_tests 1074  (1278)');
ok(eval 'not ("ac\nb\n" ~~ rx:perl5/(?m)abb$/)', 're_tests 1075  (1279)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)abb\Z/)', 're_tests 1076  (1280)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)abb\z/)', 're_tests 1077  (1281)');
ok(eval 'not ("b\nac\n" ~~ rx:perl5/(?m)abb$/)', 're_tests 1078  (1282)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)abb\Z/)', 're_tests 1079  (1283)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)abb\z/)', 're_tests 1080  (1284)');
ok(eval 'not ("b\nac" ~~ rx:perl5/(?m)abb$/)', 're_tests 1081  (1285)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/abb\Z/)', 're_tests 1082  (1286)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/abb\z/)', 're_tests 1084  (1288)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/abb$/)', 're_tests 1086  (1290)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/abb\Z/)', 're_tests 1087  (1291)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/abb\z/)', 're_tests 1089  (1293)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/abb$/)', 're_tests 1091  (1295)');
ok(eval 'not ("b\nca" ~~ rx:perl5/abb\Z/)', 're_tests 1092  (1296)');
ok(eval 'not ("b\nca" ~~ rx:perl5/abb\z/)', 're_tests 1094  (1298)');
ok(eval 'not ("b\nca" ~~ rx:perl5/abb$/)', 're_tests 1096  (1300)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)abb\Z/)', 're_tests 1097  (1301)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)abb\z/)', 're_tests 1098  (1302)');
ok(eval 'not ("ca\nb\n" ~~ rx:perl5/(?m)abb$/)', 're_tests 1099  (1303)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)abb\Z/)', 're_tests 1100  (1304)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)abb\z/)', 're_tests 1101  (1305)');
ok(eval 'not ("b\nca\n" ~~ rx:perl5/(?m)abb$/)', 're_tests 1102  (1306)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)abb\Z/)', 're_tests 1103  (1307)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)abb\z/)', 're_tests 1104  (1308)');
ok(eval 'not ("b\nca" ~~ rx:perl5/(?m)abb$/)', 're_tests 1105  (1309)');
is(eval '"ca" ~~ rx:perl5/(^|x)(c)/ && $2', "c", 're_tests 1106/2 (1310)');
ok(eval 'not ("x" ~~ rx:perl5/a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz/)', 're_tests 1108  (1312)');
is(eval '"_I(round(xs * sz),1)" ~~ rx:perl5/round\(((?>[^()]+))\)/ && $1', "xs * sz", 're_tests 1110/1 (1314)');
ok(eval '"foo.bart" ~~ rx:perl5/foo.bart/', 're_tests 1112  (1316)');
ok(eval '"abcd\ndxxx" ~~ rx:perl5/(?m)^d[x][x][x]/', 're_tests 1114  (1318)');
ok(eval '"bbbbXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.X(.+)+X/', 're_tests 1115  (1319)', :todo(1));
ok(eval '"bbbbXcXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.X(.+)+XX/', 're_tests 1117  (1321)', :todo(1));
ok(eval '"bbbbXXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.XX(.+)+X/', 're_tests 1119  (1323)', :todo(1));
ok(eval 'not ("bbbbXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.X(.+)+X/)', 're_tests 1121  (1325)');
ok(eval 'not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.X(.+)+XX/)', 're_tests 1123  (1327)');
ok(eval 'not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.XX(.+)+X/)', 're_tests 1125  (1329)');
ok(eval '"bbbbXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.X(.+)+[X]/', 're_tests 1127  (1331)', :todo(1));
ok(eval '"bbbbXcXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.X(.+)+[X][X]/', 're_tests 1129  (1333)', :todo(1));
ok(eval '"bbbbXXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.XX(.+)+[X]/', 're_tests 1131  (1335)', :todo(1));
ok(eval 'not ("bbbbXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.X(.+)+[X]/)', 're_tests 1133  (1337)');
ok(eval 'not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.X(.+)+[X][X]/)', 're_tests 1135  (1339)');
ok(eval 'not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.XX(.+)+[X]/)', 're_tests 1137  (1341)');
ok(eval '"bbbbXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.[X](.+)+[X]/', 're_tests 1139  (1343)', :todo(1));
ok(eval '"bbbbXcXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.[X](.+)+[X][X]/', 're_tests 1141  (1345)', :todo(1));
ok(eval '"bbbbXXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.[X][X](.+)+[X]/', 're_tests 1143  (1347)', :todo(1));
ok(eval 'not ("bbbbXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.[X](.+)+[X]/)', 're_tests 1145  (1349)');
ok(eval 'not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.[X](.+)+[X][X]/)', 're_tests 1147  (1351)');
ok(eval 'not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:perl5/.[X][X](.+)+[X]/)', 're_tests 1149  (1353)');
ok(eval '"xxxtt" ~~ rx:perl5/tt+$/', 're_tests 1151  (1355)');
is(eval '"za-9z" ~~ rx:perl5/([a-\d]+)/ && $1', "a-9", 're_tests 1153/1 (1357)');
is(eval '"a0-za" ~~ rx:perl5/([\d-z]+)/ && $1', "0-z", 're_tests 1155/1 (1359)');
is(eval '"a0- z" ~~ rx:perl5/([\d-\s]+)/ && $1', "0- ", 're_tests 1157/1 (1361)');
#todo_is(eval '"za-9z" ~~ rx:perl5/([a-[:digit:]]+)/ && $1', "a-9", 're_tests 1159/1 (1363)');
#todo_is(eval '"=0-z=" ~~ rx:perl5/([[:digit:]-z]+)/ && $1', "0-z", 're_tests 1160/1 (1364)');
#todo_is(eval '"=0-z=" ~~ rx:perl5/([[:digit:]-[:alpha:]]+)/ && $1', "0-z", 're_tests 1161/1 (1365)');
ok(eval 'not ("aaaXbX" ~~ rx:perl5/\GX.*X/)', 're_tests 1162  (1366)');
is(eval '"3.1415926" ~~ rx:perl5/(\d+\.\d+)/ && $1', "3.1415926", 're_tests 1163/1 (1367)');
is(eval '"have a web browser" ~~ rx:perl5/(\ba.{0,10}br)/ && $1', "a web br", 're_tests 1165/1 (1369)', :todo(1));
ok(eval 'not ("Changes" ~~ rx:perl5/(?i)\.c(pp|xx|c)?$/)', 're_tests 1167  (1371)');
ok(eval '"IO.c" ~~ rx:perl5/(?i)\.c(pp|xx|c)?$/', 're_tests 1169  (1373)');
is(eval '"IO.c" ~~ rx:perl5/(?i)(\.c(pp|xx|c)?$)/ && $1', ".c", 're_tests 1171/1 (1375)');
ok(eval 'not ("C:/" ~~ rx:perl5/^([a-z]:)/)', 're_tests 1173  (1377)');
ok(eval '"\nx aa" ~~ rx:perl5/(?m)^\S\s+aa$/', 're_tests 1175  (1379)');
ok(eval '"ab" ~~ rx:perl5/(^|a)b/', 're_tests 1176  (1380)');
ok(eval 'not ("abcab" ~~ rx:perl5/(\w)?(abc)\1b/)', 're_tests 1178  (1382)');
ok(eval '"a,b,c" ~~ rx:perl5/^(?:.,){2}c/', 're_tests 1180  (1384)', :todo(1));
is(eval '"a,b,c" ~~ rx:perl5/^(.,){2}c/ && $1', "b,", 're_tests 1182/1 (1386)', :todo(1));
ok(eval '"a,b,c" ~~ rx:perl5/^(?:[^,]*,){2}c/', 're_tests 1184  (1388)', :todo(1));
is(eval '"a,b,c" ~~ rx:perl5/^([^,]*,){2}c/ && $1', "b,", 're_tests 1186/1 (1390)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]*,){3}d/ && $1', "c,", 're_tests 1188/1 (1392)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]*,){3,}d/ && $1', "c,", 're_tests 1190/1 (1394)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]*,){0,3}d/ && $1', "c,", 're_tests 1192/1 (1396)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{1,3},){3}d/ && $1', "c,", 're_tests 1194/1 (1398)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{1,3},){3,}d/ && $1', "c,", 're_tests 1196/1 (1400)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{1,3},){0,3}d/ && $1', "c,", 're_tests 1198/1 (1402)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{1,},){3}d/ && $1', "c,", 're_tests 1200/1 (1404)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{1,},){3,}d/ && $1', "c,", 're_tests 1202/1 (1406)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{1,},){0,3}d/ && $1', "c,", 're_tests 1204/1 (1408)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{0,3},){3}d/ && $1', "c,", 're_tests 1206/1 (1410)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{0,3},){3,}d/ && $1', "c,", 're_tests 1208/1 (1412)', :todo(1));
is(eval '"aaa,b,c,d" ~~ rx:perl5/^([^,]{0,3},){0,3}d/ && $1', "c,", 're_tests 1210/1 (1414)', :todo(1));
ok(eval '"" ~~ rx:perl5/(?i)/', 're_tests 1212  (1416)');
ok(eval '"a\nxb\n" ~~ rx:perl5/(?m)(?!\A)x/', 're_tests 1214  (1418)');
ok(eval '"123\nabcabcabcabc\n" ~~ rx:perl5/(?m)^.{9}abc.*\n/', 're_tests 1215  (1419)', :todo(1));
ok(eval 'not ("a" ~~ rx:perl5/^(a)?(?(1)a|b)+$/)', 're_tests 1216  (1420)');
is(eval '"aaaaaa" ~~ rx:perl5/^(a\1?){4}$/ && $1', "aa", 're_tests 1218/1 (1422)', :todo(1));
ok(eval '"x1" ~~ rx:perl5/^(0+)?(?:x(1))?/', 're_tests 1220  (1424)');
ok(eval '"012cxx0190" ~~ rx:perl5/^([0-9a-fA-F]+)(?:x([0-9a-fA-F]+)?)(?:x([0-9a-fA-F]+))?/', 're_tests 1222  (1426)');
is(eval '"bbbac" ~~ rx:perl5/^(b+?|a){1,2}c/ && $1', "a", 're_tests 1224/1 (1428)', :todo(1));
is(eval '"bbbbac" ~~ rx:perl5/^(b+?|a){1,2}c/ && $1', "a", 're_tests 1226/1 (1430)', :todo(1));
ok(eval '"aaaacccc" ~~ rx:perl5/((?:aaaa|bbbb)cccc)?/', 're_tests 1228  (1432)');
ok(eval '"bbbbcccc" ~~ rx:perl5/((?:aaaa|bbbb)cccc)?/', 're_tests 1230  (1434)');
is(eval '"a" ~~ rx:perl5/(a)?(a)+/ && $1', "", 're_tests 1232/1 (1436)');
is(eval '"a" ~~ rx:perl5/(a)?(a)+/ && $2', "a", 're_tests 1232/2 (1437)');
is(eval '"ab" ~~ rx:perl5/(ab)?(ab)+/ && $1', "", 're_tests 1234/1 (1440)');
is(eval '"ab" ~~ rx:perl5/(ab)?(ab)+/ && $2', "ab", 're_tests 1234/2 (1441)');
is(eval '"abc" ~~ rx:perl5/(abc)?(abc)+/ && $1', "", 're_tests 1236/1 (1444)');
is(eval '"abc" ~~ rx:perl5/(abc)?(abc)+/ && $2', "abc", 're_tests 1236/2 (1445)');
ok(eval 'not ("a\nb\n" ~~ rx:perl5/(?m)b\s^/)', 're_tests 1238  (1448)', :todo(1));
ok(eval '"a" ~~ rx:perl5/\ba/', 're_tests 1239  (1449)');
#todo_is(eval '"ab" ~~ rx:perl5/^(a(??{"(?!)"})|(a)(?{1}))b/ && $2', "a", 're_tests 1241/2 (1451)');
ok(eval 'not ("AbCd" ~~ rx:perl5/ab(?i)cd/)', 're_tests 1242  (1452)');
ok(eval '"abCd" ~~ rx:perl5/ab(?i)cd/', 're_tests 1244  (1454)');
is(eval '"CD" ~~ rx:perl5/(A|B)*(?(1)(CD)|(CD))/ && $2', "", 're_tests 1246/2 (1456)');
is(eval '"CD" ~~ rx:perl5/(A|B)*(?(1)(CD)|(CD))/ && $3', "CD", 're_tests 1246/3 (1457)');
is(eval '"ABCD" ~~ rx:perl5/(A|B)*(?(1)(CD)|(CD))/ && $2', "CD", 're_tests 1248/2 (1460)');
is(eval '"ABCD" ~~ rx:perl5/(A|B)*(?(1)(CD)|(CD))/ && $3', "", 're_tests 1248/3 (1461)');
is(eval '"CD" ~~ rx:perl5/(A|B)*?(?(1)(CD)|(CD))/ && $2', "", 're_tests 1250/2 (1464)');
is(eval '"CD" ~~ rx:perl5/(A|B)*?(?(1)(CD)|(CD))/ && $3', "CD", 're_tests 1250/3 (1465)');
is(eval '"ABCD" ~~ rx:perl5/(A|B)*?(?(1)(CD)|(CD))/ && $2', "CD", 're_tests 1252/2 (1468)');
is(eval '"ABCD" ~~ rx:perl5/(A|B)*?(?(1)(CD)|(CD))/ && $3', "", 're_tests 1252/3 (1469)');
ok(eval 'not ("Oo" ~~ rx:perl5/(?i)^(o)(?!.*\1)/)', 're_tests 1254  (1472)');
is(eval '"abc12bc" ~~ rx:perl5/(.*)\d+\1/ && $1', "bc", 're_tests 1256/1 (1474)');
is(eval '"foo\n bar" ~~ rx:perl5/(?m:(foo\s*$))/ && $1', "foo", 're_tests 1258/1 (1476)');
is(eval '"abcd" ~~ rx:perl5/(.*)c/ && $1', "ab", 're_tests 1259/1 (1477)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?=c)/ && $1', "ab", 're_tests 1261/1 (1479)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?=c)c/ && $1', "ab", 're_tests 1263/1 (1481)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?=b|c)/ && $1', "ab", 're_tests 1265/1 (1483)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?=b|c)c/ && $1', "ab", 're_tests 1267/1 (1485)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?=c|b)/ && $1', "ab", 're_tests 1269/1 (1487)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?=c|b)c/ && $1', "ab", 're_tests 1271/1 (1489)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?=[bc])/ && $1', "ab", 're_tests 1273/1 (1491)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?=[bc])c/ && $1', "ab", 're_tests 1275/1 (1493)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?<=b)/ && $1', "ab", 're_tests 1277/1 (1495)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?<=b)c/ && $1', "ab", 're_tests 1279/1 (1497)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?<=b|c)/ && $1', "abc", 're_tests 1281/1 (1499)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?<=b|c)c/ && $1', "ab", 're_tests 1283/1 (1501)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?<=c|b)/ && $1', "abc", 're_tests 1285/1 (1503)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?<=c|b)c/ && $1', "ab", 're_tests 1287/1 (1505)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?<=[bc])/ && $1', "abc", 're_tests 1289/1 (1507)');
is(eval '"abcd" ~~ rx:perl5/(.*)(?<=[bc])c/ && $1', "ab", 're_tests 1291/1 (1509)');
is(eval '"abcd" ~~ rx:perl5/(.*?)c/ && $1', "ab", 're_tests 1293/1 (1511)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?=c)/ && $1', "ab", 're_tests 1295/1 (1513)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?=c)c/ && $1', "ab", 're_tests 1297/1 (1515)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?=b|c)/ && $1', "a", 're_tests 1299/1 (1517)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?=b|c)c/ && $1', "ab", 're_tests 1301/1 (1519)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?=c|b)/ && $1', "a", 're_tests 1303/1 (1521)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?=c|b)c/ && $1', "ab", 're_tests 1305/1 (1523)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?=[bc])/ && $1', "a", 're_tests 1307/1 (1525)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?=[bc])c/ && $1', "ab", 're_tests 1309/1 (1527)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?<=b)/ && $1', "ab", 're_tests 1311/1 (1529)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?<=b)c/ && $1', "ab", 're_tests 1313/1 (1531)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?<=b|c)/ && $1', "ab", 're_tests 1315/1 (1533)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?<=b|c)c/ && $1', "ab", 're_tests 1317/1 (1535)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?<=c|b)/ && $1', "ab", 're_tests 1319/1 (1537)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?<=c|b)c/ && $1', "ab", 're_tests 1321/1 (1539)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?<=[bc])/ && $1', "ab", 're_tests 1323/1 (1541)');
is(eval '"abcd" ~~ rx:perl5/(.*?)(?<=[bc])c/ && $1', "ab", 're_tests 1325/1 (1543)');
is(eval '"2" ~~ rx:perl5/2(]*)?$\1/ && $0', "2", 're_tests 1327/0 (1545)');
#todo_ok(eval '"x" ~~ rx:perl5/(??{})/', 're_tests 1329  (1547)');
is(eval '"foobarbar" ~~ rx:perl5/^.{3,4}(.+)\1\z/ && $1', "bar", 're_tests 1330/1 (1548)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^(?:f|o|b){3,4}(.+)\1\z/ && $1', "bar", 're_tests 1332/1 (1550)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^.{3,4}((?:b|a|r)+)\1\z/ && $1', "bar", 're_tests 1334/1 (1552)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^(?:f|o|b){3,4}((?:b|a|r)+)\1\z/ && $1', "bar", 're_tests 1336/1 (1554)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^.{3,4}(.+?)\1\z/ && $1', "bar", 're_tests 1338/1 (1556)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^(?:f|o|b){3,4}(.+?)\1\z/ && $1', "bar", 're_tests 1340/1 (1558)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^.{3,4}((?:b|a|r)+?)\1\z/ && $1', "bar", 're_tests 1342/1 (1560)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^(?:f|o|b){3,4}((?:b|a|r)+?)\1\z/ && $1', "bar", 're_tests 1344/1 (1562)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^.{2,3}?(.+)\1\z/ && $1', "bar", 're_tests 1346/1 (1564)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^(?:f|o|b){2,3}?(.+)\1\z/ && $1', "bar", 're_tests 1348/1 (1566)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^.{2,3}?((?:b|a|r)+)\1\z/ && $1', "bar", 're_tests 1350/1 (1568)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^(?:f|o|b){2,3}?((?:b|a|r)+)\1\z/ && $1', "bar", 're_tests 1352/1 (1570)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^.{2,3}?(.+?)\1\z/ && $1', "bar", 're_tests 1354/1 (1572)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^(?:f|o|b){2,3}?(.+?)\1\z/ && $1', "bar", 're_tests 1356/1 (1574)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^.{2,3}?((?:b|a|r)+?)\1\z/ && $1', "bar", 're_tests 1358/1 (1576)', :todo(1));
is(eval '"foobarbar" ~~ rx:perl5/^(?:f|o|b){2,3}?((?:b|a|r)+?)\1\z/ && $1', "bar", 're_tests 1360/1 (1578)', :todo(1));
ok(eval 'not ("......abef" ~~ rx:perl5/.*a(?!(b|cd)*e).*f/)', 're_tests 1362  (1580)');
