package Google::Ads::AdWords::v201109_1::BudgetOrder;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/billing/v201109_1' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %billingAccountId_of :ATTR(:get<billingAccountId>);
my %id_of :ATTR(:get<id>);
my %spendingLimit_of :ATTR(:get<spendingLimit>);
my %startDateTime_of :ATTR(:get<startDateTime>);
my %endDateTime_of :ATTR(:get<endDateTime>);

__PACKAGE__->_factory(
    [ qw(        billingAccountId
        id
        spendingLimit
        startDateTime
        endDateTime

    ) ],
    {
        'billingAccountId' => \%billingAccountId_of,
        'id' => \%id_of,
        'spendingLimit' => \%spendingLimit_of,
        'startDateTime' => \%startDateTime_of,
        'endDateTime' => \%endDateTime_of,
    },
    {
        'billingAccountId' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'spendingLimit' => 'Google::Ads::AdWords::v201109_1::Money',
        'startDateTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'endDateTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'billingAccountId' => 'billingAccountId',
        'id' => 'id',
        'spendingLimit' => 'spendingLimit',
        'startDateTime' => 'startDateTime',
        'endDateTime' => 'endDateTime',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::BudgetOrder

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
BudgetOrder from the namespace https://adwords.google.com/api/adwords/billing/v201109_1.

A {@link BudgetOrder} links an account wide budget with a {@link BillingAccount}. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * billingAccountId


=item * id


=item * spendingLimit


=item * startDateTime


=item * endDateTime




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109_1::BudgetOrder
   billingAccountId =>  $some_value, # string
   id =>  $some_value, # long
   spendingLimit =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::Money
   startDateTime =>  $some_value, # string
   endDateTime =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

