package Google::Ads::AdWords::v201109_1::InteractionBid;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109_1' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %interactionBidAmount_of :ATTR(:get<interactionBidAmount>);
my %minimumBid_of :ATTR(:get<minimumBid>);
my %bidStatus_of :ATTR(:get<bidStatus>);
my %InteractionBid__Type_of :ATTR(:get<InteractionBid__Type>);

__PACKAGE__->_factory(
    [ qw(        interactionBidAmount
        minimumBid
        bidStatus
        InteractionBid__Type

    ) ],
    {
        'interactionBidAmount' => \%interactionBidAmount_of,
        'minimumBid' => \%minimumBid_of,
        'bidStatus' => \%bidStatus_of,
        'InteractionBid__Type' => \%InteractionBid__Type_of,
    },
    {
        'interactionBidAmount' => 'Google::Ads::AdWords::v201109_1::Bid',
        'minimumBid' => 'Google::Ads::AdWords::v201109_1::Bid',
        'bidStatus' => 'Google::Ads::AdWords::v201109_1::InteractionBid::BidStatus',
        'InteractionBid__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'interactionBidAmount' => 'interactionBidAmount',
        'minimumBid' => 'minimumBid',
        'bidStatus' => 'bidStatus',
        'InteractionBid__Type' => 'InteractionBid.Type',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::InteractionBid

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
InteractionBid from the namespace https://adwords.google.com/api/adwords/cm/v201109_1.

Abstract base type for interaction bids. Represents bids for interactions other than clicks on the ad url, such as phone calls. <span class="constraint Beta">This is a beta feature.</span> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * interactionBidAmount


=item * minimumBid


=item * bidStatus


=item * InteractionBid__Type

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 InteractionBid.Type




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109_1::InteractionBid
   interactionBidAmount =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::Bid
   minimumBid =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::Bid
   bidStatus => $some_value, # InteractionBid.BidStatus
   InteractionBid__Type =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

