#!/usr/bin/perl

package eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetNotificationPreferencesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesRequestType

=head1 DESCRIPTION

Retrieves the requesting application's notification preferences.
Details are only returned for events for which a preference was
set at one point. For example, if you enabled notification for
the EndOfAuction event and later disabled it, the GetNotificationPreferences
response would cite the EndOfAuction event preference as
Disabled. Otherwise, no details would be returned regarding EndOfAuction.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::Enum::NotificationRoleCodeType;


my @gaProperties = ( [ 'PreferenceLevel', 'ns:NotificationRoleCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::NotificationRoleCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setPreferenceLevel()

Specifies what type of Preference to retrieve.

  RequiredInput: Yes
#    Argument: 'ns:NotificationRoleCodeType'

=cut

sub setPreferenceLevel {
  my $self = shift;
  $self->{'PreferenceLevel'} = shift
}

=head2 getPreferenceLevel()

#    Returns: 'ns:NotificationRoleCodeType'

=cut

sub getPreferenceLevel {
  my $self = shift;
  return $self->{'PreferenceLevel'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
