#!/usr/bin/perl

package eBay::API::XML::Call::PlaceOffer::PlaceOfferResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PlaceOfferResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::PlaceOffer::PlaceOfferResponseType

=head1 DESCRIPTION

The PlaceOffer response notifies you about the success and result
of the call.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::PlaceOffer::PlaceOfferResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::BestOfferType;
use eBay::API::XML::DataType::SellingStatusType;


my @gaProperties = ( [ 'BestOffer', 'ns:BestOfferType', ''
	     ,'eBay::API::XML::DataType::BestOfferType', '1' ]
	, [ 'SellingStatus', 'ns:SellingStatusType', ''
	     ,'eBay::API::XML::DataType::SellingStatusType', '1' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBestOffer()

For a best-offer-related action of a buyer using PlaceOffer, 
contains information about the best-offer-related action.

#    Argument: 'ns:BestOfferType'

=cut

sub setBestOffer {
  my $self = shift;
  $self->{'BestOffer'} = shift
}

=head2 getBestOffer()

  Returned: Conditionally
#    Returns: 'ns:BestOfferType'

=cut

sub getBestOffer {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOffer'
		,'eBay::API::XML::DataType::BestOfferType');
}


=head2 setSellingStatus()

Indicates the current bidding/purchase state of the item listing, as of
the offer extended using PlaceOffer. See the schema documentation for
the SellingStatus object, the properties of which contain such
post-offer information as the current high bidder, the current price for
the item, and the bid increment.

#    Argument: 'ns:SellingStatusType'

=cut

sub setSellingStatus {
  my $self = shift;
  $self->{'SellingStatus'} = shift
}

=head2 getSellingStatus()

  Returned: Always
#    Returns: 'ns:SellingStatusType'

=cut

sub getSellingStatus {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellingStatus'
		,'eBay::API::XML::DataType::SellingStatusType');
}


=head2 setTransactionID()

The TransactionID field can be returned if, on input, you specified Purchase in the Action field. 
The TransactionID field contains the ID of the transaction created.
This field applies to the following types of listings:
FixedPriceItem and StoresFixedPrice. This field also applies to Chinese BIN 
if you specified Purchase on input.

MaxLength:  19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.) 

#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

  Returned: Conditionally
#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
