#!/usr/bin/perl

package eBay::API::XML::Call::GetSellerDashboard;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSellerDashboard.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSellerDashboard

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSellerDashboard inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetSellerDashboard::GetSellerDashboardRequestType;
use eBay::API::XML::Call::GetSellerDashboard::GetSellerDashboardResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetSellerDashboard';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSellerDashboard::GetSellerDashboardRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSellerDashboard::GetSellerDashboardResponseType';
}

#
# input properties
#



#
# output properties
#

=head2 getBuyerSatisfaction()

Rates your level of customer service. This information helps you to keep track of 
how well you are providing members with positive buying experiences.

  Returned: Conditionally
#    Returns: 'ns:BuyerSatisfactionDashboardType'

=cut
       
sub getBuyerSatisfaction {
   my $self = shift;
   return $self->getResponseDataType()->getBuyerSatisfaction();
}

=head2 getPolicyCompliance()

Rates how well you are following eBay rules and policies in your selling,
and alerts you to any account or listing policy violations.
eBay's policies are rules and guidelines that help 
to create a safe, fair, and enjoyable trading environment for all eBay members. 
If you violate certain policies, your account may be restricted
without notice. This is true even if your status shows a good level of 
policy compliance. 
Therefore, understanding and following eBay's policies can help you to avoid 
restrictions on your account. 
Your policy compliance status directly affects your PowerSeller status.

  Returned: Conditionally
#    Returns: 'ns:PolicyComplianceDashboardType'

=cut
       
sub getPolicyCompliance {
   my $self = shift;
   return $self->getResponseDataType()->getPolicyCompliance();
}

=head2 getPowerSellerStatus()

Provides information about your PowerSeller status, such as whether you meet 
PowerSeller requirements. Your PowerSeller status directly affects your discount
(SellerFeeDiscount). (For eBay Germany and France, you must be a registered 
business seller to see your PowerSeller status.)

  Returned: Conditionally
#    Returns: 'ns:PowerSellerDashboardType'

=cut
       
sub getPowerSellerStatus {
   my $self = shift;
   return $self->getResponseDataType()->getPowerSellerStatus();
}

=head2 getSearchStanding()

Provides information about the visibility level you've earned for your listings. 
When you have a better search standing, your listings may receive higher 
placement in search results that are sorted by Best Match.
Because it is directly tied to your customer service, search standing 
is an important way for eBay to reward you as a good seller, 
and to encourage you to give buyers the best possible shopping experience.

  Returned: Conditionally
#    Returns: 'ns:SearchStandingDashboardType'

=cut
       
sub getSearchStanding {
   my $self = shift;
   return $self->getResponseDataType()->getSearchStanding();
}

=head2 getSellerAccount()

Reminds you of the status of your latest invoice, including alerts to help 
you identify any problems with your account.

  Returned: Conditionally
#    Returns: 'ns:SellerAccountDashboardType'

=cut
       
sub getSellerAccount {
   my $self = shift;
   return $self->getResponseDataType()->getSellerAccount();
}

=head2 getSellerFeeDiscount()

Provides information about the PowerSeller discount level you've earned, if any.
As a PowerSeller, you can earn discounts on your monthly invoice Final Value Fees 
based on how well you're rated as a seller. Only returned for members of the eBay US or Canada
PowerSeller program.

  Returned: Conditionally
#    Returns: 'ns:SellerFeeDiscountDashboardType'

=cut
       
sub getSellerFeeDiscount {
   my $self = shift;
   return $self->getResponseDataType()->getSellerFeeDiscount();
}





1;   
